package com.tydic.dyc.agr.service;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.model.agr.AgrModel;
import com.tydic.dyc.agr.model.agr.BkAgrMainDo;
import com.tydic.dyc.agr.service.agr.AgrDealAgrSupAvailableSysnService;
import com.tydic.dyc.agr.service.agr.bo.*;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import java.util.List;

/**
 * @author yinletian
 * @date 2023/4/18
 */
@HTServiceImpl
public class AgrDealAgrSupAvailableSysnServiceImpl implements AgrDealAgrSupAvailableSysnService {

    @Autowired
    private AgrModel agrModel;

    @Override
    public AgrDealAgrSupAvailableSysnRspBO dealAgrSupAvailableSysn(AgrDealAgrSupAvailableSysnReqBO reqBO) {
        if(reqBO.getAgrSupOrgId()==null) throw new ZTBusinessException("供应商id不能为空");
        if(reqBO.getSysnType()==null) throw new ZTBusinessException("同步类型不能为空");
        BkAgrMainDo mainDo = new BkAgrMainDo();
        mainDo.setAgrSupOrgId(reqBO.getAgrSupOrgId());
        mainDo.setAgrSupAvailableStatus(reqBO.getSysnType());
        agrModel.updateBy(mainDo);

        AgrDealAgrSupAvailableSysnRspBO rspBO = new AgrDealAgrSupAvailableSysnRspBO();
        List<BkAgrMainDo> bkAgrMainDos = agrModel.qryEffectAgr(mainDo);
        List<AgrMainBO> traceList = JSON.parseArray(JSON.toJSONString(bkAgrMainDos), AgrMainBO.class);
        rspBO.setTraceList(traceList);

        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return null;
    }
}
