package com.tydic.dyc.agr.repository.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.agr.model.change.BkAgrBigChangeItemDataWhileDo;
import com.tydic.dyc.agr.repository.AgrHisRepository;
import com.tydic.dyc.agr.repository.dao.*;
import com.tydic.dyc.agr.repository.po.*;
import com.tydic.dyc.agr.utils.AgrRu;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhanghengrui
 * @date 2023/2/1 0:04
 */
@Service
public class AgrHisRepositoryImpl implements AgrHisRepository {

    @Autowired
    private BkAgrMainMapper bkAgrMainMapper;
    @Autowired
    private BkAgrMainHisMapper bkAgrMainHisMapper;
    @Autowired
    private BkAgrProcessGuidanceMapper bkAgrProcessGuidanceMapper;
    @Autowired
    private BkAgrProcessGuidance_hisMapper bkAgrProcessGuidanceHisMapper;
    @Autowired
    private BkAgrPayConfigMapper bkAgrPayConfigMapper;
    @Autowired
    private BkAgrPayConfigHisMapper bkAgrPayConfigHisMapper;
    @Autowired
    private BkAgrAppScopeMapper bkAgrAppScopeMapper;
    @Autowired
    private BkAgrAppScopeHispMapper bkAgrAppScopeHispMapper;
    @Autowired
    private BkAgrMateriaPriceItemMapper bkAgrMateriaPriceItemMapper;
    @Autowired
    private BkAgrMateriaPriceItemHisMapper bkAgrMateriaPriceItemHisMapper;
    @Autowired
    private BkAgrVersionMapper bkAgrVersionMapper;

    @Override
    public Integer transDataFromMain2His(Long argId,List<BkAgrBigChangeItemDataWhileDo> bkWhileDos) {

        int i = 0;

        // 转移协议主体表
        BkAgrMainPO bkagrmainpo = new BkAgrMainPO();
        bkagrmainpo.setAgrId(argId);
        BkAgrMainPO insertAgrMainBo = bkAgrMainMapper.getModelBy(bkagrmainpo);
        if (insertAgrMainBo!=null&&insertAgrMainBo.getAgrId()!=null) {
            BkAgrMainHisPO bkagrmainhispo = new BkAgrMainHisPO();
            BeanUtils.copyProperties(insertAgrMainBo, bkagrmainhispo);
            bkAgrMainHisMapper.insert(bkagrmainhispo);
            i++;
        }

        // 关联版本记录表:通过agrId的历史id找到数据设置新的agrId
        BkAgrVersionPO updateAgrVersionPo = new BkAgrVersionPO();
        updateAgrVersionPo.setAgrId(bkagrmainpo.getAgrId());
        BkAgrVersionPO whereAgrVersionPo = new BkAgrVersionPO();
        whereAgrVersionPo.setAgrMainHisId(bkagrmainpo.getAgrId());
        Integer j = bkAgrVersionMapper.updateBy(updateAgrVersionPo,whereAgrVersionPo);


        // 转移流程指引表
        BkAgrProcessGuidancePO bkagrprocessguidancepo = new BkAgrProcessGuidancePO();
        bkagrprocessguidancepo.setAgrId(argId);
        BkAgrProcessGuidancePO insertGuidancePo = bkAgrProcessGuidanceMapper.getModelBy(bkagrprocessguidancepo);
        if (insertGuidancePo!=null&&insertGuidancePo.getAgrId()!=null){
            BkAgrProcessGuidance_hisPO bkagrprocessguidanceHispo = new BkAgrProcessGuidance_hisPO();
            BeanUtils.copyProperties(insertGuidancePo,bkagrprocessguidanceHispo);
            bkAgrProcessGuidanceHisMapper.insert(bkagrprocessguidanceHispo);
            i++;
        }

        // 转移支付配置表
        BkAgrPayConfigPO bkagrpayconfigpo = new BkAgrPayConfigPO();
        bkagrpayconfigpo.setAgrId(argId);
        BkAgrPayConfigPO insertPayConfigPo = bkAgrPayConfigMapper.getModelBy(bkagrpayconfigpo);
        if (insertPayConfigPo!=null&&insertPayConfigPo.getAgrId()!=null) {
            BkAgrPayConfigHisPO bkagrpayconfighispo = new BkAgrPayConfigHisPO();
            BeanUtils.copyProperties(insertPayConfigPo, bkagrpayconfighispo);
            bkAgrPayConfigHisMapper.insert(bkagrpayconfighispo);
            i++;
        }

        // 转移应用范围表
        BkAgrAppScopePO bkagrappscopepo = new BkAgrAppScopePO();
        bkagrappscopepo.setAgrId(argId);
        BkAgrAppScopePO insertScopePo = bkAgrAppScopeMapper.getModelBy(bkagrappscopepo);
        if (insertScopePo!=null&&insertScopePo.getAgrId()!=null) {
            BkAgrAppScopeHispPO bkagrappscopehisppo = new BkAgrAppScopeHispPO();
            BeanUtils.copyProperties(insertScopePo, bkagrappscopehisppo);
            bkAgrAppScopeHispMapper.insert(bkagrappscopehisppo);
            i++;
        }

        // 转移物料明细表
        BkAgrMateriaPriceItemPO bkagrmateriapriceitempo = new BkAgrMateriaPriceItemPO();
        bkagrmateriapriceitempo.setAgrId(argId);
        List<BkAgrMateriaPriceItemPO> list = bkAgrMateriaPriceItemMapper.getList(bkagrmateriapriceitempo);
        if (!CollectionUtils.isEmpty(list)) {
            List<BkAgrMateriaPriceItemHisPO> insertList = JSON.parseArray(JSON.toJSONString(list), BkAgrMateriaPriceItemHisPO.class);
            bkAgrMateriaPriceItemHisMapper.insertBatch(insertList);
            i++;
        }



        return i;
    }

    private Boolean check(BkAgrMateriaPriceItemPO bkAgrMateriaPriceItemPO,BkAgrBigChangeItemDataWhileDo bkWhileDo){
        return null;
    }
}
