package com.tydic.dyc.agr.repository.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.agr.repository.AgrMateriaPriceRepository;
import com.tydic.dyc.agr.repository.dao.BkAgrMateriaPriceItemHisMapper;
import com.tydic.dyc.agr.repository.dao.BkAgrMateriaPriceItemMapper;
import com.tydic.dyc.agr.repository.po.BkAgrMateriaPriceItemHisPO;
import com.tydic.dyc.agr.repository.po.BkAgrMateriaPriceItemPO;
import com.tydic.dyc.agr.service.agr.bo.AgrQryAgrMateriaPriceItemListServiceReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrQryAgrMateriaPriceItemListServiceRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrMateriaPriceItemBO;
import com.tydic.dyc.agr.utils.AgrRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author yinletian
 * @date 2023/1/30
 */
@Service
public class AgrMateriaPriceRepositoryImpl implements AgrMateriaPriceRepository {

    @Autowired
    private BkAgrMateriaPriceItemMapper bkAgrMateriaPriceItemMapper;
    @Autowired
    private BkAgrMateriaPriceItemHisMapper bkAgrMateriaPriceItemHisMapper;


    @Override
    public AgrQryAgrMateriaPriceItemListServiceRspBO qryMateriaPriceItem(AgrQryAgrMateriaPriceItemListServiceReqBO reqBO) {
        Page<BkAgrMateriaPriceItemPO> page = new Page<>(reqBO.getPageNo(), reqBO.getPageSize());
        List<BkAgrMateriaPriceItemPO> listPage = bkAgrMateriaPriceItemMapper.getListPage(AgrRu.js(reqBO, BkAgrMateriaPriceItemPO.class), page);
        AgrQryAgrMateriaPriceItemListServiceRspBO rspBO = new AgrQryAgrMateriaPriceItemListServiceRspBO();
        rspBO.setRows(AgrRu.jsl(listPage, AgrMateriaPriceItemBO.class));
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        return rspBO;
    }

    @Override
    public AgrQryAgrMateriaPriceItemListServiceRspBO qryMateriaPriceItemHis(AgrQryAgrMateriaPriceItemListServiceReqBO reqBO) {
        Page<BkAgrMateriaPriceItemHisPO> page = new Page<>(reqBO.getPageNo(), reqBO.getPageSize());
        List<BkAgrMateriaPriceItemHisPO> listPage = bkAgrMateriaPriceItemHisMapper.getListPage(AgrRu.js(reqBO, BkAgrMateriaPriceItemHisPO.class),page);
        AgrQryAgrMateriaPriceItemListServiceRspBO rspBO = new AgrQryAgrMateriaPriceItemListServiceRspBO();
        rspBO.setRows(AgrRu.jsl(listPage, AgrMateriaPriceItemBO.class));
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        return rspBO;
    }

    @Override
    public List<AgrMateriaPriceItemBO> qrySelfSalePrice(List<AgrMateriaPriceItemBO> list) {
        List<BkAgrMateriaPriceItemPO> bkAgrMateriaPriceItemPOS = bkAgrMateriaPriceItemMapper.qrySelfSalePrice(AgrRu.jsl(list, BkAgrMateriaPriceItemPO.class), list.get(0).getAgrId());
        List<AgrMateriaPriceItemBO> itemBOS = AgrRu.jsl(bkAgrMateriaPriceItemPOS, AgrMateriaPriceItemBO.class);
        return itemBOS;
    }
    @Override
    public List<AgrMateriaPriceItemBO> qrySelfSalePriceHis(List<AgrMateriaPriceItemBO> list) {
        List<BkAgrMateriaPriceItemHisPO> bkAgrMateriaPriceItemPOS = bkAgrMateriaPriceItemHisMapper.qrySelfSalePriceHis(AgrRu.jsl(list, BkAgrMateriaPriceItemHisPO.class), list.get(0).getAgrId());
        List<AgrMateriaPriceItemBO> itemBOS = AgrRu.jsl(bkAgrMateriaPriceItemPOS, AgrMateriaPriceItemBO.class);
        return itemBOS;
    }

    @Override
    public List<AgrMateriaPriceItemBO> qryMateriaPriceItem(Long agrId) {
        BkAgrMateriaPriceItemPO priceItemPO = new BkAgrMateriaPriceItemPO();
        priceItemPO.setAgrId(agrId);
        List<BkAgrMateriaPriceItemPO> list = bkAgrMateriaPriceItemMapper.getList(priceItemPO);
        return AgrRu.jsl(list, AgrMateriaPriceItemBO.class);
    }

    @Override
    public List<AgrMateriaPriceItemBO> qryMateriaItemKey(AgrQryAgrMateriaPriceItemListServiceReqBO serviceReqBO) {
        BkAgrMateriaPriceItemPO priceItemPO = new BkAgrMateriaPriceItemPO();
        priceItemPO.setAgrId(serviceReqBO.getAgrId());
        priceItemPO.setItemMatchCodeList(serviceReqBO.getItemMatchCodeList());
        List<BkAgrMateriaPriceItemPO> list = bkAgrMateriaPriceItemMapper.getList(priceItemPO);
        return  AgrRu.jsl(list, AgrMateriaPriceItemBO.class);
    }
}