package com.tydic.dyc.agr.repository.impl;

import com.tydic.dyc.agr.repository.AgrProcessGuidanceRepository;
import com.tydic.dyc.agr.repository.dao.BkAgrProcessGuidanceMapper;
import com.tydic.dyc.agr.repository.po.BkAgrProcessGuidancePO;
import com.tydic.dyc.agr.service.agr.bo.AgrQryAgrProcessGuidanceReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrQryAgrProcessGuidanceRspBO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 协议流程指引说明查询
 * @author zhanghengrui
 * @date 2023/1/29 16:43
 */
@Service
public class AgrProcessGuidanceRepositoryImpl implements AgrProcessGuidanceRepository {

    @Autowired
    private BkAgrProcessGuidanceMapper bkAgrProcessGuidanceMapper;

    @Override
    public AgrQryAgrProcessGuidanceRspBO qryAgrProcessGuidance(AgrQryAgrProcessGuidanceReqBO agrQryAgrProcessGuidanceReqBO) {

        AgrQryAgrProcessGuidanceRspBO rspBO = new AgrQryAgrProcessGuidanceRspBO();
        BkAgrProcessGuidancePO qryBo = new BkAgrProcessGuidancePO();
        qryBo.setAgrId(agrQryAgrProcessGuidanceReqBO.getAgrId());

        BkAgrProcessGuidancePO modelBy = bkAgrProcessGuidanceMapper.getModelBy(qryBo);

        BeanUtils.copyProperties(modelBy,rspBO);

        return rspBO;
    }
}
