package com.tydic.dyc.agr.repository.impl;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.tydic.dyc.agr.model.change.AgrTransDataDo;
import com.tydic.dyc.agr.model.change.BkAgrBigChangeItemDataWhileDo;
import com.tydic.dyc.agr.repository.AgrChangeRepository;
import com.tydic.dyc.agr.repository.dao.BkAgrBigChangeItemDataWhileMapper;
import com.tydic.dyc.agr.repository.dao.BkAgrBigChangeMainDataWhileMapper;
import com.tydic.dyc.agr.repository.dao.BkAgrMateriaPriceItemMapper;
import com.tydic.dyc.agr.repository.dao.BkAgrVersionMapper;
import com.tydic.dyc.agr.repository.po.BkAgrBigChangeItemDataWhilePO;
import com.tydic.dyc.agr.repository.po.BkAgrBigChangeMainDataWhilePO;
import com.tydic.dyc.agr.repository.po.BkAgrMateriaPriceItemPO;
import com.tydic.dyc.agr.repository.po.BkAgrVersionPO;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.agr.utils.IdUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;

/**
 * @author zhanghengrui
 * @date 2023/2/1 10:00
 */
@Service
@Slf4j
public class AgrChangeRepositoryImpl implements AgrChangeRepository {

    @Autowired
    private BkAgrBigChangeItemDataWhileMapper bkAgrBigChangeItemDataWhileMapper;
    @Autowired
    private BkAgrBigChangeMainDataWhileMapper bkAgrBigChangeMainDataWhileMapper;
    @Autowired
    private BkAgrMateriaPriceItemMapper bkAgrMateriaPriceItemMapper;
    @Autowired
    private BkAgrVersionMapper bkAgrVersionMapper;

    @Override
    public Integer saveData2Material(List<BkAgrBigChangeItemDataWhileDo> agrBigChangeItemDataWhileDo) {



        List<BkAgrBigChangeItemDataWhilePO> list = JSON.parseArray(JSON.toJSONString(agrBigChangeItemDataWhileDo),BkAgrBigChangeItemDataWhilePO.class);

        log.info("入参："+JSON.toJSONString(list));


        for (BkAgrBigChangeItemDataWhilePO bkAgrBigChangeItemDataWhilePO : list) {
            // 主键id
            bkAgrBigChangeItemDataWhilePO.setAgrBigChangeItemDataWhileId(IdUtil.nextId());
            // 如果是新增的话，重新设定物料id
            if (bkAgrBigChangeItemDataWhilePO.getChangeType()==1) bkAgrBigChangeItemDataWhilePO.setAgrMateriaPriceItemId(IdUtil.nextId());
        }

        log.info("转换后入参："+JSON.toJSONString(list));

        bkAgrBigChangeItemDataWhileMapper.insertBatch(list);

        return list.size();
    }

    @Override
    public Integer saveDate2Main(AgrTransDataDo agrTransDataDo) {

        // 添加版本信息：缺一个协议id，定时任务的时候执行
        BkAgrVersionPO insertAgrVersionPo = new BkAgrVersionPO();
        insertAgrVersionPo.setAgrVersionId(IdUtil.nextId());
        insertAgrVersionPo.setAgrMainHisId(agrTransDataDo.getAgrId());
        insertAgrVersionPo.setAgrCode(agrTransDataDo.getAgrCode());
        insertAgrVersionPo.setAgrSource(2);
        insertAgrVersionPo.setAgrVersionStatus("");
        insertAgrVersionPo.setCreateTime(new Date());

        int agrVersionInsert = bkAgrVersionMapper.insert(insertAgrVersionPo);


        // 添加主表信息
        BkAgrBigChangeMainDataWhilePO insertPo = new BkAgrBigChangeMainDataWhilePO();
        insertPo.setAgrBigChangeMainDataWhileId(IdUtil.nextId());
        insertPo.setAgrId(agrTransDataDo.getAgrId());
        insertPo.setBatchUniqueId(agrTransDataDo.getBatchUniqueId());
        insertPo.setContractCode(agrTransDataDo.getContractCode());
        insertPo.setAgrCode(agrTransDataDo.getAgrCode());
        insertPo.setOrderBy("1");
        insertPo.setMainDateJson(JSON.toJSONString(agrTransDataDo));
        insertPo.setAgrBigChangeMainDataWhileId(IdUtil.nextId());
        int insert = bkAgrBigChangeMainDataWhileMapper.insert(insertPo);

        return insert;
    }

    @Override
    public Integer addDataFromChangeTemp2Material(Long agrId, Long batchUniqueId) {

        // 查询主数据并转移
        BkAgrBigChangeItemDataWhilePO qryPo = new BkAgrBigChangeItemDataWhilePO();
        qryPo.setAgrId(agrId);
        qryPo.setBatchUniqueId(batchUniqueId);
        List<BkAgrBigChangeItemDataWhilePO> list = bkAgrBigChangeItemDataWhileMapper.getList(qryPo);

        if (!CollectionUtils.isEmpty(list)){
            List<BkAgrMateriaPriceItemPO> insertList = JSON.parseArray(JSON.toJSONString(list),BkAgrMateriaPriceItemPO.class);
            bkAgrMateriaPriceItemMapper.insertBatch(insertList);
        }

        return list.size();
    }

    @Override
    public List<BkAgrBigChangeItemDataWhileDo> qryChangeMaterial(Long agrId, Long batchUniqueId) {

        BkAgrBigChangeItemDataWhilePO changePo = new BkAgrBigChangeItemDataWhilePO();
        changePo.setAgrId(agrId);
        changePo.setBatchUniqueId(batchUniqueId);
        List<BkAgrBigChangeItemDataWhilePO> list = bkAgrBigChangeItemDataWhileMapper.getList(changePo);

        log.info("查询协议明细数据:"+JSON.toJSONString(list));

        List<BkAgrBigChangeItemDataWhileDo> jsl = AgrRu.jsl(list, BkAgrBigChangeItemDataWhileDo.class);

        return jsl;

    }
}
