package com.tydic.dyc.agr.repository.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.agr.model.change.BkAgrBigChangeItemDataWhileDo;
import com.tydic.dyc.agr.repository.AgrHisRepository;
import com.tydic.dyc.agr.repository.dao.*;
import com.tydic.dyc.agr.repository.po.*;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.agr.utils.IdUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhanghengrui
 * @date 2023/2/1 0:04
 */
@Service
public class AgrHisRepositoryImpl implements AgrHisRepository {

    @Autowired
    private BkAgrMainMapper bkAgrMainMapper;
    @Autowired
    private BkAgrMainHisMapper bkAgrMainHisMapper;
    @Autowired
    private BkAgrProcessGuidanceMapper bkAgrProcessGuidanceMapper;
    @Autowired
    private BkAgrProcessGuidance_hisMapper bkAgrProcessGuidanceHisMapper;
    @Autowired
    private BkAgrPayConfigMapper bkAgrPayConfigMapper;
    @Autowired
    private BkAgrPayConfigHisMapper bkAgrPayConfigHisMapper;
    @Autowired
    private BkAgrAppScopeMapper bkAgrAppScopeMapper;
    @Autowired
    private BkAgrAppScopeHispMapper bkAgrAppScopeHispMapper;
    @Autowired
    private BkAgrMateriaPriceItemMapper bkAgrMateriaPriceItemMapper;
    @Autowired
    private BkAgrMateriaPriceItemHisMapper bkAgrMateriaPriceItemHisMapper;
    @Autowired
    private BkAgrVersionMapper bkAgrVersionMapper;

    @Override
    public Integer transDataFromMain2His(Long argId,List<BkAgrBigChangeItemDataWhileDo> bkWhileDos) {

        int i = 0;

        long agrMainHisId = IdUtil.nextId();

        // 转移协议主体表
        BkAgrMainPO bkagrmainpo = new BkAgrMainPO();
        bkagrmainpo.setAgrId(argId);
        BkAgrMainPO insertAgrMainBo = bkAgrMainMapper.getModelBy(bkagrmainpo);
        if (insertAgrMainBo!=null&&insertAgrMainBo.getAgrId()!=null) {
            BkAgrMainHisPO bkagrmainhispo = new BkAgrMainHisPO();
            BeanUtils.copyProperties(insertAgrMainBo, bkagrmainhispo);
            bkagrmainhispo.setAgrMainHisId(agrMainHisId);
            bkAgrMainHisMapper.insert(bkagrmainhispo);
            i++;
        }


        // 转移流程指引表
        BkAgrProcessGuidancePO bkagrprocessguidancepo = new BkAgrProcessGuidancePO();
        bkagrprocessguidancepo.setAgrId(argId);
        BkAgrProcessGuidancePO insertGuidancePo = bkAgrProcessGuidanceMapper.getModelBy(bkagrprocessguidancepo);
        if (insertGuidancePo!=null&&insertGuidancePo.getAgrId()!=null){
            BkAgrProcessGuidance_hisPO bkagrprocessguidanceHispo = new BkAgrProcessGuidance_hisPO();
            BeanUtils.copyProperties(insertGuidancePo,bkagrprocessguidanceHispo);
            bkagrprocessguidanceHispo.setAgrProcessGuidanceHisId(IdUtil.nextId());
            bkagrprocessguidanceHispo.setAgrMainHisId(agrMainHisId);
            bkAgrProcessGuidanceHisMapper.insert(bkagrprocessguidanceHispo);
            i++;
        }

        // 转移支付配置表
        BkAgrPayConfigPO bkagrpayconfigpo = new BkAgrPayConfigPO();
        bkagrpayconfigpo.setAgrId(argId);
        List<BkAgrPayConfigPO> insertPayConfigPo = bkAgrPayConfigMapper.getList(bkagrpayconfigpo);
        if (insertPayConfigPo!=null&&insertPayConfigPo.size()>0) {
            List<BkAgrPayConfigHisPO> list = JSON.parseArray(JSON.toJSONString(insertPayConfigPo),BkAgrPayConfigHisPO.class);
            for (BkAgrPayConfigHisPO bkAgrPayConfigHisPO : list) {
                bkAgrPayConfigHisPO.setAgrMainHisId(agrMainHisId);
                bkAgrPayConfigHisPO.setPayCfgHisId(IdUtil.nextId());
            }
            bkAgrPayConfigHisMapper.insertBatch(list);
            i++;
        }

        // 转移应用范围表
        BkAgrAppScopePO bkagrappscopepo = new BkAgrAppScopePO();
        bkagrappscopepo.setAgrId(argId);
        List<BkAgrAppScopePO> insertScopePo = bkAgrAppScopeMapper.getList(bkagrappscopepo);
        if (insertScopePo!=null&&insertScopePo.size()>0) {
            List<BkAgrAppScopeHispPO> list = JSON.parseArray(JSON.toJSONString(insertScopePo),BkAgrAppScopeHispPO.class);
            for (BkAgrAppScopeHispPO bkAgrAppScopeHispPO : list) {
                bkAgrAppScopeHispPO.setAppScopeHisId(IdUtil.nextId());
                bkAgrAppScopeHispPO.setAgrMainHisId(agrMainHisId);
            }
            bkAgrAppScopeHispMapper.insertBatch(list);
            i++;
        }

        // 转移物料明细表
        BkAgrMateriaPriceItemPO bkagrmateriapriceitempo = new BkAgrMateriaPriceItemPO();
        bkagrmateriapriceitempo.setAgrId(argId);
        List<BkAgrMateriaPriceItemPO> list = bkAgrMateriaPriceItemMapper.getList(bkagrmateriapriceitempo);
        if (!CollectionUtils.isEmpty(list)) {
            List<BkAgrMateriaPriceItemHisPO> insertList = JSON.parseArray(JSON.toJSONString(list), BkAgrMateriaPriceItemHisPO.class);
            insertList.forEach(po->{
                po.setAgrMainHisId(agrMainHisId);
                po.setAgrMateriaPriceItemHisId(IdUtil.nextId());
            });
            bkAgrMateriaPriceItemHisMapper.insertBatch(insertList);
            i++;
        }

        return i;
    }


}
