package com.tydic.dyc.agr.repository.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.agr.model.log.BkAgrBigDataLogDo;
import com.tydic.dyc.agr.model.log.BkAgrChangeBigDataLogDo;
import com.tydic.dyc.agr.repository.AgrLogRepository;
import com.tydic.dyc.agr.repository.dao.BkAgrBigDataLogMapper;
import com.tydic.dyc.agr.repository.dao.BkAgrChangeBigDataLogPoMapper;
import com.tydic.dyc.agr.repository.po.BkAgrBigDataLogPO;
import com.tydic.dyc.agr.repository.po.BkAgrChangeBigDataLogPo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhanghengrui
 * @date 2023/1/31 23:55
 */
@Service
public class AgrLogRepositoryImpl implements AgrLogRepository {

    @Autowired
    private BkAgrChangeBigDataLogPoMapper bkAgrChangeBigDataLogPoMapper;
    @Autowired
    private BkAgrBigDataLogMapper bkAgrBigDataLogMapper;

    @Override
    public Integer updateDealStatus(BkAgrChangeBigDataLogDo bkAgrChangeBigDataLogDo) {

        BkAgrChangeBigDataLogPo record = new BkAgrChangeBigDataLogPo();
        BeanUtils.copyProperties(bkAgrChangeBigDataLogDo,record);
        int i = bkAgrChangeBigDataLogPoMapper.updateByPrimaryKeySelective(record);

        return i;
    }

    @Override
    public List<BkAgrChangeBigDataLogDo> qryChangeLogData(BkAgrChangeBigDataLogDo bkAgrChangeBigDataLogDo) {

        BkAgrChangeBigDataLogPo record = new BkAgrChangeBigDataLogPo();
        BeanUtils.copyProperties(bkAgrChangeBigDataLogDo,record);
        List<BkAgrChangeBigDataLogPo> list = bkAgrChangeBigDataLogPoMapper.getList(record);
        List<BkAgrChangeBigDataLogDo> resultList = new ArrayList<>();
        if (list!=null&&list.size()!=0){
            resultList = JSON.parseArray(JSON.toJSONString(list),BkAgrChangeBigDataLogDo.class);
        }

        return resultList;
    }

    @Override
    public Integer addLog(BkAgrBigDataLogDo bkAgrBigDataLogDo) {

        BkAgrBigDataLogPO bkagrbigdatalogpo = new BkAgrBigDataLogPO();
        BeanUtils.copyProperties(bkAgrBigDataLogDo,bkagrbigdatalogpo);
        int insert = bkAgrBigDataLogMapper.insert(bkagrbigdatalogpo);

        return insert;
    }

    @Override
    public Integer addChangeLog(BkAgrChangeBigDataLogDo bkAgrChangeBigDataLogDo) {
        BkAgrChangeBigDataLogPo record = new BkAgrChangeBigDataLogPo();
        BeanUtils.copyProperties(bkAgrChangeBigDataLogDo,record);
        int insert = bkAgrChangeBigDataLogPoMapper.insert(record);
        return insert;
    }

    @Override
    public Integer checkSyncStatus(String argId, Long batchUniqueId) {
        BkAgrBigDataLogPO qryBo = new BkAgrBigDataLogPO();
        qryBo.setAgrCode(argId);
        qryBo.setBatchUniqueId(batchUniqueId);
        List<BkAgrBigDataLogPO> list = bkAgrBigDataLogMapper.getList(qryBo);

        return list.size();
    }

    @Override
    public Integer checkSyncStatus1(Long argId, Long batchUniqueId) {
        BkAgrBigDataLogPO qryBo = new BkAgrBigDataLogPO();
        qryBo.setAgrId(argId+"");
        qryBo.setBatchUniqueId(batchUniqueId);
        List<BkAgrBigDataLogPO> list = bkAgrBigDataLogMapper.getList(qryBo);

        return list.size();
    }

    @Override
    public Long getAgrBigDataLog(String agrCode, Long batchUniqueId) {
        BkAgrBigDataLogPO qryBo = new BkAgrBigDataLogPO();
        qryBo.setAgrId(agrCode);
        qryBo.setBatchUniqueId(batchUniqueId);
        List<BkAgrBigDataLogPO> list = bkAgrBigDataLogMapper.getList(qryBo);
        if(!CollectionUtils.isEmpty(list)){
            String agrId = list.get(0).getAgrId();
            return Long.parseLong(agrId);
        }
        return null;
    }
}