package com.tydic.dyc.agr.repository.impl;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.tydic.dyc.agr.model.agr.BkAgrMainDo;
import com.tydic.dyc.agr.model.change.AgrTransDataDo;
import com.tydic.dyc.agr.model.change.BkAgrBigChangeItemDataWhileDo;
import com.tydic.dyc.agr.repository.AgrChangeRepository;
import com.tydic.dyc.agr.repository.dao.*;
import com.tydic.dyc.agr.repository.po.*;
import com.tydic.dyc.agr.service.agr.bo.AgrChangeCronJobRspBO;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.agr.utils.IdUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author zhanghengrui
 * @date 2023/2/1 10:00
 */
@Service
@Slf4j
public class AgrChangeRepositoryImpl implements AgrChangeRepository {

    @Autowired
    private BkAgrBigChangeItemDataWhileMapper bkAgrBigChangeItemDataWhileMapper;
    @Autowired
    private BkAgrBigChangeMainDataWhileMapper bkAgrBigChangeMainDataWhileMapper;
    @Autowired
    private BkAgrMateriaPriceItemMapper bkAgrMateriaPriceItemMapper;
    @Autowired
    private BkAgrVersionMapper bkAgrVersionMapper;
    @Autowired
    private BkAgrMainMapper bkAgrMainMapper;
    @Autowired
    private BkAgrAppScopeMapper bkAgrAppScopeMapper;
    @Autowired
    private BkAgrPayConfigMapper bkAgrPayConfigMapper;
    @Autowired
    private BkAgrProcessGuidanceMapper bkAgrProcessGuidanceMapper;

    @Override
    public Integer saveData2Material(List<BkAgrBigChangeItemDataWhileDo> agrBigChangeItemDataWhileDo) {



        List<BkAgrBigChangeItemDataWhilePO> list = JSON.parseArray(JSON.toJSONString(agrBigChangeItemDataWhileDo),BkAgrBigChangeItemDataWhilePO.class);

        log.info("入参："+JSON.toJSONString(list));


        for (BkAgrBigChangeItemDataWhilePO bkAgrBigChangeItemDataWhilePO : list) {
            // 主键id
            bkAgrBigChangeItemDataWhilePO.setAgrBigChangeItemDataWhileId(IdUtil.nextId());
            // 如果是新增的话，重新设定物料id
            if (bkAgrBigChangeItemDataWhilePO.getChangeType()==1) bkAgrBigChangeItemDataWhilePO.setAgrMateriaPriceItemId(IdUtil.nextId());
        }

        log.info("转换后入参："+JSON.toJSONString(list));

        bkAgrBigChangeItemDataWhileMapper.insertBatch(list);

        return list.size();
    }

    @Override
    public Integer saveDate2Main(AgrTransDataDo agrTransDataDo) {

        // 添加版本信息：缺一个协议id，定时任务的时候执行
        BkAgrVersionPO insertAgrVersionPo = new BkAgrVersionPO();
        insertAgrVersionPo.setAgrVersionId(IdUtil.nextId());
        insertAgrVersionPo.setAgrMainHisId(agrTransDataDo.getAgrId());
        insertAgrVersionPo.setAgrCode(agrTransDataDo.getAgrCode());
        insertAgrVersionPo.setAgrSource(2);
        insertAgrVersionPo.setAgrVersionStatus("");
        insertAgrVersionPo.setCreateTime(new Date());

        int agrVersionInsert = bkAgrVersionMapper.insert(insertAgrVersionPo);


        // 添加主表信息
        BkAgrBigChangeMainDataWhilePO insertPo = new BkAgrBigChangeMainDataWhilePO();
        insertPo.setAgrBigChangeMainDataWhileId(IdUtil.nextId());
        insertPo.setAgrId(agrTransDataDo.getAgrId());
        insertPo.setBatchUniqueId(agrTransDataDo.getBatchUniqueId());
        insertPo.setContractCode(agrTransDataDo.getContractCode());
        insertPo.setAgrCode(agrTransDataDo.getAgrCode());
        insertPo.setOrderBy("1");
        insertPo.setMainDateJson(JSON.toJSONString(agrTransDataDo));
        insertPo.setAgrBigChangeMainDataWhileId(IdUtil.nextId());
        int insert = bkAgrBigChangeMainDataWhileMapper.insert(insertPo);

        return insert;
    }

    @Override
    public Integer addDataFromChangeTemp2Material(Long agrId, Long batchUniqueId, BkAgrMainDo bkAgrMainDo) {

        // 查询主数据并转移
        BkAgrBigChangeItemDataWhilePO qryPo = new BkAgrBigChangeItemDataWhilePO();
        qryPo.setAgrId(agrId);
        qryPo.setBatchUniqueId(batchUniqueId);
        List<BkAgrBigChangeItemDataWhilePO> list = bkAgrBigChangeItemDataWhileMapper.getList(qryPo);

        if (!CollectionUtils.isEmpty(list)){
            List<BkAgrMateriaPriceItemPO> insertList = JSON.parseArray(JSON.toJSONString(list),BkAgrMateriaPriceItemPO.class);

            for (BkAgrMateriaPriceItemPO bkAgrMateriaPriceItemPO : insertList) {
                bkAgrMateriaPriceItemPO.setAgrSaleMateriaPriceItemId(IdUtil.nextId());
                bkAgrMateriaPriceItemPO.setAgrId(bkAgrMainDo.getAgrId());
                // 销售价
                bkAgrMateriaPriceItemPO.setPriceUseType(1);
            }

            insertList.forEach(obj->obj.setAgrMateriaPriceItemId(IdUtil.nextId()));
            bkAgrMateriaPriceItemMapper.insertBatch(insertList);
        }

        return list.size();
    }

    @Override
    public List<BkAgrBigChangeItemDataWhileDo> qryChangeMaterial(Long agrId, Long batchUniqueId) {

        BkAgrBigChangeItemDataWhilePO changePo = new BkAgrBigChangeItemDataWhilePO();
        changePo.setAgrId(agrId);
        changePo.setBatchUniqueId(batchUniqueId);
        List<BkAgrBigChangeItemDataWhilePO> list = bkAgrBigChangeItemDataWhileMapper.getList(changePo);

        log.info("查询协议明细数据:"+JSON.toJSONString(list));

        List<BkAgrBigChangeItemDataWhileDo> jsl = AgrRu.jsl(list, BkAgrBigChangeItemDataWhileDo.class);

        return jsl;

    }

    @Override
    public void transItemData(List<BkAgrBigChangeItemDataWhileDo> bkWhileDos, String agrCode, AgrChangeCronJobRspBO agrChangeCronJobRspBO) {



        Long newAgrId = IdUtil.nextId();

        // 保存主表数据
        BkAgrMainPO bkagrmainpo = new BkAgrMainPO();
        bkagrmainpo.setAgrCode(agrCode);
        BkAgrMainPO modelBy = bkAgrMainMapper.getModelBy(bkagrmainpo);
        Long agrId = modelBy.getAgrId();


        agrChangeCronJobRspBO.setAgrId(newAgrId);
        agrChangeCronJobRspBO.setOldAgrId(agrId);

        // 查出之前的明细
        BkAgrMateriaPriceItemPO qryPo= new BkAgrMateriaPriceItemPO();
        qryPo.setAgrId(agrId);
        List<BkAgrMateriaPriceItemPO> list1 = bkAgrMateriaPriceItemMapper.getList(qryPo);

        log.info("之前的明细数据："+JSON.toJSONString(list1));

        // 删除
        BkAgrMateriaPriceItemPO bkagrmateriapriceitempo = new BkAgrMateriaPriceItemPO();
        bkagrmateriapriceitempo.setAgrId(agrId);
        bkAgrMateriaPriceItemMapper.deleteBy(bkagrmateriapriceitempo);


        // 需要保存的数据
        List<BkAgrMateriaPriceItemPO> list= new ArrayList<>();

        for (BkAgrBigChangeItemDataWhileDo bkWhileDo : bkWhileDos) {
            BkAgrMateriaPriceItemPO bkAgrMateriaPriceItemPO = JSON.parseObject(JSON.toJSONString(bkWhileDo), BkAgrMateriaPriceItemPO.class);
            //得到之前对应的明细数据
            BkAgrMateriaPriceItemPO specPo = getSpecPo(bkWhileDo, list1);
            log.info("选中的明细："+JSON.toJSONString(specPo));
            bkAgrMateriaPriceItemPO.setAgrMateriaPriceItemId(IdUtil.nextId());
            bkAgrMateriaPriceItemPO.setPriceUseType(2);
            bkAgrMateriaPriceItemPO.setPriceType(bkWhileDo.getPriceType());
            bkAgrMateriaPriceItemPO.setAgrId(newAgrId);
            //规格型号
            bkAgrMateriaPriceItemPO.setModel(specPo.getModel());
            //起订量
            bkAgrMateriaPriceItemPO.setMoq(specPo.getMoq());
            //销售价
            bkAgrMateriaPriceItemPO.setSalePrice(specPo.getSalePrice());
            bkAgrMateriaPriceItemPO.setSaleUnTaxPrice(specPo.getSaleUnTaxPrice());
            //货期
            bkAgrMateriaPriceItemPO.setSupplyCycle(specPo.getSupplyCycle());
            //备注
            bkAgrMateriaPriceItemPO.setRemark(specPo.getRemark());

            list.add(bkAgrMateriaPriceItemPO);
        }

        //增加采购价的数据
        bkAgrMateriaPriceItemMapper.insertBatch(list);

        // 保存版本信息
        BkAgrVersionPO bkagrversionpo = new BkAgrVersionPO();
        bkagrversionpo.setAgrVersionId(IdUtil.nextId());
        bkagrversionpo.setAgrId(newAgrId);
        bkagrversionpo.setAgrMainHisId(agrId);
        bkagrversionpo.setAgrCode(agrCode);
        bkagrversionpo.setAgrVersion(modelBy.getAgrVersion());
        bkagrversionpo.setCreateTime(new Date());
        // 价格库管理
        bkagrversionpo.setAgrSource(1);
        bkAgrVersionMapper.insert(bkagrversionpo);

        // 保存主表数据
        BkAgrMainPO deletePo = new BkAgrMainPO();
        deletePo.setAgrId(agrId);
        bkAgrMainMapper.deleteBy(deletePo);

        modelBy.setAgrId(newAgrId);
        modelBy.setAgrVersion(getVersion(modelBy));
        bkAgrMainMapper.insert(modelBy);



        // 保存应用范围数据
        BkAgrAppScopePO bkagrappscopepo = new BkAgrAppScopePO();
        bkagrappscopepo.setAgrId(agrId);
        List<BkAgrAppScopePO> list2 = bkAgrAppScopeMapper.getList(bkagrappscopepo);
        list2.forEach(obj-> obj.setAgrId(newAgrId));
        bkAgrAppScopeMapper.deleteBy(bkagrappscopepo);
        bkAgrAppScopeMapper.insertBatch(list2);


        // 保存应用范围
        BkAgrPayConfigPO bkagrpayconfigpo = new BkAgrPayConfigPO();
        bkagrpayconfigpo.setAgrId(agrId);
        List<BkAgrPayConfigPO> list3 = bkAgrPayConfigMapper.getList(bkagrpayconfigpo);
        list3.forEach(obj->obj.setAgrId(newAgrId));
        bkAgrPayConfigMapper.deleteBy(bkagrpayconfigpo);
        bkAgrPayConfigMapper.insertBatch(list3);

        // 指引表
        BkAgrProcessGuidancePO bkagrprocessguidancepo = new BkAgrProcessGuidancePO();
        bkagrprocessguidancepo.setAgrId(agrId);
        List<BkAgrProcessGuidancePO> list4 = bkAgrProcessGuidanceMapper.getList(bkagrprocessguidancepo);
        list4.forEach(obj-> obj.setAgrId(newAgrId));
        bkAgrProcessGuidanceMapper.deleteBy(bkagrprocessguidancepo);
        bkAgrProcessGuidanceMapper.insertBatch(list4);



    }

    private String getVersion(BkAgrMainPO mainPO){
        String agrVersion = mainPO.getAgrVersion();
        int num = Integer.parseInt(agrVersion.substring(1))+1;
        return "V"+num;
    }


    private BkAgrMateriaPriceItemPO getSpecPo(BkAgrBigChangeItemDataWhileDo bkWhileDo,List<BkAgrMateriaPriceItemPO> list1){


        BkAgrMateriaPriceItemPO bkAgrMateriaPriceItem = new BkAgrMateriaPriceItemPO();

        if (CollectionUtils.isEmpty(list1)) return bkAgrMateriaPriceItem;

        // 匹配规则
        for (BkAgrMateriaPriceItemPO bkAgrMateriaPriceItemPO : list1) {

            // 统一价
            if (bkWhileDo.getPriceType()==1){
                // 物理编码相等
                if (bkWhileDo.getMaterialCode().equals(bkAgrMateriaPriceItemPO.getMaterialCode())) return bkAgrMateriaPriceItemPO;
            }

            // 区域价
            if (bkWhileDo.getPriceType()==2){
                if ((bkWhileDo.getMaterialCode()+bkWhileDo.getProvinceCode()+bkWhileDo.getCityCode()).equals(
                        bkAgrMateriaPriceItemPO.getMaterialCode()+bkAgrMateriaPriceItemPO.getProvinceCode()+bkAgrMateriaPriceItemPO.getCityCode()
                )){
                    return bkAgrMateriaPriceItemPO;
                }
            }

            // 专属价
            if (bkWhileDo.getPriceType()==3){
                if ((bkWhileDo.getMaterialCode()+bkWhileDo.getExclusiveOrgId()).equals
                        (bkAgrMateriaPriceItemPO.getMaterialCode()+bkAgrMateriaPriceItemPO.getExclusiveOrgId())){
                    return bkAgrMateriaPriceItemPO;
                }
            }


            // 阶梯价
            if (bkWhileDo.getPriceType()==4){
                if ((bkWhileDo.getMaterialCode()+bkWhileDo.getStartNum()+"*"+bkWhileDo.getStopNum()).equals((
                        bkAgrMateriaPriceItemPO.getMaterialCode()+bkAgrMateriaPriceItemPO.getStartNum()+"*"+bkAgrMateriaPriceItemPO.getStopNum()
                        ))){
                    return bkAgrMateriaPriceItemPO;
                }
            }

        }

        return bkAgrMateriaPriceItem;
    }
}
