package com.tydic.dyc.agr.repository.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.agr.repository.AgrVersionRepository;
import com.tydic.dyc.agr.repository.dao.BkAgrVersionMapper;
import com.tydic.dyc.agr.repository.po.BkAgrVersionPO;
import com.tydic.dyc.agr.service.agr.bo.AgrQryAgrVersionListReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrQryAgrVersionListRspBO;
import com.tydic.dyc.agr.service.agr.bo.BkAgrVersionBO;
import com.tydic.dyc.agr.utils.AgrRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author yinletian
 * @date 2023/1/29
 */
@Service
public class AgrVersionRepositoryImpl implements AgrVersionRepository {

    @Autowired
    private BkAgrVersionMapper bkAgrVersionMapper;

    @Override
    public AgrQryAgrVersionListRspBO qryAgrVersionList(AgrQryAgrVersionListReqBO reqBO) {
        Page<BkAgrVersionPO> page = new Page<>(-1,-1);
        BkAgrVersionPO po = new BkAgrVersionPO();
        po.setAgrId(reqBO.getAgrId());
        po.setAgrCode(reqBO.getAgrCode());
        List<BkAgrVersionPO> listPage = bkAgrVersionMapper.getListPage(po, page);
        AgrQryAgrVersionListRspBO rspBO = new AgrQryAgrVersionListRspBO();
        rspBO.setRows(AgrRu.jsl(listPage,BkAgrVersionBO.class));
        rspBO.setPageSize(page.getPageSize());
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        return rspBO;
    }

    @Override
    public void updateStatus(Long agrId) {
        BkAgrVersionPO set = new BkAgrVersionPO();
        set.setAgrId(agrId);
        BkAgrVersionPO where = new BkAgrVersionPO();
        where.setAgrVersionStatus("EXPIRED");
        bkAgrVersionMapper.updateBy(set,where);
    }

    @Override
    public List<Long> agrIdList(String agrCode,Long agrId) {
        BkAgrVersionPO po = new BkAgrVersionPO();
        po.setAgrCode(agrCode);
        List<BkAgrVersionPO> list = bkAgrVersionMapper.getList(po);
        List<Long> collect = new ArrayList<>();
        if(!CollectionUtils.isEmpty(list)) collect = list.stream().map(obj -> obj.getAgrMainHisId()).collect(Collectors.toList());
        collect.add(agrId);
        return collect;
    }
}
