package com.tydic.dyc.agr.repository.impl;

import com.tydic.dyc.agr.model.common.AgrCommonOrderDo;
import com.tydic.dyc.agr.repository.AgrAuditOrderExtRepository;
import com.tydic.dyc.agr.repository.dao.UocApprovalObjMapper;
import com.tydic.dyc.agr.repository.dao.UocAuditOrderMapper;
import com.tydic.dyc.agr.repository.po.UocApprovalObjPO;
import com.tydic.dyc.agr.repository.po.UocAuditOrderPO;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.agr.utils.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author yinletian
 * @date 2023/1/31
 */
@Service
public class AgrAuditOrderExtRepositoryImpl implements AgrAuditOrderExtRepository {
    @Autowired
    private UocAuditOrderMapper uocAuditOrderMapper;

    @Autowired
    private UocApprovalObjMapper uocApprovalObjMapper;

    @Override
    public void saveAuditOrder(AgrCommonOrderDo agrAuditOrderDo) {
        UocAuditOrderPO uocAuditOrderPO = AgrRu.js(agrAuditOrderDo, UocAuditOrderPO.class);
        uocAuditOrderMapper.insert(uocAuditOrderPO);
        if(!CollectionUtils.isEmpty(agrAuditOrderDo.getUocApprovalObj())){
            List<UocApprovalObjPO> uocApprovalObjPOS = new ArrayList<>();
            agrAuditOrderDo.getUocApprovalObj().forEach(uocApprovalObj -> {
                UocApprovalObjPO po = AgrRu.js(uocApprovalObj,UocApprovalObjPO.class);
                po.setAuditOrderId(agrAuditOrderDo.getAuditOrderId());
                po.setId(IdUtil.nextId());
                po.setOrderId(agrAuditOrderDo.getOrderId());
                uocApprovalObjPOS.add(po);
            });
            uocApprovalObjMapper.insertBatch(uocApprovalObjPOS);
        }
    }
}
