package com.tydic.dyc.agr.repository.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.agr.model.agr.BkAgrMainDo;
import com.tydic.dyc.agr.model.change.BkAgrBigChangeItemDataWhileDo;
import com.tydic.dyc.agr.repository.AgrHisRepository;
import com.tydic.dyc.agr.repository.dao.*;
import com.tydic.dyc.agr.repository.po.*;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.agr.utils.IdUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhanghengrui
 * @date 2023/2/1 0:04
 */
@Service
public class AgrHisRepositoryImpl implements AgrHisRepository {

    @Autowired
    private BkAgrMainMapper bkAgrMainMapper;
    @Autowired
    private BkAgrMainHisMapper bkAgrMainHisMapper;
    @Autowired
    private BkAgrProcessGuidanceMapper bkAgrProcessGuidanceMapper;
    @Autowired
    private BkAgrProcessGuidance_hisMapper bkAgrProcessGuidanceHisMapper;
    @Autowired
    private BkAgrPayConfigMapper bkAgrPayConfigMapper;
    @Autowired
    private BkAgrPayConfigHisMapper bkAgrPayConfigHisMapper;
    @Autowired
    private BkAgrAppScopeMapper bkAgrAppScopeMapper;
    @Autowired
    private BkAgrAppScopeHispMapper bkAgrAppScopeHispMapper;
    @Autowired
    private BkAgrMateriaPriceItemMapper bkAgrMateriaPriceItemMapper;
    @Autowired
    private BkAgrMateriaPriceItemHisMapper bkAgrMateriaPriceItemHisMapper;
    @Autowired
    private BkAgrVersionMapper bkAgrVersionMapper;
    @Autowired
    private AgrAccessoryMapper agrAccessoryMapper;

    @Override
    public Long transDataFromMain2His(Long argId,List<BkAgrBigChangeItemDataWhileDo> bkWhileDos) {


        // 协议历史id
        Long agrMainHisId = IdUtil.nextId();

        // 转移协议主体表
        BkAgrMainPO bkagrmainpo = new BkAgrMainPO();
        bkagrmainpo.setAgrId(argId);
        BkAgrMainPO insertAgrMainBo = bkAgrMainMapper.getModelBy(bkagrmainpo);
        if (insertAgrMainBo!=null&&insertAgrMainBo.getAgrId()!=null) {
            BkAgrMainHisPO bkagrmainhispo = new BkAgrMainHisPO();
            BeanUtils.copyProperties(insertAgrMainBo, bkagrmainhispo);
            bkagrmainhispo.setAgrMainHisId(agrMainHisId);
            bkagrmainhispo.setAgrId(argId);
            bkAgrMainHisMapper.insert(bkagrmainhispo);
        }


        // 转移流程指引表
        BkAgrProcessGuidancePO bkagrprocessguidancepo = new BkAgrProcessGuidancePO();
        bkagrprocessguidancepo.setAgrId(argId);
        BkAgrProcessGuidancePO insertGuidancePo = bkAgrProcessGuidanceMapper.getModelBy(bkagrprocessguidancepo);
        if (insertGuidancePo!=null&&insertGuidancePo.getAgrId()!=null){
            BkAgrProcessGuidance_hisPO bkagrprocessguidanceHispo = new BkAgrProcessGuidance_hisPO();
            BeanUtils.copyProperties(insertGuidancePo,bkagrprocessguidanceHispo);
            bkagrprocessguidanceHispo.setAgrProcessGuidanceHisId(IdUtil.nextId());
            bkagrprocessguidanceHispo.setAgrMainHisId(agrMainHisId);
            bkagrprocessguidanceHispo.setAgrId(argId);
            bkAgrProcessGuidanceHisMapper.insert(bkagrprocessguidanceHispo);
        }

        // 转移支付配置表
        BkAgrPayConfigPO bkagrpayconfigpo = new BkAgrPayConfigPO();
        bkagrpayconfigpo.setAgrId(argId);
        List<BkAgrPayConfigPO> insertPayConfigPo = bkAgrPayConfigMapper.getList(bkagrpayconfigpo);
        if (insertPayConfigPo!=null&&insertPayConfigPo.size()>0) {
            List<BkAgrPayConfigHisPO> list = JSON.parseArray(JSON.toJSONString(insertPayConfigPo),BkAgrPayConfigHisPO.class);
            for (BkAgrPayConfigHisPO bkAgrPayConfigHisPO : list) {
                bkAgrPayConfigHisPO.setAgrMainHisId(agrMainHisId);
                bkAgrPayConfigHisPO.setPayCfgHisId(IdUtil.nextId());
                bkAgrPayConfigHisPO.setAgrId(argId);
            }
            bkAgrPayConfigHisMapper.insertBatch(list);
        }

        // 转移应用范围表
        BkAgrAppScopePO bkagrappscopepo = new BkAgrAppScopePO();
        bkagrappscopepo.setAgrId(argId);
        List<BkAgrAppScopePO> insertScopePo = bkAgrAppScopeMapper.getList(bkagrappscopepo);
        if (insertScopePo!=null&&insertScopePo.size()>0) {
            List<BkAgrAppScopeHispPO> list = JSON.parseArray(JSON.toJSONString(insertScopePo),BkAgrAppScopeHispPO.class);
            for (BkAgrAppScopeHispPO bkAgrAppScopeHispPO : list) {
                bkAgrAppScopeHispPO.setAppScopeHisId(IdUtil.nextId());
                bkAgrAppScopeHispPO.setAgrMainHisId(agrMainHisId);
                bkAgrAppScopeHispPO.setAgrId(argId);
            }
            bkAgrAppScopeHispMapper.insertBatch(list);
        }

        // 转移物料明细表
        BkAgrMateriaPriceItemPO bkagrmateriapriceitempo = new BkAgrMateriaPriceItemPO();
        bkagrmateriapriceitempo.setAgrId(argId);
        List<BkAgrMateriaPriceItemPO> list = bkAgrMateriaPriceItemMapper.getList(bkagrmateriapriceitempo);
        if (!CollectionUtils.isEmpty(list)) {
            List<BkAgrMateriaPriceItemHisPO> insertList = JSON.parseArray(JSON.toJSONString(list), BkAgrMateriaPriceItemHisPO.class);
            insertList.forEach(po->{
                po.setAgrMainHisId(agrMainHisId);
                po.setAgrId(argId);
                po.setAgrMateriaPriceItemHisId(IdUtil.nextId());
            });
            bkAgrMateriaPriceItemHisMapper.insertBatch(insertList);
        }

        // 转移附件信息表
        AgrAccessoryPO agrAccessoryPO = new AgrAccessoryPO();
        agrAccessoryPO.setObjId(argId);
        List<AgrAccessoryPO> list1 = agrAccessoryMapper.getList(agrAccessoryPO);
        if (!CollectionUtils.isEmpty(list1)){
            list1.forEach(obj->{
                obj.setObjId(agrMainHisId);
                obj.setId(IdUtil.nextId());
            });
            agrAccessoryMapper.insertBatch(list1);
        }

        // 协议版本
        BkAgrVersionPO bkAgrVersionPO = new BkAgrVersionPO();
        bkAgrVersionPO.setAgrId(argId);
        bkAgrVersionPO.setAgrVersion(insertAgrMainBo.getAgrVersion());
        // 根据协议id和版本号查询对应的版本记录
        BkAgrVersionPO modelBy = bkAgrVersionMapper.getModelBy(bkAgrVersionPO);
        if (null!=modelBy){
            // 设置历史版本号
            modelBy.setAgrMainHisId(agrMainHisId);
            modelBy.setAgrVersionStatus("EXPIRED");
            int i1 = bkAgrVersionMapper.updateBy(modelBy,bkAgrVersionPO);
        }


        return agrMainHisId;
    }

    @Override
    public BkAgrMainDo qryMainHis(Long agrId) {
        BkAgrMainHisPO hisPO = new BkAgrMainHisPO();
        hisPO.setAgrMainHisId(agrId);
        List<BkAgrMainHisPO> list = bkAgrMainHisMapper.getList(hisPO);
        return AgrRu.js(list.get(0),BkAgrMainDo.class);
    }
}
