package com.tydic.dyc.agr.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.JsonObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.agr.model.agr.BkAgrMainDo;
import com.tydic.dyc.agr.model.change.BkAgrBigChangeItemDataWhileDo;
import com.tydic.dyc.agr.model.change.BkAgrMateriaPriceItemDo;
import com.tydic.dyc.agr.model.version.AgrVersionModel;
import com.tydic.dyc.agr.repository.AgrRepository;
import com.tydic.dyc.agr.repository.dao.AgrAccessoryMapper;
import com.tydic.dyc.agr.repository.dao.BkAgrMainMapper;
import com.tydic.dyc.agr.repository.dao.BkAgrPayConfigMapper;
import com.tydic.dyc.agr.repository.dao.BkAgrProcessGuidanceMapper;
import com.tydic.dyc.agr.repository.po.AgrAccessoryPO;
import com.tydic.dyc.agr.repository.po.BkAgrMainPO;
import com.tydic.dyc.agr.repository.po.BkAgrPayConfigPO;
import com.tydic.dyc.agr.repository.po.BkAgrProcessGuidancePO;
import com.tydic.dyc.agr.service.agr.bo.AgrSaveOrSbumitAgrReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrSaveOrSbumitAgrRspBO;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.agr.repository.dao.*;
import com.tydic.dyc.agr.repository.po.*;
import com.tydic.dyc.agr.service.agr.bo.*;
import com.tydic.dyc.agr.utils.IdUtil;
import com.tydic.dyc.constants.AgrConstant;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.swing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zhanghengrui
 * @date 2023/1/30 10:47
 */
@Service
@Slf4j
public class AgrRepositoryImpl implements AgrRepository {
    @Autowired
    private BkAgrMainMapper bkAgrMainMapper;
    @Autowired
    private BkAgrVersionMapper bkAgrVersionMapper;
    @Autowired
    private BkAgrPayConfigMapper bkAgrPayConfigMapper;
    @Autowired
    private BkAgrProcessGuidanceMapper bkAgrProcessGuidanceMapper;
    @Autowired
    private AgrAccessoryMapper agrAccessoryMapper;
    @Autowired
    private BkAgrAppScopeMapper bkAgrAppScopeMapper;
    @Autowired
    private BkAgrMainHisMapper bkAgrMainHisMapper;
    @Autowired
    private BkAgrPayConfigHisMapper bkAgrPayConfigHisMapper;
    @Autowired
    private BkAgrProcessGuidance_hisMapper bkAgrProcessGuidanceHisMapper;
    @Autowired
    private BkAgrAppScopeHispMapper bkAgrAppScopeHisMapper;
    @Autowired
    private UocOrderTaskInstMapper uocOrderTaskInstMapper;
    @Autowired
    private BkAgrBigDataLogMapper bkAgrBigDataLogMapper;
    @Autowired
    private BkAgrMateriaItemMapper bkAgrMateriaItemMapper;
    @Autowired
    private BkAgrBigChangeItemDataWhileMapper bkAgrBigChangeItemDataWhileMapper;
    @Autowired
    private BkAgrBigChangeMainDataWhileMapper bkAgrBigChangeMainDataWhileMapper;
    @Autowired
    private BkAgrChangeBigDataLogPoMapper bkAgrChangeBigDataLogPoMapper;
    @Autowired
    private BkAgrMateriaPriceItemMapper bkAgrMateriaPriceItemMapper;
    @Autowired
    private AgrVersionModel agrVersionModel;


    @Override
    public AgrSaveOrSbumitAgrRspBO operAgr(AgrSaveOrSbumitAgrReqBO agrSaveOrSbumitAgrReqBO) {


        // 保存协议主数据:这个是必传
        BkAgrMainPO insertAgrMainBO = new BkAgrMainPO();

        BkAgrMainPO qryAgrMainBO = new BkAgrMainPO();
        qryAgrMainBO.setAgrId(agrSaveOrSbumitAgrReqBO.getAgrId());
        BkAgrMainPO agrMainPO = bkAgrMainMapper.getModelBy(qryAgrMainBO);

        if (agrMainPO!=null) {
//            BeanUtils.copyProperties(agrMainPO,insertAgrMainBO);
            BeanUtils.copyProperties(agrSaveOrSbumitAgrReqBO.getAgrAgrMainBO(), insertAgrMainBO);
            if (agrSaveOrSbumitAgrReqBO.getOperType()==2) insertAgrMainBO.setAgrStatus("APPROVAL");
            insertAgrMainBO.setAgrId(agrSaveOrSbumitAgrReqBO.getAgrId());
            insertAgrMainBO.setUpdateLoginId(agrSaveOrSbumitAgrReqBO.getUserId());
            insertAgrMainBO.setUpdateName(agrSaveOrSbumitAgrReqBO.getName());
            insertAgrMainBO.setUpdateUsername(agrSaveOrSbumitAgrReqBO.getUsername());
            insertAgrMainBO.setUpdateTime(new Date());
            //自营应用范围0
            if(agrSaveOrSbumitAgrReqBO.getAgrAgrMainBO().getIsAutarky()==1) {
                insertAgrMainBO.setScopeType(0);
            }else{
                BkAgrAppScopePO po = new BkAgrAppScopePO();
                agrMainPO.setAgrId(agrSaveOrSbumitAgrReqBO.getAgrId());
                List<BkAgrAppScopePO> list = bkAgrAppScopeMapper.getList(po);
                if(!CollectionUtils.isEmpty(list)) insertAgrMainBO.setScopeType(list.get(0).getScopeType());
            }
            int i = bkAgrMainMapper.updateBy(insertAgrMainBO,agrMainPO);
        }
//        }else {
//            BeanUtils.copyProperties(agrSaveOrSbumitAgrReqBO,insertAgrMainBO);
//            BeanUtils.copyProperties(agrSaveOrSbumitAgrReqBO.getAgrAgrMainBO(),insertAgrMainBO);
//        }

//        bkAgrMainMapper.insert(insertAgrMainBO);
//
//        // 协议流程指引
//        BkAgrProcessGuidancePO insertAgrprocessGuidancepo = new BkAgrProcessGuidancePO();
//        BkAgrProcessGuidancePO qryAgrprocessGuidancepo = new BkAgrProcessGuidancePO();
 //       qryAgrprocessGuidancepo.setAgrId(agrSaveOrSbumitAgrReqBO.getAgrId());
//        BkAgrProcessGuidancePO agrProcessGuidanceMapperModelBy = bkAgrProcessGuidanceMapper.getModelBy(qryAgrprocessGuidancepo);
//
//        if (agrProcessGuidanceMapperModelBy!=null){
//            BeanUtils.copyProperties(agrProcessGuidanceMapperModelBy,insertAgrprocessGuidancepo);
//            insertAgrprocessGuidancepo.setProcessGuidance(agrSaveOrSbumitAgrReqBO.getAgrProcessGuidanceBO().getProcessGuidance());
//        }else {
//            // 会存在添加新数据情况吗？
//        }
//
//        // 附件
//        AgrAccessoryPO delAgraccessoryPo = new AgrAccessoryPO();
//        delAgraccessoryPo.setObjId(agrSaveOrSbumitAgrReqBO.getAgrId());
//        agrAccessoryMapper.deleteBy(delAgraccessoryPo);
//
//        List<AgrAccessoryPO> list = new ArrayList<>();
//        if (!CollectionUtils.isEmpty(agrSaveOrSbumitAgrReqBO.getAgrAccessoryBOs())){
//            agrSaveOrSbumitAgrReqBO.getAgrAccessoryBOs().forEach(agrAccessoryBo ->{
//               AgrAccessoryPO insertAgrAccessoryPO = new AgrAccessoryPO();
//               BeanUtils.copyProperties(agrAccessoryBo,insertAgrAccessoryPO);
//               insertAgrAccessoryPO.setObjId(agrSaveOrSbumitAgrReqBO.getAgrId());
//               insertAgrAccessoryPO.setId(IdUtil.nextId());
//           } );insertAgrMainBO.setAgrId(agrSaveOrSbumitAgrReqBO.getAgrId());
//            int i = bkAgrMainMapper.updateById(insertAgrMainBO);
//       }

        // 协议流程指引
        if(agrSaveOrSbumitAgrReqBO.getAgrProcessGuidanceBO() != null){
        //BkAgrProcessGuidancePO insertAgrprocessGuidancepo = new BkAgrProcessGuidancePO();
        BkAgrProcessGuidancePO qryAgrprocessGuidancepo = new BkAgrProcessGuidancePO();
        qryAgrprocessGuidancepo.setAgrId(agrSaveOrSbumitAgrReqBO.getAgrId());
        bkAgrProcessGuidanceMapper.deleteBy(qryAgrprocessGuidancepo);
        qryAgrprocessGuidancepo.setProcessGuidance(agrSaveOrSbumitAgrReqBO.getAgrProcessGuidanceBO().getProcessGuidance());
        //BkAgrProcessGuidancePO agrProcessGuidanceMapperModelBy = bkAgrProcessGuidanceMapper.getModelBy(qryAgrprocessGuidancepo);
        qryAgrprocessGuidancepo.setAgrProcessGuidanceId(IdUtil.nextId());
        bkAgrProcessGuidanceMapper.insert(qryAgrprocessGuidancepo);
        //if (agrProcessGuidanceMapperModelBy!=null){
        //    BeanUtils.copyProperties(agrProcessGuidanceMapperModelBy,insertAgrprocessGuidancepo);
        //    insertAgrprocessGuidancepo.setProcessGuidance(agrSaveOrSbumitAgrReqBO.getAgrProcessGuidanceBO().getProcessGuidance());
        //
        //}else {
        //    // 会存在添加新数据情况吗？
        //}
//
        }
        // 附件
        AgrAccessoryPO delAgraccessoryPo = new AgrAccessoryPO();
        delAgraccessoryPo.setObjId(agrSaveOrSbumitAgrReqBO.getAgrId());
        agrAccessoryMapper.deleteBy(delAgraccessoryPo);

        List<AgrAccessoryPO> list = new ArrayList<>();
        if (!CollectionUtils.isEmpty(agrSaveOrSbumitAgrReqBO.getAgrAccessoryBOs())){
            agrSaveOrSbumitAgrReqBO.getAgrAccessoryBOs().forEach(agrAccessoryBo ->{
                AgrAccessoryPO insertAgrAccessoryPO = new AgrAccessoryPO();
                BeanUtils.copyProperties(agrAccessoryBo,insertAgrAccessoryPO);
                insertAgrAccessoryPO.setObjId(agrSaveOrSbumitAgrReqBO.getAgrId());
                insertAgrAccessoryPO.setId(IdUtil.nextId());
                insertAgrAccessoryPO.setObjType(1);
                insertAgrAccessoryPO.setOrderId(agrSaveOrSbumitAgrReqBO.getAgrId());
                list.add(insertAgrAccessoryPO);
            } );
            agrAccessoryMapper.insertBatch(list);
        }

        //协议支付配置表
        if(agrSaveOrSbumitAgrReqBO.getAgrPayConfigBO() != null){
            //为空 自营第一次保存
            BkAgrPayConfigPO delBkAgrPayConfigPo = new BkAgrPayConfigPO();
            delBkAgrPayConfigPo.setPayObj(1);
            delBkAgrPayConfigPo.setAgrId(agrSaveOrSbumitAgrReqBO.getAgrId());
            BkAgrPayConfigPO modelBy = bkAgrPayConfigMapper.getModelBy(delBkAgrPayConfigPo);

            if(agrSaveOrSbumitAgrReqBO.getAgrAgrMainBO().getIsAutarky() == 1 && modelBy == null){
                BkAgrPayConfigPO set = new BkAgrPayConfigPO();
                set.setPayObj(1);
                BkAgrPayConfigPO where = new BkAgrPayConfigPO();
                where.setAgrId(agrSaveOrSbumitAgrReqBO.getAgrId());
                bkAgrPayConfigMapper.updateBy(set,where);
            }else{
                delBkAgrPayConfigPo.setPayObj(0);
                bkAgrPayConfigMapper.deleteBy(delBkAgrPayConfigPo);
            }

            BkAgrPayConfigPO insertBkAgrPayConfigPo = new BkAgrPayConfigPO();
            BeanUtils.copyProperties(agrSaveOrSbumitAgrReqBO.getAgrPayConfigBO(),insertBkAgrPayConfigPo);
            insertBkAgrPayConfigPo.setAgrId(agrSaveOrSbumitAgrReqBO.getAgrId());
            insertBkAgrPayConfigPo.setPayObj(0);
            insertBkAgrPayConfigPo.setPayCfgId(IdUtil.nextId());
            bkAgrPayConfigMapper.insert(insertBkAgrPayConfigPo);
        }

        //自营变直销
        if(agrSaveOrSbumitAgrReqBO.getAgrAgrMainBO().getIsAutarky() == 0){
            BkAgrPayConfigPO delBkAgrPayConfigPo = new BkAgrPayConfigPO();
            delBkAgrPayConfigPo.setAgrId(agrSaveOrSbumitAgrReqBO.getAgrId());
            List<BkAgrPayConfigPO> configPOList = bkAgrPayConfigMapper.getList(delBkAgrPayConfigPo);
            if(configPOList.size()==2){
                bkAgrPayConfigMapper.deleteBy(delBkAgrPayConfigPo);
                List<BkAgrPayConfigPO> collect = configPOList.stream().filter(obj -> obj.getPayObj() == 1).collect(Collectors.toList());

                BkAgrPayConfigPO insertBkAgrPayConfigPo1 = new BkAgrPayConfigPO();
                BeanUtils.copyProperties(collect.get(0),insertBkAgrPayConfigPo1);
                insertBkAgrPayConfigPo1.setAgrId(agrSaveOrSbumitAgrReqBO.getAgrId());
                insertBkAgrPayConfigPo1.setPayObj(0);
                insertBkAgrPayConfigPo1.setPayCfgId(IdUtil.nextId());
                bkAgrPayConfigMapper.insert(insertBkAgrPayConfigPo1);
            }
        }
        return new AgrSaveOrSbumitAgrRspBO();
    }

    @Override
    public BkAgrMainDo qryMain(BkAgrMainDo bkAgrMainDo) {

        BkAgrMainPO modelBy = bkAgrMainMapper.getModelBy(AgrRu.js(bkAgrMainDo, BkAgrMainPO.class));
        return AgrRu.js(modelBy,BkAgrMainDo.class);
    }

    @Override
    public AgrQryAgrDetailRspBO qryAgrDetail(AgrQryAgrDetailReqBO agrQryAgrDetailReqBO) {

        AgrQryAgrDetailRspBO rspBO = new AgrQryAgrDetailRspBO();

        if (agrQryAgrDetailReqBO.getAgrMainHisId()==null){
            log.info("agrQryAgrDetailReqBO入参{}",JSONObject.toJSONString(agrQryAgrDetailReqBO));
            // 主要信息
            BkAgrMainPO qryAgrMainPO = new BkAgrMainPO();
            qryAgrMainPO.setAgrId(agrQryAgrDetailReqBO.getAgrId());
            qryAgrMainPO.setAgrStatus(agrQryAgrDetailReqBO.getAgrStatus());
            qryAgrMainPO.setAgrCode(agrQryAgrDetailReqBO.getAgrCode());
            BkAgrMainPO qryAgrMain = bkAgrMainMapper.getModelBy(qryAgrMainPO);
            if(qryAgrMain == null) return null;
            agrQryAgrDetailReqBO.setAgrId(qryAgrMain.getAgrId());

            AgrMainBO agrAgrMainBO = new AgrMainBO();
            BeanUtils.copyProperties(qryAgrMain,agrAgrMainBO);
            rspBO.setAgrAgrMainBO(agrAgrMainBO);

            // 指引说明
            BkAgrProcessGuidancePO qryPo = new BkAgrProcessGuidancePO();
            qryPo.setAgrId(agrQryAgrDetailReqBO.getAgrId());
            BkAgrProcessGuidancePO qryAgrProGuidance = bkAgrProcessGuidanceMapper.getModelBy(qryPo);

            AgrProcessGuidanceBO agrProcessGuidanceBO = new AgrProcessGuidanceBO();
            if (qryAgrProGuidance!=null) {
                BeanUtils.copyProperties(qryAgrProGuidance, agrProcessGuidanceBO);
            }
            rspBO.setAgrProcessGuidanceBO(agrProcessGuidanceBO);


            // 支付配置
            BkAgrPayConfigPO qryAgrPayConfig = new BkAgrPayConfigPO();
            qryAgrPayConfig.setAgrId(agrQryAgrDetailReqBO.getAgrId());
            List<BkAgrPayConfigPO> list = bkAgrPayConfigMapper.getList(qryAgrPayConfig);

            List<AgrPayConfigBO> agrPayConfigBOList = new ArrayList<>();

            if (!CollectionUtils.isEmpty(list)) {

                list.forEach(bkAgrPayConfigPO -> {
                    AgrPayConfigBO agrPayConfigBO = new AgrPayConfigBO();
                    BeanUtils.copyProperties(bkAgrPayConfigPO, agrPayConfigBO);
                    agrPayConfigBOList.add(agrPayConfigBO);
                });
            }

            rspBO.setAgrPayConfigBOs(agrPayConfigBOList);

            // 应用范围
            BkAgrAppScopePO qryAgrAppScope = new BkAgrAppScopePO();
            qryAgrAppScope.setAgrId(agrQryAgrDetailReqBO.getAgrId());
            List<BkAgrAppScopePO> scopeList = bkAgrAppScopeMapper.getList(qryAgrAppScope);

            List<AgrAppScopeBO> agrAppScopeBOs = new ArrayList<>();

            if (!CollectionUtils.isEmpty(scopeList)){
                scopeList.forEach(bkAgrAppScopePO -> {
                    AgrAppScopeBO agrAppScopeBO = new AgrAppScopeBO();
                    BeanUtils.copyProperties(bkAgrAppScopePO,agrAppScopeBO);
                    agrAppScopeBOs.add(agrAppScopeBO);
                });
            }

            rspBO.setAgrAppScopeBOs(agrAppScopeBOs);
            // 查询当前的环节
            UocOrderTaskInstPO qryOrderTaskInst = new UocOrderTaskInstPO();
            qryOrderTaskInst.setOrderId(agrQryAgrDetailReqBO.getAgrId());
            qryOrderTaskInst.setFinishTag(0);
            qryOrderTaskInst.setObjType(2);
            List<UocOrderTaskInstPO> orderTaskList = uocOrderTaskInstMapper.getList(qryOrderTaskInst);

            List<AgrTaskBO> busiTaskList = new ArrayList<>();

            if (!CollectionUtils.isEmpty(orderTaskList)){
                orderTaskList.forEach(uocOrderTaskInstPO -> {
                    AgrTaskBO agrTaskBO = new AgrTaskBO();
                    BeanUtils.copyProperties(uocOrderTaskInstPO,agrTaskBO);
                    busiTaskList.add(agrTaskBO);
                });
            }

            rspBO.setBusiTaskList(busiTaskList);

            // 查询所有的审批的环节
            UocOrderTaskInstPO qryTaskInst = new UocOrderTaskInstPO();
            UocOrderTaskAgrPO agrPO = new UocOrderTaskAgrPO();
            //qryOrderTaskInst.setOrderId(null);
//            qryOrderTaskInst.setFinishTag(0);
            agrPO.setObjType(9);
            //List<UocOrderTaskInstPO> taskList = uocOrderTaskInstMapper.getList(qryTaskInst);
            //0通过，1驳回
            if("APPROVAL".equals(qryAgrMain.getAgrStatus())){
                agrPO.setDealResult(2);
            }else {
                agrPO.setOrderBy("finishTime desc");
            }
            if(!StringUtils.isEmpty(agrQryAgrDetailReqBO.getIsProfessionalOrgExt())){
                if (!agrQryAgrDetailReqBO.getIsProfessionalOrgExt().equals("0")) agrPO.setDealOperId(agrQryAgrDetailReqBO.getUserId());
            }
            agrPO.setTaskInstIds(agrVersionModel.agrIdList(qryAgrMain.getAgrCode(),qryAgrMain.getAgrId()));
            List<UocOrderTaskInstPO> taskList = bkAgrMainMapper.taskIdQry(agrPO);
            List<AgrTaskBO> auditTaskList = new ArrayList<>();

            if (!CollectionUtils.isEmpty(taskList)){//只有一条记录
                taskList.forEach(uocOrderTaskInstPO -> {
                    AgrTaskBO agrTaskBO = new AgrTaskBO();
                    BeanUtils.copyProperties(uocOrderTaskInstPO,agrTaskBO);
                    agrTaskBO.setTaskId(uocOrderTaskInstPO.getTaskInstId());
                    agrTaskBO.setTacheCode(uocOrderTaskInstPO.getProcState());
                    agrTaskBO.setDealId(uocOrderTaskInstPO.getDealOperId()+"");
                    agrTaskBO.setDealName(uocOrderTaskInstPO.getDealOperName());
                    agrTaskBO.setDealRemark(uocOrderTaskInstPO.getDealRemark());
                    agrTaskBO.setDealResult(uocOrderTaskInstPO.getDealResult()+"");
                    agrTaskBO.setDealResultStr("1".equals(agrTaskBO.getDealResult())?"审批通过":"0".equals(agrTaskBO.getDealResult())?"审批驳回":"待审批");
                    auditTaskList.add(agrTaskBO);
                });
            }
            rspBO.setAuditTaskList(auditTaskList);

            //协议明细id，商品测用
            BkAgrMateriaPriceItemPO priceItemPO = new BkAgrMateriaPriceItemPO();
            priceItemPO.setAgrId(agrQryAgrDetailReqBO.getAgrId());
            List<BkAgrMateriaPriceItemPO> list1 = bkAgrMateriaPriceItemMapper.getList(priceItemPO);
            rspBO.setAgrItemList(JSON.parseArray(JSONObject.toJSONString(list1),AgrMateriaPriceItemBO.class));

        }else {
            // 主要信息
            BkAgrMainHisPO qryAgrMainPO = new BkAgrMainHisPO();
            qryAgrMainPO.setAgrMainHisId(agrQryAgrDetailReqBO.getAgrMainHisId());
            BkAgrMainHisPO qryAgrMain = bkAgrMainHisMapper.getModelBy(qryAgrMainPO);

            AgrMainBO agrAgrMainBO = new AgrMainBO();
            BeanUtils.copyProperties(qryAgrMain,agrAgrMainBO);
            rspBO.setAgrAgrMainBO(agrAgrMainBO);

            // 指引说明
            BkAgrProcessGuidance_hisPO qryPo = new BkAgrProcessGuidance_hisPO();
            qryPo.setAgrMainHisId(agrQryAgrDetailReqBO.getAgrMainHisId());
            BkAgrProcessGuidance_hisPO qryAgrProGuidance = bkAgrProcessGuidanceHisMapper.getModelBy(qryPo);

            AgrProcessGuidanceBO agrProcessGuidanceBO = new AgrProcessGuidanceBO();
            if (qryAgrProGuidance!=null) BeanUtils.copyProperties(qryAgrProGuidance,agrProcessGuidanceBO);
            rspBO.setAgrProcessGuidanceBO(agrProcessGuidanceBO);


            // 支付配置
            BkAgrPayConfigHisPO qryAgrPayConfig = new BkAgrPayConfigHisPO();
            qryAgrPayConfig.setAgrMainHisId(agrQryAgrDetailReqBO.getAgrMainHisId());
            List<BkAgrPayConfigHisPO> list = bkAgrPayConfigHisMapper.getList(qryAgrPayConfig);

            List<AgrPayConfigBO> agrPayConfigBOList = new ArrayList<>();

            if (!CollectionUtils.isEmpty(list)) {

                list.forEach(bkAgrPayConfigPO -> {
                    AgrPayConfigBO agrPayConfigBO = new AgrPayConfigBO();
                    BeanUtils.copyProperties(bkAgrPayConfigPO, agrPayConfigBO);
                    agrPayConfigBOList.add(agrPayConfigBO);
                });
            }

            rspBO.setAgrPayConfigBOs(agrPayConfigBOList);

            // 应用范围
            BkAgrAppScopeHispPO qryAgrAppScope = new BkAgrAppScopeHispPO();
            qryAgrAppScope.setAgrMainHisId(agrQryAgrDetailReqBO.getAgrMainHisId());
            List<BkAgrAppScopeHispPO> scopeList = bkAgrAppScopeHisMapper.getList(qryAgrAppScope);

            List<AgrAppScopeBO> agrAppScopeBOs = new ArrayList<>();

            if (!CollectionUtils.isEmpty(scopeList)){
                scopeList.forEach(bkAgrAppScopePO -> {
                    AgrAppScopeBO agrAppScopeBO = new AgrAppScopeBO();
                    BeanUtils.copyProperties(bkAgrAppScopePO,agrAppScopeBO);
                    agrAppScopeBOs.add(agrAppScopeBO);
                });
            }

            rspBO.setAgrAppScopeBOs(agrAppScopeBOs);

            // 查询当前的环节
            UocOrderTaskInstPO qryOrderTaskInst = new UocOrderTaskInstPO();
            qryOrderTaskInst.setOrderId(agrQryAgrDetailReqBO.getAgrMainHisId());
            qryOrderTaskInst.setFinishTag(0);
            qryOrderTaskInst.setObjType(2);
            List<UocOrderTaskInstPO> orderTaskList = uocOrderTaskInstMapper.getList(qryOrderTaskInst);

            List<AgrTaskBO> busiTaskList = new ArrayList<>();

            if (!CollectionUtils.isEmpty(orderTaskList)){
                orderTaskList.forEach(uocOrderTaskInstPO -> {
                    AgrTaskBO agrTaskBO = new AgrTaskBO();
                    BeanUtils.copyProperties(uocOrderTaskInstPO,agrTaskBO);
                    busiTaskList.add(agrTaskBO);
                });
            }

            rspBO.setBusiTaskList(busiTaskList);

            // 查询所有的审批的环节
            UocOrderTaskInstPO qryTaskInst = new UocOrderTaskInstPO();
            qryOrderTaskInst.setOrderId(qryAgrMain.getAgrId());
//            qryOrderTaskInst.setFinishTag(0);
            qryOrderTaskInst.setObjType(9);
            List<UocOrderTaskInstPO> taskList = uocOrderTaskInstMapper.getList(qryTaskInst);

            List<AgrTaskBO> auditTaskList = new ArrayList<>();

            if (!CollectionUtils.isEmpty(auditTaskList)){
                taskList.forEach(uocOrderTaskInstPO -> {
                    AgrTaskBO agrTaskBO = new AgrTaskBO();
                    BeanUtils.copyProperties(uocOrderTaskInstPO,agrTaskBO);
                    auditTaskList.add(agrTaskBO);
                });
            }

            rspBO.setAuditTaskList(auditTaskList);
        }
        //附件查询
        AgrAccessoryPO agrAccessoryPO = new AgrAccessoryPO();
        agrAccessoryPO.setObjId(agrQryAgrDetailReqBO.getAgrId() != null?agrQryAgrDetailReqBO.getAgrId():agrQryAgrDetailReqBO.getAgrMainHisId());
        List<AgrAccessoryPO> list = agrAccessoryMapper.getList(agrAccessoryPO);
        rspBO.setAgrAccessoryBOs(AgrRu.jsl(list,AgrAccessoryBo.class));

        log.info("查询协议详情出参:"+JSON.toJSONString(rspBO));

        return rspBO;

    }

    @Override
    public void updateBy(BkAgrMainDo bkAgrMainDo) {
        BkAgrMainPO set = new BkAgrMainPO();
        set.setAgrStatus(bkAgrMainDo.getAgrStatus());
        set.setAgrSupAvailableStatus(bkAgrMainDo.getAgrSupAvailableStatus());
        BkAgrMainPO where = new BkAgrMainPO();
        where.setAgrId(bkAgrMainDo.getAgrId());
        where.setAgrSupOrgId(bkAgrMainDo.getAgrSupOrgId());
        bkAgrMainMapper.updateBy(set,where);
    }

    @Override
    public Integer updateAgrMainStatus(BkAgrMainDo bkAgrMainDo) {

        BkAgrMainPO set = new BkAgrMainPO();
        BkAgrMainPO where = new BkAgrMainPO();
        BeanUtils.copyProperties(bkAgrMainDo,set);
        where.setAgrId(bkAgrMainDo.getAgrId());
        int i = bkAgrMainMapper.updateBy(set, where);
        return i;
    }

    @Override
    public void insertAgrMain(AgrMainBO agrMainBO) {
        agrMainBO.setCreateTime(new Date());
        bkAgrMainMapper.insert(AgrRu.js(agrMainBO,BkAgrMainPO.class));

        // 添加版本信息
        // 主体只推一次
        //BkAgrVersionPO bkagrversionpo = new BkAgrVersionPO();
        //bkagrversionpo.setAgrVersionId(IdUtil.nextId());
        //bkagrversionpo.setAgrId(agrMainBO.getAgrId());
        //bkagrversionpo.setAgrCode(agrMainBO.getAgrCode());
        //bkagrversionpo.setAgrVersion(agrMainBO.getAgrVersion());
        //bkagrversionpo.setCreateTime(new Date());
        //bkagrversionpo.setAgrVersionStatus("EFFECTIVE");
        //// 合同新增
        //bkagrversionpo.setAgrSource(2);
        //bkAgrVersionMapper.insert(bkagrversionpo);

    }
    @Override
    public void insertVersion(AgrMainBO agrMainBO) {
        // 添加版本信息
        // 主体只推一次
        BkAgrVersionPO bkagrversionpo = new BkAgrVersionPO();
        bkagrversionpo.setAgrVersionId(IdUtil.nextId());
        bkagrversionpo.setAgrId(agrMainBO.getAgrId());
        bkagrversionpo.setAgrCode(agrMainBO.getAgrCode());
        bkagrversionpo.setAgrVersion(agrMainBO.getAgrVersion());
        bkagrversionpo.setCreateTime(new Date());
        bkagrversionpo.setAgrVersionStatus(agrMainBO.getAgrStatus());
        // 合同新增
        bkagrversionpo.setAgrSource(2);
        bkAgrVersionMapper.insert(bkagrversionpo);
    }

    @Override
    public void insertAgrPayConfig(AgrPayConfigBO agrPayConfigBO) {
        bkAgrPayConfigMapper.insert(AgrRu.js(agrPayConfigBO,BkAgrPayConfigPO.class));
    }

    @Override
    public void insertAgrAppScope(AgrAppScopeBO agrAppScopeBO) {
      bkAgrAppScopeMapper.insert(AgrRu.js(agrAppScopeBO,BkAgrAppScopePO.class));
    }

    @Override
    public void insertMateriaPriceItemList(List<AgrMateriaPriceItemBO> agrMainBO) {
        bkAgrMateriaPriceItemMapper.insertBatch(AgrRu.jsl(agrMainBO,BkAgrMateriaPriceItemPO.class));
    }

    @Override
    public List<BkAgrMainDo> qryEffectAgr(BkAgrMainDo bkAgrMainDo) {
        BkAgrMainPO bkagrmainpo = new BkAgrMainPO();
        if(bkAgrMainDo.getAgrSupOrgId() !=null){ //失效查询使用
            bkagrmainpo.setAgrSupOrgId(bkAgrMainDo.getAgrSupOrgId());
        }else {
            bkagrmainpo.setAgrStatus("UNEFFECTIVE");
        }
        List<BkAgrMainPO> list = bkAgrMainMapper.getList(bkagrmainpo);
        List<BkAgrMainDo> resultList= new ArrayList<>();
        if (!CollectionUtils.isEmpty(list)){
            resultList = JSONArray.parseArray(JSON.toJSONString(list),BkAgrMainDo.class);
        }

        return resultList;
    }

    @Override
    public AgrDeleteUselessAgrRspBO deleteUselessAgr(AgrDeleteUselessAgrReqBO agrDeleteUselessAgrReqBO) {

        // 1.日志表信息更新
        BkAgrBigDataLogPO qryBo = new BkAgrBigDataLogPO();
        qryBo.setAgrId(agrDeleteUselessAgrReqBO.getAgrId().toString());
        BkAgrBigDataLogPO modelBy = bkAgrBigDataLogMapper.getModelBy(qryBo);

        if (modelBy!=null&&modelBy.getAgrId()!=null){
            modelBy.setDealStatus("3");
            int i = bkAgrBigDataLogMapper.updateById(modelBy);
        }

        // 2.根据deleteType处理数据

        // 2.1 删除数据
        if (agrDeleteUselessAgrReqBO.getDeleteType()==1){
            // 删除协议主体
            BkAgrMainPO bkAgrMainPO = new BkAgrMainPO();
            bkAgrMainPO.setAgrId(agrDeleteUselessAgrReqBO.getAgrId());
            bkAgrMainMapper.deleteBy(bkAgrMainPO);

            // 删除应用范围表
            BkAgrAppScopePO bkAgrAppScopePO = new BkAgrAppScopePO();
            bkAgrAppScopePO.setAgrId(agrDeleteUselessAgrReqBO.getAgrId());
            bkAgrAppScopeMapper.deleteBy(bkAgrAppScopePO);

            // 删除协议支付配置
            BkAgrPayConfigPO bkagrpayconfigpo = new BkAgrPayConfigPO();
            bkagrpayconfigpo.setAgrId(agrDeleteUselessAgrReqBO.getAgrId());
            bkAgrPayConfigMapper.deleteBy(bkagrpayconfigpo);

            // 删除协议物料价格明细
            BkAgrMateriaItemPO bkagrmateriaitempo = new BkAgrMateriaItemPO();
            bkagrmateriaitempo.setAgrId(agrDeleteUselessAgrReqBO.getAgrId());
            bkAgrMateriaItemMapper.deleteBy(bkagrmateriaitempo);

            // 删除协议流程指引说明表
            BkAgrProcessGuidancePO bkagrprocessguidancepo = new BkAgrProcessGuidancePO();
            bkagrprocessguidancepo.setAgrId(agrDeleteUselessAgrReqBO.getAgrId());
            bkAgrProcessGuidanceMapper.deleteBy(bkagrprocessguidancepo);


        }
        // 2.1 转移数据
        else if (agrDeleteUselessAgrReqBO.getDeleteType()==2){

            //变更批量数据处理明细信息临时表
            BkAgrBigChangeItemDataWhilePO bkagrbigchangeitemdatawhilepo = new BkAgrBigChangeItemDataWhilePO();
            bkagrbigchangeitemdatawhilepo.setAgrId(agrDeleteUselessAgrReqBO.getAgrId());
            bkAgrBigChangeItemDataWhileMapper.deleteBy(bkagrbigchangeitemdatawhilepo);

            //变更批量数据处理主体信息临时表
            BkAgrBigChangeMainDataWhilePO bkagrbigchangemaindatawhilepo = new BkAgrBigChangeMainDataWhilePO();
            bkagrbigchangemaindatawhilepo.setAgrId(agrDeleteUselessAgrReqBO.getAgrId());
            bkAgrBigChangeMainDataWhileMapper.deleteBy(bkagrbigchangemaindatawhilepo);
        }


        return new AgrDeleteUselessAgrRspBO();
    }

    @Override
    public AgrAddChangeAgrSyncRspBO addChangeAgrSync(AgrAddChangeAgrSyncReqBO agrAddChangeAgrSyncReqBO,Long agrId) {

        AgrAddChangeAgrSyncRspBO rspBO = new AgrAddChangeAgrSyncRspBO();

        // 查询批量数据处理日志表
        BkAgrBigDataLogPO bkagrbigdatalogpo = new BkAgrBigDataLogPO();
        bkagrbigdatalogpo.setAgrId(agrId.toString());
        bkagrbigdatalogpo.setBatchUniqueId(agrAddChangeAgrSyncReqBO.getBatchUniqueId());
        List<BkAgrBigDataLogPO> list = bkAgrBigDataLogMapper.getList(bkagrbigdatalogpo);

        // 已经同步完成
        BkAgrBigDataLogPO insertAgrBigDataLogPo = new BkAgrBigDataLogPO();
        if (list.size() > agrAddChangeAgrSyncReqBO.getTotalBatchCount()) throw new ZTBusinessException("已经同步完成");
        // 新增日志表数据
        else {
            insertAgrBigDataLogPo.setAgrId(agrId.toString());
            insertAgrBigDataLogPo.setBatchUniqueId(agrAddChangeAgrSyncReqBO.getBatchUniqueId());
            insertAgrBigDataLogPo.setNowBatchCount(agrAddChangeAgrSyncReqBO.getNowBatchCount());
            insertAgrBigDataLogPo.setAgrBigDataLogId(IdUtil.nextId());
//            bkAgrBigDataLogMapper.insert(insertAgrBigDataLogPo);
        }

        // 新增主体信息数据
        if (list.get(0).equals("1")){
            AgrMainBO agrAgrMainBO = agrAddChangeAgrSyncReqBO.getAgrAgrMainBO();
            BkAgrBigChangeMainDataWhilePO bkagrbigchangemaindatawhilepo = JSON.parseObject(JSON.toJSONString(agrAgrMainBO),BkAgrBigChangeMainDataWhilePO.class);
            int insert = bkAgrBigChangeMainDataWhileMapper.insert(bkagrbigchangemaindatawhilepo);

        }

        // 有明细数据
        List<AgrMateriaPriceItemBO> agrMateriaPriceItemBOs = agrAddChangeAgrSyncReqBO.getAgrMateriaPriceItemBOs();
        List<BkAgrBigChangeItemDataWhilePO> insertAgrBigChangeBatch = JSON.parseArray(JSON.toJSONString(agrMateriaPriceItemBOs),BkAgrBigChangeItemDataWhilePO.class);
        bkAgrBigChangeItemDataWhileMapper.insertBatch(insertAgrBigChangeBatch);

        // 更新新增日志数据处理状态
        insertAgrBigDataLogPo.setDealStatus("2");
        if (list.size()+1==agrAddChangeAgrSyncReqBO.getTotalBatchCount()){
            rspBO.setIsSysnEs(1);
            // 新增协议版本记录表
            // 更改协议表的状态
            // 新增变更表数据
            BkAgrChangeBigDataLogPo record = new BkAgrChangeBigDataLogPo();
            record.setAgrChangeBigDataLogId(IdUtil.nextId());
            record.setBatchUniqueId(agrAddChangeAgrSyncReqBO.getBatchUniqueId());
            bkAgrChangeBigDataLogPoMapper.insert(record);
        }


        return rspBO;


    }

    @Override
    public AgrAddChangeAgrSyncFromPriceStockRspBO addChangeAgrSyncFromPriceStock(AgrAddChangeAgrSyncFromPriceStockReqBO agrAddChangeAgrSyncFromPriceStockReqBO) {

        AgrAddChangeAgrSyncFromPriceStockRspBO rspBO = new AgrAddChangeAgrSyncFromPriceStockRspBO();

        // 1.批量操作校验
        // 查询批量数据处理日志表
        BkAgrBigDataLogPO bkagrbigdatalogpo = new BkAgrBigDataLogPO();
        bkagrbigdatalogpo.setAgrId(agrAddChangeAgrSyncFromPriceStockReqBO.getAgrId().toString());
        bkagrbigdatalogpo.setBatchUniqueId(agrAddChangeAgrSyncFromPriceStockReqBO.getBatchUniqueId());
        List<BkAgrBigDataLogPO> list = bkAgrBigDataLogMapper.getList(bkagrbigdatalogpo);

        BkAgrBigDataLogPO insertAgrBigDataLogPo = new BkAgrBigDataLogPO();
        if (list.size() == agrAddChangeAgrSyncFromPriceStockReqBO.getTotalBatchCount()) throw new ZTBusinessException("已经同步完成");
            // 新增日志表数据
        else {
            insertAgrBigDataLogPo.setAgrId(agrAddChangeAgrSyncFromPriceStockReqBO.getAgrId().toString());
            insertAgrBigDataLogPo.setBatchUniqueId(agrAddChangeAgrSyncFromPriceStockReqBO.getBatchUniqueId());
            insertAgrBigDataLogPo.setNowBatchCount(agrAddChangeAgrSyncFromPriceStockReqBO.getNowBatchCount());
            insertAgrBigDataLogPo.setAgrBigDataLogId(IdUtil.nextId());
//            bkAgrBigDataLogMapper.insert(insertAgrBigDataLogPo);
        }

        // 2.存明细信息到临时表
        List<BkAgrMateriaPriceItemBO> agrMateriaPriceItemBOs = agrAddChangeAgrSyncFromPriceStockReqBO.getAgrMateriaPriceItemBOs();
        List<BkAgrBigChangeItemDataWhilePO> insertAgrBigChangeBatch = JSON.parseArray(JSON.toJSONString(agrMateriaPriceItemBOs),BkAgrBigChangeItemDataWhilePO.class);
        bkAgrBigChangeItemDataWhileMapper.insertBatch(insertAgrBigChangeBatch);

        // 更新日志为处理完成
        insertAgrBigDataLogPo.setDealStatus("2");
        // 判断是否处理完成
        if (list.size()+1==agrAddChangeAgrSyncFromPriceStockReqBO.getTotalBatchCount()){
            rspBO.setSyncFinishFlag(1);
            if (agrAddChangeAgrSyncFromPriceStockReqBO.getSyncType()==2){
                //新增更新协议版本记录表信息

            }
        }

        // 记录变更日志表
        BkAgrChangeBigDataLogPo record = new BkAgrChangeBigDataLogPo();
        record.setAgrChangeBigDataLogId(IdUtil.nextId());
        record.setBatchUniqueId(agrAddChangeAgrSyncFromPriceStockReqBO.getBatchUniqueId());
        bkAgrChangeBigDataLogPoMapper.insert(record);

        return rspBO;

    }

    @Override
    public List<BkAgrMateriaPriceItemDo> transDataFromChangeTemp2Main(Long agrId, Long batchUniqueId, List<BkAgrBigChangeItemDataWhileDo> bkWhileDos,Long agrHisId,AgrChangeCronJobRspBO agrChangeCronJobRspBO) {


        // 查询出当前版本的物料明细数据
        BkAgrMateriaPriceItemPO bkagrmateriapriceitempo = new BkAgrMateriaPriceItemPO();
        bkagrmateriapriceitempo.setAgrId(agrId);
        bkagrmateriapriceitempo.setPriceUseType(2);
        List<BkAgrMateriaPriceItemPO> listOld = bkAgrMateriaPriceItemMapper.getList(bkagrmateriapriceitempo);

        // 初始化
        List<BkAgrMateriaPriceItemDo> delList = new ArrayList<>();
        // 如果为空，即变更的明细没有，那么全删
        if (bkWhileDos.size()==0) delList = AgrRu.jsl(listOld,BkAgrMateriaPriceItemDo.class);
            // 取两者的交集，是删除的明细数据，需要返回给商品
        else {
            for (BkAgrMateriaPriceItemPO bkAgrMateriaPriceItemPO : listOld) {
                boolean flag = false;
                // 如果当前价格明细表中这条数据，在变更明细表中没有，那么就是删除的
                for (BkAgrBigChangeItemDataWhileDo bkWhileDo : bkWhileDos) if (bkAgrMateriaPriceItemPO.getAgrMateriaPriceItemId().equals(bkWhileDo.getAgrMateriaPriceItemId())) flag = true;

                if (!flag) {
                    BkAgrMateriaPriceItemDo bkAgrMateriaPriceItemDo = JSON.parseObject(JSON.toJSONString(bkAgrMateriaPriceItemPO), BkAgrMateriaPriceItemDo.class);
                    // 删除
                    bkAgrMateriaPriceItemDo.setChangeType(3);
                    delList.add(bkAgrMateriaPriceItemDo);
                }
            }

        }

        log.info("清理出明细中删除的数据："+JSON.toJSONString(delList));


        int i = 0;

        // 查询主数据并转移
        BkAgrBigChangeMainDataWhilePO qryPo = new BkAgrBigChangeMainDataWhilePO();
        qryPo.setAgrId(agrId);
        qryPo.setBatchUniqueId(batchUniqueId);
        BkAgrBigChangeMainDataWhilePO mainData = bkAgrBigChangeMainDataWhileMapper.getModelBy(qryPo);

        String mainDateJson = mainData.getMainDateJson();

        // 查出原有的协议主表数据
        BkAgrMainPO bkagrmainpo = new BkAgrMainPO();
        bkagrmainpo.setAgrId(agrId);
        BkAgrMainPO mainPO = bkAgrMainMapper.getModelBy(bkagrmainpo);

        log.info("原有协议主表数据："+mainPO);

        if (!mainDateJson.equals("")){
            AgrTransDataBo agrTransDataBo = JSON.parseObject(mainDateJson, AgrTransDataBo.class);

            // 保存主表数据
            if (agrTransDataBo.getAgrMainBO()!=null) {

                BkAgrMainPO delMain = new BkAgrMainPO();
                delMain.setAgrId(agrId);
                bkAgrMainMapper.deleteBy(delMain);

                BkAgrMainPO insertMain = new BkAgrMainPO();
                BeanUtils.copyProperties(mainData, insertMain);
                BeanUtils.copyProperties(agrTransDataBo.getAgrMainBO(),insertMain);
                // 物资类别
                insertMain.setMaterialCategory(mainPO.getMaterialCategory());
                // 超发比例
                insertMain.setOverRatio(mainPO.getOverRatio());
                // 是否慧财自营
                insertMain.setIsAutarky(mainPO.getIsAutarky());
                // 创建商品
                insertMain.setIsCreateGoods(mainPO.getIsCreateGoods());
                insertMain.setAgrSupContactPhone(mainPO.getAgrSupContactPhone());
                insertMain.setAgrSupEmail(mainPO.getAgrSupEmail());
                insertMain.setAgrSupContact(mainPO.getAgrSupContact());
                insertMain.setGroupOperator(mainPO.getGroupOperator());
                insertMain.setRemark(mainPO.getRemark());
                insertMain.setUpdateLoginId(mainPO.getUpdateLoginId());
                insertMain.setUpdateName(mainPO.getUpdateName());
                insertMain.setUpdateTime(mainPO.getUpdateTime());
                insertMain.setUpdateUsername(mainPO.getUpdateUsername());
                // 协议名称保留原状
                insertMain.setAgrName(mainPO.getAgrName());
                insertMain.setAgrId(agrId);
                insertMain.setAgrStatus(getStatus(mainPO,insertMain));
                insertMain.setAgrVersion(getVersion(mainPO));
                int insert = bkAgrMainMapper.insert(insertMain);

                // 如果审批通过的话升级版本信息
                if (mainPO.getAgrStatus().equals("UNEFFECTIVE")||mainPO.getAgrStatus().equals("EFFECTIVE")||mainPO.getAgrStatus().equals("EXPIRED")) {
                    BkAgrVersionPO bkagrversionpo = new BkAgrVersionPO();
                    bkagrversionpo.setAgrVersionId(IdUtil.nextId());
                    bkagrversionpo.setAgrId(agrId);
                    bkagrversionpo.setAgrCode(insertMain.getAgrCode());
                    bkagrversionpo.setAgrVersion(insertMain.getAgrVersion());
                    bkagrversionpo.setCreateTime(new Date());
                    bkagrversionpo.setAgrVersionStatus("EFFECTIVE");
                    // 合同变更
                    bkagrversionpo.setAgrSource(2);
                    bkAgrVersionMapper.insert(bkagrversionpo);
                }


                i = i + insert;
            }
            // 保存指引表
            if (agrTransDataBo.getAgrProcessGuidanceBO()!=null){

                BkAgrProcessGuidancePO delPo = new BkAgrProcessGuidancePO();
                delPo.setAgrId(agrId);
                bkAgrProcessGuidanceMapper.deleteBy(delPo);

                BkAgrProcessGuidancePO insertPo = new BkAgrProcessGuidancePO();
                BeanUtils.copyProperties(mainData, insertPo);
                BeanUtils.copyProperties(agrTransDataBo.getAgrProcessGuidanceBO(),insertPo);
                insertPo.setAgrProcessGuidanceId(IdUtil.nextId());
                insertPo.setAgrId(agrId);
                int insert = bkAgrProcessGuidanceMapper.insert(insertPo);

                i = i + insert;
            }

            List<AgrAppScopeBO> list = new ArrayList<>();
            // 保存应用范围表
            if (agrTransDataBo.getAgrAppScopeBO()!=null){

                BkAgrAppScopePO delPo = new BkAgrAppScopePO();
                delPo.setAgrId(agrId);
                bkAgrAppScopeMapper.deleteBy(delPo);

                for (AgrAppScopeBO agrAppScopeBO : agrTransDataBo.getAgrAppScopeBO()) {
                    BkAgrAppScopePO insertPo = new BkAgrAppScopePO();
                    BeanUtils.copyProperties(mainData, insertPo);
                    BeanUtils.copyProperties(agrAppScopeBO,insertPo);
                    insertPo.setAppScopeId(IdUtil.nextId());
                    insertPo.setAgrId(agrId);
                    int insert = bkAgrAppScopeMapper.insert(insertPo);

                    AgrAppScopeBO agrAppScope = new AgrAppScopeBO();
                    agrAppScope.setOrgPath(agrAppScopeBO.getOrgPath());
                    agrAppScope.setOrgId(agrAppScopeBO.getOrgId());
                    list.add(agrAppScope);

                    i = i + insert;
                }

                AgrUccAutoSyncWhiteBO agrUccAutoSyncWhiteBO = new AgrUccAutoSyncWhiteBO();
                agrUccAutoSyncWhiteBO.setList(list);
                agrUccAutoSyncWhiteBO.setAgrCode(agrTransDataBo.getAgrMainBO().getAgrCode());
                agrUccAutoSyncWhiteBO.setScopeType(agrTransDataBo.getAgrMainBO().getScopeType());
                agrChangeCronJobRspBO.setAgrUccAutoSyncWhiteBO(agrUccAutoSyncWhiteBO);
            }



            // 保存支付配置表
            if (agrTransDataBo.getAgrPayConfigBO()!=null){


                List<BkAgrPayConfigPO> insertPoList = new ArrayList<>();

                BkAgrPayConfigPO bkagrpayconfigpo = new BkAgrPayConfigPO();
                bkagrpayconfigpo.setAgrId(agrId);
                bkagrpayconfigpo.setPayObj(1);
                List<BkAgrPayConfigPO> list1 = bkAgrPayConfigMapper.getList(bkagrpayconfigpo);

                BkAgrPayConfigPO delPo = new BkAgrPayConfigPO();
                delPo.setAgrId(agrId);
                bkAgrPayConfigMapper.deleteBy(delPo);

                for (AgrPayConfigBO agrPayConfigBO : agrTransDataBo.getAgrPayConfigBO()) {
                    BkAgrPayConfigPO insertPo = new BkAgrPayConfigPO();
                    BeanUtils.copyProperties(mainData, insertPo);
                    BeanUtils.copyProperties(agrPayConfigBO,insertPo);
                    insertPo.setPayCfgId(IdUtil.nextId());
                    insertPo.setAgrId(agrId);
                    insertPo.setPayObj(0);
                    insertPoList.add(insertPo);
                }

                if (!CollectionUtils.isEmpty(list)){
                    for (BkAgrPayConfigPO bkAgrPayConfigPO : list1) {
                        bkAgrPayConfigPO.setAgrId(agrId);
                        bkAgrPayConfigPO.setPayCfgId(IdUtil.nextId());
                        insertPoList.add(bkAgrPayConfigPO);

                    }
                }
                bkAgrPayConfigMapper.insertBatch(insertPoList);


            }
        }


        // 查询变更的物料明细数据
//        BkAgrBigChangeItemDataWhilePO bkagrbigchangeitemdatawhilepo = new BkAgrBigChangeItemDataWhilePO();
//        bkagrbigchangeitemdatawhilepo.setAgrId(agrId);
//        bkagrbigchangeitemdatawhilepo.setBatchUniqueId(batchUniqueId);
//        List<BkAgrBigChangeItemDataWhilePO> listChange = bkAgrBigChangeItemDataWhileMapper.getList(bkagrbigchangeitemdatawhilepo);


        // 因为推变更的时候是全量，即不变的也会推送，那么直接全部删除
        BkAgrMateriaPriceItemPO bkAgrMateriaPriceItemPO = new BkAgrMateriaPriceItemPO();
        bkAgrMateriaPriceItemPO.setAgrId(agrId);
        bkAgrMateriaPriceItemMapper.deleteBy(bkAgrMateriaPriceItemPO);

        // 因为变更推送的是新增，变更，不变，所以可以直接全增
        if (!CollectionUtils.isEmpty(bkWhileDos)) {
            List<BkAgrMateriaPriceItemPO> jsl = AgrRu.jsl(bkWhileDos, BkAgrMateriaPriceItemPO.class);
            jsl.forEach(po->{
                    po.setAgrMateriaPriceItemId(IdUtil.nextId());
                    po.setAgrId(agrId);
                }
            );
            bkAgrMateriaPriceItemMapper.insertBatch(jsl);
        }

        return delList;
    }

    private String getStatus(BkAgrMainPO mainPO,BkAgrMainPO newMainPO){

        log.info("协议状态："+mainPO.getAgrStatus()+" 失效时间："+newMainPO.getExpDate());

        // 如果是审批中或者草稿就设置为草稿
        if (mainPO.getAgrStatus().equals("DRAFT")||mainPO.getAgrStatus().equals("APPROVAL")||mainPO.getAgrStatus().equals("REJECT")) return "DRAFT";

        Date now = new Date();
        // 如果已经过了失效日期
        if(newMainPO.getExpDate().before(now)) return AgrConstant.APPROVE_STATUS.EXPIRED;

        return mainPO.getAgrStatus();
    }


    private String getVersion(BkAgrMainPO mainPO){
        String agrVersion = mainPO.getAgrVersion();
        String agrStatus = mainPO.getAgrStatus();
        if (agrStatus.equals("UNEFFECTIVE")||agrStatus.equals("EFFECTIVE")||agrStatus.equals("EXPIRED")) {
            int num = Integer.parseInt(agrVersion.substring(1)) + 1;
            return "V"+num;
        }
       return agrVersion;
    }



    @Override
    public void inserttAgrAppScopeBatch(List<AgrAppScopeBO> list) {
        List<AgrAppScopePO> jsl = AgrRu.jsl(list, AgrAppScopePO.class);
        bkAgrAppScopeMapper.insertBatch(AgrRu.jsl(list, BkAgrAppScopePO.class));
    }

    @Override
    public AgrQryAgrUseSupListRspBO qryAgrUseSupList(AgrQryAgrUseSupListReqBO reqBO) {
        AgrQryAgrUseSupListRspBO rsp = new AgrQryAgrUseSupListRspBO();
        Page<BkAgrMainPO> page = new Page<>(reqBO.getPageNo(), reqBO.getPageSize());
        List<BkAgrMainPO> result = this.bkAgrMainMapper.getUseSupListPage(AgrRu.js(reqBO, BkAgrMainPO.class), page);
        if (ObjectUtil.isNotEmpty(result)) {
            List<AgrUseSupBO> rows = AgrRu.jsl(result,AgrUseSupBO.class);
            rsp.setRows(rows);
        }
        rsp.setTotal(page.getTotalPages());
        rsp.setPageNo(page.getPageNo());
        rsp.setRecordsTotal(page.getTotalCount());
        return rsp;
    }

    @Override
    public AgrQryAgrAppScopePageServiceRspBO qryAgrScopeList(AgrQryAgrAppScopePageServiceReqBO agrQryAgrVersionListReqBO) {


        AgrQryAgrAppScopePageServiceRspBO rspBO = new AgrQryAgrAppScopePageServiceRspBO();

        if (agrQryAgrVersionListReqBO.getAgrId()!=null) {

            Page<BkAgrAppScopePO> page = new Page<>(agrQryAgrVersionListReqBO.getPageNo(), agrQryAgrVersionListReqBO.getPageSize());
            BkAgrAppScopePO po = new BkAgrAppScopePO();
            po.setAgrId(agrQryAgrVersionListReqBO.getAgrId());
            List<BkAgrAppScopePO> listPage = bkAgrAppScopeMapper.getListPage(po, page);


            rspBO.setRows(AgrRu.jsl(listPage,AgrAppScopeBO.class));
            rspBO.setPageSize(page.getPageSize());
            rspBO.setPageNo(page.getPageNo());
            rspBO.setTotal(page.getTotalPages());
            rspBO.setRecordsTotal(page.getTotalCount());
        }else if (agrQryAgrVersionListReqBO.getAgrHisId()!=null) {

            Page<BkAgrAppScopeHispPO> pageHis = new Page<>(agrQryAgrVersionListReqBO.getPageNo(), agrQryAgrVersionListReqBO.getPageSize());
            BkAgrAppScopeHispPO bkAgrAppScopeHisPo = new BkAgrAppScopeHispPO();
            bkAgrAppScopeHisPo.setAgrMainHisId(agrQryAgrVersionListReqBO.getAgrHisId());

            List<BkAgrAppScopeHispPO> listPage1 = bkAgrAppScopeHisMapper.getListPage(bkAgrAppScopeHisPo, pageHis);

            rspBO.setRows(AgrRu.jsl(listPage1, AgrAppScopeBO.class));
            rspBO.setPageSize(pageHis.getPageSize());
            rspBO.setPageNo(pageHis.getPageNo());
            rspBO.setTotal(pageHis.getTotalPages());
            rspBO.setRecordsTotal(pageHis.getTotalCount());
        }
        return rspBO;


    }
}
