package com.tydic.dyc.agr.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.procinst.sub.UocTodo;
import com.tydic.dyc.agr.repository.UocCommonRepository;
import com.tydic.dyc.agr.repository.dao.UocTodoExtMapper;
import com.tydic.dyc.agr.repository.po.UocTodoPo;
import com.tydic.dyc.agr.utils.AgrRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.ArrayList;
import java.util.List;


@Service
public class UocCommonRepositoryImpl implements UocCommonRepository {
    @Autowired
    private UocTodoExtMapper uocTodoExtMapper;
    @Override
    public int saveTodoInfo(UocTodo uocTodo) {
        return uocTodoExtMapper.insert(AgrRu.js(uocTodo, UocTodoPo.class));
    }

    @Override
    public int updateTodoById(UocTodo uocTodo) {
        return uocTodoExtMapper.updateById(AgrRu.js(uocTodo, UocTodoPo.class));
    }

    @Override
    public UocTodo getTodoInfo(UocTodo uocTodo) {
        UocTodoPo modelBy = uocTodoExtMapper.getModelBy(AgrRu.js(uocTodo, UocTodoPo.class));
        return ObjectUtil.isNotEmpty(modelBy) ? AgrRu.js(modelBy, UocTodo.class) : new UocTodo();
    }

    @Override
    public List<UocTodo> getTodoListInfo(UocTodo uocTodo) {
        List<UocTodoPo> todoPoList = uocTodoExtMapper.getList(AgrRu.js(uocTodo, UocTodoPo.class));
        return CollectionUtils.isEmpty(todoPoList) ? new ArrayList<>() : AgrRu.jsl(todoPoList, UocTodo.class);
    }

    @Override
    public void insertBatchTodo(List<UocTodo> list) {
        List<UocTodoPo> recordPoList = AgrRu.jsl(list, UocTodoPo.class);
        uocTodoExtMapper.insertBatch(recordPoList);
    }
}
