package com.tydic.dyc.agr.repository.po;

import lombok.Data;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 描述：bk_agr_materia_price_item
 * 
 * @author auto_gen
 * @date 2023-01-18 15:41
 **/
@Data
public class BkAgrMateriaPriceItemPO implements Serializable {
	private static final long serialVersionUID =  7659123237639659819L;

	/**
	 * 协议物料价格明细ID
	 */
	private Long agrMateriaPriceItemId;
	/**
	 * 协议ID
	 */
	private Long agrId;
	/**
	 * 物料分类编码
	 */
	private String catalogCode;
	/**
	 * 物料分类名称
	 */
	private String catalogName;
	/**
	 * 物料编码
	 */
	private String materialCode;
	/**
	 * 物料名称
	 */
	private String materialName;
	/**
	 * 物料短描述
	 */
	private String materialShortDesc;
	/**
	 * 计量单位编码
	 */
	private String measureCode;
	/**
	 * 计量单位名称
	 */
	private String measureName;
	/**
	 * 计量单位小数位数
	 */
	private String unitDigit;
	/**
	 * 基础分类:生产，非生产，科研
	 */
	private String basicClassify;
	/**
	 * 物料规格型号信息
	 */
	private String model;
	/**
	 * 最小起订量
	 */
	private Integer moq;
	/**
	 * 价格类型\r\n1.统一价，\r\n2.区域价，\r\n3.专属价，\r\n4.阶梯价
	 */
	private Integer priceType;
	/**
	 * 省份名称
	 */
	private String provinceName;
	/**
	 * 省份编码
	 */
	private String provinceCode;
	/**
	 * 地市名称
	 */
	private String cityName;
	/**
	 * 地市编码
	 */
	private String cityCode;
	/**
	 * 专属价机构名称
	 */
	private String exclusiveOrgName;
	/**
	 * 专属价机构id
	 */
	private Long exclusiveOrgId;
	/**
	 * 专属价主数据机构id
	 */
	private String exclusiveMainOrgId;
	/**
	 * 阶梯开始数量
	 */
	private BigDecimal startNum;
	/**
	 * 阶梯结束数量
	 */
	private BigDecimal stopNum;
	/**
	 * 价格使用类型\r\n1.销售价\r\n2.采购价
	 */
	private Integer priceUseType;
	/**
	 * 税率
	 */
	private BigDecimal taxRate;
	/**
	 * 单价,(含税)
	 */
	private BigDecimal price;
	/**
	 * 单价,(未含税)
	 */
	private BigDecimal unTaxPrice;
	/**
	 * 货期
	 */
	private String supplyCycle;
	/**
	 * 备注
	 */
	private String remark;
	/**
	 * 分组标识\r\n1.非阶梯价按物料编码分组\r\n2.阶梯价按物料编码+阶梯开始数量分组
	 */
	private String groupByFlag;
	/**
	 * 排序标识:物料+价格类型
	 */
	private String orderByFlag;
	/**
	 * 创建者ID
	 */
	private Long createLoginId;
	/**
	 * 创建人
	 */
	private String createName;
	/**
	 * 创建人用户名
	 */
	private String createUsername;
	/**
	 * 创建时间
	 */
	private Date createTime;
	private Date createTimeStart;
	private Date createTimeEnd;
	/**
	 * 更新者ID
	 */
	private Long updateLoginId;
	/**
	 * 更新人
	 */
	private String updateName;
	/**
	 * 更新人用户名
	 */
	private String updateUsername;
	/**
	 * 更新时间
	 */
	private Date updateTime;
	private Date updateTimeStart;
	private Date updateTimeEnd;
	/**
	 * 删除标志1已删除
	 */
	private Integer delTag;
	/**
	 * 排序
	 */
	private String orderBy;
	private Integer isAutarky;
	/**
	 * 销售单价,(含税)
	 */
	private String salePrice;
	/**
	 * 销售单价,(未含税)
	 */
	private BigDecimal saleUnTaxPrice;
	/**
	 * 销售价协议物料价格明细Id
	 */
	private Long agrSaleMateriaPriceItemId;

	private String keyCode;

	private List<String> itemMatchCodeList;

}
