/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.extension.util;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.extension.bo.BkFscMailInfoBO;
import com.tydic.fsc.util.ExcelFileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailInfoExcelUtils {
    private static final Logger log = LoggerFactory.getLogger(MailInfoExcelUtils.class);
    public static final String[] sheetNames = new String[]{"\u586b\u5199\u8bf4\u660e", "\u5feb\u9012\u516c\u53f8\u4fe1\u606f", "\u90ae\u5bc4\u4fe1\u606f"};
    public static final String EXCEL_XLS = "xls";
    public static final String EXCEL_XLSX = "xlsx";
    public static final String[][] ivDetailInMap = new String[][]{{"fscOrderId", "A", "S"}, {"fscOrderNo", "B", "S"}, {"sendOrder", "C", "S"}, {"sendCompany", "D", "S"}, {"receiveName", "E", "S"}, {"sendDate", "F", "T"}, {"sendPhone", "G", "S"}};
    public static final String BILL_DATE_KEY = "billDate";

    private static List<BkFscMailInfoBO> explainExcel(InputStream is, boolean xlsxMode) {
        ExcelFileUtils excel = new ExcelFileUtils(is, xlsxMode);
        if (!excel.isReady()) {
            throw new ZTBusinessException("\u65e0\u6cd5\u89e3\u6790Excel\u6587\u4ef6");
        }
        if (excel.getSheetCount() == 3 ? !"\u90ae\u5bc4\u4fe1\u606f".equals(excel.getSheetName(2)) && excel.getSheetCount() != 2 : excel.getSheetCount() != 2) {
            throw new ZTBusinessException("\u4e0a\u4f20\u7684Excel\u5e94\u67092\u9875");
        }
        for (int i = 0; i < 2; ++i) {
            if (sheetNames[i].equals(excel.getSheetName(i))) continue;
            throw new ZTBusinessException("\u7b2c" + (i + 1) + "\u4e2a\u6570\u636e\u9875\u7684\u540d\u79f0[" + excel.getSheetName(i) + "]\u4e0e\u9884\u671f\u4e0d\u7b26\u5408,\u8bf7\u4e0d\u8981\u4fee\u6539\u6a21\u677f\u6587\u4ef6\u7684\u9875\u540d\u79f0");
        }
        List dataRow = excel.readRows(2, 1, -1);
        ArrayList<BkFscMailInfoBO> bkFscMailInfoBOS = new ArrayList<BkFscMailInfoBO>();
        for (int i = 0; i < dataRow.size(); ++i) {
            BkFscMailInfoBO mailInfoBO = new BkFscMailInfoBO();
            StringBuilder errorCollection = new StringBuilder();
            StringBuilder nullErrorMsg = new StringBuilder();
            HashMap<String, Object> map = new HashMap<String, Object>();
            String[] fields = (String[])dataRow.get(i);
            if (fields[0].length() == 0) {
                nullErrorMsg.append("\u7b2c" + (i + 1) + "\u884c\u7ed3\u7b97\u5355ID\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (fields[1].length() == 0) {
                nullErrorMsg.append("\u7b2c" + (i + 1) + "\u884c\u7ed3\u7b97\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (fields[2].length() == 0) {
                nullErrorMsg.append("\u7b2c" + (i + 1) + "\u884c\u5feb\u9012\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (fields[3].length() == 0) {
                nullErrorMsg.append("\u7b2c" + (i + 1) + "\u884c\u5feb\u9012\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (fields[4].length() == 0) {
                nullErrorMsg.append("\u7b2c" + (i + 1) + "\u884c\u90ae\u5bc4\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (fields[5].length() == 0) {
                nullErrorMsg.append("\u7b2c" + (i + 1) + "\u884c\u90ae\u5bc4\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (fields[6].length() == 0) {
                nullErrorMsg.append("\u7b2c" + (i + 1) + "\u884c\u90ae\u5bc4\u4eba\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (!StringUtils.isBlank((CharSequence)nullErrorMsg)) {
                errorCollection.append(nullErrorMsg.toString());
                throw new FscBusinessException("198888", errorCollection.toString());
            }
            map.clear();
            StringBuilder errorMsg = MailInfoExcelUtils.arrayToMap(fields, ivDetailInMap, map);
            if (!StringUtils.isBlank((CharSequence)errorCollection)) {
                errorCollection.append(errorMsg.toString());
                throw new FscBusinessException("198888", errorCollection.toString());
            }
            MailInfoExcelUtils.mapToBean(map, mailInfoBO);
            bkFscMailInfoBOS.add(mailInfoBO);
        }
        excel.close();
        return bkFscMailInfoBOS;
    }

    private static StringBuilder arrayToMap(String[] datasource, String[][] fieldDefine, Map<String, Object> targetMap) {
        StringBuilder errorMsg = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (int j = 0; j < fieldDefine.length; ++j) {
            String type = fieldDefine[j][2];
            if (type.length() == 0) continue;
            int idx = ExcelFileUtils.cellNameToIndex((String)fieldDefine[j][1]);
            String fName = fieldDefine[j][0];
            log.debug("\u6570\u636e" + fName + datasource[idx]);
            if ("D".equals(type) && datasource[idx] != null) {
                if (datasource[idx].length() == 0) {
                    datasource[idx] = "0";
                }
                targetMap.put(fName, new BigDecimal(datasource[idx]));
                continue;
            }
            if ("T".equals(type)) {
                Date dt = null;
                try {
                    dt = sdf.parse(datasource[idx]);
                }
                catch (Exception e) {
                    errorMsg.append("\u65e5\u671f" + datasource[idx] + "\u683c\u5f0f\u6709\u8bef\u3002");
                    break;
                }
                if (dt == null) continue;
                targetMap.put(fName, dt);
                continue;
            }
            targetMap.put(fName, datasource[idx]);
        }
        if (null != errorMsg && errorMsg.length() <= 0) {
            errorMsg = null;
        }
        return errorMsg;
    }

    private static void mapToBean(Map<String, Object> map, Object bean) {
        try {
            BeanUtils.populate((Object)bean, map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<BkFscMailInfoBO> dealExcel(File file) {
        try {
            boolean xlsFlag = false;
            FileInputStream is = new FileInputStream(file);
            if (file.getName().endsWith(EXCEL_XLS)) {
                xlsFlag = false;
            } else if (file.getName().endsWith(EXCEL_XLSX)) {
                xlsFlag = true;
            }
            return MailInfoExcelUtils.explainExcel(is, xlsFlag);
        }
        catch (FileNotFoundException e) {
            throw new FscBusinessException("198888", "FileNotFound\u5f02\u5e38");
        }
    }
}

