/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.extension.busibase.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.extension.bo.BkFscComOrderListBO;
import com.tydic.fsc.extension.busibase.busi.api.BkFscEsQryComOrderListBusiService;
import com.tydic.fsc.extension.busibase.busi.bo.BkFscComOrderListPageQueryBusiReqBO;
import com.tydic.fsc.extension.busibase.busi.bo.BkFscComOrderListPageQueryBusiRspBO;
import com.tydic.fsc.extension.config.BkFscEsConfig;
import com.tydic.fsc.extension.util.BkFscBuildEsQrySqlConditionUtil;
import com.tydic.fsc.extension.util.BkFscElasticsearchUtil;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BkFscEsQryComOrderListBusiServiceImpl
implements BkFscEsQryComOrderListBusiService {
    private static final Logger log = LoggerFactory.getLogger(BkFscEsQryComOrderListBusiServiceImpl.class);
    private final BkFscEsConfig fscEsConfig;
    private final BkFscElasticsearchUtil fscElasticsearchUtil;
    private final BkFscBuildEsQrySqlConditionUtil buildEsQrySqlConditionUtil;

    @Autowired
    public BkFscEsQryComOrderListBusiServiceImpl(BkFscEsConfig fscEsConfig, BkFscElasticsearchUtil fscElasticsearchUtil) {
        this.fscEsConfig = fscEsConfig;
        this.fscElasticsearchUtil = fscElasticsearchUtil;
        this.buildEsQrySqlConditionUtil = new BkFscBuildEsQrySqlConditionUtil();
    }

    @Override
    public BkFscComOrderListPageQueryBusiRspBO esQryComOrderList(BkFscComOrderListPageQueryBusiReqBO reqBO) {
        BkFscComOrderListPageQueryBusiRspBO rspBO = new BkFscComOrderListPageQueryBusiRspBO();
        String qryString = this.buildEsQrySqlConditionUtil.buildComOrderEsSql(reqBO);
        log.debug("ES\u67e5\u8be2\u7ed3\u7b97\u4e3b\u5355\u67e5\u8be2\u6761\u4ef6---->" + qryString);
        String endPoint = "/" + this.fscEsConfig.getOrderIndexName() + "/_search";
        String result = null;
        Request request = new Request("POST", endPoint);
        request.setJsonEntity(qryString);
        try {
            Response response = this.fscElasticsearchUtil.getLowLevelClient().performRequest(request);
            result = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            String ioExceptionStr = JSON.toJSONString((Object)e.getCause());
            if (ioExceptionStr.contains("index_not_found_exception")) {
                boolean index = this.fscElasticsearchUtil.createIndex(this.fscEsConfig.getOrderIndexName());
                if (!index) {
                    log.error("\u81ea\u52a8\u521b\u5efa\u9a8c\u6536\u7d22\u5f15\u5931\u8d25");
                    rspBO.setRespCode("191001");
                    rspBO.setRespDesc("\u81ea\u52a8\u521b\u5efa\u9a8c\u6536\u7d22\u5f15\u5931\u8d25");
                    return rspBO;
                }
                try {
                    Response response = this.fscElasticsearchUtil.getLowLevelClient().performRequest(request);
                    result = EntityUtils.toString((HttpEntity)response.getEntity());
                }
                catch (IOException childE) {
                    log.error("ioException", (Throwable)childE);
                    rspBO.setRespCode("\u5931\u8d25");
                    rspBO.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u7ed3\u7b97\u4e3b\u5355\u5931\u8d25!");
                    return rspBO;
                }
            }
            log.error("ioException", (Throwable)e);
            rspBO.setRespCode("\u5931\u8d25");
            rspBO.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u7ed3\u7b97\u4e3b\u5355\u5217\u8868\u4fe1\u606f\u9a8c\u6536!");
            return rspBO;
        }
        System.out.println("ES\u67e5\u8be2\u7ed3\u7b97\u4e3b\u5355result---->" + result);
        rspBO = this.resolveReturnData(result, rspBO, reqBO.getPageSize(), reqBO.getPageNo());
        return rspBO;
    }

    private BkFscComOrderListPageQueryBusiRspBO resolveReturnData(String result, BkFscComOrderListPageQueryBusiRspBO rspBO, Integer pageSize, Integer pageNo) {
        rspBO.setRespCode("0000");
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getInteger("total");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (listObject == null || listObject.size() < 1) {
            rspBO.setPageNo(1);
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(total);
            rspBO.setRows(new ArrayList());
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u4e3b\u5355\u4fe1\u606f!");
            return rspBO;
        }
        ArrayList<BkFscComOrderListBO> rows = new ArrayList<BkFscComOrderListBO>();
        for (int i = 0; i < listObject.size(); ++i) {
            JSONObject hitObj = listObject.getJSONObject(i);
            JSONObject data = (JSONObject)hitObj.get((Object)"_source");
            String objJsonStr = data.getString("objJson");
            JSONObject objJson = JSONObject.parseObject((String)objJsonStr);
            BkFscComOrderListBO fscComOrderListBO = (BkFscComOrderListBO)JSON.toJavaObject((JSON)objJson, BkFscComOrderListBO.class);
            rows.add(fscComOrderListBO);
        }
        Integer totalPageNo = total % pageSize == 0 ? total / pageSize : total / pageSize + 1;
        rspBO.setTotal(totalPageNo);
        rspBO.setRecordsTotal(total);
        rspBO.setPageNo(pageNo);
        rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u7b97\u5355\u5217\u8868\u4fe1\u606f\u6210\u529f");
        rspBO.setRows(rows);
        return rspBO;
    }
}

