/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.extension.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.fsc.base.FscRspBaseBO;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.common.ability.extension.api.FscComOrderSyncByHandAbilityService;
import com.tydic.fsc.common.ability.extension.bo.BkFscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.extension.bo.FscOrderSyncMultiThreadAbilityReqBO;
import com.tydic.fsc.common.ability.extension.impl.FscOrderSyncThreadsImpl;
import com.tydic.fsc.common.busi.extension.bo.BkFscComOrderListQueryBusiReqBO;
import com.tydic.fsc.common.consumer.bo.FscSyncReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.extension.dao.BkFscOrderMapper;
import com.tydic.fsc.extension.po.BkFscOrderPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.extension.api.FscComOrderSyncByHandAbilityService"})
public class FscComOrderSyncByHandAbilityServiceImpl
implements FscComOrderSyncByHandAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscComOrderSyncByHandAbilityServiceImpl.class);
    @Autowired
    private BkFscOrderMapper fscOrderMapper;
    @Resource(name="fscSyncOrderListMqServiceProvider")
    private ProxyMessageProducer fscSyncOrderListMqServiceProvider;
    @Value(value="${es.FSC_SYNC_TOPIC}")
    private String topic;
    @Value(value="${es.FSC_SYNC_TAG}")
    private String tag;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;

    @PostMapping(value={"dealComOrderSyncEs"})
    public FscRspBaseBO dealComOrderSyncEs(@RequestBody BkFscComOrderListSyncAbilityReqBO reqBO) {
        FscRspBaseBO rsp = new FscRspBaseBO();
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u624b\u52a8\u4e3b\u5355\u5217\u8868ES\u540c\u6b65\u6210\u529f\uff01");
        FscSyncReqBO fscSyncReqBO = new FscSyncReqBO();
        fscSyncReqBO.setFscOrderId(reqBO.getFscOrderId());
        ProxySendResult proxySendResult = this.fscSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)fscSyncReqBO)));
        if (!"SEND_OK".equals(proxySendResult.getStatus())) {
            this.writeFailLog(reqBO, JSONObject.toJSONString((Object)proxySendResult));
            rsp.setRespCode("190000");
            rsp.setRespDesc(JSONObject.toJSONString((Object)proxySendResult));
        }
        return rsp;
    }

    private void writeFailLog(BkFscComOrderListSyncAbilityReqBO reqBO, String errDesc) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjId(reqBO.getFscOrderId());
        fscOrderFailLogUpdateBusiReqBO.setBusiFailDesc(errDesc);
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_SYNC_ES);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }

    @PostMapping(value={"syncAllComOrderList"})
    public FscRspBaseBO syncAllComOrderList(@RequestBody BkFscComOrderListSyncAbilityReqBO reqBO) {
        FscRspBaseBO rsp = new FscRspBaseBO();
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u624b\u52a8\u4e3b\u5355\u5217\u8868ES\u540c\u6b65\u6210\u529f\uff01");
        BkFscOrderPO fscOrderPO = new BkFscOrderPO();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getFscOrderIds())) {
            fscOrderPO.setFscOrderIds(reqBO.getFscOrderIds());
        }
        fscOrderPO.setOrderBy("create_time asc");
        List fscOrderList = this.fscOrderMapper.getFscOrderIdList(fscOrderPO);
        if (!CollectionUtils.isEmpty((Collection)fscOrderList)) {
            for (BkFscOrderPO orderPO : fscOrderList) {
                FscSyncReqBO fscSyncReqBO = new FscSyncReqBO();
                fscSyncReqBO.setFscOrderId(orderPO.getFscOrderId());
                ProxySendResult proxySendResult = this.fscSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)fscSyncReqBO)));
                if ("SEND_OK".equals(proxySendResult.getStatus())) continue;
                BkFscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new BkFscComOrderListSyncAbilityReqBO();
                fscComOrderListSyncAbilityReqBO.setFscOrderId(orderPO.getFscOrderId());
                this.writeFailLog(fscComOrderListSyncAbilityReqBO, JSON.toJSONString((Object)proxySendResult));
                rsp.setRespCode("190000");
                rsp.setRespDesc(JSONObject.toJSONString((Object)proxySendResult));
            }
        }
        return rsp;
    }

    @PostMapping(value={"syncAllMultiThread"})
    public FscRspBaseBO syncAllMultiThread(@RequestBody FscOrderSyncMultiThreadAbilityReqBO reqBO) {
        FscRspBaseBO rspBO = new FscRspBaseBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u624b\u52a8\u4e3b\u5355\u5217\u8868ES\u540c\u6b65\u6210\u529f\uff01");
        if (reqBO.getIsAll().booleanValue()) {
            if (null == reqBO.getThreadNum()) {
                reqBO.setThreadNum(Integer.valueOf(0));
            }
            this.batchDealOrder(reqBO, rspBO);
        } else {
            FscSyncReqBO fscSyncReqBO = new FscSyncReqBO();
            fscSyncReqBO.setFscOrderId(reqBO.getFscOrderId());
            ProxySendResult proxySendResult = this.fscSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)fscSyncReqBO)));
            if (!"SEND_OK".equals(proxySendResult.getStatus())) {
                BkFscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new BkFscComOrderListSyncAbilityReqBO();
                fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
                this.writeFailLog(fscComOrderListSyncAbilityReqBO, JSON.toJSONString((Object)proxySendResult));
                rspBO.setRespCode("190000");
                rspBO.setRespDesc(JSONObject.toJSONString((Object)proxySendResult));
            }
        }
        return rspBO;
    }

    public void batchDealOrder(FscOrderSyncMultiThreadAbilityReqBO reqBO, FscRspBaseBO rspBO) {
        BkFscOrderPO fscOrderPO = new BkFscOrderPO();
        if (!StringUtils.isEmpty((Object)reqBO.getCreateTimeEff())) {
            fscOrderPO.setCreateTimeStart(DateUtils.strToDateLong((String)reqBO.getCreateTimeEff()));
        }
        if (!StringUtils.isEmpty((Object)reqBO.getCreateTimeExp())) {
            fscOrderPO.setCreateTimeEnd(DateUtils.strToDateLong((String)reqBO.getCreateTimeExp()));
        }
        fscOrderPO.setOrderBy("create_time asc");
        List fscOrderList = this.fscOrderMapper.getFscOrderIdList(fscOrderPO);
        log.info("ES\u591a\u7ebf\u7a0b\u540c\u6b65\u7ed3\u7b97\u5355\u7684\u6570\u91cf\u4e3a\uff1a{}", (Object)fscOrderList.size());
        if (!CollectionUtils.isEmpty((Collection)fscOrderList)) {
            if (reqBO.getIsThreads().booleanValue()) {
                ArrayList<BkFscComOrderListQueryBusiReqBO> comReqBO = new ArrayList<BkFscComOrderListQueryBusiReqBO>();
                for (BkFscOrderPO orderPO : fscOrderList) {
                    BkFscComOrderListQueryBusiReqBO fscComOrderListSyncAbilityReqBO = new BkFscComOrderListQueryBusiReqBO();
                    fscComOrderListSyncAbilityReqBO.setFscOrderId(orderPO.getFscOrderId());
                    fscComOrderListSyncAbilityReqBO.setObjType(reqBO.getObjType());
                    comReqBO.add(fscComOrderListSyncAbilityReqBO);
                }
                try {
                    FscOrderSyncThreadsImpl ordIdxSyncThreadsAbilityService = new FscOrderSyncThreadsImpl();
                    if (ordIdxSyncThreadsAbilityService.handleList(comReqBO, reqBO.getThreadNum()).booleanValue()) {
                        rspBO.setRespCode("190000");
                        rspBO.setRespDesc("\u540c\u6b65\u6709\u5931\u8d25\u6570\u636e\uff0c\u5177\u4f53\u60c5\u51b5\u8bf7\u770b\u65e5\u5fd7\uff01");
                    }
                }
                catch (Exception e) {
                    rspBO.setRespCode("190000");
                    rspBO.setRespDesc("---ES\u540c\u6b65\u591a\u7ebf\u7a0b\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + JSON.toJSONString((Object)e));
                }
            } else {
                for (BkFscOrderPO orderPO : fscOrderList) {
                    FscSyncReqBO fscSyncReqBO = new FscSyncReqBO();
                    fscSyncReqBO.setFscOrderId(orderPO.getFscOrderId());
                    ProxySendResult proxySendResult = this.fscSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)fscSyncReqBO)));
                    if ("SEND_OK".equals(proxySendResult.getStatus())) continue;
                    BkFscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new BkFscComOrderListSyncAbilityReqBO();
                    fscComOrderListSyncAbilityReqBO.setFscOrderId(orderPO.getFscOrderId());
                    this.writeFailLog(fscComOrderListSyncAbilityReqBO, JSON.toJSONString((Object)proxySendResult));
                    rspBO.setRespCode("190000");
                    rspBO.setRespDesc(JSONObject.toJSONString((Object)proxySendResult));
                }
            }
        }
    }
}

