package com.tydic.dyc.util;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * 标题：类名称:ToBigDecimalSerializer
 * 说明：描述一下类的作用TODO
 * 时间：2022/6/6 20:29
 * 作者 @author 尹栋梁
 */
@Slf4j
public class ToBigDecimalSerializer implements ObjectSerializer {
    public static final ToBigDecimalSerializer instance = new ToBigDecimalSerializer();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.out;

        if (object == null) {
            out.writeNull();
            return;
        }
//        log.info("ToBigDecimalSerializer->start-{}",object);
        BigDecimal bigDecimal = new BigDecimal(object.toString()).setScale(3, RoundingMode.HALF_UP);
//        log.info("ToBigDecimalSerializer->end-{}",bigDecimal);
//        log.info("ToBigDecimalSerializer->end-{}",bigDecimal.toPlainString());

        out.writeString(bigDecimal.toPlainString());
    }
}
