package com.tydic.dyc.agr.service.agr.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 协议支付配置
 *
 * @author zhanghengrui
 * @date 2023/1/30 10:32
 */
@Data
public class AgrPayConfigBO implements Serializable {
    private static final long serialVersionUID = 461983782672686401L;
    /**
     * 支付方式 0预付款 1分阶段 2账期
     */
    private Integer payType;

    /**
     * 合同编号
     */
    private String contractCode;
    /**
     * 账期
     */
    private Integer paymentDays;
    /**
     * 预付款
     */
    private BigDecimal prePay;
    /**
     * 预付款比例
     */
    private BigDecimal prePayRatio;
    /**
     * 发货款
     */
    private BigDecimal matPay;
    /**
     * 发货款比例
     */
    private BigDecimal matPayRatio;
    /**
     * 到货验收款
     */
    private BigDecimal proPay;
    /**
     * 到货验收款比例
     */
    private BigDecimal proPayRatio;
    /**
     * 安装调试款
     */
    private BigDecimal verPay;
    /**
     * 安装调试款比例
     */
    private BigDecimal verPayRatio;
    /**
     * 竣工验收金
     */
    private BigDecimal quaPay;
    /**
     * 竣工验收金比例
     */
    private BigDecimal quaPayRatio;
    /**
     * 质保期满款
     */
    private BigDecimal pilPay;
    /**
     * 质保期满款比例
     */
    private BigDecimal pilPayRatio;
    /**
     * 协议id
     */
    private Long agrId;
    /**
     * id
     */
    private Long payCfgId;
    /**
     * 支付方 0 采购商 1供应商
     */
    private Integer payObj;

    private String assign;
    private Integer busiNode;
    private Integer currency;

    private BigDecimal serviceRate;
    private BigDecimal taxRate;
    private String settlementDate;
    private String settlementMonth;

//-----------------------新增部分--------------------------

    /**
     *预付编码:服务类 FC
     */
    private String preCode;
    /**
     *预付比例:服务类 FC
     */
    private BigDecimal preRatio;
    /**
     *验收阶段1编码:服务类 FC
     */
    private String verb1Code;
    /**
     *验收阶段1比例:服务类 FC
     */
    private BigDecimal verb1Ratio;
    /**
     *验收阶段2编码:服务类 FC
     */
    private String verb2Code;
    /**
     *验收阶段2比例:服务类 FC
     */
    private BigDecimal verb2Ratio;
    /**
     *验收阶段3编码:服务类 FC
     */
    private String verb3Code;
    /**
     *验收阶段3比例:服务类 FC
     */
    private BigDecimal verb3Ratio;
    /**
     *验收阶段4编码:服务类 FC
     */
    private String verb4Code;
    /**
     *验收阶段4比例:服务类 FC
     */
    private BigDecimal verb4Ratio;
    /**
     *验收阶段5编码:服务类 FC
     */
    private String verb5Code;
    /**
     *验收阶段5比例:服务类 FC
     */
    private BigDecimal verb5Ratio;
    /**
     *验收阶段6编码:服务类 FC
     */
    private String verb6Code;
    /**
     *验收阶段6比例:服务类 FC
     */
    private BigDecimal verb6Ratio;
    /**
     *验质保期/尾款编码:服务类 FC
     */
    private String pilPayCode;
//    private String pilPayRatio;
}
