package com.tydic.dyc.agr.service.agr.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author zhanghengrui
 * @date 2023/1/31 11:01
 */
@Data
public class BkAgrMateriaPriceItemBO implements Serializable {
    private static final long serialVersionUID = -3908877392808505611L;

    /**
     *变更类型
     */
    private Integer changeType;
    /**
     *物料分类编码
     */
    private String catalogCode;
    /**
     *物料分类名称
     */
    private String catalogName;
    /**
     *物料编码
     */
    private String materialCode;
    /**
     *物料名称
     */
    private String materialName;
    /**
     *物料短描述
     */
    private String materialShortDesc;
    /**
     *计量单位编码
     */
    private String measureCode;
    /**
     *计量单位名称
     */
    private String measureName;
    /**
     *计量单位小数位数（该计量单位对应的采购数量可填写的小数位数）
     */
    private String unitDigit;
    /**
     *基础分类:生产，非生产，科研
     */
    private String basiClassify;
    /**
     *物料规格型号信息
     */
    private String model;
    /**
     *最小起订量
     */
    private BigDecimal moq;
    /**
     *价格类型：1.统一价，2.区域价，3.专属价，4.阶梯价"
     */
    private Integer priceType;
    /**
     *省份名称
     */
    private String provinceName;
    /**
     *省份编码
     */
    private String provinceCode;
    /**
     *地市名称
     */
    private String cityName;
    /**
     *地市编码
     */
    private String cityCode;
    /**
     *专属价机构名称
     */
    private String exclusiveOrgName;
    /**
     *专属价机构id
     */
    private Long exclusiveOrgId;
    /**
     *专属价主数据机构id
     */
    private String exclusiveMainOrgId;
    /**
     *阶梯开始数量
     */
    private BigDecimal startNum;
    /**
     *阶梯结束数量
     */
    private BigDecimal stopNum;
    /**
     *价格使用类型：1.销售价2.采购价
     */
    private Integer priceUseType;
    /**
     *税率
     */
    private BigDecimal taxRate;
    /**
     *单价,(含税)
     */
    private BigDecimal price;
    /**
     *单价,(未含税)
     */
    private BigDecimal unTaxPrice;
    /**
     *货期
     */
    private String supplyCycle;
    /**
     *备注
     */
    private String remark;
    /**
     *分组标识：1.非阶梯价按物料编码分组2.阶梯价按物料编码+阶梯开始数量分组
     */
    private String groupByFlag;
    /**
     *排序标识:物料+价格类型
     */
    private String orderByFlag;

}
