package com.tydic.dyc.agr.service.agr.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 标题：BkAppUccPriceQryPageListAbilityBO
 * 说明：
 * 时间：2023/2/3 16:00
 * 作者：Zhouhaifeng
 */
@Data
public class BkAgrUccPriceItemBO implements Serializable {
    private static final long serialVersionUID = 2615152739705177059L;

    /**
     * 一级地址编码
     */
    private String province;
    /**
     * 二级地址编码
     */
    private String city;

    /**
     * 专属价机构单位编码
     */
    private Long orgId;

    /**
     * 专属价机构单位名称
     */
    private String orgName;

    /**
     * 物料编码
     */
    private String materialCode;
    /**
     * 单价（含税）
     */
    private BigDecimal price;

    /**
     * 数量起
     */
    private BigDecimal start;
    /**
     * 数量止
     */
    private BigDecimal end;
    /**
     * 单价（未含税）
     */
    private BigDecimal taxPrice;

    /**
     * 税率
     */
    private BigDecimal rate;

    private String materialName;

    private String provinceName;

    private String cityName;

    private String shortDesc;

    private String measureName;

    private Integer decimalLimit;

    private String model;

    private String factory;

    /**
     * 是否利润筹划（专属价），1是0否
     */
    private Integer isRestore;

    /**
     * 是否利润筹划（专属价），1是0否
     */
    private String isRestoreStr;
}
