package com.tydic.dyc.agr.service.constants;

/**
 * 描述：活动中心通用Api常量类
 *
 * @author: yuhao
 * @date: 2018年8月14日 上午9:28:30
 * LM商城逻辑
 * LM商城逻辑
 */
public class AgrCommConstant {

    /**
     * 字典Pcode
     */
    public static final class DictPcode {
        /**
         * 当前系统编码
         */
        public static final String AGR = "AGR";
        /**
         * 协议模式 1：平台协议 2：单位协议
         */
        public static final String AGREEMENT_MODE_PCODE = "AGREEMENT_MODE_PCODE";
        /**
         * 价格类型 1：执行价  2：协议价
         */
        public static final String PRICE_TYPE_PCODE = "PRICE_TYPE_PCODE";
        /**
         * 协议分类：0：集团集采协议:1：区域集采协议、2：项目单位协议； 默认值：0：集团集采协议
         */
        public static final String AGREEMENT_TYPE_PCODE = "AGREEMENT_TYPE_PCODE";
        /**
         * 协议来源 0：询比价，1：招投标，2：由询比价协议转成的商城协议 默认1
         */
        public static final String AGREEMENT_SRC_PCODE = "AGREEMENT_SRC_PCODE";
        /**
         * 采购类别：1物资类、2施工类、3服务类
         */
        public static final String AGREEMENT_VARIETY_PCODE = "AGREEMENT_VARIETY_PCODE";
        /**
         * 币种 0：人民币 默认0
         */
        public static final String CURRENCY_PCODE = "CURRENCY_PCODE";
        /**
         * 是否配送：0:否,1是 默认值：是
         */
        public static final String IS_DISPATCH_PCODE = "IS_DISPATCH_PCODE";
        /**
         * 调价机制：0：无，1：事前调价，2：事中调价 默认值：0
         */
        public static final String ADJUST_PRICE_PCODE = "ADJUST_PRICE_PCODE";
        /**
         * 是否公式调价：0：否 1：是 默认值：0
         */
        public static final String IS_ADJUST_PRICE_FORMULA_PCODE = "IS_ADJUST_PRICE_FORMULA_PCODE";
        /**
         * 是否手动修改采购单价：0:否 1：是  默认值：0
         */
        public static final String IS_MODIFY_BUY_PRICE_PCODE = "IS_MODIFY_BUY_PRICE_PCODE";
        /**
         * 是否存在加价项：0：否 1：是
         */
        public static final String IS_ADD_PRICE_PCODE = "IS_ADD_PRICE_PCODE";
        /**
         * 所属专区 1：电力专区，2:电子超市 5：煤炭专区
         */
        public static final String AGR_LOCATION_PCODE = "AGR_LOCATION_PCODE";
        /**
         * 协议状态：0：草稿 1：驳回 2：审核中 3：暂停 4：启用 5：冻结 6：过期 7：终止
         */
        public static final String AGREEMENT_STATUS_PCODE = "AGREEMENT_STATUS_PCODE";
        /**
         * 协议操作日志： 0:协议新增 1:协议修改 2:协议启动 3:协议停用 4:协议删除 5:协议明细修改
         */
        public static final String AGREEMENT_OPERATE_PCODE = "AGREEMENT_OPERATE_PCODE";
        /**
         * 协议分配状态：0：已分配 1：待分配
         */
        public static final String ASSIGN_STATUS_PCODE = "ASSIGN_STATUS_PCODE";
        /**
         * 铺货方式 1：运营商自主铺货 2：供应商铺货
         */
        public static final String SUPPLIER_MODE_PCODE = "SUPPLIER_MODE_PCODE";
        /**
         * 交易模式 1：购销模式 2：搓合模式
         */
        public static final String TRADE_MODE_PCODE = "TRADE_MODE_PCODE";
        /**
         * 应用范围类型 0：全部:1：省份、2：行业:3：分子公司:4：项目单位
         */
        public static final String SCOPE_TYPE_PCODE = "SCOPE_TYPE_PCODE";
        /**
         * 审批结果：0通过、1未通过
         */
        public static final String AUDIT_STATUS_PCODE = "AUDIT_STATUS_PCODE";
        /**
         * 协议变更类型:1:暂停，2：启用，3：终止，4：调价，5：延期，6:补充，7:其他变更
         */
        public static final String CHANGE_TYPE_PCODE = "CHANGE_TYPE_PCODE";

        public static final String CHANGE_TYPE_PCODE_2 = "CHANGE_TYPE_PCODE_2";
        /**
         * 协议变更申请状态	:	0：草稿，1：审批中，2：通过，3：不通过
         */
        public static final String CHANGE_APPLY_STATUS_PCODE = "CHANGE_APPLY_STATUS_PCODE";

        /**
         * 协议分类反向转义
         */
        public static final String AGR_TYPE_NAME_TO_CODE_PCODE = "AGR_TYPE_NAME_TO_CODE_PCODE";

        /**
         * 采购类别反向转义
         */
        public static final String AGR_VARIETR_NAME_TO_CODE_PCODE = "AGR_VARIETR_NAME_TO_CODE_PCODE";
        /**
         * 变更类型反向转义
         */
        public static final String CHANGE_TYPE_NAME_TO_CODE_PCODE = "CHANGE_TYPE_NAME_TO_CODE_PCODE";

        /**
         * 是否成品油 1是 0 否
         */
        public static final String IS_OIL_PCODE = "IS_OIL_PCODE";

        /**
         * 协议状态页签
         * <p>
         * 1：全部有效协议状态 2：全部失效协议状态
         */
        public static final String EFF_AGREEMENT_STATUS_PCODE = "EFF_AGREEMENT_STATUS_PCODE";


        /**
         * 导入模版
         */
        public static final String IMPORT_TEMPLATE_PCODE = "IMPORT_TEMPLATE_PCODE";

        /**
         * 导入模版
         */
        public static final String IMPORT_SKU_CHANGE_TEMPLATE_PCODE = "IMPORT_SKU_CHANGE_TEMPLATE_PCODE";

        /**
         * 定时任务总分片值
         */
        public static final String TIME_TASK_TOTAL_SHARD_COUNT_PCODE = "AGR_TOTAL_SHARD_COUNT";

        /**
         * 税率 0：0%，6：6%，3：3%:，17：17% ，13：13%，15：15% 默认值：17：17%
         */
        public static final String TAX_RATE_PCODE = "TAX_RATE_PCODE";

        /**
         * 质保期（月）：0、3、6、12、24、36 默认值：12
         */
        public static final String WARANTTY_PCODE = "WARANTTY_PCODE";

        /**
         * 加价比率0%、1%、2%、3%、4%、5%、6%、7%、8%、9%、10%、11%
         */
        public static final String FARE_INCREASE_RATIO_PCODE = "FARE_INCREASE_RATIO_PCODE";

        /**
         * 模版下载
         */
        public static final String TEMPLATE_DOWNLOAD_PCODE = "TEMPLATE_DOWNLOAD_PCODE";
        /**
         * 采购方式
         */
        public static final String EXT_FIELD1_PCODE = "EXT_FIELD1_PCODE";

        /**
         * 二级集采类型
         */
        public static final String EXT_FIELD3_PCODE = "EXT_FIELD3_PCODE";

        /**
         * 协议权限：配送经理，配送专责
         */
        public static final String AGREEMENT_QUERY_AUTH_PCODE = "AGREEMENT_QUERY_AUTH_PCODE";
    }


    /**
     * 协议权限：
     * 0.配送专责
     * 1.配送经理
     */
    public static final class AGREEMENT_QUERY_AUTH_CODE {
        /**
         * 配送专责
         */
        public static final String PSZZ = "0";

        /**
         * 配送经理
         */
        public static final String PSJL = "1";

    }

    /**
     * 定时任务总分片值
     * 1.过期启用协议状态变更定时任务
     */
    public static final class TIME_TASK_TOTAL_SHARD_COUNT_CODE {

        public static final String UPDATE_BEOVERDUE_AGREEMENT_STATUS_CODE = "1";
    }

    /**
     * 操作类型 1 保存 2 提交
     */
    public static final class AgrSaveOrSubmit {
        /**
         * 1 保存
         */
        public static final Byte SAVE = 1;

        /**
         * 2 提交
         */
        public static final Byte SUBMIT = 2;
    }

    /**
     * 操作类型 1 接受 2 不接受
     */
    public static final class AgrConfirmOrNo {
        /**
         * 1 接受
         */
        public static final Byte CONFIRM = 1;

        /**
         * 2 不接受
         */
        public static final Byte NOCONFIRM = 2;
    }

    /**
     * 是否查询附件 true：是 false ：否
     */
    public static final class QueryAttachFlag {
        /**
         * true：是
         */
        public static final Boolean YES = true;

        /**
         * false ：否
         */
        public static final Boolean NO = false;
    }

    /**
     * 是否查询应用范围  true：是 false ：否
     */
    public static final class QueryScopeFlag {
        /**
         * true：是
         */
        public static final Boolean YES = true;

        /**
         * false ：否
         */
        public static final Boolean NO = false;
    }

    /**
     * 是否需要转义true：是 false ：否
     */
    public static final class TranslateFlag {
        /**
         * true：是
         */
        public static final Boolean YES = true;

        /**
         * false ：否
         */
        public static final Boolean NO = false;
    }

    /**
     * 是否分页查询标识
     * true：是  false: 否
     */
    public static final class PageQryFlag {
        /**
         * true：是
         */
        public static final Boolean YES = true;

        /**
         * false ：否
         */
        public static final Boolean NO = false;
    }

    /**
     * 是否需要物质明细数量标识
     * true：需要 false 不需要
     */
    public static final class NeedAgreementSkuNumFlag {
        /**
         * true：是
         */
        public static final Boolean YES = true;

        /**
         * false ：否
         */
        public static final Boolean NO = false;
    }

    /**
     * 协议变更申请是否需要转义标识  true：转义  false：不转义
     */
    public static final class AgrApplyTranslateFlag {
        /**
         * true：是
         */
        public static final Boolean YES = true;

        /**
         * false ：否
         */
        public static final Boolean NO = false;
    }


    /**
     * 正常/删除
     */
    public static final class IsDelete {
        /**
         * 正常
         */
        public static final Byte NORMAL = 0;
        /**
         * 已删除
         */
        public static final Byte DELETED = 1;
    }


    /**
     * 协议状态 0：草稿 1：驳回 2：审核中 3：暂停 4：启用 5：冻结 6：过期 7：终止 8：待确认 9：合同失效 10:待生效  11:确认中  12：未接受
     */
    public static final class AgreementStatus {
        /**
         * 99：未完成状态（协议创建点击下一步后的中间状态，在明细页面点击保存后，将协议变为草稿状态）
         */
        public static final Integer NO_ASS = 99;
        /**
         * 0：草稿
         */
        public static final Integer DRAFT = 0;

        /**
         * 1：驳回
         */
        public static final Integer REJECT = 1;

        /**
         * 2：审核中
         */
        public static final Integer IN_AUDIT = 2;

        /**
         * 3：暂停
         */
        public static final Integer SUSPEND = 3;

        /**
         * 4：启用
         */
        public static final Integer ENABLE = 4;

        /**
         * 5：冻结
         */
        public static final Integer FROZEN = 5;

        /**
         * 6：过期
         */
        public static final Integer BE_OVERDUE = 6;

        /**
         * 7：终止
         */
        public static final Integer TERMINATION = 7;
        /**
         * 8：确认中
         */
        public static final Integer TO_CONFIRM = 8;
        /**
         * 9：合同失效
         */
        public static final Integer INVALID_CONTRACT = 9;
        /**
         * 10：待生效状态
         */
        public static final Integer WAIT_ENABLE = 10;
        /**
         * 11:未接受
         */
        public static final Integer NO_CONFIRM = 11;
    }


    /**
     * 协议明细状态 0：草稿，1：待审批    2：待上架，3：已上架    4：驳回    5：手动下架，6：失效 ,7:电商下架     8：冻结  9：协议失效 10 商品不可售'  20：待发布
     */
    public static final class SkuStatus {
        /**
         * 0：草稿
         */
        public static final Integer DRAFT = 0;

        /**
         * 1：待审批
         */
        public static final Integer PENDING_APPROVAL = 1;

        /**
         * 2：待上架
         */
        public static final Integer TO_BE_SHELF = 2;

        /**
         * 3：已上架
         */
        public static final Integer BE_SHELF = 3;

        /**
         * 4：驳回
         */
        public static final Integer REJECT = 4;

        /**
         * 5：手动下架
         */
        public static final Integer HAND_DOWN_SHELF = 5;

        /**
         * 6：失效
         */
        public static final Integer INVALID = 6;

        /**
         * 7:电商下架
         */
        public static final Integer ELE_DOWN_SHELF = 7;

        /**
         * 8：协议冻结
         */
        public static final Integer AGREEMENT_FREEZEN = 8;

        /**
         * 9：协议失效
         */
        public static final Integer AGREEMENT_INVALID = 9;
        /**
         * 10 商品不可售
         */
        public static final Integer NOT_SALE = 10;

        /**
         * 20：待发布
         */
        public static final Integer TO_BE_RELEASED = 20;
    }

    /**
     * 商品中心商品状态：0：草稿，1：待审批    2：待上架，3：已上架    4：驳回    5：手动下架，6：失效 ,7:电商下架     8：冻结  9：协议失效 10 商品不可售',
     */
    public static final class CommiditySkuStatus {
        /**
         * 0：草稿
         */
        public static final Byte DRAFT = 0;

        /**
         * 1：待审批
         */
        public static final Byte PENDING_APPROVAL = 1;

        /**
         * 2：待上架
         */
        public static final Byte TO_BE_SHELF = 2;

        /**
         * 3：已上架
         */
        public static final Byte BE_SHELF = 3;

        /**
         * 4：驳回
         */
        public static final Byte REJECT = 4;

        /**
         * 5：手动下架
         */
        public static final Byte HAND_DOWN_SHELF = 5;

        /**
         * 6：失效
         */
        public static final Byte INVALID = 6;

        /**
         * 7:电商下架
         */
        public static final Byte ELE_DOWN_SHELF = 7;

        /**
         * 8：协议冻结
         */
        public static final Byte AGREEMENT_FREEZEN = 8;

        /**
         * 9：协议失效
         */
            public static final Byte AGREEMENT_INVALID = 6;
        /**
         * 10 商品不可售
         */
        public static final Byte NOT_SALE = 10;
    }

    /**
     * 税率 0：0%，6：6%，3：3%:，17：17% ，13：13%，15：15% 默认值：17：17%
     */
    public static final class TaxRate {
        /**
         * 0：0%
         */
        public static final Byte ZERO = 0;
        /**
         * 6：6%
         */
        public static final Byte SIX = 6;
        /**
         * 3：3%
         */
        public static final Byte THREE = 3;
        /**
         * 17：17%
         */
        public static final Byte SEVENTEEN = 17;
        /**
         * 13：13%
         */
        public static final Byte THIRTEEN = 13;

    }

    /**
     * 币种 0：人民币 默认0
     */
    public static final class Currency {
        /**
         * 0：人民币
         */
        public static final Byte RMB = 0;

    }

    /**
     * 质保期（月）：0、3、6、12、24、36 默认值：12
     */
    public static final class Warantty {
        /**
         * 0：0
         */
        public static final Integer ZERO = 0;
        /**
         * 3：3
         */
        public static final Integer THREE = 3;
        /**
         * 6：6
         */
        public static final Integer SIX = 6;
        /**
         * 12：12
         */
        public static final Integer TWELVE = 12;
        /**
         * 24：24
         */
        public static final Integer TWENNTYGOUR = 24;
        /**
         * 36：36
         */
        public static final Integer THIRTYSIX = 36;

    }


    /**
     * 是否配送：0:否,1是 默认值：是
     *
     */
    public static final class IsDispatch {
        /**
         * 0:否
         */
        public static final Byte NO = 0;
        /**
         * 1是
         */
        public static final Byte YES = 1;
    }

    /**
     * 结算类型：1 供应商 2 采购商
     */
    public static final class PayMeThod {
        /**
         * 0:否
         */
        public static final String  A = "1";
        /**
         * 1是
         */
        public static final String  B = "2";
    }

    /**
     * 结算类型转义：1 供应商 2 采购商
     */
    public static final class PayMeThodStr {
        /**
         * 0:否
         */
        public static final String  A = "供应商";
        /**
         * 1是
         */
        public static final String  B = "采购商";
    }

    /**
     * 调价机制：0：无，1：事前调价，2：事中调价 默认值：0
     */
    public static final class AdjustPrice {
        /**
         * 0：无
         */
        public static final Byte NO_ADJUST_PRICE = 0;
        /**
         * 1：事前调价
         */
        public static final Byte PRICE_ADJUSTMENT_BEFOREHAND = 1;
        /**
         * 2：事中调价
         */
        public static final Byte PRICE_ADJUSTMENT_IN_BUSINESS = 2;
    }

    /**
     * 是否公式调价：0：否 1：是 默认值：0
     */
    public static final class IsAdjustPriceFormula {
        /**
         * 0:否
         */
        public static final Byte NO = 0;
        /**
         * 1是
         */
        public static final Byte YES = 1;
    }

    /**
     * 是否手动修改采购单价：0:否 1：是  默认值：0
     */
    public static final class IsModifyBuyPrice {
        /**
         * 0:否
         */
        public static final Byte NO = 0;
        /**
         * 1是
         */
        public static final Byte YES = 1;
    }

    /**
     * 是否存在加价项 0：否 1：是 默认值：0
     */
    public static final class IsAddPrice {
        /**
         * 0:否
         */
        public static final Byte NO = 0;
        /**
         * 1是
         */
        public static final Byte YES = 1;
    }

    /**
     * 审批流程key
     */
    public static final class AgreementAuditKey {

        /**
         * 平台协议-审批流
         */
        public static final String AGREEMENT_PLAT_AUDIT = "agreementPlatAudit";

        /**
         * 单位协议-审批流
         */
        public static final String AGREEMENT_PURCHASE_AUDIT = "agreementPurchaseAudit";

        /**
         * 平台协议变更-审批流
         */
        public static final String AGREEMENT_PLAT_CHANGE_AUDIT = "agreementPlatChangeAudit";

        /**
         * 单位协议变更-审批流
         */
        public static final String AGREEMENT_PURCHASE_CHANGE_AUDIT = "agreementPurchaseChangeAudit";

    }


    /**
     * 协议变更类型 1:暂停，2：启用，3：终止，4：调价，5：延期，6:补充，7:其他变更
     */
    public static final class AgreementChangeType {

        /**
         * 暂停
         */
        public static final Integer STOP = 1;
        /**
         * 启用
         */
        public static final Integer START = 2;
        /**
         * 终止
         */
        public static final Integer TERMINATION = 3;
        /**
         * 调价
         */
        public static final Integer CHANGE_PRICE = 4;
        /**
         * 延期
         */
        public static final Integer DELAY = 5;
        /**
         * 补充
         */
        public static final Integer SUPPLEMENT = 6;
        /**
         * 其他变更
         */
        public static final Integer OTHER = 7;
        /**
         * 其他变更
         */
        public static final Integer STOCK_CHANGE = 8;
        /**
         * 原始版本
         */
        public static final Integer ORGINAL = 99;

    }

    /**
     * 审批业务编码
     */
    public static final class AuditBusiCode {

        /**
         * 协议新增审核
         */
        public static final String AGR_ADD_AUDIT = "agreementAddAudit";

        /**
         * 协议变更申请审核
         */
        public static final String AGR_CHG_APPLY_AUDIT = "agreementChgApplyAudit";

    }

    /**
     * 审批状态
     */
    public static final class AuditStatus {
        /**
         * 待审核
         */
        public static final Integer PENDING_REVIEW = 0;
        /**
         * 审核中
         */
        public static final Integer UNDER_REVIEW = 1;
        /**
         * 审核完成
         */
        public static final Integer REVIEW_COMPLETED = 2;
        /**
         * 审批驳回
         */
        public static final Integer APPROVAL_REJECTION = 3;
    }


    /**
     * 审批结果：1通过、0未通过
     */
    public static final class AuditResult {
        /**
         * 1通过
         */
        public static final Integer ADOPT = 1;
        /**
         * 0未通过
         */
        public static final Integer NOT_PASS = 0;
    }

    /**
     * 供应商确认结果
     */
    public static final class SupConfirmResult {
        /**
         * 1 不接受
         */
        public static final Integer NOT_PASS = 1;
        /**
         * 0 接受
         */
        public static final Integer ADOPT = 0;
    }

    /**
     * 协议变更申请是否需要转义标识  true：转义  false：不转义
     */
    public static final class AgreementApplyTranslateFlag {
        /**
         * true：是
         */
        public static final Boolean YES = true;

        /**
         * false ：否
         */
        public static final Boolean NO = false;
    }

    /**
     * 审批对象
     */
    public static final class AuditObjType {
        /**
         * 101 协议新增审批
         */
        public static final Integer AGREEMENT_AUDIT = 101;
        /**
         * 102 协议变更审批
         */
        public static final Integer AGREEMENT_ADD_AUDIT = 102;
    }

    /**
     * 协议分配状态  0：已分配 1：待分配
     */
    public static final class AssignStatus {
        /**
         * 0：已分配
         */
        public static final Byte BE_ASSIGN = 0;
        /**
         * 1：待分配
         */
        public static final Byte TO_BE_ASSIGN = 1;
    }

    /**
     * 协议变更申请状态	:	0：草稿，1：审批中，2：通过，3：不通过
     */
    public static final class ChangeApplyStatus {
        /**
         * 0：草稿
         */
        public static final Integer DRAFT = 0;
        /**
         * 1：审核中
         */
        public static final Integer IN_AUDIT = 1;
        /**
         * 2：通过
         */
        public static final Integer PASS = 2;
        /**
         * 3：不通过
         */
        public static final Integer NO_PASS = 3;
        /**
         * 4：待确认
         * */
        public static final Integer TO_CONFIRM = 4;
        /**
         * 5：不接受
         * */
        public static final Integer NO_CONFIRM = 5;
        /**
         * 6：冻结
         * */
        public static final Integer FROZEN = 6;
    }

    /**
     * 编号类型  1:平台协议编号 2:变更申请编号
     */
    public static final class CodeType {
        /**
         * 1：平台协议编号
         */
        public static final Byte AGR_CODE = 1;
        /**
         * 2：变更申请编号
         */
        public static final Byte AGR_CHG_CODE = 2;
    }


    /**
     * 铺货方式 1：运营商自主铺货 2：供应商铺货
     */
    public static final class SupplierMode {
        /**
         * 1：运营商自主铺货
         */
        public static final Byte OPERATOR_SELLS_GOODS_INDEPENDENTLY = 1;
        /**
         * 2：供应商铺货
         */
        public static final Byte SUPPLIER_DELIVERY = 2;
        /**
         * 3：采购单位铺货
         */
        public static final Byte PUR_DELIVERY = 3;
    }

    /**
     * 协议明细变更类型 1 ：新增 2：修改 3：删除
     */
    public static final class AgreementSkuChangeType {
        /**
         * 1：新增
         */
        public static final Integer ADD = 1;
        /**
         * 2：修改
         */
        public static final Integer UPDATE = 2;
        /**
         * 3：删除
         */
        public static final Integer DELETE = 3;
    }

    /**
     * 交易模式 1：购销模式 2：撮合模式
     */
    public static final class TradeMode {
        /**
         * 1：购销模式
         */
        public static final Byte PURCHASE_AND_SALE = 1;
        /**
         * 2：撮合模式
         */
        public static final Byte MATCH_UP = 2;
    }

    /**
     * 编号类型
     */
    public static final class CreateCodeType {
        /**
         * 1：平台协议编号
         */
        public static final Byte PLA_CODE = 1;
        /**
         * 2：变更申请编号
         */
        public static final Byte CHNAGE_CODE = 2;
    }

    /**
     * 协议明细查询维度
     */
    public static final class QryRange {
        /**
         * 1：协议明细
         */
        public static final String AGR_SKU = "1";
        /**
         * 2：变更明细
         */
        public static final String AGR_CHG_SKU = "2";
    }
    /**
     * 协议明细查询维度
     */
    public static final class payObj {
        /**
         * 0：采购商
         */
        public static final Integer PAY_OBJ_PURCHASE = 0;
        /**
         * 1：供应商
         */
        public static final Integer PAY_OBJ_SUPPLY = 1;
    }

    /**
     * AGREEMENT_SKU_TO_PUBLISH ("待发布")
     * <p>
     * AGREEMENT_HAVE_COMMIDITY （商品查询）
     * <p>
     * RESTORE_UP_SHELF("RESTORE_UP_SHELF","106","恢复上架"),
     * APPROVAL_DOWN_SHELF("APPROVAL_DOWN_SHELF","104","手动下架"),
     * <p>
     * APPROVAL_UP_SHELF_AUTO("APPROVAL_UP_SHELF_AUTO","104","自动上架"),
     * <p>
     * APPROVAL_EDIT("APPROVAL_EDIT","107","编辑审核");
     * APPROVAL_UP_SHELF("APPROVAL_UP_SHELF","103","上架"),
     * <p>
     * AGREEMENT_SKU_EDIT（"审核记录'）
     */
    public static final class OperCode {
        /**
         * AGREEMENT_SKU_TO_PUBLISH ("待发布")
         */
        public static final String AGREEMENT_SKU_TO_PUBLISH = "AGREEMENT_SKU_TO_PUBLISH";
        /**
         * AGREEMENT_HAVE_COMMIDITY （商品查询）
         */
        public static final String AGREEMENT_HAVE_COMMIDITY = "AGREEMENT_HAVE_COMMIDITY";
        /**
         * RESTORE_UP_SHELF("RESTORE_UP_SHELF","106","恢复上架"),
         */
        public static final String RESTORE_UP_SHELF = "RESTORE_UP_SHELF";
        /**
         * APPROVAL_DOWN_SHELF("APPROVAL_DOWN_SHELF","104","手动下架"),
         */
        public static final String APPROVAL_DOWN_SHELF = "APPROVAL_DOWN_SHELF";
        /**
         * APPROVAL_UP_SHELF_AUTO("APPROVAL_UP_SHELF_AUTO","104","自动上架"),
         */
        public static final String APPROVAL_UP_SHELF_AUTO = "APPROVAL_UP_SHELF_AUTO";
        /**
         * APPROVAL_EDIT("APPROVAL_EDIT","107","编辑审核");
         */
        public static final String APPROVAL_EDIT = "APPROVAL_EDIT";
        /**
         * APPROVAL_UP_SHELF("APPROVAL_UP_SHELF","103","上架"),
         */
        public static final String APPROVAL_UP_SHELF = "APPROVAL_UP_SHELF";
        /**
         * AGREEMENT_SKU_EDIT（"审核记录'）
         */
        public static final String AGREEMENT_SKU_EDIT = "AGREEMENT_SKU_EDIT";
        /**
         * 商品编辑-商品编辑协议列表
         */
        public static final String COMMIDITY_EDIT = "COMMIDITY_EDIT";
    }

    /**
     * 协议模式 1：平台协议 2：单位协议
     */
    public static final class agreementMode {
        /**
         * 1：平台协议
         */
        public static final Byte PLAT_AGREEMENT = 1;

        /**
         * 2：单位协议
         */
        public static final Byte UNIT_AGREEMENT = 2;
    }

    /**
     * 1 已生成合同 2 可以生成合同 3 不可以生成合同'
     */
    public static final class isPurchase {
        /**
         * 1：已生成合同
         */
        public static final Integer HAVE_CONTRACT = 1;

        /**
         * 2：可以生成合同
         */
        public static final Integer AVALIABLE_CONTRACT = 2;

        /**
         * 3 不可以生成合同
         */
        public static final Integer NOT_AVALIABLE_CONTRACT = 3;
    }

    /**
     * 1 已生成合同 2 可以生成合同 3 不可以生成合同'
     */
    public static final class isSale {
        /**
         * 1：已生成合同
         */
        public static final Integer HAVE_CONTRACT = 1;

        /**
         * 2：可以生成合同
         */
        public static final Integer AVALIABLE_CONTRACT = 2;

        /**
         * 3 不可以生成合同
         */
        public static final Integer NOT_AVALIABLE_CONTRACT = 3;
    }

    public static final class Atour{
        /**
         * 参与服务费
         */
        public static final String  IS_PARTICIPATE = "IS_PARTICIPATE";
        /**
         * 是否预付
         */
        public static final String  IS_PREPAID = "IS_PREPAID";
    }

    /**
     * atour协议变更操作状态
     */
    public static final class operType{
        /**
         * 启用
         */
        public static final String ENABLE = "1";
        /**
         * 停用
         */
        public static final String DISABLE = "2";
        /**
         * 删除
         */
        public static final String DELETE = "3";
    }
    /**
     * 协议操作日志： 0:协议新增 1:协议修改 2:协议启动 3:协议停用 4：协议删除 5:协议明细修改
     */
    public static final class agreementOperateType{
        /**
         * 协议新增
         */
        public static final String ADD = "0" ;
        /**
         * 协议修改
         */
        public static final String MODIFY = "1" ;
        /**
         * 协议启动
         */
        public static final String ENABLE = "2" ;
        /**
         * 协议停用
         */
        public static final String DISABLE = "3" ;
        /**
         * 协议删除
         */
        public static final String DELETE = "4";
        /**
         * 协议明细修改
         */
        public static final String SKU_MODIFY = "5";

    }
    /**
     * 加签标识  0 ：环节任务   1：前加签任务  2：后加签任务  3：存在后加签任务
     */
    public static final class TASK_SING_TAG {
        public static final Integer TACHE_TASK = 0;
        public static final Integer PRE_TASK = 1;
        public static final Integer AF_TASK = 2;
        public static final Integer EXIST_AF_TASK = 3;

    }

    /**
     * 处理分类，1处理人，2候选人
     */
    public static final class TASK_DEAL_CLASS {
        public static final String ASSIGNEE = "1";
        public static final String CANDIDATE = "2";

    }
    /**
     * 删除标志，1已删除，0未删除
     */
    public static final class DELETE_TAG {
        public static final Integer DELETED = 1;
        public static final Integer NO_DEL = 0;

    }
    /**
     * 审批单状态
     */
    public static final class AUDIT_ORDER_STATUS {
        /**
         * 驳回
         */
        public static final String REJECT = "0";
        /**
         * 通过
         */
        public static final String PASS = "1";
        /**
         * 待审批
         */
        public static final String WAIT_AUDIT = "2";
    }

    public static final class PROC_TASK_FINISHED {
        public static final Integer FINISHED = 1;
        public static final Integer NO_FINISHED = 0;
        public static final Integer END_TASK = 2;

    }
    public static final class TASK_DEAL_RESULT {
        public static final Integer APPROVING = 2;
        public static final Integer AUDIT_PASS = 1;
        public static final Integer AUDIT_REJECT = 0;

    }
    /**
     * 单据类型
     */
    public static final class ObjType {
        /**
         * 协议
         */
        public static final Integer AGREEMENT = 1;
        /**
         * 变更单
         */
        public static final Integer CHANGE = 2;
        /**
         * 审批单
         */
        public static final Integer  APPROVE = 9;

    }

    /**
     * 协议分类：0：集团集采协议:1：区域集采协议、2：项目单位协议
     */
    public enum AgrTypeEnum {

        AGR_TYPE_GROP(0,"集团集采协议"),
        AGR_TYPE_ZOON(1,"区域集采协议"),
        AGR_TYPE_PROJECT_UNIT(2,"项目单位协议");

        private String name;
        private Integer value;

        public String getName() {
            return name;
        }
        public Integer getValue() {
            return value;
        }

        AgrTypeEnum(Integer value, String name) {
            this.name = name;
            this.value = value;
        }
        public static String getValueByCode(Integer code){
            for(AgrTypeEnum agrTypeEnum:AgrTypeEnum.values()){
                if(code.equals(agrTypeEnum.getValue())){
                    return agrTypeEnum.getName();
                }
            }
            return  null;
        }
    }
    /**
     * 协议模式 1：平台协议 2: 单位协议
     */
    public enum AgreementModeEnum {

        AGREEMENT_MODE_PLATFORM(1,"平台协议"),
        AGREEMENT_MODE_UNIT(2,"单位协议");

        private String name;
        private Integer value;

        public String getName() {
            return name;
        }
        public Integer getValue() {
            return value;
        }

        AgreementModeEnum(Integer value, String name) {
            this.name = name;
            this.value = value;
        }
        public static String getValueByCode(Integer code){
            for(AgreementModeEnum item:AgreementModeEnum.values()){
                if(code.equals(item.getValue())){
                    return item.getName();
                }
            }
            return  null;
        }
        public static Integer getCodeByName(String name){
            for(AgreementModeEnum item:AgreementModeEnum.values()){
                if(name.equals(item.getName())){
                    return item.getValue();
                }
            }
            return  null;
        }
    }
    /**
     * 价格类型 1：执行价 2：协议价
     */
    public enum AgrPriceTypeEnum {

        AGR_PRICE_TYPE_EXECUTE(1,"执行价"),
        AGR_PRICE_TYPE_AGR(2,"协议价");

        private String name;
        private Integer value;

        public String getName() {
            return name;
        }
        public Integer getValue() {
            return value;
        }

        AgrPriceTypeEnum(Integer value, String name) {
            this.name = name;
            this.value = value;
        }
        public static String getValueByCode(Integer code){
            for(AgrPriceTypeEnum item:AgrPriceTypeEnum.values()){
                if(code.equals(item.getValue())){
                    return item.getName();
                }
            }
            return  null;
        }
    }

    /**
     * 协议来源：1：手动创建，2.协议合同，3.招投标，4.询比价，5.竞价
     */
    public enum AgrSrcEnum {

        AGR_SRC_MANUALLY_CREATE(1,"手动创建"),
        AGR_SRC_AGR_CONTRACT(2,"协议合同"),
        AGR_SRC_BID(3,"招投标"),
        AGR_SRC_FOR_COMPARISON(4,"询比价"),
        AGR_SRC_BIDING(5,"竞价");

        private String name;
        private Integer value;

        public String getName() {
            return name;
        }
        public Integer getValue() {
            return value;
        }

        AgrSrcEnum(Integer value, String name) {
            this.name = name;
            this.value = value;
        }
        public static String getValueByCode(Integer code){
            for(AgrSrcEnum item:AgrSrcEnum.values()){
                if(code.equals(item.getValue())){
                    return item.getName();
                }
            }
            return  null;
        }
        public static Integer getCodeByName(String name){
            for(AgrSrcEnum item:AgrSrcEnum.values()){
                if(name.equals(item.getName())){
                    return item.getValue();
                }
            }
            return  null;
        }
    }

    /**
     * 交易模式：1：贸易模式 2：搓合模式
     */
    public enum TradeModeEnum {

        TRADE_MODE_BUYING_AND_SELLING(1,"贸易模式"),
        TRADE_MODE_CU(2,"撮合模式");

        private String name;
        private Integer value;

        public String getName() {
            return name;
        }
        public Integer getValue() {
            return value;
        }

        TradeModeEnum(Integer value, String name) {
            this.name = name;
            this.value = value;
        }
        public static String getValueByCode(Integer code){
            for(TradeModeEnum item:TradeModeEnum.values()){
                if(code.equals(item.getValue())){
                    return item.getName();
                }
            }
            return  null;
        }
        public static Integer getCodeByName(String name){
            for(TradeModeEnum item:TradeModeEnum.values()){
                if(name.equals(item.getName())){
                    return item.getValue();
                }
            }
            return  null;
        }
    }

    /**
     * 是否配送 0:否,1是
     */
    public enum WhetherDispatchEnum {

        WHETHER_DISPATCH_NO(0,"否"),
        WHETHER_DISPATCH_YES(1,"是");

        private String name;
        private Integer value;

        public String getName() {
            return name;
        }
        public Integer getValue() {
            return value;
        }

        WhetherDispatchEnum(Integer value, String name) {
            this.name = name;
            this.value = value;
        }
        public static String getValueByCode(Integer code){
            for(WhetherDispatchEnum item:WhetherDispatchEnum.values()){
                if(code.equals(item.getValue())){
                    return item.getName();
                }
            }
            return  null;
        }
    }

    /**
     * 是否分配 0:否,1是
     */
    public enum WhetherAssignEnum {

        WHETHER_DISPATCH_NO(0,"否"),
        WHETHER_DISPATCH_YES(1,"是");

        private String name;
        private Integer value;

        public String getName() {
            return name;
        }
        public Integer getValue() {
            return value;
        }

        WhetherAssignEnum(Integer value, String name) {
            this.name = name;
            this.value = value;
        }
        public static String getValueByCode(Integer code){
            for(WhetherAssignEnum item:WhetherAssignEnum.values()){
                if(code.equals(item.getValue())){
                    return item.getName();
                }
            }
            return  null;
        }
    }

    /**
     * 采购类别：1物资类、2施工类、3服务类
     */
    public enum AgreementVarietyEnum {

        AGREEMENT_VARIETY_SUPPLIES(1,"物资类"),
        AGREEMENT_VARIETY_CONSTRUCTION(2,"施工类"),
        AGREEMENT_VARIETY_SERVE(3,"服务类");

        private String name;
        private Integer value;

        public String getName() {
            return name;
        }
        public Integer getValue() {
            return value;
        }

        AgreementVarietyEnum(Integer value, String name) {
            this.name = name;
            this.value = value;
        }
        public static String getValueByCode(Integer code){
            for(AgreementVarietyEnum item:AgreementVarietyEnum.values()){
                if(code.equals(item.getValue())){
                    return item.getName();
                }
            }
            return  null;
        }
        public static Integer getCodeByName(String Name){
            for(AgreementVarietyEnum item:AgreementVarietyEnum.values()){
                if(Name.equals(item.getName())){
                    return item.getValue();
                }
            }
            return  null;
        }
    }

    /**
     * 所属专区 1：电力专区，5：煤炭专区
     */
    public enum AgrLocationEnum {

        AGR_LOCATION_POWER(1,"电力专区"),
        AGR_LOCATION_COAL(5,"煤炭专区");

        private String name;
        private Integer value;

        public String getName() {
            return name;
        }
        public Integer getValue() {
            return value;
        }

        AgrLocationEnum(Integer value, String name) {
            this.name = name;
            this.value = value;
        }
        public static String getValueByCode(Integer code){
            for(AgrLocationEnum item:AgrLocationEnum.values()){
                if(code.equals(item.getValue())){
                    return item.getName();
                }
            }
            return  null;
        }
    }

    /**
     * 是否商城铺货标识 1：是，0：否
     */
    public enum WhetherStorePlanEnum {

        WHETHER_STORE_PLAN_YES(1,"是"),
        WHETHER_STORE_PLAN_NO(0,"否");

        private String name;
        private Integer value;

        public String getName() {
            return name;
        }
        public Integer getValue() {
            return value;
        }

        WhetherStorePlanEnum(Integer value, String name) {
            this.name = name;
            this.value = value;
        }
        public static String getValueByCode(Integer code){
            for(WhetherStorePlanEnum item:WhetherStorePlanEnum.values()){
                if(code.equals(item.getValue())){
                    return item.getName();
                }
            }
            return  null;
        }
    }


    /**
     * 是否有明细标识 1：是，0：否
     */
    public enum WhetherHaveItemEnum {

        WHETHER_HAVE_ITEM_YES(1,"是"),
        WHETHER_HAVE_ITEM_NO(0,"否");

        private String name;
        private Integer value;

        public String getName() {
            return name;
        }
        public Integer getValue() {
            return value;
        }

        WhetherHaveItemEnum(Integer value, String name) {
            this.name = name;
            this.value = value;
        }
        public static String getValueByCode(Integer code){
            for(WhetherHaveItemEnum item: WhetherHaveItemEnum.values()){
                if(code.equals(item.getValue())){
                    return item.getName();
                }
            }
            return  null;
        }
    }

    /**
     * 应用范围类型 选项值：0：全国 3：二级单位
     */
    public enum ScopeTypeEnum {

        SCOPE_TYPE_ALL(0,"平台"),
        SCOPE_TYPE_GORP_COMPANY(3,"指定单位"),
        SCOPE_TYPE_SPE_COMPANY(4,"内部单位");

        private String name;
        private Integer value;

        public String getName() {
            return name;
        }
        public Integer getValue() {
            return value;
        }

        ScopeTypeEnum(Integer value, String name) {
            this.name = name;
            this.value = value;
        }
        public static String getValueByCode(Integer code){
            for(ScopeTypeEnum item:ScopeTypeEnum.values()){
                if(code.equals(item.getValue())){
                    return item.getName();
                }
            }
            return  null;
        }
        public static Integer getCodeByName(String name){
            for(ScopeTypeEnum item:ScopeTypeEnum.values()){
                if(name.equals(item.getName())){
                    return item.getValue();
                }
            }
            return  null;
        }
    }

    /**
     * 调价机制：0：无，1：事前调价，2：事中调价
     */
    public enum AdjustPriceEnum {

        SCOPE_TYPE_NULL(0,"无"),
        SCOPE_TYPE_BEFORE_SCOPE(1,"事前调价"),
        SCOPE_TYPE_CENTER_SCOPE(2,"事中调价");

        private String name;
        private Integer value;

        public String getName() {
            return name;
        }
        public Integer getValue() {
            return value;
        }

        AdjustPriceEnum(Integer value, String name) {
            this.name = name;
            this.value = value;
        }
        public static String getValueByCode(Integer code){
            for(AdjustPriceEnum item:AdjustPriceEnum.values()){
                if(code.equals(item.getValue())){
                    return item.getName();
                }
            }
            return  null;
        }
        public static Integer getCodeByName(String name){
            for(AdjustPriceEnum item:AdjustPriceEnum.values()){
                if(name.equals(item.getName())){
                    return item.getValue();
                }
            }
            return  null;
        }
    }
    /**
     * 铺货方式：1：运营商自主铺货 2：供应商铺货 3:采购单位铺货
     */
    public enum VendorModeEnum {

        SCOPE_TYPE_NULL(1,"运营单位"),
        SCOPE_TYPE_BEFORE_SCOPE(2,"供应商"),
        SCOPE_TYPE_CENTER_SCOPE(3,"采购单位");

        private String name;
        private Integer value;

        public String getName() {
            return name;
        }
        public Integer getValue() {
            return value;
        }

        VendorModeEnum(Integer value, String name) {
            this.name = name;
            this.value = value;
        }
        public static String getValueByCode(Integer code){
            for(VendorModeEnum item:VendorModeEnum.values()){
                if(item.getValue().equals(code)){
                    return item.getName();
                }
            }
            return  null;
        }
        public static Integer getCodeByName(String name){
            for(VendorModeEnum item:VendorModeEnum.values()){
                if(item.getName().equals(name)){
                    return item.getValue();
                }
            }
            return  null;
        }
    }

    /**
     * 支付方: 0 采购商 1 供应商
     */
    public enum PayObjEnum {

        PAY_OBJ_PURCHASE(0,"采购商"),
        PAY_OBJ_SUPPLY(1,"供应商");

        private String name;
        private Integer value;

        public String getName() {
            return name;
        }
        public Integer getValue() {
            return value;
        }

        PayObjEnum(Integer value, String name) {
            this.name = name;
            this.value = value;
        }
        public static String getValueByCode(Integer code){
            for(PayObjEnum item:PayObjEnum.values()){
                if(code.equals(item.getValue())){
                    return item.getName();
                }
            }
            return  null;
        }
    }

    /**
     * 支付方: 0 采购商 1 供应商
     */
    public enum PayTypeEnum {

        PAY_TYPE_ADVANCE_PAYMENT(0,"预付款"),
        PAY_TYPE_SUBLEVEL(1,"分阶段支付"),
        PAY_TYPE_PAYMENT_DAYS(2,"账期支付");

        private String name;
        private Integer value;

        public String getName() {
            return name;
        }
        public Integer getValue() {
            return value;
        }

        PayTypeEnum(Integer value, String name) {
            this.name = name;
            this.value = value;
        }
        public static String getValueByCode(Integer code){
            for(PayTypeEnum item:PayTypeEnum.values()){
                if(code.equals(item.getValue())){
                    return item.getName();
                }
            }
            return  null;
        }
        public static Integer getCodeByName(String name){
            for(PayTypeEnum item:PayTypeEnum.values()){
                if(name.equals(item.getName())){
                    return item.getValue();
                }
            }
            return  null;
        }
    }

    public static final class FileObjType {
        public static final Integer AGR = 1;
        public static final Integer AGR_CHANGE = 3;
        public static final Integer AGR_ITEM = 2;

    }

    /**
     * 是否成品油转义 1是 0 否
     */
    public enum IsOilPcodeEnum {

        IS_OIL_PCODE_NO(0,"否"),
        IS_OIL_PCODE_IS(1,"是");

        private String name;
        private Integer value;

        public String getName() {
            return name;
        }
        public Integer getValue() {
            return value;
        }

        IsOilPcodeEnum(Integer value, String name) {
            this.name = name;
            this.value = value;
        }
        public static String getValueByCode(Integer code){
            for(IsOilPcodeEnum isOilPcodeEnum:IsOilPcodeEnum.values()){
                if(code.equals(isOilPcodeEnum.getValue())){
                    return isOilPcodeEnum.getName();
                }
            }
            return  null;
        }
        public static Integer getCodeByName(String name){
            for(IsOilPcodeEnum isOilPcodeEnum:IsOilPcodeEnum.values()){
                if(name.equals(isOilPcodeEnum.getName())){
                    return isOilPcodeEnum.getValue();
                }
            }
            return  null;
        }
    }

    /**
     * 任务完成标识 1：完成 0:未完成
     */
    public static final class taskFinishFLag {
        /**
         * 0 未完成
         */
        public static final Integer NOT_FINISH = 0;

        /**
         * 1 完成
         */
        public static final Integer FINISHED = 1;

    }

    /**
     * 是否指定日期 1：指定账期日，2：账期起算特定业务节点+账期天
     */
    public static final class Assign {
        /**
         * 1：指定账期日
         */
        public static final Integer NOT_FINISH = 1;

        /**
         * 2：账期起算特定业务节点+账期天
         */
        public static final Integer FINISHED = 2;

    }
    /**
     * 对象类型:1协议主体 2协议明细 3协议变更申请
     */
    public static final class AccessoryObjType {
        /**
         *  1协议主体
         */
        public static final Integer AGR_MAIN = 1;

        /**
         * 2协议明细
         */
        public static final Integer AGR_ITEM = 2;

        /**
         * 3协议变更申请
         */
        public static final Integer AGR_CHNG_APPLY = 3;

    }
    /**
     * 账期支付-指定账期日
     * 1：签收发票开始
     * 2：订单验收
     * 3：订单到货
     */
    public enum IsAssign{

        IS_ASSIGN_SIGN_BEGIN(1,"签收发票开始"),
        IS_ASSIGN_ORDER_CHECK(2,"订单验收"),
        IS_ASSIGN_ORDER_AOG(3,"订单到货");

        private String name;
        private Integer value;

        public String getName() {
            return name;
        }
        public Integer getValue() {
            return value;
        }

        IsAssign(Integer value, String name) {
            this.name = name;
            this.value = value;
        }
        public static String getValueByCode(Integer code){
            for(IsAssign isAssign:IsAssign.values()){
                if(code.equals(isAssign.getValue())){
                    return isAssign.getName();
                }
            }
            return  null;
        }
        public static Integer getCodeByName(String name){
            for(IsAssign isAssign:IsAssign.values()){
                if(name.equals(isAssign.getName())){
                    return isAssign.getValue();
                }
            }
            return  null;
        }
    }
    /**
     *账期支付-账期起算特定业务节点+账期天
     *1：订单收票
     *2：订单/验收单验收
     *3：订单/发货单到货
     *4：发票挂账
     */
    public enum NoAssign{

        NO_ASSIGN_ORDER_INVOICE(1,"订单收票"),
        NO_ASSIGN_ORDER_checkCHECK(2,"订单/验收单验收"),
        NO_ASSIGN_ORDER_AOG(3,"订单/发货单到货"),
        NO_ASSIGN_BBOC(4,"发票挂账");

        private String name;
        private Integer value;

        public String getName() {
            return name;
        }
        public Integer getValue() {
            return value;
        }

        NoAssign(Integer value, String name) {
            this.name = name;
            this.value = value;
        }
        public static String getValueByCode(Integer code){
            for(NoAssign noAssign:NoAssign.values()){
                if(code.equals(noAssign.getValue())){
                    return noAssign.getName();
                }
            }
            return  null;
        }
        public static Integer getCodeByName(String name){
            for(NoAssign noAssign:NoAssign.values()){
                if(name.equals(noAssign.getName())){
                    return noAssign.getValue();
                }
            }
            return  null;
        }
    }

    /**
     * 协议明细变更类型 1 ：新增 2：修改 3：删除
     */
    public enum AgrItemChngTypeEnum{

        AGR_ITEM_CHNG_TYPE_ENUM_ADD(1,"新增"),
        AGR_ITEM_CHNG_TYPE_ENUM_UPDATE(2,"修改"),
        AGR_ITEM_CHNG_TYPE_ENUM_DELETE(3,"减少");

        private String name;
        private Integer value;

        public String getName() {
            return name;
        }
        public Integer getValue() {
            return value;
        }

        AgrItemChngTypeEnum(Integer value, String name) {
            this.name = name;
            this.value = value;
        }
        public static String getValueByCode(Integer code){
            for(AgrItemChngTypeEnum agrItemChngTypeEnum:AgrItemChngTypeEnum.values()){
                if(agrItemChngTypeEnum.getValue().equals(code)){
                    return agrItemChngTypeEnum.getName();
                }
            }
            return  null;
        }
        public static Integer getCodeByName(String name){
            for(AgrItemChngTypeEnum agrItemChngTypeEnum:AgrItemChngTypeEnum.values()){
                if(agrItemChngTypeEnum.getName().equals(name)){
                    return agrItemChngTypeEnum.getValue();
                }
            }
            return  null;
        }
    }

    /**
     协议变更申请状态转义 0申请中 1变更通过 2变更中止
     */
    public enum ChngApplyStatusEnum{

        DRAFT(0,"草稿"),
        IN_AUDIT(1,"审核中"),
        PASS(2,"审批通过"),
        NO_PASS(3,"已驳回"),
        TO_CONFIRM(4,"待确认"),
        NO_CONFIRM(5,"未接受"),
        FROZEN(6,"冻结");

        private String name;
        private Integer value;

        public String getName() {
            return name;
        }
        public Integer getValue() {
            return value;
        }

        ChngApplyStatusEnum(Integer value, String name) {
            this.name = name;
            this.value = value;
        }
        public static String getNameByValue(Integer code){
            for(ChngApplyStatusEnum chngApplyStatusEnum:ChngApplyStatusEnum.values()){
                if(chngApplyStatusEnum.getValue().equals(code)){
                    return chngApplyStatusEnum.getName();
                }
            }
            return  null;
        }
    }
    /**
     * 协议变更申请状态 0申请中 1变更通过 2变更中止
     */
    public static final class ChngApplyStatus {
        /**
         * 0申请中
         */
        public static final Integer APPLYING = 0;
        /**
         * 1变更通过
         */
        public static final Integer APPLY_PASS = 1;
        /**
         * 2变更中止
         */
        public static final Integer APPLY_STOP = 2;
    }

    /**
     * 协议明细状态 0：草稿，1：待审批 2：已生效 3：驳回 4：失效 5：冻结 6：协议失效 20：待发布
     */
    public static final class agrSkuStatus {
        /**
         * 0：草稿
         */
        public static final Integer DRAFTS = 0;
        /**
         * 1：待审批
         */
        public static final Integer APPROVAL_PENDING = 1;
        /**
         * 2：已生效
         */
        public static final Integer EFFECTED = 2;
        /**
         * 3：驳回
         */
        public static final Integer REJECT = 3;
        /**
         * 4：失效
         */
        public static final Integer LOSE_EFFICACY = 4;
        /**
         * 5：冻结
         */
        public static final Integer FROZEN = 5;
        /**
         * 6：协议失效
         */
        public static final Integer AGR_LOSE_EFFICACY = 6;
        /**
         * 20：待发布
         */
        public static final Integer TO_BE_ANNOUNCED = 20;
    }

    /**
     * 关联对象类型
     */
    public static final class RelObjType {
        /**
         * 0：合同
         */
        public static final Integer CONTRACT = 0;
        /**
         * 1：计划
         */
        public static final Integer PLAN = 1;

    }

    public static final class SyncType{
        /**
         * 1： 修改商品状态为协议冻结
         */
        public static final Integer  FROZEN= 1;
        /**
         * 2： 修改商品状态为协议失效
         */
        public static final Integer INVALID = 2;
        /**
         * 3： 修改商品状态为上架
         */
        public static final Integer UP_SHELF = 3;
        /**
         * 4：应用范围同步 同步协议应用范围编码集合
         */
        public static final Integer AGR_SCOPE_CHNG = 4;
        /**
         * 5：明细调价同步 同步采购单价，销售单价
         */
        public static final Integer AGR_ITEM_ADJUST_PRICE = 5;
        /**
         * 6：明细删除同步 修改商品状态为协议失效
         */
        public static final Integer AGR_ITEM_DELETE = 6;
    }

    /**
     * 协议版本状态 0已失效 1生效中2审批中
     */
    public static final class AgrVersionStatus{
        /**
         * 0： 已失效
         */
        public static final Integer  INVALID= 0;
        /**
         * 1： 生效中
         */
        public static final Integer  VALID = 1;
        /**
         * 2： 待生效
         */
        public static final Integer TO_VALID = 2;

    }
    /**
     * 版本状态转义
     */
    public enum VersionStatusEnum {

        INVALID(0,"已失效"),
        VALID(1,"生效中"),
        TO_VALID(2,"待生效");

        private String name;
        private Integer value;

        public String getName() {
            return name;
        }
        public Integer getValue() {
            return value;
        }

        VersionStatusEnum(Integer value, String name) {
            this.name = name;
            this.value = value;
        }
        public static String getValueByCode(Integer code){
            for(VersionStatusEnum versionStatusEnum: VersionStatusEnum.values()){
                if(code.equals(versionStatusEnum.getValue())){
                    return versionStatusEnum.getName();
                }
            }
            return  null;
        }
    }
    /**
     * 变更类型转义
     */
    public enum AgrChngTypeEnum {

        STOP(1,"暂停"),
        START(2,"启用"),
        TERMINATION(3,"终止"),
        CHANGE_PRICE(4,"调价"),
        DELAY(5,"延期"),
        SUPPLEMENT(6,"补充"),
        OTHER(7,"其他变更"),
        STOCK_CHANGE(8,"库存变更"),
        ORGINAL(99,"原始版本");

        private String name;
        private Integer value;

        public String getName() {
            return name;
        }
        public Integer getValue() {
            return value;
        }

        AgrChngTypeEnum(Integer value, String name) {
            this.name = name;
            this.value = value;
        }
        public static String getValueByCode(Integer code){
            for(AgrChngTypeEnum agrChngTypeEnum: AgrChngTypeEnum.values()){
                if(code.equals(agrChngTypeEnum.getValue())){
                    return agrChngTypeEnum.getName();
                }
            }
            return  null;
        }
        public static Integer getCodeByName(String name){
            for(AgrChngTypeEnum agrChngTypeEnum: AgrChngTypeEnum.values()){
                if(name.equals(agrChngTypeEnum.getName())){
                    return agrChngTypeEnum.getValue();
                }
            }
            return  null;
        }
    }

    /**
     * 加价比率转义
     */
    public enum MarkUpEnum {
        MarkUp0(0,"0%"),
        MarkUp1(1,"1%"),
        MarkUp2(2,"2%"),
        MarkUp3(3,"3%"),
        MarkUp4(4,"4%"),
        MarkUp5(5,"5%"),
        MarkUp6(6,"6%"),
        MarkUp7(7,"7%"),
        MarkUp8(8,"8%"),
        MarkUp9(9,"9%"),
        MarkUp10(10,"10"),
        MarkUp11(11,"11%"),
        MarkUp12(12,"12%"),
        MarkUp13(13,"13%");

        private String name;
        private Integer value;

        public String getName() {
            return name;
        }
        public Integer getValue() {
            return value;
        }

        MarkUpEnum(Integer value, String name) {
            this.name = name;
            this.value = value;
        }
        public static String getValueByCode(Integer code){
            for(MarkUpEnum markUpEnum: MarkUpEnum.values()){
                if(code.equals(markUpEnum.getValue())){
                    return markUpEnum.getName();
                }
            }
            return  null;
        }
        public static Integer getCodeByName(String name){
            for(MarkUpEnum markUpEnum: MarkUpEnum.values()){
                if(name.equals(markUpEnum.getName())){
                    return markUpEnum.getValue();
                }
            }
            return  null;
        }
    }
    /**
     * 税率转义
     */
    public enum TaxRateEnum {
        TaxRate0(0,"0%"),
        TaxRate3(3,"3%"),
        TaxRate5(5,"5%"),
        TaxRate6(6,"6%"),
        TaxRate9(9,"9%"),
        TaxRate12(12,"12%"),
        TaxRate13(13,"13%"),
        TaxRate16(16,"16%");


        private String name;
        private Integer value;

        public String getName() {
            return name;
        }
        public Integer getValue() {
            return value;
        }

        TaxRateEnum(Integer value, String name) {
            this.name = name;
            this.value = value;
        }
        public static String getValueByCode(Integer code){
            for(TaxRateEnum taxRateEnum: TaxRateEnum.values()){
                if(code.equals(taxRateEnum.getValue())){
                    return taxRateEnum.getName();
                }
            }
            return  null;
        }
        public static Integer getCodeByName(String name){
            for(TaxRateEnum taxRateEnum: TaxRateEnum.values()){
                if(name.equals(taxRateEnum.getName())){
                    return taxRateEnum.getValue();
                }
            }
            return  null;
        }
    }
    /**
     * 是否指定日期 1：指定账期日，2：账期起算特定业务节点+账期天
     */
    public enum  AssignEnum {
        yes("1","指定账期日"),
        no("2","账期起算特定业务节点+账期天数");

        private String name;
        private String value;

        public String getName() {
            return name;
        }
        public String getValue() {
            return value;
        }

        AssignEnum(String value, String name) {
            this.name = name;
            this.value = value;
        }
        public static String getValueByCode(String code){
            for(AssignEnum assignEnum: AssignEnum.values()){
                if(code.equals(assignEnum.getValue())){
                    return assignEnum.getName();
                }
            }
            return  null;
        }
        public static String getCodeByName(String name){
            for(AssignEnum assignEnum: AssignEnum.values()){
                if(name.equals(assignEnum.getName())){
                    return assignEnum.getValue();
                }
            }
            return  null;
        }
    }
    /**
     * 协议同步结果
     */
    public static final class SyncResult {
        /**
         * 1 成功
         */
        public static final Integer SUCCESS = 1;
        /**
         * 0失败
         */
        public static final Integer FAIL = 0;
    }
    /**
     * 协议同步类型
     */
    public static final class AgrSyncType {
        /**
         * 1 协议主体
         */
        public static final Integer AGR_MAIN = 1;
        /**
         * 2 协议明细
         */
        public static final Integer AGR_ITEM = 2;
    }

    /**
     * 协议同步处理状态
     */
    public static final class ProcessStatus {
        /**
         * 1 待处理
         */
        public static final Integer TO_PROCESS = 1;
        /**
         * 2 处理中
         */
        public static final Integer PROCESSING = 2;
        /**
         * 3 处理成功
         */
        public static final Integer PROCESS_SUCCESS = 3;
        /**
         * 4 处理失败
         */
        public static final Integer PROCESS_FAIL = 4;
    }

    /**
     * 协议变更消息类型
     */
    public static class agrChngMsgType{
        /**
         * 冻结
         */
        public static final Integer FROZEN = 1;
        /**
         * 解冻
         */
        public static final Integer UN_FROZEN = 2;

    }

    /**
     * 协议变更消息状态
     */
    public static final class agrChngMsgStatus{
        /**
         * 1-有效
         */
        public static final Integer EFFECTIVE = 1;

        /**
         * 0-无效
         */
        public static final Integer NO_EFFECTIVE= 0;
        /**
         * 2-处理中
         */
        public static final Integer EFFECTIVEING= 2;
    }
    /**
     * 协议状态转义  0：草稿 1：驳回 2：审核中 3：暂停 4：启用 5：冻结 6：过期 7：终止 8：待确认 9：合同失效 10:待生效  11:未接受
     */
    public enum AgreementStatusEnum {
        DRAFT(0,"草稿"),
        REJECT(1,"驳回"),
        IN_AUDIT(2,"审核中"),
        SUSPEND(3,"暂停"),
        ENABLE(4,"启用"),
        FROZEN(5,"冻结"),
        BE_OVERDUE(6,"过期"),
        TERMINATION(7,"终止"),
        TO_CONFIRM(8,"待确认"),
        INVALID_CONTRACT(9,"合同失效"),
        WAIT_ENABLE(10,"待生效"),
        NO_CONFIRM(11,"未接受");


        private String name;
        private Integer value;

        public String getName() {
            return name;
        }
        public Integer getValue() {
            return value;
        }

        AgreementStatusEnum(Integer value, String name) {
            this.name = name;
            this.value = value;
        }
        public static String getNameByValue(Integer value){
            for(AgreementStatusEnum agreementStatusEnum: AgreementStatusEnum.values()){
                if(value.equals(agreementStatusEnum.getValue())){
                    return agreementStatusEnum.getName();
                }
            }
            return  null;
        }
        public static Integer getCodeByName(String name){
            for(AgreementStatusEnum agreementStatusEnum: AgreementStatusEnum.values()){
                if(name.equals(agreementStatusEnum.getName())){
                    return agreementStatusEnum.getValue();
                }
            }
            return  null;
        }
    }

    /**
     * 货物采购类合同
     */
    public static final String CONTRACT_TYPE_HC="HC";
    /**
     *服务采购类合同
     */
    public static final String CONTRACT_TYPE_FC="FC";
    /**
     * 建设工程类合同
     */
    public static final String CONTRACT_TYPE_JG="JG";

    /**
     * 污泥
     */
    public static final String CONTRACT_TYPE_FC_WN="WN";
    public static final String CONTRACT_TYPE_FC_WN_CATEGORY="FC10";
    public static final String CONTRACT_TYPE_FC_WN_CATEGORY_CODE="1";

    /**
     * 电费
     */
    public static final String CONTRACT_TYPE_FC_DF="DF";
    public static final String CONTRACT_TYPE_FC_DF_CATEGORY="FC04";
    public static final String CONTRACT_TYPE_FC_DF_CONTRACT_CODE="1";


    /**
     * 租赁
     */
    public static final String CONTRACT_TYPE_FC_ZN_CATEGORY="FC12";

    /**
     * kunpeng推送标签
     */
    public static final Integer kunPengPushTagAdd  =1;
    public static final Integer kunPengPushTagChange  =2;
    public static final Integer kunPengPushTagState  =3;

}
