package com.tydic.dyc.agr.extService;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.dyc.agr.service.agr.AgrAddChangeAgrSyncFromPriceStockService;
import com.tydic.dyc.agr.service.agr.bo.AgrAddChangeAgrSyncFromPriceStockReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrAddChangeAgrSyncFromPriceStockRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.Resource;

/**
 * @author zhanghengrui
 * @date 2023/3/20 19:49
 */
@HTServiceImpl
@Slf4j
public class AgrAddChangeAgrSyncFromPriceStockServiceExtImpl implements AgrAddChangeAgrSyncFromPriceStockServiceExt{

    @Autowired
    private AgrAddChangeAgrSyncFromPriceStockService agrAddChangeAgrSyncFromPriceStockService;
    @Resource(name = "agrCornJobSyncProvider")
    private ProxyMessageProducer proxyMessageProducer;

    @Override
    public AgrAddChangeAgrSyncFromPriceStockRspBO addChangeAgrSyncFromPriceStock(AgrAddChangeAgrSyncFromPriceStockReqBO agrAddChangeAgrSyncFromPriceStockReqBO) {
        AgrAddChangeAgrSyncFromPriceStockRspBO rspBO = agrAddChangeAgrSyncFromPriceStockService.addChangeAgrSyncFromPriceStock(agrAddChangeAgrSyncFromPriceStockReqBO);

        if (null!=rspBO.getIsMq()&& rspBO.getIsMq()){
            log.info("商品推送价格库-发送mq:" + JSON.toJSONString(rspBO.getAgrChangeCronJobReqBO()));
            ProxySendResult send = proxyMessageProducer.send(new ProxyMessage("AGR_CORN_JOB_TOPIC", "AGR", JSON.toJSONString(rspBO.getAgrChangeCronJobReqBO())));
            log.info("商品推送价格库-mq发送完成:" + JSON.toJSONString(send));
        }

        return rspBO;

    }
}
