package com.tydic.dyc.agr.model.materiaPrice.impl;

import com.tydic.dyc.agr.model.materiaPrice.AgrMateriaPriceModel;
import com.tydic.dyc.agr.repository.AgrMateriaPriceRepository;
import com.tydic.dyc.agr.service.agr.bo.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author yinletian
 * @date 2023/1/30
 */
@Service
public class AgrMateriaPriceModelImpl implements AgrMateriaPriceModel {

    @Autowired
    private AgrMateriaPriceRepository agrMateriaPriceRepository;

    /**
     * 分页查询协议物料价格明细
     * @param agrAddChangeAgrSyncFromPriceStockReqBO
     * @return
     */
    @Override
    public AgrQryAgrMateriaPriceItemListServiceRspBO qryMateriaPriceItem(AgrQryAgrMateriaPriceItemListServiceReqBO agrAddChangeAgrSyncFromPriceStockReqBO) {
        return agrMateriaPriceRepository.qryMateriaPriceItem(agrAddChangeAgrSyncFromPriceStockReqBO);
    }

    /**
     * 查询协议物料价格明细历史
     * @param agrAddChangeAgrSyncFromPriceStockReqBO
     * @return
     */
    @Override
    public AgrQryAgrMateriaPriceItemListServiceRspBO qryMateriaPriceItemHis(AgrQryAgrMateriaPriceItemListServiceReqBO agrAddChangeAgrSyncFromPriceStockReqBO) {
        return agrMateriaPriceRepository.qryMateriaPriceItemHis(agrAddChangeAgrSyncFromPriceStockReqBO);
    }

    @Override
    public List<AgrMateriaPriceItemBO> qrySelfSalePrice(List<AgrMateriaPriceItemBO> list) {
        return agrMateriaPriceRepository.qrySelfSalePrice(list);
    }

    @Override
    public List<AgrMateriaPriceItemBO> qrySelfSalePriceHis(List<AgrMateriaPriceItemBO> list) {
        return agrMateriaPriceRepository.qrySelfSalePriceHis(list);
    }

    @Override
    public List<AgrMateriaPriceItemBO> qryMateriaPriceItem(Long agrId) {
        return agrMateriaPriceRepository.qryMateriaPriceItem(agrId);
    }

    @Override
    public List<AgrMateriaPriceItemBO> qryMateriaItemKey(AgrQryAgrMateriaPriceItemListServiceReqBO serviceReqBO) {
        return agrMateriaPriceRepository.qryMateriaItemKey(serviceReqBO);
    }

    @Override
    public List<AgrMateriaPriceItemBO> deleteSalePrice(Long agrId) {
        return agrMateriaPriceRepository.deleteSalePrice(agrId);
    }

    @Override
    public List<AgrMateriaPriceItemBO> checkMaterialInfo(AgrCheckItemIfHaveStepPriceServiceReqBO reqBO) {
        return agrMateriaPriceRepository.checkMaterialInfo(reqBO);
    }

    @Override
    public AgrMateriaPriceItemBO qryMaterialItemSupplyCycle(AgrQryMateriaItemSupplyCycleServiceReqBO reqBO) {
        return agrMateriaPriceRepository.qryMaterialItemSupplyCycle(reqBO);
    }

    @Override
    public List<AgrQryMaterialCycleBO> batchQryAgrItemSupplyCycle(AgrQryMateriaItemSupplyCycleServiceReqBO reqBO) {
        return agrMateriaPriceRepository.batchQryAgrItemSupplyCycle(reqBO);
    }
}
