package com.tydic.dyc.agr.repository;

import com.tydic.dyc.agr.service.agr.bo.*;

import java.util.List;

/**
 * @author yinletian
 * @date 2023/1/30
 */
public interface AgrMateriaPriceRepository {
    /**
     * 分页查询协议物料价格明细
     * @param agrAddChangeAgrSyncFromPriceStockReqBO
     * @return
     */
    AgrQryAgrMateriaPriceItemListServiceRspBO qryMateriaPriceItem(AgrQryAgrMateriaPriceItemListServiceReqBO agrAddChangeAgrSyncFromPriceStockReqBO);

    /**
     * 查询协议物料价格明细历史
     * @param agrAddChangeAgrSyncFromPriceStockReqBO
     * @return
     */
    AgrQryAgrMateriaPriceItemListServiceRspBO qryMateriaPriceItemHis(AgrQryAgrMateriaPriceItemListServiceReqBO agrAddChangeAgrSyncFromPriceStockReqBO);
    /**
     * 查询自营销售价
     */
    List<AgrMateriaPriceItemBO> qrySelfSalePrice(List<AgrMateriaPriceItemBO> list);

    /**
     * 查询历史自营销售价
     */
    List<AgrMateriaPriceItemBO> qrySelfSalePriceHis(List<AgrMateriaPriceItemBO> list);
    /**
     * 根据协议id查询协议物料明细
     */
    List<AgrMateriaPriceItemBO> qryMateriaPriceItem(Long agrId);

    List<AgrMateriaPriceItemBO> qryMateriaItemKey(AgrQryAgrMateriaPriceItemListServiceReqBO serviceReqBO);

    List<AgrMateriaPriceItemBO> deleteSalePrice(Long agrId);
    /**
     * 校验自营的物料明细
     */
    List<AgrMateriaPriceItemBO> checkMaterialInfo(AgrCheckItemIfHaveStepPriceServiceReqBO reqBO);
    /**
     * 单个查询物料货期
     */
    AgrMateriaPriceItemBO qryMaterialItemSupplyCycle(AgrQryMateriaItemSupplyCycleServiceReqBO reqBO);
    /**
     * 批量查询物料货期
     */
    List<AgrQryMaterialCycleBO> batchQryAgrItemSupplyCycle(AgrQryMateriaItemSupplyCycleServiceReqBO reqBO);
}

