package com.tydic.dyc.agr.service;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.model.agr.AgrModel;
import com.tydic.dyc.agr.model.agr.BkAgrMainDo;
import com.tydic.dyc.agr.model.change.AgrChangeModel;
import com.tydic.dyc.agr.model.change.AgrTransDataDo;
import com.tydic.dyc.agr.model.change.BkAgrBigChangeItemDataWhileDo;
import com.tydic.dyc.agr.model.log.AgrLogModel;
import com.tydic.dyc.agr.model.log.BkAgrBigDataLogDo;
import com.tydic.dyc.agr.model.log.BkAgrChangeBigDataLogDo;
import com.tydic.dyc.agr.service.agr.AgrAddChangeAgrSyncService;
import com.tydic.dyc.agr.service.agr.bo.AgrAddChangeAgrSyncReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrAddChangeAgrSyncRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrMateriaPriceItemBO;
import com.tydic.dyc.agr.utils.IdUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * AGRSBK0007-合同协议变更同步领域服务
 * @author zhanghengrui
 * @date 2023/1/31 11:00
 */
@Service
@Slf4j
public class AgrAddChangeAgrSyncServiceImpl implements AgrAddChangeAgrSyncService {

    @Autowired
    private AgrModel agrModel;
    @Autowired
    private AgrLogModel agrLogModel;
    @Autowired
    private AgrChangeModel agrChangeModel;

    @Override
    public AgrAddChangeAgrSyncRspBO addChangeAgrSync(AgrAddChangeAgrSyncReqBO agrAddChangeAgrSyncReqBO) {

        AgrAddChangeAgrSyncRspBO rspBO = new AgrAddChangeAgrSyncRspBO();

        // 校验是否同步完成
        Integer syncNum = 0;
        syncNum = agrLogModel.checkSyncStatus(agrAddChangeAgrSyncReqBO.getAgrCode(), agrAddChangeAgrSyncReqBO.getBatchUniqueId());

        if (syncNum.equals(agrAddChangeAgrSyncReqBO.getTotalBatchCount())) throw new ZTBusinessException("同步完成");

        BkAgrMainDo qryAgrMainDo = new BkAgrMainDo();
        qryAgrMainDo.setAgrId(agrAddChangeAgrSyncReqBO.getAgrId());
        qryAgrMainDo.setAgrCode(agrAddChangeAgrSyncReqBO.getAgrCode());
        BkAgrMainDo bkAgrMainDo = agrModel.qryMain(qryAgrMainDo);


        // 如果是1，3会有多个批次
        if (agrAddChangeAgrSyncReqBO.getSyncType()==1||agrAddChangeAgrSyncReqBO.getSyncType()==3) {

            // 保存主表的信息
            if (agrAddChangeAgrSyncReqBO.getAgrAgrMainBO()!=null) {

                AgrTransDataDo agrTransDataDo = new AgrTransDataDo();
                agrTransDataDo.setAgrId(bkAgrMainDo.getAgrId());
                agrTransDataDo.setAgrCode(bkAgrMainDo.getAgrCode());
                agrTransDataDo.setContractCode(bkAgrMainDo.getContractCode());
                if(agrAddChangeAgrSyncReqBO.getAgrPayConfigBO()!=null && agrAddChangeAgrSyncReqBO.getAgrAgrMainBO()!=null)agrAddChangeAgrSyncReqBO.getAgrPayConfigBO().setPaymentDays(agrAddChangeAgrSyncReqBO.getAgrAgrMainBO().getPaymentDays());
                agrTransDataDo.setAgrPayConfigBO(agrAddChangeAgrSyncReqBO.getAgrPayConfigBO());
                agrTransDataDo.setAgrMainBO(agrAddChangeAgrSyncReqBO.getAgrAgrMainBO());
                agrTransDataDo.setAgrAppScopeBO(agrAddChangeAgrSyncReqBO.getAgrAppScopeBO());
                agrTransDataDo.setBatchUniqueId(agrAddChangeAgrSyncReqBO.getBatchUniqueId());
                agrChangeModel.saveDate2Main(agrTransDataDo);
            }

            // 保存明细到更临时表
            List<AgrMateriaPriceItemBO> agrMateriaPriceItemBOs = agrAddChangeAgrSyncReqBO.getAgrMateriaPriceItemBOs();
            if (!CollectionUtils.isEmpty(agrMateriaPriceItemBOs)&&agrMateriaPriceItemBOs.size()>0){
                List<BkAgrBigChangeItemDataWhileDo> agrBigChangeItemDataWhileDo = JSON.parseArray(JSON.toJSONString(agrMateriaPriceItemBOs),BkAgrBigChangeItemDataWhileDo.class);
                agrBigChangeItemDataWhileDo.forEach(po-> {
                    po.setAgrCode(bkAgrMainDo.getAgrCode());
                    po.setContractCode(bkAgrMainDo.getAgrCode());
                    po.setAgrId(bkAgrMainDo.getAgrId());
                    po.setBatchUniqueId(agrAddChangeAgrSyncReqBO.getBatchUniqueId());
                });
                agrChangeModel.saveData2Material(agrBigChangeItemDataWhileDo);
            }

            // 日志表增加数据,表示该同步完成
            BkAgrBigDataLogDo bkAgrBigDataLogDo = new BkAgrBigDataLogDo();
            bkAgrBigDataLogDo.setAgrBigDataLogId(IdUtil.nextId());
            bkAgrBigDataLogDo.setBatchUniqueId(agrAddChangeAgrSyncReqBO.getBatchUniqueId());
            bkAgrBigDataLogDo.setTotalBatchCount(agrAddChangeAgrSyncReqBO.getTotalBatchCount());
            bkAgrBigDataLogDo.setNowBatchCount(agrAddChangeAgrSyncReqBO.getNowBatchCount());
            bkAgrBigDataLogDo.setAgrId(bkAgrMainDo.getAgrId().toString());
            bkAgrBigDataLogDo.setAgrCode(bkAgrMainDo.getAgrCode());
            bkAgrBigDataLogDo.setContractCode(bkAgrBigDataLogDo.getContractCode());
            // 处理完成
            bkAgrBigDataLogDo.setDealStatus("2");
            bkAgrBigDataLogDo.setBatchOperType(2);
            bkAgrBigDataLogDo.setIsSysnEs(1);
            // 是否添加了主体
            bkAgrBigDataLogDo.setIsCopyMain(agrAddChangeAgrSyncReqBO.getSyncType()==1?0:1);
            bkAgrBigDataLogDo.setCreateName(new Date().toString());
            agrLogModel.addLog(bkAgrBigDataLogDo);

        }
        // 如果是2只会有一个批次
        else if (agrAddChangeAgrSyncReqBO.getSyncType()==2){
            // 保存主表的信息

            AgrTransDataDo agrTransDataDo = new AgrTransDataDo();
            agrTransDataDo.setAgrId(bkAgrMainDo.getAgrId());
            agrTransDataDo.setAgrCode(bkAgrMainDo.getAgrCode());
            agrTransDataDo.setContractCode(bkAgrMainDo.getContractCode());
            if(agrAddChangeAgrSyncReqBO.getAgrPayConfigBO()!=null && agrAddChangeAgrSyncReqBO.getAgrAgrMainBO()!=null)agrAddChangeAgrSyncReqBO.getAgrPayConfigBO().setPaymentDays(agrAddChangeAgrSyncReqBO.getAgrAgrMainBO().getPaymentDays());
            agrTransDataDo.setAgrPayConfigBO(agrAddChangeAgrSyncReqBO.getAgrPayConfigBO());
            agrTransDataDo.setAgrMainBO(agrAddChangeAgrSyncReqBO.getAgrAgrMainBO());
            agrTransDataDo.setAgrAppScopeBO(agrAddChangeAgrSyncReqBO.getAgrAppScopeBO());
            agrTransDataDo.setBatchUniqueId(agrAddChangeAgrSyncReqBO.getBatchUniqueId());
            agrChangeModel.saveDate2Main(agrTransDataDo);

            // 日志表增加数据,表示该同步完成
            BkAgrBigDataLogDo bkAgrBigDataLogDo = new BkAgrBigDataLogDo();
            bkAgrBigDataLogDo.setAgrBigDataLogId(IdUtil.nextId());
            bkAgrBigDataLogDo.setBatchUniqueId(agrAddChangeAgrSyncReqBO.getBatchUniqueId());
            bkAgrBigDataLogDo.setTotalBatchCount(agrAddChangeAgrSyncReqBO.getTotalBatchCount());
            bkAgrBigDataLogDo.setNowBatchCount(agrAddChangeAgrSyncReqBO.getNowBatchCount());
            bkAgrBigDataLogDo.setAgrId(bkAgrMainDo.getAgrId().toString());
            bkAgrBigDataLogDo.setAgrCode(bkAgrMainDo.getAgrCode());
            bkAgrBigDataLogDo.setContractCode(bkAgrBigDataLogDo.getContractCode());
            // 处理完成
            bkAgrBigDataLogDo.setDealStatus("2");
            bkAgrBigDataLogDo.setBatchOperType(2);
            bkAgrBigDataLogDo.setIsSysnEs(1);
            // 是否添加了主体
            bkAgrBigDataLogDo.setIsCopyMain(1);
            bkAgrBigDataLogDo.setCreateName(new Date().toString());
            agrLogModel.addLog(bkAgrBigDataLogDo);

            // 增加更改日志表
            BkAgrChangeBigDataLogDo bkAgrChangeBigDataLogDo = new BkAgrChangeBigDataLogDo();
            bkAgrChangeBigDataLogDo.setAgrChangeBigDataLogId(IdUtil.nextId());
            bkAgrChangeBigDataLogDo.setAgrId(bkAgrMainDo.getAgrId());
            // 待处理
//            bkAgrChangeBigDataLogDo.setDealStatus("1");
//            bkAgrChangeBigDataLogDo.setBatchUniqueId(agrAddChangeAgrSyncReqBO.getBatchUniqueId());
//            bkAgrChangeBigDataLogDo.setBatchOperType(new Byte("1"));
//            bkAgrChangeBigDataLogDo.setAgrCode(bkAgrMainDo.getAgrCode());
//            bkAgrChangeBigDataLogDo.setContractCode(bkAgrMainDo.getContractCode());
//            bkAgrChangeBigDataLogDo.setCreateName(new Date().toString());
//            agrLogModel.addChangeLog(bkAgrChangeBigDataLogDo);


        }

        // 如果批次推送完成，那么写变更表，提供给定时任务同步
        if (syncNum+1==agrAddChangeAgrSyncReqBO.getTotalBatchCount()){
            BkAgrChangeBigDataLogDo bkAgrChangeBigDataLogDo = new BkAgrChangeBigDataLogDo();
            bkAgrChangeBigDataLogDo.setAgrChangeBigDataLogId(IdUtil.nextId());
            bkAgrChangeBigDataLogDo.setAgrId(bkAgrMainDo.getAgrId());
            // 待处理
            bkAgrChangeBigDataLogDo.setDealStatus("1");
            bkAgrChangeBigDataLogDo.setBatchUniqueId(agrAddChangeAgrSyncReqBO.getBatchUniqueId());
            // 批处理类型：\r\n1.合同新增\r\n2.合同变更\r\n3.价格库采购价变更\r\n4.价格库销售价变更
            bkAgrChangeBigDataLogDo.setBatchOperType(new Byte("2"));
            bkAgrChangeBigDataLogDo.setAgrCode(bkAgrMainDo.getAgrCode());
            bkAgrChangeBigDataLogDo.setContractCode(bkAgrMainDo.getContractCode());
            bkAgrChangeBigDataLogDo.setCreateName(new Date().toString());
            agrLogModel.addChangeLog(bkAgrChangeBigDataLogDo);

            rspBO.setIsMq(true);
            rspBO.getAgrChangeCronJobReqBO().setAgrId(bkAgrChangeBigDataLogDo.getAgrId());
            rspBO.getAgrChangeCronJobReqBO().setAgrChangeLogId(bkAgrChangeBigDataLogDo.getAgrChangeBigDataLogId());

        }

        // 同步es:通过直接修改es状态
        // 更新协议状态
//        BkAgrMainDo updateAgrMainDo = new BkAgrMainDo();
//        BeanUtils.copyProperties(bkAgrMainDo,updateAgrMainDo);
//        updateAgrMainDo.setAgrStatus("changing");
//        agrModel.updateMain(updateAgrMainDo);

        rspBO.setAgrId(bkAgrMainDo.getAgrId());

        log.info("出参:"+JSON.toJSONString(rspBO));

        return rspBO;
    }
}
