package com.tydic.dyc.agr.service;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.model.agr.AgrModel;
import com.tydic.dyc.agr.model.agr.BkAgrMainDo;
import com.tydic.dyc.agr.model.procinst.AgrProcInstDo;
import com.tydic.dyc.agr.model.procinst.IAgrProcInstModel;
import com.tydic.dyc.agr.model.version.AgrVersionModel;
import com.tydic.dyc.agr.model.version.BkAgrProcInstDo;
import com.tydic.dyc.agr.model.version.BkAgrProcInstModel;
import com.tydic.dyc.agr.service.agr.AgrCancelAgrSyncService;
import com.tydic.dyc.agr.service.agr.bo.AgrCancelAgrSyncReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrCancelAgrSyncRspBO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.constants.AgrConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author yinletian
 * @date 2023/1/31
 */
@HTServiceImpl
public class AgrCancelAgrSyncServiceImpl implements AgrCancelAgrSyncService {
    @Autowired
    private AgrModel agrModel;
    @Autowired
    private AgrVersionModel agrVersionModel;
    @Autowired
    private BkAgrProcInstModel bkAgrProcInstModel;

    @Override
    public AgrCancelAgrSyncRspBO cancelAgrSync(AgrCancelAgrSyncReqBO reqBO) {
        AgrCancelAgrSyncRspBO rspBO = new AgrCancelAgrSyncRspBO();

        //查询数据
        BkAgrMainDo qryMainBo = new BkAgrMainDo();
        qryMainBo.setAgrCode(reqBO.getAgrCode());
        BkAgrMainDo bkAgrMainDo1 = agrModel.qryMain(qryMainBo);
        if (bkAgrMainDo1 == null){
            throw new ZTBusinessException("商城未查询到当前协议[" + reqBO.getAgrCode() + "]信息");
        }

        //更新协议状态为已失效，
        BkAgrMainDo bkAgrMainDo = new BkAgrMainDo();
        bkAgrMainDo.setAgrCode(reqBO.getAgrCode());
        bkAgrMainDo.setAgrStatus(AgrConstant.APPROVE_STATUS.EXPIRED);
        agrModel.updateBy(bkAgrMainDo);

        agrVersionModel.updateStatus(bkAgrMainDo1.getAgrId());

        //查询该供应商协议编号下
        BkAgrMainDo mainDo = new BkAgrMainDo();
        mainDo.setAgrCode(reqBO.getAgrCode());
        mainDo.setAgrSupOrgId(bkAgrMainDo1.getAgrSupOrgId());
        List<BkAgrMainDo> bkAgrMainDos = agrModel.qryEffectAgr(mainDo);
        //是否全部失效
        if(!CollectionUtils.isEmpty(bkAgrMainDos)){
            rspBO.setAgrFlag(bkAgrMainDos.stream().allMatch(obj -> "EXPIRED".equals(obj.getAgrStatus())));
        }

        //查询流程审批实例id
        BkAgrProcInstDo agrProcInstDo = new BkAgrProcInstDo();
        agrProcInstDo.setOrderId(bkAgrMainDo1.getAgrId());
        agrProcInstDo.setObjType(9);
        agrProcInstDo = bkAgrProcInstModel.getProcInst(agrProcInstDo);
        if (agrProcInstDo != null){
            rspBO.setProcInstId(agrProcInstDo.getProcInstId());
        }
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        rspBO.setAgrSupOrgId(bkAgrMainDo1.getAgrSupOrgId());
        rspBO.setExpDate(bkAgrMainDo1.getExpDate());
        rspBO.setArgId(bkAgrMainDo1.getAgrId());
        rspBO.setOrderId(bkAgrMainDo1.getAgrId());
        return rspBO;
    }
}
