package com.tydic.dyc.agr.service;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.model.materiaPrice.AgrMateriaPriceModel;
import com.tydic.dyc.agr.service.agr.AgrCheckItemIfHaveStepPriceService;
import com.tydic.dyc.agr.service.agr.bo.AgrCheckItemIfHaveStepPriceServiceReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrCheckItemIfHaveStepPriceServiceRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrMateriaPriceItemBO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @desc：
 * @author： liujian
 * @date： 2023/6/15 11:16
 **/
@HTServiceImpl
public class AgrCheckItemIfHaveStepPriceServiceImpl implements AgrCheckItemIfHaveStepPriceService {

    @Autowired
    private AgrMateriaPriceModel agrMateriaPriceModel;

    @Override
    public AgrCheckItemIfHaveStepPriceServiceRspBO checkMaterialInfo(AgrCheckItemIfHaveStepPriceServiceReqBO reqBO) {
        AgrCheckItemIfHaveStepPriceServiceRspBO rspBO = new AgrCheckItemIfHaveStepPriceServiceRspBO();
        if (CollectionUtils.isEmpty(reqBO.getAgrIdList())){
            throw new ZTBusinessException("校验物料明细入参协议ID集合为空");
        }
        if (CollectionUtils.isEmpty(reqBO.getMaterialCodeList())){
            throw new ZTBusinessException("校验物料明细入参物料编码集合为空");
        }

        List<AgrMateriaPriceItemBO> itemList = agrMateriaPriceModel.checkMaterialInfo(reqBO);
        if (!CollectionUtils.isEmpty(itemList)){
            List<String> materialCodeList = itemList.stream().map(AgrMateriaPriceItemBO::getMaterialCode).distinct().collect(Collectors.toList());
            rspBO.setMaterialCodeList(materialCodeList);
        }
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
}