package com.tydic.dyc.agr.service;

import com.tydic.dyc.agr.model.agr.AgrModel;
import com.tydic.dyc.agr.model.agr.BkAgrMainDo;
import com.tydic.dyc.agr.service.agr.AgrComeIntoEffectCronJobService;
import com.tydic.dyc.agr.service.agr.bo.AgrComeIntoEffectCronJobReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrComeIntoEffectCronJobRspBO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 定时任务
 * @author zhanghengrui
 * @date 2023/1/31 16:49
 */
@HTServiceImpl
public class AgrComeIntoEffectCronJobServiceImpl implements AgrComeIntoEffectCronJobService {

    @Autowired
    private AgrModel agrModel;


    @Override
    public AgrComeIntoEffectCronJobRspBO comeIntoEffect(AgrComeIntoEffectCronJobReqBO agrComeIntoEffectCronJobReqBO) {

        // 1.查询符合条件的协议数据
        BkAgrMainDo qryAgrMainDo = new BkAgrMainDo();
        List<BkAgrMainDo> bkAgrMainDos = agrModel.qryEffectAgr(qryAgrMainDo);

        // 2.修改状态
        List<BkAgrMainDo> retAgrMainList = new ArrayList<>();
        bkAgrMainDos.forEach(bkAgrMainDo -> {
            BkAgrMainDo updateAgrMainDo = new BkAgrMainDo();
            BeanUtils.copyProperties(bkAgrMainDo,updateAgrMainDo);
            Integer retUpdate = agrModel.updateMain(updateAgrMainDo);
            if (retUpdate.intValue() == 1){
                retAgrMainList.add(bkAgrMainDo);
            }
        });

        List<Long> agrIdList = retAgrMainList.stream().map(BkAgrMainDo::getAgrId).collect(Collectors.toList());

        // 3.同步
        AgrComeIntoEffectCronJobRspBO jobRspBO = new AgrComeIntoEffectCronJobRspBO();
        jobRspBO.setAgrCodes(retAgrMainList.stream().map(obj->obj.getAgrCode()).collect(Collectors.toList()));
        jobRspBO.setAgrIdList(agrIdList);
        jobRspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        jobRspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return jobRspBO;
    }
}
