package com.tydic.dyc.agr.service;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.model.agr.AgrModel;
import com.tydic.dyc.agr.model.agr.BkAgrMainDo;
import com.tydic.dyc.agr.model.materiaPrice.AgrMateriaPriceModel;
import com.tydic.dyc.agr.service.agr.AgrDealAgrSupAvailableSysnService;
import com.tydic.dyc.agr.service.agr.bo.*;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author yinletian
 * @date 2023/4/18
 */
@HTServiceImpl
@Slf4j
public class AgrDealAgrSupAvailableSysnServiceImpl implements AgrDealAgrSupAvailableSysnService {

    @Autowired
    private AgrModel agrModel;
    @Autowired
    private AgrMateriaPriceModel agrMateriaPriceModel;

    @Override
    public AgrDealAgrSupAvailableSysnRspBO dealAgrSupAvailableSysn(AgrDealAgrSupAvailableSysnReqBO reqBO) {
        if(reqBO.getAgrSupOrgId()==null) throw new ZTBusinessException("供应商id不能为空");
        if(reqBO.getSysnType()==null) throw new ZTBusinessException("同步类型不能为空");
        BkAgrMainDo mainDo = new BkAgrMainDo();
        mainDo.setAgrSupOrgId(reqBO.getAgrSupOrgId());
        mainDo.setAgrSupAvailableStatus(reqBO.getSysnType());
        agrModel.updateBy(mainDo);

        AgrDealAgrSupAvailableSysnRspBO rspBO = new AgrDealAgrSupAvailableSysnRspBO();
        List<BkAgrMainDo> bkAgrMainDos = agrModel.qryEffectAgr(mainDo);
        if(CollectionUtil.isNotEmpty(bkAgrMainDos)){
            AgrQryAgrMateriaPriceItemListServiceReqBO listServiceReqBO = new AgrQryAgrMateriaPriceItemListServiceReqBO();
            listServiceReqBO.setAgrIdList(bkAgrMainDos.stream().map(obj->obj.getAgrId()).collect(Collectors.toList()));
            listServiceReqBO.setPageSize(-1);
            listServiceReqBO.setPageNo(-1);
            AgrQryAgrMateriaPriceItemListServiceRspBO listServiceRspBO = agrMateriaPriceModel.qryMateriaPriceItem(listServiceReqBO);
            List<AgrMateriaPriceItemBO> traceList = JSON.parseArray(JSON.toJSONString(listServiceRspBO.getRows()), AgrMateriaPriceItemBO.class);
            reqBO.setTraceList(traceList);
        }

        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
}
