package com.tydic.dyc.agr.service;

import com.alibaba.fastjson.JSON;
import com.google.gson.annotations.JsonAdapter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.model.agr.AgrModel;
import com.tydic.dyc.agr.model.agr.BkAgrMainDo;
import com.tydic.dyc.agr.model.his.AgrHisModel;
import com.tydic.dyc.agr.model.materiaPrice.AgrMateriaPriceModel;
import com.tydic.dyc.agr.repository.AgrHisRepository;
import com.tydic.dyc.agr.service.agr.AgrQryAgrMateriaPriceItemListService;
import com.tydic.dyc.agr.service.agr.bo.*;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.constants.AgrConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author yinletian
 * @date 2023/1/30
 */
@Slf4j
@HTServiceImpl
public class AgrQryAgrMateriaPriceItemListServiceImpl implements AgrQryAgrMateriaPriceItemListService {

    @Autowired
    private AgrMateriaPriceModel agrMateriaPriceModel;
    @Autowired
    private AgrModel agrModel;
    @Autowired
    private AgrHisModel agrHisModel;

    @Override
    public AgrQryAgrMateriaPriceItemListServiceRspBO qryAgrMateriaPriceItemList(AgrQryAgrMateriaPriceItemListServiceReqBO reqBO) {
        BkAgrMainDo agrMainBO;
        //查询协议是否为自营
        if(reqBO.getAgrMainHisId()!=null){
            agrMainBO = agrHisModel.qryMainHis(reqBO.getAgrMainHisId());
        }else {
            BkAgrMainDo agrMainDo = new BkAgrMainDo();
            agrMainDo.setAgrId(reqBO.getAgrId());
            agrMainDo.setAgrCode(reqBO.getAgrCode());
            agrMainBO = agrModel.qryMain(agrMainDo);
        }

        AgrQryAgrMateriaPriceItemListServiceRspBO rspBO = new AgrQryAgrMateriaPriceItemListServiceRspBO();
        reqBO.setPriceUseType(2);
        //接口平台调用
        if(StringUtils.isEmpty(reqBO.getAgrId()) && !CollectionUtils.isEmpty(reqBO.getItemMatchCodeList())){
            AgrQryAgrMateriaPriceItemListServiceReqBO serviceReqBO = new AgrQryAgrMateriaPriceItemListServiceReqBO();
            serviceReqBO.setAgrId(agrMainBO.getAgrId());
            serviceReqBO.setItemMatchCodeList(reqBO.getItemMatchCodeList());
            serviceReqBO.setPriceUseType(2);
            List<AgrMateriaPriceItemBO> agrMateriaPriceItemBOS = agrMateriaPriceModel.qryMateriaItemKey(serviceReqBO);
            rspBO.setRows(agrMateriaPriceItemBOS);
        }else{
            if(reqBO.getPriceType() == null) throw new ZTBusinessException("价格类型不能为空");
            //详情查询
            if(StringUtils.isEmpty(reqBO.getAgrMainHisId())){
                rspBO = agrMateriaPriceModel.qryMateriaPriceItem(reqBO);
            }else{
                rspBO = agrMateriaPriceModel.qryMateriaPriceItemHis(reqBO);
            }
            //自营补全销售价
            if (agrMainBO.getIsAutarky() != null) {
                if (AgrConstant.IsAutarky.YES.compareTo(agrMainBO.getIsAutarky()) == 0) {
                    rspBO.setRows(converParam(rspBO, reqBO));
                } else {
                    //自营销售价=采购价
                    //rspBO.getRows().forEach(obj->{
                    //    obj.setSalePrice(obj.getPrice());
                    //    obj.setSaleUnTaxPrice(obj.getUnTaxPrice());
                    //});
                }
            }
        }

        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public AgrQryMateriaItemSupplyCycleServiceRspBO qryAgrMaterialItemSupplyCycle(AgrQryMateriaItemSupplyCycleServiceReqBO reqBO) {
        AgrMateriaPriceItemBO agrMateriaPriceItemBO = agrMateriaPriceModel.qryMaterialItemSupplyCycle(reqBO);
        AgrQryMateriaItemSupplyCycleServiceRspBO rspBO = new AgrQryMateriaItemSupplyCycleServiceRspBO();
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        if (agrMateriaPriceItemBO != null) {
            rspBO.setSupplyCycle(agrMateriaPriceItemBO.getSupplyCycle());
        }
        return rspBO;
    }

    @Override
    public AgrQryMateriaItemSupplyCycleServiceRspBO batchQryAgrItemSupplyCycle(AgrQryMateriaItemSupplyCycleServiceReqBO reqBO) {
        List<AgrQryMaterialCycleBO> agrMateriaPriceItemBOs = agrMateriaPriceModel.batchQryAgrItemSupplyCycle(reqBO);
        AgrQryMateriaItemSupplyCycleServiceRspBO rspBO = new AgrQryMateriaItemSupplyCycleServiceRspBO();
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        if (!CollectionUtils.isEmpty(agrMateriaPriceItemBOs)) {
            rspBO.setMaterialCycleList(agrMateriaPriceItemBOs);
        }
        return rspBO;
    }

    private  List<AgrMateriaPriceItemBO> converParam(AgrQryAgrMateriaPriceItemListServiceRspBO rspBO, AgrQryAgrMateriaPriceItemListServiceReqBO reqBO){

        List<AgrMateriaPriceItemBO> rows = rspBO.getRows();

        if(!CollectionUtils.isEmpty(rows)){
            rows.forEach(obj->{
                //解决翻页的时候分页参数问题 重新new一个对象放入参
                AgrQryAgrMateriaPriceItemListServiceReqBO reqQryBO = new AgrQryAgrMateriaPriceItemListServiceReqBO();
                BeanUtils.copyProperties(reqBO, reqQryBO);
                reqQryBO.setPageNo(1);
                reqQryBO.setPageSize(10);

                reqQryBO.setMaterialCode(obj.getMaterialCode());
                reqQryBO.setPriceUseType(1);

                //区域价
                if(AgrConstant.PriceType.REGION == reqBO.getPriceType()){
                    reqQryBO.setProvinceCode(obj.getProvinceCode());
                    reqQryBO.setCityCode(obj.getCityCode());
                }
                //专属价
                if(AgrConstant.PriceType.EXCLUSIVE == reqBO.getPriceType()){
                    reqQryBO.setExclusiveOrgId(obj.getExclusiveOrgId());
                }
                AgrQryAgrMateriaPriceItemListServiceRspBO serviceRspBO;
                if(StringUtils.isEmpty(reqBO.getAgrMainHisId())){
                    serviceRspBO = agrMateriaPriceModel.qryMateriaPriceItem(reqQryBO);
                }else{
                    serviceRspBO = agrMateriaPriceModel.qryMateriaPriceItemHis(reqQryBO);
                }
                List<AgrMateriaPriceItemBO> rows1 = serviceRspBO.getRows();
                if(!CollectionUtils.isEmpty(rows1)){
                    obj.setSalePrice(rows1.get(0).getPrice());
                    obj.setSaleUnTaxPrice(rows1.get(0).getUnTaxPrice());
                    obj.setAgrSaleMateriaPriceItemId(rows1.get(0).getAgrMateriaPriceItemId());
                }
            });
            //
        }

        //有销售价就返回true
        AgrQryAgrMateriaPriceItemListServiceReqBO materiaPriceItemListServiceReqBO = new AgrQryAgrMateriaPriceItemListServiceReqBO();
        materiaPriceItemListServiceReqBO.setAgrId(reqBO.getAgrId());
        materiaPriceItemListServiceReqBO.setAgrMainHisId(reqBO.getAgrMainHisId());
        materiaPriceItemListServiceReqBO.setPriceUseType(1);
        AgrQryAgrMateriaPriceItemListServiceRspBO serviceRspBO1;
        if(StringUtils.isEmpty(reqBO.getAgrMainHisId())){
            serviceRspBO1 = agrMateriaPriceModel.qryMateriaPriceItem(materiaPriceItemListServiceReqBO);
        }else{
            serviceRspBO1 = agrMateriaPriceModel.qryMateriaPriceItemHis(materiaPriceItemListServiceReqBO);
        }
        if(!CollectionUtils.isEmpty(serviceRspBO1.getRows())&&serviceRspBO1.getRows().size()>0) rspBO.setSaleFlag(true);
        return rows;
    }
}
