package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.sub.AgrAllocateRecord;
import com.tydic.dyc.agr.service.agr.bo.AgrAgrAllocateReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrAgrAllocateRspBO;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:AgrAgrAllocateServiceImpl
 * 说明:TODO
 * 时间:2022/9/6 13:16
 * 作者:代愿愿
 */
@HTServiceImpl
public class AgrAgrAllocateServiceImpl implements AgrAgrAllocateService {

    @Autowired
    private IAgrAgrModel agrAgrModel;

    @Override
    public AgrAgrAllocateRspBO dealAgrAllocate(AgrAgrAllocateReqBO agrAllocateReqBO) {
        if (ObjectUtil.isEmpty(agrAllocateReqBO.getAgrId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR,"入参对象属性[协议ID]不能为空");
        }
        // 1 查询信息主体信息
        AgrAgrDo agrAgrDo = this.getAgrMain(agrAllocateReqBO.getAgrId());
        // 2 调用协议分配记录保存方法
        this.invokeSaveAgrAllocateRecord(agrAllocateReqBO,agrAgrDo);
        // 3 调用协议主体修改方法
        AgrAgrDo agrAgrDo1 = AgrRu.js(agrAllocateReqBO,AgrAgrDo.class);
        this.agrAgrModel.updateAgrMain(agrAgrDo1);

        return AgrRu.success(AgrAgrAllocateRspBO.class);
    }
    /**
     * 调用协议分配记录保存方法
     */
    private void invokeSaveAgrAllocateRecord(AgrAgrAllocateReqBO agrAllocateReqBO,AgrAgrDo agrAgrDo){
        // 拷贝用户信息
        AgrAgrDo agrAgrAllocateDo = AgrRu.js(agrAllocateReqBO,AgrAgrDo.class);
        List<AgrAllocateRecord> agrAllocateRecords = new ArrayList<>();
        // 拷贝分配人信息
        AgrAllocateRecord agrAllocateRecord = AgrRu.js(agrAllocateReqBO,AgrAllocateRecord.class);
        agrAllocateRecord.setAgrOperatorIdOld(agrAgrDo.getAgrOperatorId());
        agrAllocateRecord.setAgrOperatorNameOld(agrAgrDo.getAgrOperatorName());
        agrAllocateRecord.setAgrOperatorUsernameOld(agrAgrDo.getAgrOperatorUsername());
        agrAllocateRecords.add(agrAllocateRecord);
        agrAgrAllocateDo.setAgrAllocateRecord(agrAllocateRecords);
        this.agrAgrModel.saveAgrAllocateRecord(agrAgrAllocateDo);
    }
    /**
     * 查询协议信息
     */
    private AgrAgrDo getAgrMain(Long agrId){
        AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
        agrAgrQryBo.setAgrId(agrId);
        AgrAgrDo agrAgrDo = this.agrAgrModel.getAgrMain(agrAgrQryBo);
        if(agrAgrDo== null || agrAgrDo.getAgrId()==null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_QUERY_NOT_EXIST_ERROR,"协议信息不不存在"+agrId);
        }
        return agrAgrDo;
    }
}
