package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.sub.AgrAdjustCfg;
import com.tydic.dyc.agr.model.agr.sub.AgrMainExt;
import com.tydic.dyc.agr.model.agr.sub.AgrPayConfig;
import com.tydic.dyc.agr.model.agr.sub.AgrRel;
import com.tydic.dyc.agr.model.auditorder.AgrAuditOrderDo;
import com.tydic.dyc.agr.model.auditorder.IAgrAuditOrderModel;
import com.tydic.dyc.agr.model.auditorder.qrybo.AgrAuditOrderQryBo;
import com.tydic.dyc.agr.model.procinst.AgrProcInstDo;
import com.tydic.dyc.agr.model.procinst.IAgrProcInstModel;
import com.tydic.dyc.agr.service.agr.bo.*;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * 标题:AgrGetAgrDetailServiceImpl
 * 说明:TODO
 * 时间:2022/8/25 13:36
 * 作者:代愿愿
 */
@HTServiceImpl
public class AgrGetAgrDetailServiceImpl implements AgrGetAgrDetailService {

    @Autowired
    private IAgrAgrModel agrAgrModel;

    @Autowired
    private IAgrProcInstModel iAgrProcInstModel;

    @Autowired
    private IAgrAuditOrderModel iAgrAuditOrderModel;

    @Override
    public AgrGetAgrDetailRspBo getAgrDetail(AgrGetAgrDetailReqBo agrGetAgrDetailReqBo) {
        //1 参数检验
        this.validationParam(agrGetAgrDetailReqBo);
        //2 数据转换
        AgrAgrQryBo agrAgrQryBo = AgrRu.js(agrGetAgrDetailReqBo, AgrAgrQryBo.class);
        //3 调用协议详情查询方法
        AgrAgrDo agrDetail = this.agrAgrModel.getAgrDetail(agrAgrQryBo);
        //4 获取封装出参信息
        AgrGetAgrDetailRspBo rspBo = this.setRspBoInfo(agrDetail);
        //5 查询最新的审批流信息
        if(agrDetail!=null){
            rspBo.setProcInstId(qryProInstId(agrDetail.getAgrId()));
        }
        return  rspBo;
    }

    /**
     * 入参检验
     * @param agrGetAgrDetailReqBo agrGetAgrDetailReqBo
     */
    private void validationParam(AgrGetAgrDetailReqBo agrGetAgrDetailReqBo){
        if(agrGetAgrDetailReqBo.getAgrId() == null && StringUtils.isEmpty(agrGetAgrDetailReqBo.getAgrCode()) ){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR,"入参对象属性[agrId]和协议编号[agrCode]不能同时为空！");
        }
    }
    /**
     * 查询流程实例ID
     */
    private String qryProInstId(Long agrId){
        String procInstId = null;
        AgrAuditOrderQryBo agrAuditOrderQryBo = new AgrAuditOrderQryBo();
        agrAuditOrderQryBo.setObjId(agrId);
        agrAuditOrderQryBo.setObjType(AgrCommConstant.ObjType.AGREEMENT);
        agrAuditOrderQryBo.setOrderId(agrId);
        agrAuditOrderQryBo.setOrderBy("id desc");
        AgrAuditOrderDo agrAuditOrderDo = this.iAgrAuditOrderModel.getAuditObj(agrAuditOrderQryBo);
        if(!CollectionUtils.isEmpty(agrAuditOrderDo.getUocApprovalObj())){
            Long auditOrderId = agrAuditOrderDo.getUocApprovalObj().get(0).getAuditOrderId();
            AgrProcInstDo agrProcInstDo = new  AgrProcInstDo();
            agrProcInstDo.setOrderId(agrId);
            agrProcInstDo.setObjId(auditOrderId);
            agrProcInstDo.setObjType(AgrCommConstant.ObjType.APPROVE);
            AgrProcInstDo agrProcInstDo1 = iAgrProcInstModel.getProcInst(agrProcInstDo);
            procInstId = agrProcInstDo1.getProcInstId();
        }
        return procInstId;
    }


    /**
     * 封装出参信息
     */
    public AgrGetAgrDetailRspBo setRspBoInfo(AgrAgrDo agrDetail){
        AgrGetAgrDetailRspBo rspBo = new AgrGetAgrDetailRspBo();
        if(agrDetail!=null){
            //设置协议主体信息
            AgrMainDetailBo agrMainBO = AgrRu.js(agrDetail, AgrMainDetailBo.class);
            AgrMainDetailBo agrMain = this.agrMainTransferredMeaning(agrMainBO);
            rspBo.setAgrMainSaveBO(agrMain);
            //设置协议应用范围
            rspBo.setAgrAppScopeBOs(AgrRu.jsl(agrDetail.getAgrAppScope(), AgrAppScopeBO.class));
            //设置附件信息
            rspBo.setAgrAccessoryBOs(AgrRu.jsl(agrDetail.getAgrAccessory(), AgrAccessoryBo.class));
            //设置协议类目信息
            rspBo.setAgrCataScopeBOs(AgrRu.jsl(agrDetail.getAgrCataScope(), AgrCataScopeBo.class));
            //设置付款配置
            List<AgrPayConfig> agrPayConfig = agrDetail.getAgrPayConfig();
            if(!agrPayConfig.isEmpty()){
                for(AgrPayConfig item : agrPayConfig){
                    AgrPayConfigDetailBo payConfigDetailBo = AgrRu.js(item, AgrPayConfigDetailBo.class);

                    if(ObjectUtil.isNotEmpty(payConfigDetailBo.getAssign())){
                        //判断是否为指定日期
                        if(item.getAssign().equals(AgrCommConstant.Assign.NOT_FINISH.toString())){
                            //设置业务节点转义
                            payConfigDetailBo.setBusiNodeStr(AgrCommConstant.NoAssign.getValueByCode(payConfigDetailBo.getBusiNode()));
                        }else if(item.getAssign().equals(AgrCommConstant.Assign.FINISHED.toString())){
                            //设置业务节点转义
                            payConfigDetailBo.setBusiNodeStr(AgrCommConstant.IsAssign.getValueByCode(payConfigDetailBo.getBusiNode()));
                        }
                    }

                    //设置支付方式转义
                    payConfigDetailBo.setPayTypeStr(AgrCommConstant.PayTypeEnum.getValueByCode(payConfigDetailBo.getPayType()));
                    if(AgrCommConstant.payObj.PAY_OBJ_PURCHASE.equals(item.getPayObj())){
                        //设置支付放转义(对采购)
                        payConfigDetailBo.setPayObjStr(AgrCommConstant.PayObjEnum.getValueByCode(item.getPayObj()));
                        rspBo.getAgrMainSaveBO().setPayTypePur(payConfigDetailBo);
                    }
                    if(AgrCommConstant.payObj.PAY_OBJ_SUPPLY.equals(item.getPayObj())){
                        //设置支付放转义(对供应)
                        payConfigDetailBo.setPayObjStr(AgrCommConstant.PayObjEnum.getValueByCode(item.getPayObj()));
                        rspBo.getAgrMainSaveBO().setPayTypeSup(payConfigDetailBo);
                    }

                    //判断付款方式采购商是否为空
                    if(rspBo.getAgrMainSaveBO().getPayTypePur() == null){
                        rspBo.getAgrMainSaveBO().setPayTypePur(new AgrPayConfigDetailBo());
                    }
                    //判断付款方式供应商是否为空
                    if(rspBo.getAgrMainSaveBO().getPayTypeSup() == null){
                        rspBo.getAgrMainSaveBO().setPayTypeSup(new AgrPayConfigDetailBo());
                    }
                }
            }
            //调价配置信息
            AgrAdjustCfg agrAdjustCfg = agrDetail.getAgrAdjustCfg();
            if(ObjectUtil.isNotEmpty(agrAdjustCfg)){
                rspBo.getAgrMainSaveBO().setWhetherAddPrice(agrAdjustCfg.getWhetherAddPrice());
                rspBo.getAgrMainSaveBO().setMarkupRate(agrAdjustCfg.getMarkupRate());
                rspBo.getAgrMainSaveBO().setWhetherAdjustPriceFormula(agrAdjustCfg.getWhetherAdjustPriceFormula());
                rspBo.getAgrMainSaveBO().setWhetherModifyBuyPrice(agrAdjustCfg.getWhetherModifyBuyPrice());
                rspBo.getAgrMainSaveBO().setAdjustPriceFormulaId(agrAdjustCfg.getAdjustPriceFormulaId());
                rspBo.getAgrMainSaveBO().setAdjustPriceFormulaName(agrAdjustCfg.getAdjustPriceFormulaName());
                rspBo.getAgrMainSaveBO().setAdjustPriceFormulaValue(agrAdjustCfg.getAdjustPriceFormulaValue());
                rspBo.getAgrMainSaveBO().setAdjustPriceFormula(agrAdjustCfg.getAdjustPriceFormula());
            }
            //外部关联设置
            List<AgrRel> agrRel = agrDetail.getAgrRel();
            rspBo.setAgrRel(AgrRu.jsl(agrRel,AgrRelBo.class));

            //协议主体扩展
            List<AgrMainExt> agrMainExt = agrDetail.getAgrMainExt();
            List<AgrMainExtBo> agrMainExtBos = AgrRu.jsl(agrMainExt, AgrMainExtBo.class);
            rspBo.getAgrMainSaveBO().setAgrMainExtBOs(agrMainExtBos);
        }
        return rspBo;
    }

    /**
     * 协议主体所需字段转义
     * @return
     */
    private AgrMainDetailBo agrMainTransferredMeaning(AgrMainDetailBo rspBo){
        //协议模式转义  协议模式 1：平台协议 2：单位协议 默认1
        if(rspBo.getAgrMode() != null){
            rspBo.setAgrModeStr(AgrCommConstant.AgreementModeEnum.getValueByCode(rspBo.getAgrMode()));
        }
        //协议分类转义 协议分类 0：集团集采协议:1：区域集采协议、2：项目单位协议； 默认值：0：集团集采协议
        if(rspBo.getAgrType() != null){
            rspBo.setAgrTypeStr(AgrCommConstant.AgrTypeEnum.getValueByCode(rspBo.getAgrType()));
        }
        //协议状态转义  协议状态 0：草稿 1：提交中  2：启用 3：停用
        if(rspBo.getAgrStatus()!= null){
            rspBo.setAgrStatusStr(AgrCommConstant.AgreementStatusEnum.getNameByValue(rspBo.getAgrStatus()));
        }
        //协议价格类型转义 价格类型 1：执行价 2：协议价 默认1
        if(rspBo.getAgrPriceType() != null){
            rspBo.setAgrPriceTypeStr(AgrCommConstant.AgrPriceTypeEnum.getValueByCode(rspBo.getAgrPriceType()));
        }
        //协议来源转义 协议来源：1：手动创建，2.协议合同，3.招投标，4.询比价，5.竞价
        if(rspBo.getAgrSrc() != null){
            rspBo.setAgrSrcStr(AgrCommConstant.AgrSrcEnum.getValueByCode(rspBo.getAgrSrc()));
        }
        //交易模式转义 交易模式：1：贸易模式 2：搓合模式
        if(rspBo.getTradeMode() != null){
            rspBo.setTradeModeStr(AgrCommConstant.TradeModeEnum.getValueByCode(rspBo.getTradeMode()));
        }
        //是否配送转义 是否配送 0:否,1是 默认值：是
        if(rspBo.getWhetherDispatch() != null){
            rspBo.setWhetherDispatchStr(AgrCommConstant.WhetherDispatchEnum.getValueByCode(rspBo.getWhetherDispatch()));
        }
        //是否分配转义 是否配送 0:否,1是 默认值：是
        if(rspBo.getWhetherAssign() != null){
            rspBo.setWhetherAssignStr(AgrCommConstant.WhetherAssignEnum.getValueByCode(rspBo.getWhetherAssign()));
        }
        //采购类别：1物资类、2施工类、3服务类
        if(rspBo.getAgreementVariety() != null){
            rspBo.setAgreementVarietyStr(AgrCommConstant.AgreementVarietyEnum.getValueByCode(rspBo.getAgreementVariety()));
        }
        //所属专区转义  1：电力专区，5：煤炭专区
        if(rspBo.getAgrLocation() != null){
            rspBo.setAgrLocationStr(AgrCommConstant.AgrLocationEnum.getValueByCode(rspBo.getAgrLocation()));
        }
        //是否商城铺货标识转义 是否商城铺货标识 1：是，0：否
        if(rspBo.getWhetherStorePlan() != null){
            rspBo.setWhetherStorePlanStr(AgrCommConstant.WhetherStorePlanEnum.getValueByCode(rspBo.getWhetherStorePlan()));
        }
        //应用范围类型转义 选项值：0：全部:1：省份、2：行业:3：分子公司:4：项目单位 默认值：无
        if(rspBo.getScopeType() != null){
            rspBo.setScopeTypeStr(AgrCommConstant.ScopeTypeEnum.getValueByCode(rspBo.getScopeType()));
        }
        //调价机制转义 调价机制：0：无，1：事前调价，2：事中调价 默认值：0
        if(rspBo.getAdjustPrice() !=null){
            rspBo.setAdjustPriceStr(AgrCommConstant.AdjustPriceEnum.getValueByCode(rspBo.getAdjustPrice()));
        }
        //是否有明细标识转义  1：是，0：否
        if(rspBo.getWhetherHaveItem() != null){
            rspBo.setWhetherHaveItemStr(AgrCommConstant.WhetherHaveItemEnum.getValueByCode(rspBo.getWhetherHaveItem()));
        }
        return rspBo;
    }

}
