package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrItemCountByCommodityTypeReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrItemCountByCommodityTypeRspPageBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemCountReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemCountRspBO;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题:AgrGetAgrItemCountServiceImpl
 * 说明:TODO
 * 时间:2022/10/13 16:07
 * 作者:代愿愿
 */
@HTServiceImpl
public class AgrGetAgrItemCountServiceImpl implements AgrGetAgrItemCountService {
    @Autowired
    private IAgrAgrModel agrAgrModel;
    @Override
    public AgrGetAgrItemCountRspBO getAgrItemCount(AgrGetAgrItemCountReqBO reqBO) {
        // 1 参数校验
        this.validateParam(reqBO);
        // 2 查询明细数量
        AgrGetAgrItemCountByCommodityTypeReqPageBo commodityTypeReqPageBo = AgrRu.js(reqBO,AgrGetAgrItemCountByCommodityTypeReqPageBo.class);
        AgrGetAgrItemCountByCommodityTypeRspPageBo commodityTypeRspPageBo = this.agrAgrModel.getAgrItemCount(commodityTypeReqPageBo);
        AgrGetAgrItemCountRspBO rspBO = AgrRu.js(commodityTypeRspPageBo,AgrGetAgrItemCountRspBO.class);
        rspBO.setRespCode(AgrRspConstant.RESP_CODE_SUCCESS);
        return rspBO;
    }
    private void validateParam(AgrGetAgrItemCountReqBO reqBO){
        if (ObjectUtil.isEmpty(reqBO)){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getAgrId())){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
        }
        if(ObjectUtil.isEmpty(reqBO.getPageNo())){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[pageNo]不能为空");
        }
        if(ObjectUtil.isEmpty(reqBO.getPageSize())){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[pageSize]不能为空");
        }
    }
}
