/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.repository.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.agr.model.agrsync.AgrSyncRecordDo;
import com.tydic.dyc.agr.model.agrsync.qrybo.AgrGetAgrItemInfoRspPageBo;
import com.tydic.dyc.agr.model.agrsync.qrybo.AgrGetSyncProcessRspPageBo;
import com.tydic.dyc.agr.model.agrsync.qrybo.AgrSyncQryBo;
import com.tydic.dyc.agr.model.agrsync.sub.AgrItemInfo;
import com.tydic.dyc.agr.model.agrsync.sub.AgrMainInfo;
import com.tydic.dyc.agr.model.agrsync.sub.AgrSyncProcess;
import com.tydic.dyc.agr.repository.AgrSyncRecordRepository;
import com.tydic.dyc.agr.repository.dao.AgrItemInfoMapper;
import com.tydic.dyc.agr.repository.dao.AgrMainInfoMapper;
import com.tydic.dyc.agr.repository.dao.AgrSyncProcessMapper;
import com.tydic.dyc.agr.repository.dao.AgrSyncRecordMapper;
import com.tydic.dyc.agr.repository.po.AgrItemInfoPO;
import com.tydic.dyc.agr.repository.po.AgrMainInfoPO;
import com.tydic.dyc.agr.repository.po.AgrSyncProcessPO;
import com.tydic.dyc.agr.repository.po.AgrSyncRecordPO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.agr.utils.IdUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class AgrSyncRecordRepositoryImpl
implements AgrSyncRecordRepository {
    @Autowired
    private AgrSyncRecordMapper agrSyncRecordMapper;
    @Autowired
    private AgrMainInfoMapper agrMainInfoMapper;
    @Autowired
    private AgrItemInfoMapper agrItemInfoMapper;
    @Autowired
    private AgrSyncProcessMapper agrSyncProcessMapper;

    public void saveAgrSyncRecord(AgrSyncRecordDo agrSyncRecordDo) {
        Date createTime = new Date();
        Long syncRecordId = IdUtil.nextId();
        AgrSyncRecordPO agrSyncRecordPO2 = (AgrSyncRecordPO)AgrRu.js((Object)agrSyncRecordDo, AgrSyncRecordPO.class);
        agrSyncRecordPO2.setSyncRecordId(syncRecordId);
        agrSyncRecordPO2.setCreateTime(createTime);
        agrSyncRecordPO2.setSyncResult(AgrCommConstant.SyncResult.SUCCESS);
        this.agrSyncRecordMapper.insert(agrSyncRecordPO2);
        if (agrSyncRecordDo.getSyncType().equals(AgrCommConstant.AgrSyncType.AGR_ITEM) && !CollectionUtils.isEmpty((Collection)agrSyncRecordDo.getAgrItemInfo())) {
            List agrItemInfoPOS = AgrRu.jsl((List)agrSyncRecordDo.getAgrItemInfo(), AgrItemInfoPO.class);
            agrItemInfoPOS.forEach(agrItemInfoPO -> {
                agrItemInfoPO.setId(IdUtil.nextId());
                agrItemInfoPO.setAgrId(agrSyncRecordDo.getAgrId());
                agrItemInfoPO.setBatchNo(agrSyncRecordDo.getBatchNo());
                agrItemInfoPO.setSyncRecordId(agrSyncRecordPO2.getSyncRecordId());
                agrItemInfoPO.setCreateTime(createTime);
            });
            this.agrItemInfoMapper.insertBatch(agrItemInfoPOS);
        }
        if (agrSyncRecordDo.getSyncType().equals(AgrCommConstant.AgrSyncType.AGR_MAIN) && !ObjectUtils.isEmpty((Object)agrSyncRecordDo.getAgrMainInfo())) {
            AgrMainInfoPO agrMainInfoPO = (AgrMainInfoPO)AgrRu.js((Object)agrSyncRecordDo.getAgrMainInfo(), AgrMainInfoPO.class);
            agrMainInfoPO.setId(IdUtil.nextId());
            agrMainInfoPO.setAgrId(agrSyncRecordDo.getAgrId());
            agrMainInfoPO.setBatchNo(agrSyncRecordDo.getBatchNo());
            agrMainInfoPO.setSyncRecordId(agrSyncRecordPO2.getSyncRecordId());
            agrMainInfoPO.setCreateTime(createTime);
            this.agrMainInfoMapper.insert(agrMainInfoPO);
        }
        AgrSyncRecordPO agrSyncRecordPO = new AgrSyncRecordPO();
        agrSyncRecordPO.setBatchNo(agrSyncRecordDo.getBatchNo());
        agrSyncRecordPO.setAgrId(agrSyncRecordDo.getAgrId());
        List<AgrSyncRecordPO> agrSyncRecordPOs = this.agrSyncRecordMapper.getList(agrSyncRecordPO);
        Boolean failFlag = false;
        Integer totalBatchNum = 0;
        if (!CollectionUtils.isEmpty(agrSyncRecordPOs)) {
            for (AgrSyncRecordPO agrSyncRecordPO1 : agrSyncRecordPOs) {
                if (agrSyncRecordPO1.getSyncResult().equals(AgrCommConstant.SyncResult.FAIL)) {
                    failFlag = true;
                }
                Integer n = totalBatchNum;
                Integer n2 = totalBatchNum = Integer.valueOf(totalBatchNum + 1);
            }
        }
        if (totalBatchNum == agrSyncRecordDo.getBatchNum() && !failFlag.booleanValue()) {
            AgrSyncProcessPO agrSyncProcessPO = new AgrSyncProcessPO();
            agrSyncProcessPO.setId(IdUtil.nextId());
            agrSyncProcessPO.setBatchNo(agrSyncRecordDo.getBatchNo());
            agrSyncProcessPO.setCreateTime(createTime);
            agrSyncProcessPO.setProcessStatus(AgrCommConstant.ProcessStatus.TO_PROCESS);
            agrSyncProcessPO.setAgrId(agrSyncRecordDo.getAgrId());
            this.agrSyncProcessMapper.insert(agrSyncProcessPO);
        }
        if (failFlag.booleanValue()) {
            AgrSyncRecordPO agrSyncRecordPO1 = new AgrSyncRecordPO();
            agrSyncRecordPO1.setBatchNo(agrSyncRecordDo.getBatchNo());
            agrSyncRecordPO1.setAgrId(agrSyncRecordDo.getAgrId());
            this.agrSyncRecordMapper.deleteBy(agrSyncRecordPO1);
            AgrMainInfoPO agrMainInfoPO = new AgrMainInfoPO();
            agrMainInfoPO.setBatchNo(agrSyncRecordDo.getBatchNo());
            agrMainInfoPO.setAgrId(agrSyncRecordDo.getAgrId());
            this.agrMainInfoMapper.deleteBy(agrMainInfoPO);
            AgrItemInfoPO agrItemInfoPO2 = new AgrItemInfoPO();
            agrItemInfoPO2.setBatchNo(agrSyncRecordDo.getBatchNo());
            agrItemInfoPO2.setAgrId(agrSyncRecordDo.getAgrId());
            this.agrItemInfoMapper.deleteBy(agrItemInfoPO2);
        }
    }

    public void updateAgrSyncProcess(AgrSyncRecordDo agrSyncRecordDo) {
        AgrSyncProcessPO set = (AgrSyncProcessPO)AgrRu.js((Object)agrSyncRecordDo.getAgrSyncProcess(), AgrSyncProcessPO.class);
        set.setUpdateTime(new Date());
        AgrSyncProcessPO where = new AgrSyncProcessPO();
        where.setId(agrSyncRecordDo.getAgrSyncProcess().getId());
        this.agrSyncProcessMapper.updateBy(set, where);
    }

    public AgrGetSyncProcessRspPageBo getAgrSyncProcessByPage(AgrSyncQryBo agrSyncQryBo) {
        Page pg = new Page(agrSyncQryBo.getPageNo().intValue(), agrSyncQryBo.getPageSize().intValue());
        AgrSyncProcessPO agrsyncprocesspo = new AgrSyncProcessPO();
        agrsyncprocesspo.setProcessStatus(agrSyncQryBo.getProcessStatus());
        List<AgrSyncProcessPO> agrSyncProcessPOs = this.agrSyncProcessMapper.getListPage(agrsyncprocesspo, (Page<AgrSyncProcessPO>)pg);
        AgrGetSyncProcessRspPageBo agrGetSyncProcessRspPageBo = new AgrGetSyncProcessRspPageBo();
        List agrSyncProcesss = AgrRu.jsl(agrSyncProcessPOs, AgrSyncProcess.class);
        agrGetSyncProcessRspPageBo.setPageNo(agrSyncQryBo.getPageNo());
        agrGetSyncProcessRspPageBo.setTotal(Integer.valueOf(pg.getTotalPages()));
        agrGetSyncProcessRspPageBo.setRecordsTotal(Integer.valueOf(pg.getTotalCount()));
        agrGetSyncProcessRspPageBo.setRows(agrSyncProcesss);
        return agrGetSyncProcessRspPageBo;
    }

    public AgrSyncRecordDo getAgrMainInfo(AgrSyncQryBo agrSyncQryBo) {
        AgrMainInfoPO agrMainInfoPO = new AgrMainInfoPO();
        agrMainInfoPO.setBatchNo(agrSyncQryBo.getBatchNo());
        agrMainInfoPO.setAgrId(agrSyncQryBo.getAgrId());
        AgrMainInfoPO po = this.agrMainInfoMapper.getModelBy(agrMainInfoPO);
        AgrMainInfo agrMainInfo = (AgrMainInfo)AgrRu.js((Object)po, AgrMainInfo.class);
        AgrSyncRecordDo agrSyncRecordDo = new AgrSyncRecordDo();
        agrSyncRecordDo.setAgrMainInfo(agrMainInfo);
        return agrSyncRecordDo;
    }

    public AgrGetAgrItemInfoRspPageBo getAgrItemInfoByPage(AgrSyncQryBo agrSyncQryBo) {
        Page pg = new Page(agrSyncQryBo.getPageNo().intValue(), agrSyncQryBo.getPageSize().intValue());
        AgrItemInfoPO agrItemInfoPO = new AgrItemInfoPO();
        agrItemInfoPO.setBatchNo(agrSyncQryBo.getBatchNo());
        agrItemInfoPO.setAgrId(agrSyncQryBo.getAgrId());
        List<AgrItemInfoPO> agrItemInfoPOs = this.agrItemInfoMapper.getListPage(agrItemInfoPO, (Page<AgrItemInfoPO>)pg);
        AgrGetAgrItemInfoRspPageBo agrGetAgrItemInfoRspPageBo = new AgrGetAgrItemInfoRspPageBo();
        List agrItemInfos = AgrRu.jsl(agrItemInfoPOs, AgrItemInfo.class);
        agrGetAgrItemInfoRspPageBo.setPageNo(agrSyncQryBo.getPageNo());
        agrGetAgrItemInfoRspPageBo.setTotal(Integer.valueOf(pg.getTotalPages()));
        agrGetAgrItemInfoRspPageBo.setRecordsTotal(Integer.valueOf(pg.getTotalCount()));
        agrGetAgrItemInfoRspPageBo.setRows(agrItemInfos);
        return agrGetAgrItemInfoRspPageBo;
    }
}

