/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.repository.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.agr.repository.AgrVersionRepository;
import com.tydic.dyc.agr.repository.dao.BkAgrVersionMapper;
import com.tydic.dyc.agr.repository.po.BkAgrVersionPO;
import com.tydic.dyc.agr.service.agr.bo.AgrQryAgrVersionListReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrQryAgrVersionListRspBO;
import com.tydic.dyc.agr.service.agr.bo.BkAgrVersionBO;
import com.tydic.dyc.agr.utils.AgrRu;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrVersionRepositoryImpl
implements AgrVersionRepository {
    @Autowired
    private BkAgrVersionMapper bkAgrVersionMapper;

    public AgrQryAgrVersionListRspBO qryAgrVersionList(AgrQryAgrVersionListReqBO reqBO) {
        Page page = new Page(-1, -1);
        BkAgrVersionPO po = new BkAgrVersionPO();
        po.setAgrId(reqBO.getAgrId());
        po.setAgrCode(reqBO.getAgrCode());
        List<BkAgrVersionPO> listPage = this.bkAgrVersionMapper.getListPage(po, (Page<BkAgrVersionPO>)page);
        AgrQryAgrVersionListRspBO rspBO = new AgrQryAgrVersionListRspBO();
        rspBO.setRows(AgrRu.jsl(listPage, BkAgrVersionBO.class));
        rspBO.setPageSize(Integer.valueOf(page.getPageSize()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        return rspBO;
    }

    public void updateStatus(Long agrId) {
        BkAgrVersionPO set = new BkAgrVersionPO();
        set.setAgrVersionStatus("EXPIRED");
        BkAgrVersionPO where = new BkAgrVersionPO();
        where.setAgrId(agrId);
        this.bkAgrVersionMapper.updateBy(set, where);
    }

    public List<Long> agrIdList(String agrCode, Long agrId) {
        BkAgrVersionPO po = new BkAgrVersionPO();
        po.setAgrCode(agrCode);
        List<BkAgrVersionPO> list = this.bkAgrVersionMapper.getList(po);
        List<Long> collect = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty(list)) {
            collect = list.stream().map(obj -> obj.getAgrMainHisId()).collect(Collectors.toList());
        }
        collect.add(agrId);
        return collect;
    }
}

