/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.extension.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DateExtUtils {
    private static final Log logger = LogFactory.getLog(DateExtUtils.class);

    public static Date dateBefore(int dayCntBefore) {
        return DateExtUtils.dateBefore(new Date(), dayCntBefore);
    }

    public static Date dateBefore(Date date, int dayCntBefore) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(5, dayCntBefore);
        return cal.getTime();
    }

    public static Date dateAddSeconds(Date date, int seconds) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(13, seconds);
        return cal.getTime();
    }

    public static Date dateAddHours(Date date, int hours) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(11, hours);
        return cal.getTime();
    }

    public static Date dateAddMonths(Date date, int months) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(2, months);
        return cal.getTime();
    }

    public static String formatDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    public static String formatDate(Date date, String fmt) {
        SimpleDateFormat sdf = new SimpleDateFormat(fmt);
        return sdf.format(date);
    }

    public static Date parseDate(String dateYYYYMMdd) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date dt = null;
        try {
            dt = sdf.parse(dateYYYYMMdd);
        }
        catch (ParseException e) {
            logger.error((Object)"\u65e5\u671f\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
        }
        return dt;
    }

    public static Date obtainEndOfDay(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        int dayOfYear = calendar.get(6);
        calendar.clear();
        calendar.set(1, year);
        calendar.set(6, dayOfYear);
        calendar.add(6, 1);
        calendar.add(14, -1);
        return calendar.getTime();
    }

    public static int obtainDaysBetween(Date dateStart, Date dateEnd) {
        int daysBetween = 0;
        if (dateStart == null || dateEnd == null) {
            return daysBetween;
        }
        dateStart = DateExtUtils.obtainEndOfDay(dateStart);
        dateEnd = DateExtUtils.obtainEndOfDay(dateEnd);
        try {
            daysBetween = (int)(dateEnd.getTime() - dateStart.getTime()) / 86400000;
        }
        catch (Exception e) {
            logger.error((Object)"\u8ba1\u7b97\u51fa\u9519", (Throwable)e);
        }
        return daysBetween;
    }

    public static Date getFirstDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, calendar.get(2));
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static String getLastDayOfLastMonth() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar calendar2 = Calendar.getInstance();
        calendar2.set(5, 0);
        calendar2.set(calendar2.get(1), calendar2.get(2), calendar2.get(5), 23, 59, 59);
        String lastDay = sdf.format(calendar2.getTime());
        return lastDay;
    }

    public static Date getLastDayOfLastMonthToDate() {
        Calendar calendar2 = Calendar.getInstance();
        calendar2.set(5, 0);
        calendar2.set(calendar2.get(1), calendar2.get(2), calendar2.get(5), 23, 59, 59);
        return calendar2.getTime();
    }

    public static String getFirstDayOfLastMonth() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar calendar2 = Calendar.getInstance();
        calendar2.add(2, -1);
        calendar2.set(5, 1);
        calendar2.set(calendar2.get(1), calendar2.get(2), calendar2.get(5), 0, 0, 0);
        String lastDay = sdf.format(calendar2.getTime());
        return lastDay;
    }

    public static String getDayOfLastMonth() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(2, -1);
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        String lastDay = sdf.format(cal.getTime());
        return lastDay;
    }

    public static String getDayOfLastDay() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, -1);
        cal.set(cal.get(1), cal.get(2), cal.get(5), 23, 59, 59);
        String lastDay = sdf.format(cal.getTime());
        return lastDay;
    }

    public static Date getLastDayDateOfLastMonth() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar calendar2 = Calendar.getInstance();
        calendar2.set(5, 0);
        calendar2.set(calendar2.get(1), calendar2.get(2), calendar2.get(5), 23, 59, 59);
        return calendar2.getTime();
    }

    public static Date getFirstDayDateOfLastMonth() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar calendar2 = Calendar.getInstance();
        calendar2.add(2, -1);
        calendar2.set(5, 1);
        calendar2.set(calendar2.get(1), calendar2.get(2), calendar2.get(5), 0, 0, 0);
        return calendar2.getTime();
    }
}

