/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.constants;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FscSSLClient
extends DefaultHttpClient {
    private static final Logger log = LoggerFactory.getLogger(FscSSLClient.class);

    public FscSSLClient() throws Exception {
        SSLContext ctx = SSLContext.getInstance("TLS");
        X509TrustManager tm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        ctx.init(null, new TrustManager[]{tm}, null);
        SSLSocketFactory ssf = new SSLSocketFactory(ctx, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        ClientConnectionManager ccm = this.getConnectionManager();
        SchemeRegistry sr = ccm.getSchemeRegistry();
        sr.register(new Scheme("https", 443, (SchemeSocketFactory)ssf));
    }

    public static String doPost(String url) {
        String charset = "utf-8";
        FscSSLClient httpClient = null;
        HttpPost httpPost = null;
        String result = null;
        try {
            HttpEntity resEntity;
            httpClient = new FscSSLClient();
            httpPost = new HttpPost(url);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception ex) {
            log.error("POST\u8bf7\u6c42\u5f02\u5e38:{}", (Object)ex.getMessage());
        }
        return result;
    }

    public static String doPost(String url, Map<String, String> map) {
        String charset = "utf-8";
        FscSSLClient httpClient = null;
        HttpPost httpPost = null;
        String result = null;
        try {
            HttpEntity resEntity;
            HttpResponse response;
            httpClient = new FscSSLClient();
            httpPost = new HttpPost(url);
            if (null != map) {
                ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, String> elem : map.entrySet()) {
                    list.add(new BasicNameValuePair(elem.getKey(), elem.getValue()));
                }
                if (list.size() > 0) {
                    UrlEncodedFormEntity entity = new UrlEncodedFormEntity(list, charset);
                    entity.setContentType("application/x-www-form-urlencoded");
                    httpPost.setHeader("Content-type", "application/x-www-form-urlencoded; charset=utf-8");
                    httpPost.setEntity((HttpEntity)entity);
                }
            }
            if ((response = httpClient.execute((HttpUriRequest)httpPost)) != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception ex) {
            log.error("POST\u8bf7\u6c42\u5f02\u5e38:{}", (Object)ex.getMessage());
        }
        return result;
    }

    public static String doPost(String url, String body) {
        String charset = "utf-8";
        FscSSLClient httpClient = null;
        HttpPost httpPost = null;
        String result = null;
        try {
            HttpEntity resEntity;
            httpClient = new FscSSLClient();
            httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(2000).setSocketTimeout(3000).setConnectTimeout(2000).build();
            httpPost.setConfig(requestConfig);
            StringEntity entity = new StringEntity(body, charset);
            entity.setContentType("application/json");
            httpPost.setHeader("Content-type", "application/json; charset=utf-8");
            httpPost.setEntity((HttpEntity)entity);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception ex) {
            log.error("POST\u8bf7\u6c42\u5f02\u5e38:{}", (Object)ex.getMessage());
        }
        return result;
    }

    public static String doPost(String url, String body, String headKey, String headValue) {
        String charset = "utf-8";
        FscSSLClient httpClient = null;
        HttpPost httpPost = null;
        String result = null;
        try {
            HttpEntity resEntity;
            httpClient = new FscSSLClient();
            httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(body, charset);
            entity.setContentType("application/json");
            httpPost.setHeader("Content-type", "application/json; charset=utf-8");
            if (!StringUtils.isBlank((CharSequence)headKey) && !StringUtils.isBlank((CharSequence)headValue)) {
                httpPost.setHeader(headKey, headValue);
            }
            httpPost.setEntity((HttpEntity)entity);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception ex) {
            log.error("POST\u8bf7\u6c42\u5f02\u5e38:{}", (Object)ex.getMessage());
        }
        return result;
    }

    public static String doPost(String url, Map<String, String> map, Map<String, String> headers) {
        String charset = "utf-8";
        FscSSLClient httpClient = null;
        HttpPost httpPost = null;
        String result = null;
        try {
            HttpEntity httpEntity;
            HttpResponse response;
            httpClient = new FscSSLClient();
            httpPost = new HttpPost(url);
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                list.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            if (list.size() > 0) {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(list, charset);
                entity.setContentType("application/x-www-form-urlencoded");
                httpPost.setHeader("Accept", "text/plain;charset=utf-8");
                httpPost.setHeader("Content-type", "application/x-www-form-urlencoded; charset=utf-8");
                if (headers != null && headers.size() > 0) {
                    for (Map.Entry<String, String> entry : headers.entrySet()) {
                        httpPost.setHeader(entry.getKey(), entry.getValue());
                    }
                }
                httpPost.setEntity((HttpEntity)entity);
            }
            if ((response = httpClient.execute((HttpUriRequest)httpPost)) != null && (httpEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)httpEntity, (String)charset);
            }
        }
        catch (Exception e) {
            log.error("\u5f02\u5e38", (Throwable)e);
        }
        return result;
    }
}

