/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.extension.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.common.ability.extension.api.BkFscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.extension.bo.BkFscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.consumer.extension.bo.BkFscSyncReqBO;
import com.tydic.fsc.constants.FscConstants;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BkFscComOrderSyncAbilityServiceImpl
implements BkFscComOrderSyncAbilityService {
    private static final Logger log = LoggerFactory.getLogger(BkFscComOrderSyncAbilityServiceImpl.class);
    @Resource(name="bkFscOrderEsSyncMqProvider")
    private ProxyMessageProducer bkFscOrderEsSyncMqProvider;
    @Value(value="${es.BK_FSC_SYNC_TOPIC}")
    private String topic;
    @Value(value="${es.BK_FSC_SYNC_TAG}")
    private String tag;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;

    public void dealComOrderSyncEs(BkFscComOrderListSyncAbilityReqBO reqBO) {
        BkFscSyncReqBO fscSyncReqBO = new BkFscSyncReqBO();
        fscSyncReqBO.setFscOrderId(reqBO.getFscOrderId());
        ProxySendResult proxySendResult = this.bkFscOrderEsSyncMqProvider.send(new ProxyMessage(this.topic, this.tag, JSON.toJSONString((Object)fscSyncReqBO)));
        if (!"SEND_OK".equals(proxySendResult.getStatus())) {
            this.writeFailLog(reqBO, JSON.toJSONString((Object)proxySendResult));
        }
        log.info("\u540c\u6b65\u7ed3\u7b97\u5355\u6d88\u606f\u53d1\u9001\u5b8c\u6210\uff0cMessageId={}", (Object)proxySendResult.getMsgId());
    }

    private void writeFailLog(BkFscComOrderListSyncAbilityReqBO reqBO, String errDesc) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjId(reqBO.getFscOrderId());
        fscOrderFailLogUpdateBusiReqBO.setBusiFailDesc(errDesc);
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_SYNC_ES);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }
}

