/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.extension.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.extension.api.BkFscOrderItemDetailQueryAbilityService;
import com.tydic.fsc.common.ability.extension.bo.BkFscOrderItemDetailQueryAbilityReqBO;
import com.tydic.fsc.common.ability.extension.bo.BkFscOrderItemDetailQueryAbilityRspBO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.extension.bo.BkFscOrderItemDetailBO;
import com.tydic.fsc.extension.dao.BkFscOrderItemMapper;
import com.tydic.fsc.extension.dao.BkFscOrderMapper;
import com.tydic.fsc.extension.dao.BkFscOrderRelationMapper;
import com.tydic.fsc.extension.po.BkFscOrderItemPO;
import com.tydic.fsc.extension.po.BkFscOrderPO;
import com.tydic.fsc.extension.po.BkFscOrderRelationPO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.extension.api.BkFscOrderItemDetailQueryAbilityService"})
public class BkFscOrderItemDetailQueryAbilityServiceImpl
implements BkFscOrderItemDetailQueryAbilityService {
    @Autowired
    private BkFscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private BkFscOrderMapper fscOrderMapper;
    @Autowired
    private BkFscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    @PostMapping(value={"queryOrderItemDetail"})
    public BkFscOrderItemDetailQueryAbilityRspBO queryOrderItemDetail(@RequestBody BkFscOrderItemDetailQueryAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        BkFscOrderItemPO fscOrderItemPO = new BkFscOrderItemPO();
        if (null != reqBO.getFscOrderId()) {
            fscOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getFscOrderIdList())) {
            fscOrderItemPO.setFscOrderIdList(reqBO.getFscOrderIdList());
        }
        List fscOrderItemPOS = this.fscOrderItemMapper.getOrdItemExpList(fscOrderItemPO);
        List fscOrderItemDetailBOS = JSON.parseArray((String)JSON.toJSONString((Object)fscOrderItemPOS), BkFscOrderItemDetailBO.class);
        Map invoiceTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_TYPE");
        Map invoiceCategoryMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_CATEGORY");
        fscOrderItemDetailBOS.forEach(bkFscOrderItemDetailBO -> {
            bkFscOrderItemDetailBO.setInvoiceTypeStr((String)invoiceTypeMap.get(bkFscOrderItemDetailBO.getInvoiceType()));
            bkFscOrderItemDetailBO.setInvoiceCategoryStr((String)invoiceCategoryMap.get(bkFscOrderItemDetailBO.getInvoiceCategory()));
        });
        BkFscOrderRelationPO fscOrderRelationPO = new BkFscOrderRelationPO();
        if (null != reqBO.getFscOrderId()) {
            fscOrderRelationPO.setFscOrderId(reqBO.getFscOrderId());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getFscOrderIdList())) {
            fscOrderRelationPO.setFscOrderIds(reqBO.getFscOrderIdList());
        }
        List fscOrderRelationPOS = this.fscOrderRelationMapper.getList(fscOrderRelationPO);
        HashMap<String, String> orderRelationMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty((Collection)fscOrderRelationPOS)) {
            for (BkFscOrderRelationPO fscOrderRelationPO1 : fscOrderRelationPOS) {
                orderRelationMap.put(fscOrderRelationPO1.getOrderId().toString(), fscOrderRelationPO1.getOrderNo());
            }
        }
        BkFscOrderPO fscOrderPO = new BkFscOrderPO();
        if (null != reqBO.getFscOrderId()) {
            fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getFscOrderIdList())) {
            fscOrderPO.setFscOrderIds(reqBO.getFscOrderIdList());
        }
        List fscOrderList = this.fscOrderMapper.getList(fscOrderPO);
        for (BkFscOrderItemDetailBO fscOrderItemDetailBO : fscOrderItemDetailBOS) {
            for (BkFscOrderPO orderPO : fscOrderList) {
                if (!orderPO.getFscOrderId().equals(fscOrderItemDetailBO.getFscOrderId())) continue;
                fscOrderItemDetailBO.setOrderNo(orderPO.getOrderNo());
                fscOrderItemDetailBO.setOrderDesc(orderPO.getOrderDesc());
                if (orderRelationMap.containsKey(fscOrderItemDetailBO.getOrderId())) {
                    fscOrderItemDetailBO.setOrderCode((String)orderRelationMap.get(fscOrderItemDetailBO.getOrderId()));
                }
                fscOrderItemDetailBO.setPurchaserName(orderPO.getPurchaserName());
                fscOrderItemDetailBO.setTaxCode(fscOrderItemDetailBO.getTaxCode());
                String productId = fscOrderItemDetailBO.getOrderItemId() + "-" + fscOrderItemDetailBO.getId();
                fscOrderItemDetailBO.setProductId(productId);
                String spec = fscOrderItemDetailBO.getSpec();
                String model = fscOrderItemDetailBO.getModel();
                StringBuffer specModel = new StringBuffer();
                if (StringUtils.isEmpty((Object)spec)) {
                    if (!StringUtils.isEmpty((Object)model)) {
                        specModel = specModel.append(model);
                    }
                } else {
                    specModel = specModel.append(spec);
                    if (!StringUtils.isEmpty((Object)model)) {
                        specModel = specModel.append("," + model);
                    }
                }
                fscOrderItemDetailBO.setSkuNo(fscOrderItemDetailBO.getMaterialCode());
                fscOrderItemDetailBO.setSkuName(fscOrderItemDetailBO.getMaterialName());
                fscOrderItemDetailBO.setSpecModel(specModel.toString());
                fscOrderItemDetailBO.setPrice(fscOrderItemDetailBO.getPrice().setScale(3, RoundingMode.HALF_UP));
                BigDecimal untaxPrice = fscOrderItemDetailBO.getPrice().divide(new BigDecimal(1).add(fscOrderItemDetailBO.getTaxRate().divide(new BigDecimal(100)).setScale(4, RoundingMode.HALF_UP)), 3, RoundingMode.HALF_UP);
                fscOrderItemDetailBO.setUntaxPrice(untaxPrice);
                fscOrderItemDetailBO.setAmt(fscOrderItemDetailBO.getAmt().setScale(2, RoundingMode.HALF_UP));
                fscOrderItemDetailBO.setTaxAmt(fscOrderItemDetailBO.getTaxAmt().setScale(2, RoundingMode.HALF_UP));
                fscOrderItemDetailBO.setUntaxAmt(fscOrderItemDetailBO.getUntaxAmt().setScale(2, RoundingMode.HALF_UP));
                fscOrderItemDetailBO.setTaxRate(fscOrderItemDetailBO.getTaxRate().setScale(2, RoundingMode.HALF_UP));
                fscOrderItemDetailBO.setExpNum(String.valueOf(fscOrderItemDetailBO.getNum().setScale(3)));
            }
        }
        BkFscOrderItemDetailQueryAbilityRspBO fscOrderItemDetailQueryAbilityRspBO = new BkFscOrderItemDetailQueryAbilityRspBO();
        fscOrderItemDetailQueryAbilityRspBO.setFscOrderItemDetailBOS(fscOrderItemDetailBOS);
        return fscOrderItemDetailQueryAbilityRspBO;
    }
}

