/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.extension.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.common.ability.extension.api.BkFscPushOrderToNcAbilityService;
import com.tydic.fsc.common.ability.extension.bo.BkFscPushOrderToNcAbilityServiceReqBO;
import com.tydic.fsc.extension.constants.FscExtConstants;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BkFscPushOrderToNcAbilityServiceImpl
implements BkFscPushOrderToNcAbilityService {
    private static final Logger log = LoggerFactory.getLogger(BkFscPushOrderToNcAbilityServiceImpl.class);
    @Resource(name="fscPushOrderNcMqServiceProvider")
    private ProxyMessageProducer fscPushOrderNcMqServiceProvider;
    @Value(value="${nc.FSC_PUSH_ORDER_TOPIC}")
    private String topic;
    @Value(value="${nc.FSC_PUSH_ORDER_TAG}")
    private String tag;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;

    public void dealFscOrderPushToNc(BkFscPushOrderToNcAbilityServiceReqBO reqBO) {
        ProxySendResult proxySendResult = this.fscPushOrderNcMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)reqBO)));
        if (!"SEND_OK".equals(proxySendResult.getStatus())) {
            this.writeFailLog(reqBO, JSONObject.toJSONString((Object)proxySendResult));
        }
        log.info("\u63a8\u9001\u7ed3\u7b97\u5355\u8c03\u63a5\u53e3\u5e73\u53f0\u6d88\u606f\u53d1\u9001\u5b8c\u6210\uff0cMessageId={}", (Object)proxySendResult.getMsgId());
    }

    private void writeFailLog(BkFscPushOrderToNcAbilityServiceReqBO reqBO, String desc) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjId(reqBO.getFscOrderId());
        fscOrderFailLogUpdateBusiReqBO.setBusiFailDesc(desc);
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscExtConstants.FscOrderFailRetansBusiType.FSC_BILL_ORDER_PUSH_NC_FAIL);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }
}

