/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.extension.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.external.api.bo.FscPebExtOrdStatisticReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscPebExtOrdStatisticRspBO;
import com.tydic.fsc.busibase.external.api.pay.FscPayTransPayInsService;
import com.tydic.fsc.busibase.external.api.pay.bo.FscPayTransPayInsReqBo;
import com.tydic.fsc.busibase.external.api.pay.bo.FscPayTransPayInsRspBo;
import com.tydic.fsc.busibase.external.api.uoc.FscPebExtOrdStatisticAbilityService;
import com.tydic.fsc.busibase.external.api.uoc.FscUocProTransactionServiceListQueryAbilityService;
import com.tydic.fsc.common.busi.extension.api.BkFscComOrderDetailQueryBusiService;
import com.tydic.fsc.common.busi.extension.bo.BkFscComOrderListDetailRspBO;
import com.tydic.fsc.common.busi.extension.bo.BkFscComOrderListQueryBusiReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderFlowEnum;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.extension.constants.FscExtConstants;
import com.tydic.fsc.extension.dao.BkFscInvoiceMapper;
import com.tydic.fsc.extension.dao.BkFscInvoicePostMapper;
import com.tydic.fsc.extension.dao.BkFscOrderInvoiceMapper;
import com.tydic.fsc.extension.dao.BkFscOrderItemMapper;
import com.tydic.fsc.extension.dao.BkFscOrderMapper;
import com.tydic.fsc.extension.dao.BkFscOrderRelationMapper;
import com.tydic.fsc.extension.po.BkFscInvoicePO;
import com.tydic.fsc.extension.po.BkFscInvoicePostPO;
import com.tydic.fsc.extension.po.BkFscOrderInvoicePO;
import com.tydic.fsc.extension.po.BkFscOrderItemPO;
import com.tydic.fsc.extension.po.BkFscOrderPO;
import com.tydic.fsc.extension.po.BkFscOrderRelationPO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BkFscComOrderDetailQueryBusiServiceImpl
implements BkFscComOrderDetailQueryBusiService {
    private static final Logger log = LoggerFactory.getLogger(BkFscComOrderDetailQueryBusiServiceImpl.class);
    @Autowired
    private BkFscOrderMapper fscOrderMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private BkFscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private BkFscOrderItemMapper bkFscOrderItemMapper;
    @Autowired
    private BkFscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private BkFscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private BkFscInvoicePostMapper fscInvoicePostMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private FscPayTransPayInsService fscPayTransPayInsService;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscUocProTransactionServiceListQueryAbilityService fscUocProTransactionServiceListQueryAbilityService;
    @Autowired
    private FscPebExtOrdStatisticAbilityService fscPebExtOrdStatisticAbilityService;

    @Override
    public BkFscComOrderListDetailRspBO qryOrderDetailBusi(BkFscComOrderListQueryBusiReqBO reqBO) {
        this.validateParams(reqBO);
        BkFscOrderPO fscOrderPO = new BkFscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (StringUtils.isEmpty((Object)fscOrderPO)) {
            throw new FscBusinessException("193111", "\u8be5\u7ed3\u7b97\u5355id" + reqBO.getFscOrderId() + "\u65e0\u6cd5\u67e5\u8be2\u5230\u7ed3\u7b97\u5355");
        }
        BkFscComOrderListDetailRspBO fscComOrderListBO = (BkFscComOrderListDetailRspBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)fscOrderPO), BkFscComOrderListDetailRspBO.class));
        fscComOrderListBO.setFscOrderNo(fscOrderPO.getOrderNo());
        if (FscConstants.OrderFlow.PAY.equals(fscOrderPO.getOrderFlow())) {
            fscComOrderListBO.setAuditType(0);
        } else if (FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(fscOrderPO.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(fscOrderPO.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(fscOrderPO.getOrderFlow())) {
            fscComOrderListBO.setAuditType(1);
        }
        FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
        fscAttachmentPo.setFscOrderId(reqBO.getFscOrderId());
        List fscAttachmentPOS = this.fscAttachmentMapper.getList(fscAttachmentPo);
        ArrayList<String> attUrls = null;
        if (!CollectionUtils.isEmpty((Collection)fscAttachmentPOS)) {
            attUrls = new ArrayList<String>(fscAttachmentPOS.size());
            for (FscAttachmentPO fscAttachmentPO : fscAttachmentPOS) {
                attUrls.add(fscAttachmentPO.getAttachmentUrl());
            }
        }
        BkFscOrderRelationPO fscOrderRelationPo = new BkFscOrderRelationPO();
        fscOrderRelationPo.setFscOrderId(reqBO.getFscOrderId());
        List fscOrderRelationCounts = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
        ArrayList<Long> orderIdList = null;
        ArrayList<Long> acceptOrderIdList = null;
        if (!CollectionUtils.isEmpty((Collection)fscOrderRelationCounts)) {
            ArrayList<String> acceptOrderNoList;
            ArrayList<String> orderNoList;
            if ("1".equals(fscOrderPO.getOrderSource().toString())) {
                if (!FscConstants.OrderFlow.PAY.equals(fscOrderPO.getOrderFlow())) {
                    fscComOrderListBO.setOrderNum(fscOrderRelationCounts.size());
                }
                orderIdList = new ArrayList<Long>();
                orderNoList = new ArrayList<String>(fscOrderRelationCounts.size());
                acceptOrderIdList = new ArrayList<Long>(fscOrderRelationCounts.size());
                acceptOrderNoList = new ArrayList(fscOrderRelationCounts.size());
                ArrayList<Integer> payStageList = new ArrayList<Integer>();
                for (BkFscOrderRelationPO fscOrderRelationCount : fscOrderRelationCounts) {
                    if (!orderIdList.contains(fscOrderRelationCount.getOrderId())) {
                        orderIdList.add(fscOrderRelationCount.getOrderId());
                    }
                    if (!payStageList.contains(fscOrderRelationCount.getPayStage())) {
                        payStageList.add(fscOrderRelationCount.getPayStage());
                    }
                    if (ObjectUtil.isNotNull((Object)fscOrderRelationCount.getAcceptOrderNo()) && !acceptOrderNoList.contains(fscOrderRelationCount.getAcceptOrderNo())) {
                        acceptOrderNoList.add(fscOrderRelationCount.getAcceptOrderNo());
                    }
                    orderNoList.add(fscOrderRelationCount.getOrderNo());
                }
                fscComOrderListBO.setAcceptOrderNoList(acceptOrderNoList);
                fscComOrderListBO.setOrderIdList(orderIdList);
                fscComOrderListBO.setPayStageStr(this.translatePayStageStr(payStageList));
                fscComOrderListBO.setPayStageList((List<Integer>)payStageList);
                fscComOrderListBO.setOrderNo(orderNoList);
            } else if ("2".equals(fscOrderPO.getOrderSource().toString())) {
                fscComOrderListBO.setPayStageStr("\u5230\u8d27\u9a8c\u6536");
                if (!FscConstants.OrderFlow.PAY.equals(fscOrderPO.getOrderFlow())) {
                    fscComOrderListBO.setOrderNum(fscOrderRelationCounts.size());
                }
                acceptOrderNoList = new ArrayList<String>(fscOrderRelationCounts.size());
                orderIdList = new ArrayList(fscOrderRelationCounts.size());
                ArrayList<String> extOrderNoList = new ArrayList<String>(fscOrderRelationCounts.size());
                orderNoList = new ArrayList(fscOrderRelationCounts.size());
                acceptOrderIdList = new ArrayList(fscOrderRelationCounts.size());
                for (BkFscOrderRelationPO fscOrderRelationCount : fscOrderRelationCounts) {
                    acceptOrderNoList.add(fscOrderRelationCount.getAcceptOrderNo());
                    orderIdList.add(fscOrderRelationCount.getOrderId());
                    extOrderNoList.add(fscOrderRelationCount.getExtOrderNo());
                    orderNoList.add(fscOrderRelationCount.getOrderNo());
                    if (!ObjectUtil.isNotNull((Object)fscOrderRelationCount.getAcceptOrderId())) continue;
                    acceptOrderIdList.add(fscOrderRelationCount.getAcceptOrderId());
                }
                fscComOrderListBO.setAcceptOrderNoList(acceptOrderNoList);
                fscComOrderListBO.setExtOrderNoList(extOrderNoList);
                fscComOrderListBO.setOrderIdList(orderIdList);
                fscComOrderListBO.setOrderNo(orderNoList);
            }
        } else if (FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(fscOrderPO.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(fscOrderPO.getOrderFlow())) {
            String serviceFeeCycle = fscOrderPO.getServiceFeeCycle();
            String[] cycles = serviceFeeCycle.split(",");
            Integer year = LocalDate.now().getYear();
            String firstCycleMonth = cycles[0].length() < 10 ? "0" + cycles[0] : cycles[0];
            String firstCycleDay = cycles[1].length() < 10 ? "0" + cycles[1] : cycles[1];
            String lastCycleMonth = cycles[2].length() < 10 ? "0" + cycles[2] : cycles[2];
            String lastCycleDay = cycles[3].length() < 10 ? "0" + cycles[3] : cycles[3];
            String firstDayStr = year + "-" + firstCycleMonth + "-" + firstCycleDay;
            String lastDayStr = year + "-" + lastCycleMonth + "-" + lastCycleDay;
            Integer searchType = FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(fscOrderPO.getOrderFlow()) ? FscConstants.SearchType.ACCEPT : FscConstants.SearchType.ORDER;
            FscPebExtOrdStatisticRspBO fscPebExtOrdStatisticRspBO = this.qryYearOrdInfo(fscOrderPO.getSupplierId(), searchType, firstDayStr, lastDayStr);
            fscComOrderListBO.setOrderNum(fscPebExtOrdStatisticRspBO.getTotalCount());
        } else {
            fscComOrderListBO.setOrderNum(0);
        }
        if (FscConstants.OrderFlow.PAY.equals(fscOrderPO.getOrderFlow())) {
            FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
            fscOrderPayItemPO.setFscOrderId(reqBO.getFscOrderId());
            List fscOrderPayItemList = this.fscOrderPayItemMapper.getList(fscOrderPayItemPO);
            if (!CollectionUtils.isEmpty((Collection)fscOrderPayItemList)) {
                fscComOrderListBO.setOrderNum(fscOrderPayItemList.size());
            }
        }
        BkFscInvoicePO fscInvoicePo = new BkFscInvoicePO();
        fscInvoicePo.setFscOrderId(reqBO.getFscOrderId());
        List fscInvoicePOS = this.fscInvoiceMapper.getList(fscInvoicePo);
        Map buildActionMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_BUILD_ACTION");
        Map orderSourceMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_SOURCE");
        Map shouldPayTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("SHOULD_PAY_TYPE");
        Map payTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_CFC_PAY_TYPE_ALLOW");
        Map busiCategoryMap = this.fscDictionaryBusiService.queryBypCodeBackMap("BUSI_CATEGORY");
        Map orderStateMap = 0 == fscOrderPO.getOrderFlow() && FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(fscOrderPO.getMakeType()) ? this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_PUR_MATCH_ECOM_SETTLE_ORDER_STATE") : (0 == fscOrderPO.getOrderFlow() && !FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(fscOrderPO.getMakeType()) ? this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_LIST_STATE") : this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_SERVICE_LIST_STATE"));
        if (null != fscComOrderListBO.getPayChannel()) {
            FscPayTransPayInsReqBo fscPayTransPayInsReqBo = new FscPayTransPayInsReqBo();
            fscPayTransPayInsReqBo.setPaymentInsId(Collections.singletonList(Long.parseLong(fscComOrderListBO.getPayChannel())));
            FscPayTransPayInsRspBo fscPayTransPayInsRspBo = this.fscPayTransPayInsService.tranPayIns(fscPayTransPayInsReqBo);
            if (!StringUtils.isEmpty((Object)fscPayTransPayInsRspBo)) {
                if (!StringUtils.isEmpty((Object)fscPayTransPayInsRspBo.getPayInsMap())) {
                    fscComOrderListBO.setPayChannelStr((String)fscPayTransPayInsRspBo.getPayInsMap().get(fscComOrderListBO.getPayChannel()));
                }
                if (!StringUtils.isEmpty((Object)fscPayTransPayInsRspBo.getPayMethodMap())) {
                    fscComOrderListBO.setPayMethodStr((String)fscPayTransPayInsRspBo.getPayMethodMap().get(fscComOrderListBO.getPayMethod()));
                }
            }
        }
        BigDecimal totalChargeBill = new BigDecimal("0");
        BkFscOrderInvoicePO fscOrderInvoicePO = new BkFscOrderInvoicePO();
        fscOrderInvoicePO.setFscOrderId(reqBO.getFscOrderId());
        List fscOrderInvoiceList = this.fscOrderInvoiceMapper.getList(fscOrderInvoicePO);
        if (!CollectionUtils.isEmpty((Collection)fscOrderInvoiceList)) {
            fscOrderInvoicePO = (BkFscOrderInvoicePO)fscOrderInvoiceList.get(0);
            fscComOrderListBO.setAccountSetId(fscOrderInvoicePO.getAccountSetId());
            fscComOrderListBO.setBuyName(fscOrderInvoicePO.getBuyName());
            fscComOrderListBO.setSignTime(fscOrderInvoicePO.getSignTime());
            fscComOrderListBO.setBillTime(fscOrderInvoicePO.getBillTime());
            fscComOrderListBO.setSignOperName(fscOrderInvoicePO.getSignOperName());
            fscComOrderListBO.setInvoiceCategory(fscOrderInvoicePO.getInvoiceCategory());
            fscComOrderListBO.setInvoiceType(fscOrderInvoicePO.getInvoiceType());
            fscComOrderListBO.setAccountSetName(fscOrderInvoicePO.getAccountSetName());
            Map InvoiceCategoryMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_CATEGORY");
            Map invoiceTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_TYPE");
            if (!StringUtils.isEmpty((Object)fscComOrderListBO.getInvoiceCategory())) {
                fscComOrderListBO.setInvoiceCategoryStr((String)InvoiceCategoryMap.get(String.valueOf(fscComOrderListBO.getInvoiceCategory())));
            }
            if (!StringUtils.isEmpty((Object)fscComOrderListBO.getInvoiceType())) {
                fscComOrderListBO.setInvoiceTypeStr((String)invoiceTypeMap.get(fscComOrderListBO.getInvoiceType()));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)fscInvoicePOS)) {
            ArrayList<Long> mailIdList = new ArrayList<Long>(fscInvoicePOS.size());
            ArrayList<String> invoiceNoList = new ArrayList<String>(fscInvoicePOS.size());
            ArrayList<String> invoiceCodeList = new ArrayList<String>(fscInvoicePOS.size());
            ArrayList<String> billDate = new ArrayList<String>(fscInvoicePOS.size());
            for (Object fscInvoicePO : fscInvoicePOS) {
                totalChargeBill = totalChargeBill.add(fscInvoicePO.getAmt());
                mailIdList.add(fscInvoicePO.getMailId());
                invoiceNoList.add(fscInvoicePO.getInvoiceNo());
                invoiceCodeList.add(fscInvoicePO.getInvoiceCode());
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)fscInvoicePO.getBillDate())) continue;
                billDate.add(fscInvoicePO.getBillDate());
            }
            fscComOrderListBO.setTotalChargeBill(totalChargeBill);
            if (fscOrderPO.getTotalCharge().compareTo(fscComOrderListBO.getTotalChargeBill()) == 0) {
                fscComOrderListBO.setInvoiceFlag("0");
            } else {
                fscComOrderListBO.setInvoiceFlag("1");
            }
            fscComOrderListBO.setInvoiceNo((String)invoiceNoList.get(0));
            fscComOrderListBO.setInvoiceCode((String)invoiceCodeList.get(0));
            fscComOrderListBO.setBillDate((String)billDate.get(0));
            List InvoicePostPOList = this.fscInvoicePostMapper.getListByIds(mailIdList);
            if (!CollectionUtils.isEmpty((Collection)InvoicePostPOList)) {
                ArrayList<String> sendInfoStr = new ArrayList<String>(InvoicePostPOList.size());
                for (BkFscInvoicePostPO fscInvoicePostPO : InvoicePostPOList) {
                    String sendCompany = fscInvoicePostPO.getSendCompany();
                    String sendOrder = fscInvoicePostPO.getSendOrder();
                    if (!StringUtils.isEmpty((Object)sendCompany) && !StringUtils.isEmpty((Object)sendOrder)) {
                        sendInfoStr.add(sendCompany + "," + sendOrder);
                        fscComOrderListBO.setMailFlag("0");
                        continue;
                    }
                    if (!FscConstants.InvoiceCategory.PAPER.equals(fscOrderInvoicePO.getInvoiceCategory())) continue;
                    fscComOrderListBO.setMailFlag("1");
                }
                fscComOrderListBO.setSendInfoStr(sendInfoStr);
            }
        }
        ArrayList inspectionOper = new ArrayList();
        ArrayList receiverName = new ArrayList();
        ArrayList purPlaceOrderName = new ArrayList();
        ArrayList orderNos = new ArrayList();
        if ((FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(fscOrderPO.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(fscOrderPO.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(fscOrderPO.getOrderFlow())) && !CollectionUtils.isEmpty(orderIdList) || !CollectionUtils.isEmpty(acceptOrderIdList)) {
            // empty if block
        }
        if (fscComOrderListBO.getBillCycle() != null) {
            fscComOrderListBO.setBillCycleStr(fscComOrderListBO.getBillCycle() + "\u4e2a\u81ea\u7136\u65e5");
        }
        fscComOrderListBO.setOrderFlowStr(Objects.requireNonNull(FscOrderFlowEnum.getInstance((Integer)fscComOrderListBO.getOrderFlow())).getDescr());
        fscComOrderListBO.setBusiCategoryStr((String)busiCategoryMap.get(fscComOrderListBO.getBusiCategory() + ""));
        fscComOrderListBO.setBuildActionStr((String)buildActionMap.get(fscComOrderListBO.getBuildAction() + ""));
        fscComOrderListBO.setOrderStateStr((String)orderStateMap.get(fscComOrderListBO.getOrderState() + ""));
        fscComOrderListBO.setShouldPayTypeStr((String)shouldPayTypeMap.get(fscComOrderListBO.getShouldPayType() + ""));
        fscComOrderListBO.setOrderSourceStr((String)orderSourceMap.get(fscComOrderListBO.getOrderSource() + ""));
        fscComOrderListBO.setPayTypeStr((String)payTypeMap.get(fscComOrderListBO.getPayType() + ""));
        fscComOrderListBO.setAttachmentList(attUrls);
        fscComOrderListBO.setPayEvidenceUrls(attUrls);
        BkFscOrderItemPO bkFscOrderItemPO = new BkFscOrderItemPO();
        bkFscOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
        bkFscOrderItemPO.setPayFlag("0");
        BigDecimal payMoney = BigDecimal.ZERO;
        payMoney = this.bkFscOrderItemMapper.getPayMoneyTotal(bkFscOrderItemPO);
        if (payMoney == null) {
            fscComOrderListBO.setTotalPayCharge(BigDecimal.ZERO);
        } else {
            fscComOrderListBO.setTotalPayCharge(payMoney);
        }
        bkFscOrderItemPO = new BkFscOrderItemPO();
        bkFscOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
        bkFscOrderItemPO.setRefundFlag("0");
        BigDecimal returnMoney = BigDecimal.ZERO;
        returnMoney = this.bkFscOrderItemMapper.getReturnMoneyTotal(bkFscOrderItemPO);
        if (returnMoney == null) {
            fscComOrderListBO.setTotalReturnCharge(BigDecimal.ZERO);
        } else {
            fscComOrderListBO.setTotalReturnCharge(returnMoney);
        }
        BkFscOrderItemPO fscOrderItemPO = new BkFscOrderItemPO();
        fscOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
        Integer unPayItemInfoCount = this.bkFscOrderItemMapper.getUnPayItemInfoCount(fscOrderItemPO);
        if (unPayItemInfoCount > 0) {
            fscComOrderListBO.setPayFlag("1");
        } else {
            fscComOrderListBO.setPayFlag("0");
        }
        fscComOrderListBO.setRespCode("0000");
        fscComOrderListBO.setRespDesc("\u6210\u529f");
        return fscComOrderListBO;
    }

    private FscPebExtOrdStatisticRspBO qryYearOrdInfo(Long supId, Integer searchType, String effTime, String expTime) {
        FscPebExtOrdStatisticReqBO fscPebExtOrdStatisticReqBO = new FscPebExtOrdStatisticReqBO();
        fscPebExtOrdStatisticReqBO.setSupNo(supId.toString());
        fscPebExtOrdStatisticReqBO.setSearchType(searchType);
        fscPebExtOrdStatisticReqBO.setCreateTimeEff(effTime);
        fscPebExtOrdStatisticReqBO.setCreateTimeExp(expTime);
        FscPebExtOrdStatisticRspBO fscPebExtOrdStatisticRspBO = this.fscPebExtOrdStatisticAbilityService.queryOrdStatisticInfo(fscPebExtOrdStatisticReqBO);
        if (!"0000".equals(fscPebExtOrdStatisticRspBO.getRespCode())) {
            throw new FscBusinessException("193111", fscPebExtOrdStatisticRspBO.getRespDesc());
        }
        return fscPebExtOrdStatisticRspBO;
    }

    private void validateParams(BkFscComOrderListQueryBusiReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u3010reqBO\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getFscOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u3010fscOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0L == reqBO.getFscOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u3010fscOrderId\u3011\u4e0d\u80fd\u4e3a0");
        }
    }

    private String translatePayStageStr(List<Integer> payStageList) {
        if (CollectionUtils.isEmpty(payStageList)) {
            return "";
        }
        ArrayList<String> payStageStr = new ArrayList<String>();
        for (Integer payStage : payStageList) {
            if (FscExtConstants.FSC_PAY_STAGE.PRE.equals(payStage)) {
                payStageStr.add("\u9884\u4ed8\u6b3e");
                continue;
            }
            if (FscExtConstants.FSC_PAY_STAGE.SEND.equals(payStage)) {
                payStageStr.add("\u53d1\u8d27\u6b3e");
                continue;
            }
            if (FscExtConstants.FSC_PAY_STAGE.ARRIVE.equals(payStage)) {
                payStageStr.add("\u5230\u8d27\u9a8c\u6536");
                continue;
            }
            if (FscExtConstants.FSC_PAY_STAGE.INSTALL.equals(payStage)) {
                payStageStr.add("\u5b89\u88c5\u9a8c\u6536");
                continue;
            }
            if (FscExtConstants.FSC_PAY_STAGE.COMPLETE.equals(payStage)) {
                payStageStr.add("\u7ae3\u5de5\u9a8c\u6536");
                continue;
            }
            if (!FscExtConstants.FSC_PAY_STAGE.QUALITY.equals(payStage)) continue;
            payStageStr.add("\u8d28\u4fdd\u91d1");
        }
        return org.apache.commons.lang3.StringUtils.join((Object[])payStageStr.toArray(), (String)",");
    }
}

