/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.busi.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscAuditBaseBo;
import com.tydic.fsc.bo.FscOrderPayItemBO;
import com.tydic.fsc.busibase.atom.api.FscAuditOrderCreateAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAuditOrderCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAuditOrderCreateAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.busi.api.FscPayBillUpdateBusiService;
import com.tydic.fsc.pay.busi.bo.FscPayBillUpdateBusiReqBO;
import com.tydic.fsc.pay.busi.bo.FscPayBillUpdateBusiRspBO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscShouldPayPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscPayBillUpdateBusiServiceImpl
implements FscPayBillUpdateBusiService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscAuditOrderCreateAtomService fscAuditOrderCreateAtomService;
    @Value(value="${no.need.audit.key :noNeedAudit}")
    private String noNeedAudit;

    @Override
    public FscPayBillUpdateBusiRspBO dealPayBillUpdate(FscPayBillUpdateBusiReqBO busiReqBO) {
        FscOrderPO set = new FscOrderPO();
        if (!CollectionUtils.isEmpty(busiReqBO.getFscOrderPayItemBOS())) {
            BigDecimal totalAmount = this.updateShouldPay(busiReqBO);
            set.setTotalCharge(totalAmount);
        }
        set.setPayMethod(busiReqBO.getPayMethod());
        set.setPayChannel(busiReqBO.getPayChannel());
        set.setUpdateOperId(busiReqBO.getUserName());
        set.setUpdateOperName(busiReqBO.getName());
        set.setUpdateTime(new Date());
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderId(busiReqBO.getFscOrderId());
        where.setOrderState(FscConstants.FscPayOrderState.CANCEL);
        int count = this.fscOrderMapper.updateBy(set, where);
        if (count != 1) {
            throw new FscBusinessException("193204", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u4e0d\u5b58\u5728\u6216\u72b6\u6001\u4e0d\u662f\u8349\u7a3f\u72b6\u6001");
        }
        FscPayBillUpdateBusiRspBO busiRspBO = new FscPayBillUpdateBusiRspBO();
        this.invokeFscOrderStatusFlow(busiReqBO, busiRspBO);
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u4fee\u6539\u6210\u529f");
        return busiRspBO;
    }

    private BigDecimal updateShouldPay(FscPayBillUpdateBusiReqBO busiReqBO) {
        BigDecimal totalAmount = new BigDecimal(0);
        ArrayList<FscOrderPayItemPO> fscOrderPayItemPOs = new ArrayList<FscOrderPayItemPO>();
        Date now = new Date();
        for (FscOrderPayItemBO fscOrderPayItemBO : busiReqBO.getFscOrderPayItemBOS()) {
            FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
            fscShouldPayPO.setShouldPayId(fscOrderPayItemBO.getShouldPayId());
            fscShouldPayPO.setPayAmount(fscOrderPayItemBO.getPayAmount());
            fscShouldPayPO.setUpdateTime(now);
            fscShouldPayPO.setUpdateOperId(Convert.toStr((Object)busiReqBO.getUserId()));
            fscShouldPayPO.setUpdateOperName(busiReqBO.getName());
            int count1 = this.fscShouldPayMapper.updateAmount(fscShouldPayPO);
            if (count1 != 1) {
                throw new FscBusinessException("193204", "\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u5f85\u4ed8\u91d1\u989d\uff01");
            }
            FscOrderPayItemPO po = new FscOrderPayItemPO();
            po.setFscOrderId(busiReqBO.getFscOrderId());
            po.setOrderPayItemId(Long.valueOf(Sequence.getInstance().nextId()));
            po.setShouldPayId(fscOrderPayItemBO.getShouldPayId());
            po.setPayAmount(fscOrderPayItemBO.getPayAmount());
            fscOrderPayItemPOs.add(po);
            totalAmount = totalAmount.add(fscOrderPayItemBO.getPayAmount());
        }
        FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
        fscOrderPayItemPO.setFscOrderId(busiReqBO.getFscOrderId());
        this.fscOrderPayItemMapper.deleteBy(fscOrderPayItemPO);
        this.fscOrderPayItemMapper.insertBatch(fscOrderPayItemPOs);
        return totalAmount;
    }

    private void invokeFscOrderStatusFlow(FscPayBillUpdateBusiReqBO busiReqBO, FscPayBillUpdateBusiRspBO busiRspBO) {
        FscOrderStatusFlowAtomRspBO atomRspBO;
        String createFscProcessKey = "FSC_PAY_AUDIT";
        Long fscOrderId = busiReqBO.getFscOrderId();
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        if (this.noNeedAudit.equals(createFscProcessKey)) {
            paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag2);
        } else {
            paramMap.put("auditFlag", FscConstants.ProcessParam.auditFlag);
            FscAuditOrderCreateAtomReqBO fscAuditOrderCreateAtomReqBO = new FscAuditOrderCreateAtomReqBO();
            fscAuditOrderCreateAtomReqBO.setOrderId(fscOrderId);
            fscAuditOrderCreateAtomReqBO.setObjId(fscOrderId);
            fscAuditOrderCreateAtomReqBO.setObjType(FscConstants.OBJ_TYPE.FSC_ORDER);
            fscAuditOrderCreateAtomReqBO.setObjBusiType(FscConstants.AuditObjType.PAY_APPLY_ORDER);
            fscAuditOrderCreateAtomReqBO.setUserId(busiReqBO.getUserId());
            fscAuditOrderCreateAtomReqBO.setUserName(busiReqBO.getName());
            atomRspBO = this.fscAuditOrderCreateAtomService.dealAuditOrderCreate(fscAuditOrderCreateAtomReqBO);
            this.startAuditFlow(fscOrderId, createFscProcessKey, (FscAuditOrderCreateAtomRspBO)atomRspBO, busiRspBO);
        }
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = (FscOrderStatusFlowAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiReqBO)), FscOrderStatusFlowAtomReqBO.class);
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        fscOrderStatusFlowAtomReqBO.setCurStatus(FscConstants.FscPayOrderState.CANCEL);
        fscOrderStatusFlowAtomReqBO.setOrderId(busiReqBO.getFscOrderId());
        atomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new FscBusinessException("193204", atomRspBO.getRespDesc());
        }
    }

    private void startAuditFlow(Long fscOrderId, String createFscProcessKey, FscAuditOrderCreateAtomRspBO atomRspBO, FscPayBillUpdateBusiRspBO rspBO) {
        FscAuditBaseBo fscAuditBaseBo = new FscAuditBaseBo();
        fscAuditBaseBo.setProcDefKey(createFscProcessKey);
        fscAuditBaseBo.setPartitionKey(fscOrderId.toString());
        HashMap<String, Long> variables = new HashMap<String, Long>();
        variables.put("auditId", atomRspBO.getAuditOrderId());
        fscAuditBaseBo.setVariables(variables);
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(fscOrderId.toString());
        fscAuditBaseBo.setBusinessIdList(strings);
        rspBO.setIsStartAuditFlow(true);
        rspBO.setFscAuditBaseBo(fscAuditBaseBo);
    }
}

