/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.zone.agr.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.cfc.ability.api.CfcParamConfigAbilityService;
import com.tydic.cfc.ability.bo.CfcParamConfigBO;
import com.tydic.cfc.ability.bo.CfcParamConfigItemBO;
import com.tydic.cfc.ability.bo.CfcQryParamConfigDetailAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcQryParamConfigDetailAbilityRspBO;
import com.tydic.commodity.zone.ability.api.UccAgrSkuImportCheckAbilityService;
import com.tydic.commodity.zone.ability.bo.UccAgrSkuImportCheckAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccAgrSkuImportCheckAbilityRspBO;
import com.tydic.commodity.zone.ability.bo.UccAgrSkuImportCheckBO;
import com.tydic.dyc.agr.service.agr.AgrGetAgrItemListService;
import com.tydic.dyc.agr.service.agr.AgrGetAgrMainService;
import com.tydic.dyc.agr.service.agr.AgrUpdateAgrMainService;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainRspBo;
import com.tydic.dyc.agr.service.agr.bo.AgrItemDetailBo;
import com.tydic.dyc.agr.service.agr.bo.AgrUpdateAgrMainReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrUpdateAgrMainRspBO;
import com.tydic.dyc.agr.service.agrchange.AgrCreateAgrItemChngService;
import com.tydic.dyc.agr.service.agrchange.AgrCreateArgChngApplyService;
import com.tydic.dyc.agr.service.agrchange.AgrCreateArgMainChngService;
import com.tydic.dyc.agr.service.agrchange.AgrGetAgrChngCodeService;
import com.tydic.dyc.agr.service.agrchange.bo.AgrAppScopeChngBo;
import com.tydic.dyc.agr.service.agrchange.bo.AgrCreateAgrItemChngReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrCreateAgrItemChngRspBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrCreateArgChngApplyReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrCreateArgChngApplyRspBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrCreateArgMainChngReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrCreateArgMainChngRspBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrChngCodeReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrChngCodeRspBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrMainChngBo;
import com.tydic.dyc.agr.service.agrchange.bo.AgrPayConfigChngBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.domainservice.AgrSyncUccService;
import com.tydic.dyc.agr.service.domainservice.bo.AgrSyncUccReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrSyncUccRspBO;
import com.tydic.dyc.atom.base.constants.DycFuncCommonConstants;
import com.tydic.dyc.atom.zone.agr.api.DycAgrAgrChngImportFunction;
import com.tydic.dyc.atom.zone.agr.bo.DycAgrAgrChngImportFuncBO;
import com.tydic.dyc.atom.zone.agr.bo.DycAgrAgrChngImportFuncReqBO;
import com.tydic.dyc.atom.zone.agr.bo.DycAgrAgrChngImportFuncRspBO;
import com.tydic.dyc.atom.zone.agr.bo.DycAgrItemChngFuncBO;
import com.tydic.dyc.atom.zone.agr.bo.DycCommonImportFailReasonFuncBO;
import com.tydic.dyc.umc.service.supplieraccess.api.UmcSupplierInfoQryDetailService;
import com.tydic.dyc.umc.service.supplieraccess.bo.UmcEnterpriseInfoAccessBO;
import com.tydic.dyc.umc.service.supplieraccess.bo.UmcSupplierInfoQryDetailReqBO;
import com.tydic.dyc.umc.service.supplieraccess.bo.UmcSupplierInfoQryDetailRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DycAgrAgrChngImportFunctionImpl
implements DycAgrAgrChngImportFunction {
    @Autowired
    private UccAgrSkuImportCheckAbilityService uccAgrSkuImportCheckAbilityService;
    @Autowired
    private AgrCreateAgrItemChngService agrCreateAgrItemChngService;
    @Autowired
    private AgrCreateArgMainChngService agrCreateArgMainChngService;
    @Autowired
    private AgrCreateArgChngApplyService agrCreateArgChngApplyService;
    @Autowired
    private AgrUpdateAgrMainService agrUpdateAgrMainService;
    @Autowired
    private AgrSyncUccService agrSyncUccService;
    @Autowired
    private AgrGetAgrChngCodeService agrGetAgrChngCodeService;
    @Autowired
    AgrGetAgrItemListService agrGetAgrItemListService;
    @Autowired
    private UmcSupplierInfoQryDetailService umcSupplierInfoQryDetailService;
    @Autowired
    private AgrGetAgrMainService agrGetAgrMainService;
    @Autowired
    private CfcParamConfigAbilityService cfcParamConfigAbilityService;

    @Override
    public DycAgrAgrChngImportFuncRspBO dealAgrChngImport(DycAgrAgrChngImportFuncReqBO reqBO) {
        Integer salePriceGreateRule = this.dealSalePriceGreateRule();
        ArrayList<DycCommonImportFailReasonFuncBO> failReasonBOs = new ArrayList<DycCommonImportFailReasonFuncBO>();
        if (ObjectUtil.isNotEmpty(reqBO.getAgrChng())) {
            this.importAgrChng(salePriceGreateRule, failReasonBOs, reqBO);
        }
        if (ObjectUtil.isNotEmpty(reqBO.getAgrItemChng())) {
            this.importAgrItemChng(salePriceGreateRule, failReasonBOs, reqBO);
        }
        DycAgrAgrChngImportFuncRspBO rspBO = new DycAgrAgrChngImportFuncRspBO();
        rspBO.setFailReasonList(failReasonBOs);
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void importAgrItemChng(Integer salePriceGreateRule, List<DycCommonImportFailReasonFuncBO> failReasonBOs, DycAgrAgrChngImportFuncReqBO reqBO) {
        HashMap<Integer, String> lineErrorMsgMap = new HashMap<Integer, String>();
        AgrGetAgrMainReqBo agrGetAgrMainReqBo = new AgrGetAgrMainReqBo();
        agrGetAgrMainReqBo.setAgrId(reqBO.getAgrId());
        AgrGetAgrMainRspBo agrMain = this.agrGetAgrMainService.getAgrMain(agrGetAgrMainReqBo);
        if (!"0000".equals(agrMain.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u534f\u8bae\u4e3b\u4f53\u8be6\u60c5\u67e5\u8be2\u5931\u8d25\uff01\u5f02\u5e38\u7f16\u7801\u3010" + agrMain.getRespCode() + "\u3011," + agrMain.getRespDesc());
        }
        if (agrMain == null) {
            throw new ZTBusinessException("\u534f\u8bae\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (AgrCommConstant.AgreementChangeType.CHANGE_PRICE.equals(reqBO.getChngType())) {
            this.agrItemAdjustPriceTranslate(salePriceGreateRule, agrMain.getTradeMode(), reqBO.getAgrItemChng(), lineErrorMsgMap);
            this.validChngPrice(reqBO.getAgrItemChng(), reqBO.getAgrId(), lineErrorMsgMap);
        } else {
            this.agrItemAddTranslate(salePriceGreateRule, agrMain.getTradeMode(), reqBO.getAgrItemChng(), lineErrorMsgMap);
            this.uccCheck(reqBO.getAgrItemChng(), lineErrorMsgMap);
            this.validPuplicate(reqBO.getAgrItemChng(), lineErrorMsgMap, reqBO.getAgrId());
        }
        if (lineErrorMsgMap.size() > 0) {
            lineErrorMsgMap.forEach((k, v) -> {
                DycCommonImportFailReasonFuncBO bo = new DycCommonImportFailReasonFuncBO();
                bo.setFailReason("\u534f\u8bae\u660e\u7ec6\u884c\u3010" + k + "\u3011" + v.substring(1));
                bo.setLineNum((Integer)k);
                failReasonBOs.add(bo);
            });
        }
        if (failReasonBOs.size() == 0) {
            this.saveAgrItemChng(reqBO);
        }
    }

    private Integer dealSalePriceGreateRule() {
        CfcParamConfigBO bo;
        Integer salePriceGreateRule = 1;
        CfcQryParamConfigDetailAbilityReqBO abilityReqBO = new CfcQryParamConfigDetailAbilityReqBO();
        abilityReqBO.setParamConfigCode("agr_base_param");
        CfcQryParamConfigDetailAbilityRspBO cfcQryParamConfigDetailAbilityRspBO = this.cfcParamConfigAbilityService.qryParamConfigDetail(abilityReqBO);
        if (ObjectUtil.isNotEmpty((Object)cfcQryParamConfigDetailAbilityRspBO.getParamConfigBO()) && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(bo = cfcQryParamConfigDetailAbilityRspBO.getParamConfigBO()).getParamConfigItemList())) {
            for (CfcParamConfigItemBO cfcParamConfigItemBO : bo.getParamConfigItemList()) {
                if (!"agr_sale_price_rule".equals(cfcParamConfigItemBO.getItemCode())) continue;
                salePriceGreateRule = Integer.parseInt(cfcParamConfigItemBO.getItemValue());
            }
        }
        return salePriceGreateRule;
    }

    private void importAgrChng(Integer salePriceGreateRule, List<DycCommonImportFailReasonFuncBO> failReasonBOs, DycAgrAgrChngImportFuncReqBO reqBO) {
        for (DycAgrAgrChngImportFuncBO dycAgrAgrChngImportFuncBO2 : reqBO.getAgrChng()) {
            HashMap<Integer, String> itemlineErrorMsgMap = new HashMap<Integer, String>();
            Integer gluttonLineNum = dycAgrAgrChngImportFuncBO2.getGluttonLineNum();
            StringBuilder lineError = new StringBuilder();
            if (dycAgrAgrChngImportFuncBO2.getAgrNo() == null) {
                lineError.append(",\u534f\u8bae\u5e8f\u53f7\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)dycAgrAgrChngImportFuncBO2.getChngTypeStr())) {
                lineError.append(",\u53d8\u66f4\u7c7b\u578b\u4e3a\u7a7a");
            } else {
                dycAgrAgrChngImportFuncBO2.setChngType(AgrCommConstant.AgrChngTypeEnum.getCodeByName((String)dycAgrAgrChngImportFuncBO2.getChngTypeStr()));
                if (dycAgrAgrChngImportFuncBO2.getChngType() == null) {
                    lineError.append(",\u53d8\u66f4\u7c7b\u578b\u8f93\u5165\u9519\u8bef");
                } else if (AgrCommConstant.AgreementChangeType.OTHER.equals(dycAgrAgrChngImportFuncBO2.getChngType())) {
                    if (StringUtils.isEmpty((Object)dycAgrAgrChngImportFuncBO2.getTradeModeStr())) {
                        lineError.append(",\u4ea4\u6613\u6a21\u5f0f\u4e3a\u7a7a");
                    } else {
                        Integer tradeMode = AgrCommConstant.TradeModeEnum.getCodeByName((String)dycAgrAgrChngImportFuncBO2.getTradeModeStr());
                        if (tradeMode == null) {
                            lineError.append(",\u4ea4\u6613\u6a21\u5f0f\u8f93\u5165\u9519\u8bef");
                        } else if (dycAgrAgrChngImportFuncBO2.getAgrMode().equals(AgrCommConstant.agreementMode.UNIT_AGREEMENT)) {
                            if (!dycAgrAgrChngImportFuncBO2.getTradeMode().equals(tradeMode)) {
                                lineError.append(",\u5355\u4f4d\u534f\u8bae\u4ea4\u6613\u6a21\u5f0f\u4e0d\u80fd\u4fee\u6539");
                            }
                        } else {
                            dycAgrAgrChngImportFuncBO2.setTradeMode(tradeMode);
                        }
                    }
                }
            }
            if (StringUtils.isEmpty((Object)dycAgrAgrChngImportFuncBO2.getChngApplyComment())) {
                lineError.append(",\u7533\u8bf7\u8bf4\u660e\u4e3a\u7a7a");
            }
            if (AgrCommConstant.AgreementChangeType.CHANGE_PRICE.equals(dycAgrAgrChngImportFuncBO2.getChngType())) {
                if (CollectionUtils.isEmpty(dycAgrAgrChngImportFuncBO2.getAgrItemChng())) {
                    lineError.append(",\u534f\u8bae\u660e\u7ec6\u4e3a\u7a7a");
                } else {
                    this.agrItemAdjustPriceTranslate(salePriceGreateRule, dycAgrAgrChngImportFuncBO2.getTradeMode(), dycAgrAgrChngImportFuncBO2.getAgrItemChng(), itemlineErrorMsgMap);
                    this.validChngPrice(dycAgrAgrChngImportFuncBO2.getAgrItemChng(), dycAgrAgrChngImportFuncBO2.getAgrId(), itemlineErrorMsgMap);
                }
            }
            if (AgrCommConstant.AgreementChangeType.SUPPLEMENT.equals(dycAgrAgrChngImportFuncBO2.getChngType())) {
                if (CollectionUtils.isEmpty(dycAgrAgrChngImportFuncBO2.getAgrItemChng())) {
                    lineError.append(",\u534f\u8bae\u660e\u7ec6\u4e3a\u7a7a");
                } else {
                    this.agrItemAddTranslate(salePriceGreateRule, dycAgrAgrChngImportFuncBO2.getTradeMode(), dycAgrAgrChngImportFuncBO2.getAgrItemChng(), itemlineErrorMsgMap);
                    this.uccCheck(dycAgrAgrChngImportFuncBO2.getAgrItemChng(), itemlineErrorMsgMap);
                    this.validPuplicate(dycAgrAgrChngImportFuncBO2.getAgrItemChng(), itemlineErrorMsgMap, dycAgrAgrChngImportFuncBO2.getAgrId());
                }
            }
            if (AgrCommConstant.AgreementChangeType.OTHER.equals(dycAgrAgrChngImportFuncBO2.getChngType())) {
                this.agrTransLate(lineError, dycAgrAgrChngImportFuncBO2);
                dycAgrAgrChngImportFuncBO2.setAgrItemChng(null);
            }
            if (AgrCommConstant.AgreementChangeType.DELAY.equals(dycAgrAgrChngImportFuncBO2.getChngType())) {
                if (!dycAgrAgrChngImportFuncBO2.getAgrStatus().equals(AgrCommConstant.AgreementStatus.ENABLE) && !dycAgrAgrChngImportFuncBO2.getAgrStatus().equals(AgrCommConstant.AgreementStatus.BE_OVERDUE)) {
                    lineError.append(",\u534f\u8bae\u5f53\u524d\u72b6\u6001\u4e0d\u652f\u6301\u5ef6\u671f\u53d8\u66f4");
                } else if (StringUtils.isEmpty((Object)dycAgrAgrChngImportFuncBO2.getPostExpDate())) {
                    lineError.append(",\u5ef6\u671f\u540e\u5931\u6548\u65e5\u671f\u4e3a\u7a7a");
                } else {
                    try {
                        DateUtils.strToDate((String)dycAgrAgrChngImportFuncBO2.getPostExpDate(), (String)"yyyy-MM-dd");
                    }
                    catch (Exception e) {
                        lineError.append(",\u5ef6\u671f\u540e\u5931\u6548\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
                    }
                }
                dycAgrAgrChngImportFuncBO2.setAgrItemChng(null);
            }
            if (AgrCommConstant.AgreementChangeType.STOP.equals(dycAgrAgrChngImportFuncBO2.getChngType())) {
                if (!dycAgrAgrChngImportFuncBO2.getAgrStatus().equals(AgrCommConstant.AgreementStatus.ENABLE)) {
                    lineError.append(",\u534f\u8bae\u5f53\u524d\u72b6\u6001\u4e0d\u652f\u6301\u6682\u505c\u53d8\u66f4");
                }
                dycAgrAgrChngImportFuncBO2.setAgrItemChng(null);
            }
            if (AgrCommConstant.AgreementChangeType.START.equals(dycAgrAgrChngImportFuncBO2.getChngType())) {
                if (!dycAgrAgrChngImportFuncBO2.getAgrStatus().equals(AgrCommConstant.AgreementStatus.SUSPEND)) {
                    lineError.append(",\u534f\u8bae\u5f53\u524d\u72b6\u6001\u4e0d\u652f\u6301\u542f\u7528\u53d8\u66f4");
                }
                dycAgrAgrChngImportFuncBO2.setAgrItemChng(null);
            }
            if (AgrCommConstant.AgreementChangeType.TERMINATION.equals(dycAgrAgrChngImportFuncBO2.getChngType())) {
                if (!(dycAgrAgrChngImportFuncBO2.getAgrStatus().equals(AgrCommConstant.AgreementStatus.SUSPEND) || dycAgrAgrChngImportFuncBO2.getAgrStatus().equals(AgrCommConstant.AgreementStatus.ENABLE) || dycAgrAgrChngImportFuncBO2.getAgrStatus().equals(AgrCommConstant.AgreementStatus.BE_OVERDUE))) {
                    lineError.append(",\u534f\u8bae\u5f53\u524d\u72b6\u6001\u4e0d\u652f\u6301\u7ec8\u6b62\u53d8\u66f4");
                }
                dycAgrAgrChngImportFuncBO2.setAgrItemChng(null);
            }
            if (lineError.length() <= 0 && itemlineErrorMsgMap.size() <= 0) continue;
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append("\u534f\u8bae\u4e3b\u4f53\u4fe1\u606f\u884c\u3010" + dycAgrAgrChngImportFuncBO2.getGluttonLineNum() + "\u3011");
            if (lineError.length() > 0) {
                String mainError = lineError.toString().substring(1);
                errorMsg.append(mainError);
            }
            if (itemlineErrorMsgMap.size() > 0) {
                itemlineErrorMsgMap.forEach((k, v) -> {
                    String itemError = v.substring(1);
                    errorMsg.append("\u534f\u8bae\u660e\u7ec6\u884c\u3010" + k + "\u3011\u7684\u660e\u7ec6\u9879" + itemError);
                });
            }
            DycCommonImportFailReasonFuncBO bo = new DycCommonImportFailReasonFuncBO();
            bo.setFailReason(errorMsg.toString());
            bo.setLineNum(gluttonLineNum);
            failReasonBOs.add(bo);
        }
        if (failReasonBOs.size() == 0) {
            reqBO.getAgrChng().forEach(dycAgrAgrChngImportFuncBO -> {
                AgrGetAgrChngCodeReqBO agrGetAgrChngCodeReqBO = (AgrGetAgrChngCodeReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), AgrGetAgrChngCodeReqBO.class);
                agrGetAgrChngCodeReqBO.setChangeType(dycAgrAgrChngImportFuncBO.getChngType());
                agrGetAgrChngCodeReqBO.setPlaAgreementCode(dycAgrAgrChngImportFuncBO.getAgrCode());
                AgrGetAgrChngCodeRspBO agrGetAgrChngCodeRspBO = this.agrGetAgrChngCodeService.getAgrChngCode(agrGetAgrChngCodeReqBO);
                if (!"0000".equals(agrGetAgrChngCodeRspBO.getRespCode())) {
                    throw new ZTBusinessException(agrGetAgrChngCodeRspBO.getRespDesc());
                }
                dycAgrAgrChngImportFuncBO.setChngApplyNo(agrGetAgrChngCodeRspBO.getChngApplyNo());
                dycAgrAgrChngImportFuncBO.setChngApplyId(agrGetAgrChngCodeRspBO.getChngApplyId());
                this.saveAgrChng((DycAgrAgrChngImportFuncBO)dycAgrAgrChngImportFuncBO, reqBO);
                if (dycAgrAgrChngImportFuncBO.getChngType().equals(AgrCommConstant.AgreementChangeType.STOP)) {
                    this.updateAgr(dycAgrAgrChngImportFuncBO.getAgrId(), AgrCommConstant.AgreementStatus.FROZEN);
                    this.syncUcc(dycAgrAgrChngImportFuncBO.getAgrId(), null, AgrCommConstant.SyncType.FROZEN);
                }
                if (dycAgrAgrChngImportFuncBO.getChngType().equals(AgrCommConstant.AgreementChangeType.CHANGE_PRICE)) {
                    this.updateAgr(dycAgrAgrChngImportFuncBO.getAgrId(), AgrCommConstant.AgreementStatus.FROZEN);
                    this.syncUcc(dycAgrAgrChngImportFuncBO.getAgrId(), null, AgrCommConstant.SyncType.FROZEN);
                }
            });
        }
    }

    private void agrTransLate(StringBuilder lineError, DycAgrAgrChngImportFuncBO agrMain) {
        Integer gluttonLineNum = agrMain.getGluttonLineNum();
        if (gluttonLineNum != null) {
            BigDecimal temp2;
            BigDecimal temp1;
            if (StringUtils.isEmpty((Object)agrMain.getEffDate())) {
                lineError.append(",\u751f\u6548\u65e5\u671f\u4e3a\u7a7a");
            } else {
                try {
                    DateUtils.strToDate((String)agrMain.getEffDate(), (String)"yyyy-MM-dd");
                }
                catch (Exception e) {
                    lineError.append(",\u751f\u6548\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
                }
            }
            if (StringUtils.isEmpty((Object)agrMain.getExpDate())) {
                lineError.append(",\u5931\u6548\u65e5\u671f\u4e3a\u7a7a");
            } else {
                try {
                    DateUtils.strToDate((String)agrMain.getExpDate(), (String)"yyyy-MM-dd");
                }
                catch (Exception e) {
                    lineError.append(",\u5931\u6548\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
                }
            }
            if (StringUtils.isEmpty((Object)agrMain.getTradeModeStr())) {
                lineError.append(",\u4ea4\u6613\u6a21\u5f0f\u4e3a\u7a7a");
            } else {
                agrMain.setTradeMode(AgrCommConstant.TradeModeEnum.getCodeByName((String)agrMain.getTradeModeStr()));
                if (agrMain.getTradeMode() == null) {
                    lineError.append(",\u4ea4\u6613\u6a21\u5f0f\u8f93\u5165\u9519\u8bef");
                }
            }
            if (StringUtils.isEmpty((Object)agrMain.getSupplierContact())) {
                lineError.append(",\u4f9b\u5e94\u5546\u8054\u7cfb\u4eba\u7a7a");
            }
            if (StringUtils.isEmpty((Object)agrMain.getSupplierPhone())) {
                lineError.append(",\u4f9b\u5e94\u5546\u8054\u7cfb\u7535\u8bdd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)agrMain.getPayTypeSupStr())) {
                lineError.append(",\u4ed8\u6b3e\u65b9\u5f0f\uff08\u5bf9\u4f9b\u5e94\u5546\uff09\u4e3a\u7a7a");
            } else {
                agrMain.setPayTypeSup(AgrCommConstant.PayTypeEnum.getCodeByName((String)agrMain.getPayTypeSupStr()));
                if (agrMain.getPayTypeSup() == null) {
                    lineError.append(",\u5bf9\u4f9b\u5e94\u5546\u4ed8\u6b3e\u65b9\u5f0f\u8f93\u5165\u9519\u8bef");
                } else if (agrMain.getPayTypeSup().equals(AgrCommConstant.PayTypeEnum.PAY_TYPE_PAYMENT_DAYS.getValue())) {
                    if (StringUtils.isEmpty((Object)agrMain.getAssignSupStr())) {
                        lineError.append(",\u671f\u671b\u7ed3\u7b97\u65b9\u5f0f\uff08\u5bf9\u4f9b\u5e94\u5546\uff09\u4e3a\u7a7a");
                    } else {
                        agrMain.setAssignSup(AgrCommConstant.AssignEnum.getCodeByName((String)agrMain.getAssignSupStr()));
                        if (agrMain.getAssignSup() == null) {
                            lineError.append(",\u671f\u671b\u7ed3\u7b97\u65b9\u5f0f\uff08\u5bf9\u4f9b\u5e94\u5546\uff09\u8f93\u5165\u9519\u8bef");
                        } else if (agrMain.getAssignSup().equals(AgrCommConstant.Assign.FINISHED.toString())) {
                            if (StringUtils.isEmpty((Object)agrMain.getBusiNodeSupStr())) {
                                lineError.append(",\u8d26\u671f\u8d77\u7b97\u7279\u5b9a\u4e1a\u52a1\u8282\u70b9\uff08\u5bf9\u4f9b\u5e94\u5546\uff09\u4e3a\u7a7a");
                            } else {
                                agrMain.setBusiNodeSup(AgrCommConstant.NoAssign.getCodeByName((String)agrMain.getBusiNodeSupStr()));
                                if (agrMain.getBusiNodeSup() == null) {
                                    lineError.append(",\u8d26\u671f\u8d77\u7b97\u7279\u5b9a\u4e1a\u52a1\u8282\u70b9\uff08\u5bf9\u4f9b\u5e94\u5546\uff09\u8f93\u5165\u9519\u8bef");
                                }
                                if (StringUtils.isEmpty((Object)agrMain.getPaymentDaysSup())) {
                                    lineError.append(",\u8d26\u671f\u5929\u6570\uff08\u5bf9\u4f9b\u5e94\u5546\uff09\u4e3a\u7a7a");
                                } else {
                                    agrMain.setSettlementDateSup(agrMain.getPaymentDaysSup());
                                }
                            }
                        } else if (StringUtils.isEmpty((Object)agrMain.getOrderRuleNodeSupStr())) {
                            lineError.append(",\u8d26\u671f\u65e5\u7ed3\u7b97\u8ba2\u5355\u89c4\u5219\uff08\u5bf9\u4f9b\u5e94\u5546\uff09\u4e3a\u7a7a");
                        } else {
                            agrMain.setBusiNodeSup(AgrCommConstant.IsAssign.getCodeByName((String)agrMain.getOrderRuleNodeSupStr()));
                            if (agrMain.getBusiNodeSup() == null) {
                                lineError.append(",\u8d26\u671f\u65e5\u7ed3\u7b97\u8ba2\u5355\u89c4\u5219\uff08\u5bf9\u4f9b\u5e94\u5546\uff09\u8f93\u5165\u9519\u8bef");
                            }
                            if (StringUtils.isEmpty((Object)agrMain.getSettlementDateSup())) {
                                lineError.append(",\u6bcf\u6708\u7ed3\u7b97\u65e5\uff08\u5bf9\u4f9b\u5e94\u5546\uff09\u4e3a\u7a7a");
                            }
                        }
                    }
                } else if (agrMain.getPayTypeSup().equals(AgrCommConstant.PayTypeEnum.PAY_TYPE_SUBLEVEL.getValue()) && (temp1 = new BigDecimal(100)).compareTo(temp2 = new BigDecimal(0).add(agrMain.getPrePaySup()).add(agrMain.getMatPaySup()).add(agrMain.getVerPaySup()).add(agrMain.getQuaPaySup())) != 0) {
                    lineError.append(",\u9884\u4ed8\u6b3e\u3001\u5230\u8d27\u6b3e\u3001\u9a8c\u6536\u6846\u3001\u8d28\u4fdd\u91d1\uff08\u5bf9\u4f9b\u5e94\u5546\uff09\u4e0d\u4e3a100");
                }
            }
            if (agrMain.getTradeMode() != null && agrMain.getTradeMode().equals(AgrCommConstant.TradeModeEnum.TRADE_MODE_BUYING_AND_SELLING.getValue())) {
                if (StringUtils.isEmpty((Object)agrMain.getPayTypePurStr())) {
                    lineError.append(",\u4ed8\u6b3e\u65b9\u5f0f\uff08\u5bf9\u91c7\u8d2d\u5546\uff09\u4e3a\u7a7a");
                } else {
                    agrMain.setPayTypePur(AgrCommConstant.PayTypeEnum.getCodeByName((String)agrMain.getPayTypePurStr()));
                    if (agrMain.getPayTypePur() == null) {
                        lineError.append(",\u5bf9\u91c7\u8d2d\u5546\u4ed8\u6b3e\u65b9\u5f0f\u8f93\u5165\u9519\u8bef");
                    } else if (agrMain.getPayTypePur().equals(AgrCommConstant.PayTypeEnum.PAY_TYPE_PAYMENT_DAYS.getValue())) {
                        if (StringUtils.isEmpty((Object)agrMain.getAssignPurStr())) {
                            lineError.append(",\u671f\u671b\u7ed3\u7b97\u65b9\u5f0f\uff08\u5bf9\u91c7\u8d2d\u5546\uff09\u4e3a\u7a7a");
                        } else {
                            agrMain.setAssignPur(AgrCommConstant.AssignEnum.getCodeByName((String)agrMain.getAssignPurStr()));
                            if (agrMain.getAssignPur() == null) {
                                lineError.append(",\u671f\u671b\u7ed3\u7b97\u65b9\u5f0f\uff08\u5bf9\u91c7\u8d2d\u5546\uff09\u8f93\u5165\u9519\u8bef");
                            } else if (agrMain.getAssignPur().equals(AgrCommConstant.Assign.FINISHED.toString())) {
                                if (StringUtils.isEmpty((Object)agrMain.getBusiNodePurStr())) {
                                    lineError.append(",\u8d26\u671f\u8d77\u7b97\u7279\u5b9a\u4e1a\u52a1\u8282\u70b9\uff08\u5bf9\u91c7\u8d2d\u5546\uff09\u4e3a\u7a7a");
                                } else {
                                    agrMain.setBusiNodePur(AgrCommConstant.NoAssign.getCodeByName((String)agrMain.getBusiNodePurStr()));
                                    if (agrMain.getBusiNodePur() == null) {
                                        lineError.append(",\u8d26\u671f\u8d77\u7b97\u7279\u5b9a\u4e1a\u52a1\u8282\u70b9\uff08\u5bf9\u91c7\u8d2d\u5546\uff09\u8f93\u5165\u9519\u8bef");
                                    }
                                    if (StringUtils.isEmpty((Object)agrMain.getPaymentDaysPur())) {
                                        lineError.append(",\u8d26\u671f\u5929\u6570\uff08\u5bf9\u91c7\u8d2d\u5546\uff09\u4e3a\u7a7a");
                                    } else {
                                        agrMain.setSettlementDatePur(agrMain.getPaymentDaysPur());
                                    }
                                }
                            } else if (StringUtils.isEmpty((Object)agrMain.getOrderRuleNodePurStr())) {
                                lineError.append(",\u8d26\u671f\u65e5\u7ed3\u7b97\u8ba2\u5355\u89c4\u5219\uff08\u5bf9\u91c7\u8d2d\u5546\uff09\u4e3a\u7a7a");
                            } else {
                                agrMain.setBusiNodePur(AgrCommConstant.IsAssign.getCodeByName((String)agrMain.getOrderRuleNodePurStr()));
                                if (agrMain.getBusiNodePur() == null) {
                                    lineError.append(",\u8d26\u671f\u65e5\u7ed3\u7b97\u8ba2\u5355\u89c4\u5219\uff08\u5bf9\u91c7\u8d2d\u5546\uff09\u8f93\u5165\u9519\u8bef");
                                }
                                if (StringUtils.isEmpty((Object)agrMain.getSettlementDatePur())) {
                                    lineError.append(",\u6bcf\u6708\u7ed3\u7b97\u65e5\uff08\u5bf9\u91c7\u8d2d\u5546\uff09\u4e3a\u7a7a");
                                }
                            }
                        }
                    } else if (agrMain.getPayTypePur().equals(AgrCommConstant.PayTypeEnum.PAY_TYPE_SUBLEVEL.getValue()) && (temp1 = new BigDecimal(100)).compareTo(temp2 = new BigDecimal(0).add(agrMain.getPrePayPur()).add(agrMain.getMatPayPur()).add(agrMain.getVerPayPur()).add(agrMain.getQuaPayPur())) != 0) {
                        lineError.append(",\u9884\u4ed8\u6b3e\u3001\u5230\u8d27\u6b3e\u3001\u9a8c\u6536\u6846\u3001\u8d28\u4fdd\u91d1\uff08\u5bf9\u91c7\u8d2d\u5546\uff09\u4e0d\u4e3a100");
                    }
                }
            }
            if (StringUtils.isEmpty((Object)agrMain.getQuaprotectCount())) {
                lineError.append(",\u8d28\u4fdd\u671f\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)agrMain.getAdjustPriceStr())) {
                lineError.append(",\u8c03\u4ef7\u673a\u5236\u4e3a\u7a7a");
            } else {
                agrMain.setAdjustPrice(AgrCommConstant.AdjustPriceEnum.getCodeByName((String)agrMain.getAdjustPriceStr()));
                if (agrMain.getAdjustPrice() == null) {
                    lineError.append(",\u8c03\u4ef7\u673a\u5236\u8f93\u5165\u9519\u8bef");
                }
            }
            if (StringUtils.isEmpty((Object)agrMain.getScopeTypeStr())) {
                lineError.append(",\u5e94\u7528\u8303\u56f4\u7c7b\u578b\u4e3a\u7a7a");
            } else {
                agrMain.setScopeType(AgrCommConstant.ScopeTypeEnum.getCodeByName((String)agrMain.getScopeTypeStr()));
                if (agrMain.getScopeType() == null) {
                    lineError.append(",\u5e94\u7528\u8303\u56f4\u7c7b\u578b\u8f93\u5165\u9519\u8bef");
                } else if (agrMain.getScopeType().equals(3)) {
                    if (StringUtils.isEmpty((Object)agrMain.getAgrAppScopeName())) {
                        lineError.append(",\u5e94\u7528\u8303\u56f4\u4e3a\u7a7a");
                    } else {
                        UmcSupplierInfoQryDetailReqBO umcSupplierInfoQryDetailReqBO = new UmcSupplierInfoQryDetailReqBO();
                        umcSupplierInfoQryDetailReqBO.setQueryType("1");
                        umcSupplierInfoQryDetailReqBO.setSupplierName(agrMain.getAgrAppScopeName());
                        UmcSupplierInfoQryDetailRspBO rspBO = this.umcSupplierInfoQryDetailService.qryInfoDetail(umcSupplierInfoQryDetailReqBO);
                        if (!"0000".equals(rspBO.getRespCode())) {
                            throw new ZTBusinessException(rspBO.getRespDesc());
                        }
                        UmcEnterpriseInfoAccessBO umcEnterpriseInfoBO1 = rspBO.getUmcEnterpriseInfoBO();
                        if (null == umcEnterpriseInfoBO1) {
                            lineError.append(",\u5e94\u7528\u8303\u56f4\u4e0d\u5b58\u5728");
                        }
                        agrMain.setAgrAppScopeCode(umcEnterpriseInfoBO1.getOrgId().toString());
                    }
                }
            }
        }
    }

    private void agrItemAddTranslate(Integer salePriceGreateRule, Integer tradeMode, List<DycAgrItemChngFuncBO> agrItemChng, Map<Integer, String> lineErrorMsgMap) {
        if (!CollectionUtils.isEmpty(agrItemChng)) {
            for (DycAgrItemChngFuncBO dycAgrItemFuncBO : agrItemChng) {
                Integer gluttonLineNum = dycAgrItemFuncBO.getGluttonLineNum();
                StringBuilder lineError = new StringBuilder();
                String itemlineError = lineErrorMsgMap.get(gluttonLineNum);
                if (!StringUtils.isEmpty((Object)itemlineError)) {
                    lineError.append(itemlineError);
                }
                if (dycAgrItemFuncBO.getAgrItemNo() == null) {
                    lineError.append(",\u660e\u7ec6\u5e8f\u53f7\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((Object)dycAgrItemFuncBO.getItemChngTypeStr())) {
                    lineError.append(",\u8865\u5145\u7c7b\u578b\u4e3a\u7a7a");
                    continue;
                }
                dycAgrItemFuncBO.setItemChngType(AgrCommConstant.AgrItemChngTypeEnum.getCodeByName((String)dycAgrItemFuncBO.getItemChngTypeStr()));
                if (dycAgrItemFuncBO.getItemChngType() == null) {
                    lineError.append(",\u8865\u5145\u7c7b\u578b\u8f93\u5165\u9519\u8bef");
                    continue;
                }
                if (StringUtils.isEmpty((Object)dycAgrItemFuncBO.getCommodityTypeName())) {
                    lineError.append(",\u5546\u54c1\u7c7b\u578b\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((Object)dycAgrItemFuncBO.getMaterialCode())) {
                    lineError.append(",\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
                }
                if (dycAgrItemFuncBO.getItemChngType().equals(AgrCommConstant.AgrItemChngTypeEnum.AGR_ITEM_CHNG_TYPE_ENUM_ADD.getValue())) {
                    if (StringUtils.isEmpty((Object)dycAgrItemFuncBO.getMaterialName())) {
                        lineError.append(",\u7269\u6599\u540d\u79f0\u4e3a\u7a7a");
                    }
                    if (StringUtils.isEmpty((Object)dycAgrItemFuncBO.getBrandName())) {
                        lineError.append(",\u54c1\u724c\u4e3a\u7a7a");
                    }
                    if (dycAgrItemFuncBO.getSupplyCycle() == null) {
                        lineError.append(",\u4f9b\u8d27\u5468\u671f\u4e3a\u7a7a");
                    }
                    if (StringUtils.isEmpty((Object)dycAgrItemFuncBO.getWhetherOilStr())) {
                        lineError.append(",\u662f\u5426\u6210\u54c1\u6cb9\u4e3a\u7a7a");
                    } else {
                        dycAgrItemFuncBO.setWhetherOil(AgrCommConstant.IsOilPcodeEnum.getCodeByName((String)dycAgrItemFuncBO.getWhetherOilStr()));
                        if (dycAgrItemFuncBO.getWhetherOil() == null) {
                            lineError.append(",\u662f\u5426\u6210\u54c1\u6cb9\u8f93\u5165\u9519\u8bef");
                        }
                    }
                    if (dycAgrItemFuncBO.getBuyNumber() == null) {
                        lineError.append(",\u6570\u91cf\u4e3a\u7a7a");
                    }
                    if (StringUtils.isEmpty((Object)dycAgrItemFuncBO.getTaxRateStr())) {
                        lineError.append(",\u7a0e\u7387\u4e3a\u7a7a");
                    } else {
                        Integer taxRate = AgrCommConstant.TaxRateEnum.getCodeByName((String)dycAgrItemFuncBO.getTaxRateStr());
                        if (taxRate == null) {
                            lineError.append(",\u7a0e\u7387\u8f93\u5165\u9519\u8bef");
                        } else {
                            dycAgrItemFuncBO.setTaxRate(new BigDecimal(taxRate));
                        }
                    }
                    if (tradeMode != null) {
                        if (!tradeMode.equals(AgrCommConstant.TradeModeEnum.TRADE_MODE_BUYING_AND_SELLING.getValue())) {
                            dycAgrItemFuncBO.setMarkupRate(new BigDecimal(0));
                            dycAgrItemFuncBO.setSalePrice(dycAgrItemFuncBO.getBuyPrice().add(dycAgrItemFuncBO.getBuyPrice().multiply(dycAgrItemFuncBO.getMarkupRate().divide(new BigDecimal(100)))));
                        } else if (DycFuncCommonConstants.SalePriceGreateRule.BASE_MARKET_UP.equals(salePriceGreateRule)) {
                            if (StringUtils.isEmpty((Object)dycAgrItemFuncBO.getMarkupRateStr())) {
                                lineError.append(",\u52a0\u4ef7\u6bd4\u7387\u4e3a\u7a7a");
                            } else {
                                Integer markupRate = AgrCommConstant.MarkUpEnum.getCodeByName((String)dycAgrItemFuncBO.getMarkupRateStr());
                                if (markupRate == null) {
                                    lineError.append(",\u52a0\u4ef7\u6bd4\u7387\u8f93\u5165\u9519\u8bef");
                                } else {
                                    dycAgrItemFuncBO.setMarkupRate(new BigDecimal(markupRate));
                                    dycAgrItemFuncBO.setSalePrice(dycAgrItemFuncBO.getBuyPrice().add(dycAgrItemFuncBO.getBuyPrice().multiply(dycAgrItemFuncBO.getMarkupRate().divide(new BigDecimal(100)))));
                                }
                            }
                        }
                    }
                    if (dycAgrItemFuncBO.getBuyPrice() == null) {
                        lineError.append(",\u91c7\u8d2d\u5355\u4ef7\u4e3a\u7a7a");
                    }
                    if (dycAgrItemFuncBO.getMarkupRate() == null) {
                        dycAgrItemFuncBO.setMarkupRate(new BigDecimal("0"));
                    }
                }
                if (StringUtils.hasText((String)lineError.toString())) {
                    lineErrorMsgMap.put(gluttonLineNum, lineError.toString());
                    continue;
                }
                dycAgrItemFuncBO.setBuyPriceSum(dycAgrItemFuncBO.getBuyPrice().multiply(dycAgrItemFuncBO.getBuyNumber()));
                dycAgrItemFuncBO.setSalePriceSum(dycAgrItemFuncBO.getSalePrice().multiply(dycAgrItemFuncBO.getBuyNumber()));
            }
        }
    }

    private void agrItemAdjustPriceTranslate(Integer salePriceGreateRule, Integer tradeMode, List<DycAgrItemChngFuncBO> agrItemChng, Map<Integer, String> lineErrorMsgMap) {
        if (!CollectionUtils.isEmpty(agrItemChng)) {
            for (DycAgrItemChngFuncBO dycAgrItemFuncBO : agrItemChng) {
                Integer gluttonLineNum = dycAgrItemFuncBO.getGluttonLineNum();
                StringBuilder lineError = new StringBuilder();
                String itemlineError = lineErrorMsgMap.get(gluttonLineNum);
                if (!StringUtils.isEmpty((Object)itemlineError)) {
                    lineError.append(itemlineError);
                }
                if (dycAgrItemFuncBO.getAgrItemNo() == null) {
                    lineError.append(",\u660e\u7ec6\u5e8f\u53f7\u4e3a\u7a7a");
                }
                dycAgrItemFuncBO.setItemChngType(AgrCommConstant.AgrItemChngTypeEnum.AGR_ITEM_CHNG_TYPE_ENUM_UPDATE.getValue());
                if (StringUtils.isEmpty((Object)dycAgrItemFuncBO.getCommodityTypeName())) {
                    lineError.append(",\u5546\u54c1\u7c7b\u578b\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((Object)dycAgrItemFuncBO.getMaterialCode())) {
                    lineError.append(",\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
                }
                if (dycAgrItemFuncBO.getPostBuyNumber() == null) {
                    lineError.append(",\u8c03\u6574\u540e\u6570\u91cf\u4e3a\u7a7a");
                } else {
                    dycAgrItemFuncBO.setBuyNumber(dycAgrItemFuncBO.getPostBuyNumber());
                }
                if (dycAgrItemFuncBO.getPostBuyPrice() == null) {
                    lineError.append(",\u8c03\u6574\u540e\u91c7\u8d2d\u5355\u4ef7\u4e3a\u7a7a");
                } else {
                    dycAgrItemFuncBO.setBuyPrice(dycAgrItemFuncBO.getPostBuyPrice());
                }
                if (!tradeMode.equals(AgrCommConstant.TradeModeEnum.TRADE_MODE_BUYING_AND_SELLING.getValue())) {
                    dycAgrItemFuncBO.setMarkupRate(new BigDecimal(0));
                    dycAgrItemFuncBO.setSalePrice(dycAgrItemFuncBO.getBuyPrice());
                } else if (DycFuncCommonConstants.SalePriceGreateRule.BASE_MARKET_UP.equals(salePriceGreateRule)) {
                    if (StringUtils.isEmpty((Object)dycAgrItemFuncBO.getPostMarkupRateStr())) {
                        lineError.append(",\u8c03\u6574\u540e\u52a0\u4ef7\u6bd4\u7387\u4e3a\u7a7a");
                    } else {
                        Integer markupRate = AgrCommConstant.MarkUpEnum.getCodeByName((String)dycAgrItemFuncBO.getPostMarkupRateStr());
                        if (markupRate == null) {
                            lineError.append(",\u8c03\u6574\u540e\u52a0\u4ef7\u6bd4\u7387\u8f93\u5165\u9519\u8bef");
                        } else {
                            dycAgrItemFuncBO.setMarkupRate(new BigDecimal(markupRate));
                            dycAgrItemFuncBO.setSalePrice(dycAgrItemFuncBO.getBuyPrice().add(dycAgrItemFuncBO.getBuyPrice().multiply(dycAgrItemFuncBO.getMarkupRate().divide(new BigDecimal(100)))));
                        }
                    }
                } else if (dycAgrItemFuncBO.getPostSalePrice() == null) {
                    lineError.append(",\u8c03\u6574\u540e\u9500\u552e\u5355\u4ef7\u4e3a\u7a7a");
                } else {
                    dycAgrItemFuncBO.setSalePrice(dycAgrItemFuncBO.getPostSalePrice());
                }
                if (StringUtils.hasText((String)lineError.toString())) {
                    lineErrorMsgMap.put(gluttonLineNum, lineError.toString());
                    continue;
                }
                if (dycAgrItemFuncBO.getMarkupRate() == null) {
                    dycAgrItemFuncBO.setMarkupRate(new BigDecimal("0"));
                }
                if (dycAgrItemFuncBO.getBuyPrice() == null) {
                    dycAgrItemFuncBO.setBuyPrice(new BigDecimal("0"));
                }
                dycAgrItemFuncBO.setBuyPriceSum(dycAgrItemFuncBO.getBuyPrice().multiply(dycAgrItemFuncBO.getBuyNumber()));
                dycAgrItemFuncBO.setSalePriceSum(dycAgrItemFuncBO.getSalePrice().multiply(dycAgrItemFuncBO.getBuyNumber()));
            }
        }
    }

    private void updateAgr(Long agrId, Integer agrStatus) {
        AgrUpdateAgrMainReqBO agrUpdateAgrMainReqBO = new AgrUpdateAgrMainReqBO();
        agrUpdateAgrMainReqBO.setAgrStatus(agrStatus);
        agrUpdateAgrMainReqBO.setAgrId(agrId);
        AgrUpdateAgrMainRspBO agrUpdateAgrMainRspBO = this.agrUpdateAgrMainService.updateAgrMain(agrUpdateAgrMainReqBO);
        if (!"0000".equals(agrUpdateAgrMainRspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u4e3b\u4f53\u53d8\u66f4\u5931\u8d25\uff01\u5f02\u5e38\u7f16\u7801\u3010" + agrUpdateAgrMainRspBO.getRespCode() + "\u3011," + agrUpdateAgrMainRspBO.getRespDesc());
        }
    }

    private void syncUcc(Long agrId, Long chngApplyId, Integer syncType) {
        AgrSyncUccReqBO agrSyncUccReqBO = new AgrSyncUccReqBO();
        agrSyncUccReqBO.setSyncType(syncType);
        agrSyncUccReqBO.setAgrId(agrId);
        agrSyncUccReqBO.setChngApplyId(chngApplyId);
        AgrSyncUccRspBO agrSyncUccRspBO = this.agrSyncUccService.dealAgrSyncUcc(agrSyncUccReqBO);
        if (!"0000".equals(agrSyncUccRspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u5546\u54c1\u540c\u6b65\u5931\u8d25\u3010" + agrSyncUccRspBO.getRespCode() + "\u3011," + agrSyncUccRspBO.getRespDesc());
        }
    }

    private void saveAgrChng(DycAgrAgrChngImportFuncBO dycAgrAgrChngImportFuncBO, DycAgrAgrChngImportFuncReqBO reqBO) {
        if (dycAgrAgrChngImportFuncBO.getChngType().equals(AgrCommConstant.AgreementChangeType.OTHER)) {
            AgrCreateArgMainChngReqBO mainChngReqBO = (AgrCreateArgMainChngReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), AgrCreateArgMainChngReqBO.class);
            BeanUtils.copyProperties((Object)dycAgrAgrChngImportFuncBO, (Object)mainChngReqBO);
            mainChngReqBO.setPreExpDate(DateUtils.strToDate((String)dycAgrAgrChngImportFuncBO.getExpDate(), (String)"yyyy-MM-dd"));
            mainChngReqBO.setPostExpDate(DateUtils.strToDate((String)dycAgrAgrChngImportFuncBO.getPostExpDate(), (String)"yyyy-MM-dd"));
            ArrayList<AgrPayConfigChngBo> agrPayConfigChng = new ArrayList<AgrPayConfigChngBo>();
            if (ObjectUtil.isNotEmpty((Object)dycAgrAgrChngImportFuncBO.getPayTypePur())) {
                AgrPayConfigChngBo payTypePur = new AgrPayConfigChngBo();
                payTypePur.setPayType(dycAgrAgrChngImportFuncBO.getPayTypePur());
                payTypePur.setAssign(dycAgrAgrChngImportFuncBO.getAssignPur());
                payTypePur.setBusiNode(dycAgrAgrChngImportFuncBO.getBusiNodePur());
                payTypePur.setMatPay(dycAgrAgrChngImportFuncBO.getMatPayPur());
                payTypePur.setPilPay(dycAgrAgrChngImportFuncBO.getPilPayPur());
                payTypePur.setPrePay(dycAgrAgrChngImportFuncBO.getPrePayPur());
                payTypePur.setProPay(dycAgrAgrChngImportFuncBO.getProPayPur());
                payTypePur.setQuaPay(dycAgrAgrChngImportFuncBO.getQuaPayPur());
                payTypePur.setSettlementDate(dycAgrAgrChngImportFuncBO.getSettlementDatePur());
                payTypePur.setSettlementMonth(dycAgrAgrChngImportFuncBO.getSettlementMonthPur());
                payTypePur.setVerPay(dycAgrAgrChngImportFuncBO.getVerPayPur());
                payTypePur.setPayObj(AgrCommConstant.payObj.PAY_OBJ_PURCHASE);
                agrPayConfigChng.add(payTypePur);
            }
            if (ObjectUtil.isNotEmpty((Object)dycAgrAgrChngImportFuncBO.getPayTypeSup())) {
                AgrPayConfigChngBo payTypeSup = new AgrPayConfigChngBo();
                payTypeSup.setPayType(dycAgrAgrChngImportFuncBO.getPayTypeSup());
                payTypeSup.setAssign(dycAgrAgrChngImportFuncBO.getAssignSup());
                payTypeSup.setBusiNode(dycAgrAgrChngImportFuncBO.getBusiNodeSup());
                payTypeSup.setMatPay(dycAgrAgrChngImportFuncBO.getMatPaySup());
                payTypeSup.setPilPay(dycAgrAgrChngImportFuncBO.getPilPaySup());
                payTypeSup.setPrePay(dycAgrAgrChngImportFuncBO.getPrePaySup());
                payTypeSup.setProPay(dycAgrAgrChngImportFuncBO.getProPaySup());
                payTypeSup.setQuaPay(dycAgrAgrChngImportFuncBO.getQuaPaySup());
                payTypeSup.setSettlementDate(dycAgrAgrChngImportFuncBO.getSettlementDateSup());
                payTypeSup.setSettlementMonth(dycAgrAgrChngImportFuncBO.getSettlementMonthSup());
                payTypeSup.setVerPay(dycAgrAgrChngImportFuncBO.getVerPaySup());
                payTypeSup.setPayObj(AgrCommConstant.payObj.PAY_OBJ_SUPPLY);
                agrPayConfigChng.add(payTypeSup);
            }
            mainChngReqBO.setAgrPayConfigChng(agrPayConfigChng);
            AgrMainChngBo agrMainChng = (AgrMainChngBo)JSON.parseObject((String)JSON.toJSONString((Object)dycAgrAgrChngImportFuncBO), AgrMainChngBo.class);
            mainChngReqBO.setAgrMainChng(agrMainChng);
            if (ObjectUtil.isNotEmpty((Object)dycAgrAgrChngImportFuncBO.getAgrAppScopeCode())) {
                ArrayList<AgrAppScopeChngBo> agrAppScopeBOs = new ArrayList<AgrAppScopeChngBo>();
                AgrAppScopeChngBo agrAppScopeBo = new AgrAppScopeChngBo();
                agrAppScopeBo.setScopeCode(dycAgrAgrChngImportFuncBO.getAgrAppScopeCode());
                agrAppScopeBo.setScopeName(dycAgrAgrChngImportFuncBO.getAgrAppScopeName() + "");
                agrAppScopeBOs.add(agrAppScopeBo);
                mainChngReqBO.setAgrAppScopeChng(agrAppScopeBOs);
            }
            mainChngReqBO.setChngApplyId(dycAgrAgrChngImportFuncBO.getChngApplyId());
            mainChngReqBO.setChngType(dycAgrAgrChngImportFuncBO.getChngType());
            mainChngReqBO.setAgrId(dycAgrAgrChngImportFuncBO.getAgrId());
            AgrCreateArgMainChngRspBO agrCreateArgMainChngRspBO = this.agrCreateArgMainChngService.createAgrMainChng(mainChngReqBO);
            if (!"0000".equals(agrCreateArgMainChngRspBO.getRespCode())) {
                throw new ZTBusinessException("\u8c03\u7528\u534f\u8bae\u4e3b\u4f53\u53d8\u66f4\u7533\u8bf7\u65b0\u589e\u5931\u8d25\uff01\u5f02\u5e38\u7f16\u7801\u3010" + agrCreateArgMainChngRspBO.getRespCode() + "\u3011," + agrCreateArgMainChngRspBO.getRespDesc());
            }
        } else {
            AgrCreateArgChngApplyReqBO chngApplyReqBO = (AgrCreateArgChngApplyReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)dycAgrAgrChngImportFuncBO), AgrCreateArgChngApplyReqBO.class);
            BeanUtils.copyProperties((Object)reqBO, (Object)chngApplyReqBO);
            chngApplyReqBO.setChngApplyId(dycAgrAgrChngImportFuncBO.getChngApplyId());
            chngApplyReqBO.setChngType(dycAgrAgrChngImportFuncBO.getChngType());
            chngApplyReqBO.setAgrId(dycAgrAgrChngImportFuncBO.getAgrId());
            AgrCreateArgChngApplyRspBO agrCreateArgChngApplyRspBO = this.agrCreateArgChngApplyService.createAgrChngApply(chngApplyReqBO);
            if (!"0000".equals(agrCreateArgChngApplyRspBO.getRespCode())) {
                throw new ZTBusinessException("\u8c03\u7528\u534f\u8bae\u53d8\u66f4\u7533\u8bf7\u65b0\u589e\u5931\u8d25\uff01\u5f02\u5e38\u7f16\u7801\u3010" + agrCreateArgChngApplyRspBO.getRespCode() + "\u3011," + agrCreateArgChngApplyRspBO.getRespDesc());
            }
        }
    }

    private void saveAgrItemChng(DycAgrAgrChngImportFuncReqBO reqBO) {
        AgrCreateAgrItemChngReqBO agrCreateAgrItemChngReqBO = (AgrCreateAgrItemChngReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), AgrCreateAgrItemChngReqBO.class);
        AgrCreateAgrItemChngRspBO agrCreateAgrItemChngRspBO = this.agrCreateAgrItemChngService.createAgrItemChng(agrCreateAgrItemChngReqBO);
        if (!"0000".equals(agrCreateAgrItemChngRspBO.getRespCode())) {
            throw new ZTBusinessException("\u534f\u8bae\u660e\u7ec6\u65b0\u589e\u5931\u8d25" + agrCreateAgrItemChngRspBO.getRespDesc());
        }
    }

    private void validChngPrice(List<DycAgrItemChngFuncBO> agrItemChng, Long agrId, Map<Integer, String> lineErrorMsgMap) {
        ArrayList uniqueKeys = new ArrayList();
        agrItemChng.forEach(dycAgrItemChngFuncBO -> {
            dycAgrItemChngFuncBO.setItemChngType(AgrCommConstant.AgreementSkuChangeType.UPDATE);
            uniqueKeys.add(dycAgrItemChngFuncBO.getCommodityTypeName() + "_" + dycAgrItemChngFuncBO.getMaterialCode());
        });
        AgrGetAgrItemListReqBO agrGetAgrItemListReqBO = new AgrGetAgrItemListReqBO();
        agrGetAgrItemListReqBO.setPageNo(Integer.valueOf(-1));
        agrGetAgrItemListReqBO.setPageSize(Integer.valueOf(-1));
        agrGetAgrItemListReqBO.setAgrId(agrId);
        agrGetAgrItemListReqBO.setUniqueKeys(uniqueKeys);
        AgrGetAgrItemListRspBO agrGetAgrItemListRspBO = this.agrGetAgrItemListService.getAgrItemList(agrGetAgrItemListReqBO);
        ArrayList existUniqueKeys = new ArrayList();
        if ("0000".equals(agrGetAgrItemListRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)agrGetAgrItemListRspBO.getRows())) {
            agrGetAgrItemListRspBO.getRows().forEach(agrItemDetailBo -> existUniqueKeys.add(agrItemDetailBo.getUniqueKey()));
        }
        agrItemChng.forEach(dycAgrItemChngFuncBO -> {
            if (!existUniqueKeys.contains(dycAgrItemChngFuncBO.getCommodityTypeName() + "_" + dycAgrItemChngFuncBO.getMaterialCode())) {
                Integer gluttonLineNum = dycAgrItemChngFuncBO.getGluttonLineNum();
                StringBuilder lineError = new StringBuilder();
                String itemlineError = (String)lineErrorMsgMap.get(gluttonLineNum);
                if (!StringUtils.isEmpty((Object)itemlineError)) {
                    lineError.append(itemlineError);
                }
                lineError.append(",\u534f\u8bae\u660e\u7ec6\u4e0d\u5b58\u5728");
                lineErrorMsgMap.put(gluttonLineNum, lineError.toString());
            }
        });
    }

    private void uccCheck(List<DycAgrItemChngFuncBO> agrItemChng, Map<Integer, String> lineErrorMsgMap) {
        UccAgrSkuImportCheckAbilityReqBO uccAgrSkuImportCheckAbilityReqBO = new UccAgrSkuImportCheckAbilityReqBO();
        ArrayList rows = new ArrayList();
        agrItemChng.forEach(dycAgrItemFuncBO -> {
            UccAgrSkuImportCheckBO bo = new UccAgrSkuImportCheckBO();
            bo.setSerialNumber(dycAgrItemFuncBO.getGluttonLineNum());
            bo.setCommodityTypeName(dycAgrItemFuncBO.getCommodityTypeName());
            bo.setCatalogCode(dycAgrItemFuncBO.getCatalogCode());
            bo.setMaterialCode(dycAgrItemFuncBO.getMaterialCode());
            bo.setMeasureName(dycAgrItemFuncBO.getMeasureName());
            rows.add(bo);
        });
        uccAgrSkuImportCheckAbilityReqBO.setRows(rows);
        UccAgrSkuImportCheckAbilityRspBO uccAgrSkuImportCheckAbilityRspBO = this.uccAgrSkuImportCheckAbilityService.checkInfo(uccAgrSkuImportCheckAbilityReqBO);
        if (!"0000".equals(uccAgrSkuImportCheckAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u5546\u54c1\u4e2d\u5fc3\u6821\u9a8c\u8c03\u7528\u5931\u8d25" + uccAgrSkuImportCheckAbilityRspBO.getRespDesc());
        }
        Map uccRspMap = uccAgrSkuImportCheckAbilityRspBO.getRows().stream().collect(Collectors.toMap(UccAgrSkuImportCheckBO::getSerialNumber, Function.identity()));
        agrItemChng.forEach(dycAgrItemFuncBO -> {
            UccAgrSkuImportCheckBO bo = (UccAgrSkuImportCheckBO)uccRspMap.get(dycAgrItemFuncBO.getGluttonLineNum());
            if (bo.isPass()) {
                dycAgrItemFuncBO.setMeasureId(bo.getMeasureId());
                dycAgrItemFuncBO.setCatalogCode(bo.getCatalogCode());
                dycAgrItemFuncBO.setMaterialId(bo.getMaterialId().toString());
                dycAgrItemFuncBO.setCatalogId(bo.getCatalogId().toString());
                dycAgrItemFuncBO.setCatalogName(bo.getCatalogName());
                dycAgrItemFuncBO.setCommodityTypeId(bo.getCommodityTypeId());
            } else {
                Integer gluttonLineNum = dycAgrItemFuncBO.getGluttonLineNum();
                StringBuilder lineError = new StringBuilder();
                String itemlineError = (String)lineErrorMsgMap.get(gluttonLineNum);
                if (!StringUtils.isEmpty((Object)itemlineError)) {
                    lineError.append(itemlineError);
                }
                lineError.append("," + bo.getReson());
                lineErrorMsgMap.put(gluttonLineNum, lineError.toString());
            }
        });
    }

    private void validPuplicate(List<DycAgrItemChngFuncBO> agrItemChng, Map<Integer, String> lineErrorMsgMap, Long agrId) {
        ArrayList uniqueKeys = new ArrayList();
        HashMap uniqueKeyMap = new HashMap();
        agrItemChng.forEach(dycAgrItemChngFuncBO -> {
            String key = dycAgrItemChngFuncBO.getCommodityTypeName() + "_" + dycAgrItemChngFuncBO.getMaterialCode();
            if (uniqueKeyMap.get(key) != null) {
                Integer gluttonLineNum = dycAgrItemChngFuncBO.getGluttonLineNum();
                StringBuilder lineError = new StringBuilder();
                String itemlineError = (String)lineErrorMsgMap.get(gluttonLineNum);
                if (!StringUtils.isEmpty((Object)itemlineError)) {
                    lineError.append(itemlineError);
                }
                lineError.append(",\u534f\u8bae\u660e\u7ec6\u91cd\u590d");
                lineErrorMsgMap.put(gluttonLineNum, lineError.toString());
            } else {
                uniqueKeyMap.put(key, dycAgrItemChngFuncBO);
                uniqueKeys.add(key);
            }
        });
        if (uniqueKeys.size() > 0) {
            AgrGetAgrItemListReqBO agrGetAgrItemListReqBO = new AgrGetAgrItemListReqBO();
            agrGetAgrItemListReqBO.setPageNo(Integer.valueOf(-1));
            agrGetAgrItemListReqBO.setPageSize(Integer.valueOf(-1));
            agrGetAgrItemListReqBO.setAgrId(agrId);
            agrGetAgrItemListReqBO.setUniqueKeys(uniqueKeys);
            AgrGetAgrItemListRspBO agrGetAgrItemListRspBO = this.agrGetAgrItemListService.getAgrItemList(agrGetAgrItemListReqBO);
            if (!"0000".equals(agrGetAgrItemListRspBO.getRespCode())) {
                throw new ZTBusinessException("\u534f\u8bae\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u5931\u8d25" + agrGetAgrItemListRspBO.getRespDesc());
            }
            Map agrItemMap = agrGetAgrItemListRspBO.getRows().stream().collect(Collectors.toMap(AgrItemDetailBo::getUniqueKey, Function.identity()));
            agrItemChng.forEach(dycAgrItemChngFuncBO -> {
                String itemlineError;
                StringBuilder lineError;
                Integer gluttonLineNum;
                String key = dycAgrItemChngFuncBO.getCommodityTypeName() + "_" + dycAgrItemChngFuncBO.getMaterialCode();
                AgrItemDetailBo agrItemDetailBo = (AgrItemDetailBo)agrItemMap.get(key);
                if (AgrCommConstant.AgreementSkuChangeType.ADD.equals(dycAgrItemChngFuncBO.getItemChngType()) && null != agrItemDetailBo) {
                    gluttonLineNum = ((DycAgrItemChngFuncBO)uniqueKeyMap.get(agrItemDetailBo.getUniqueKey())).getGluttonLineNum();
                    lineError = new StringBuilder();
                    itemlineError = (String)lineErrorMsgMap.get(gluttonLineNum);
                    if (!StringUtils.isEmpty((Object)itemlineError)) {
                        lineError.append(itemlineError);
                    }
                    lineError.append(",\u534f\u8bae\u660e\u7ec6\u91cd\u590d");
                    lineErrorMsgMap.put(gluttonLineNum, lineError.toString());
                }
                if (AgrCommConstant.AgreementSkuChangeType.DELETE.equals(dycAgrItemChngFuncBO.getItemChngType())) {
                    if (null != agrItemDetailBo) {
                        dycAgrItemChngFuncBO.setAgrItemId(agrItemDetailBo.getAgrItemId());
                    } else {
                        gluttonLineNum = dycAgrItemChngFuncBO.getGluttonLineNum();
                        lineError = new StringBuilder();
                        itemlineError = (String)lineErrorMsgMap.get(gluttonLineNum);
                        if (!StringUtils.isEmpty((Object)itemlineError)) {
                            lineError.append(itemlineError);
                        }
                        lineError.append(",\u534f\u8bae\u660e\u7ec6\u4e0d\u5b58\u5728");
                        lineErrorMsgMap.put(gluttonLineNum, lineError.toString());
                    }
                }
            });
        }
    }
}

