/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.zone.extension.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.common.extension.ability.api.BkUccMaterialInfoQryAbilityService;
import com.tydic.commodity.common.extension.ability.bo.BkUccMaterialInfoQryAbilityReqBO;
import com.tydic.commodity.common.extension.ability.bo.BkUccMaterialInfoQryAbilityRspBO;
import com.tydic.commodity.common.extension.ability.bo.UccMaterialBatchBO;
import com.tydic.dyc.atom.zone.extension.api.BkAgrQryMaterialInfoFunction;
import com.tydic.dyc.atom.zone.extension.bo.BkAgrIteminbulkAbilityReqBO;
import com.tydic.dyc.atom.zone.extension.bo.BkAgrIteminbulkAbilityRspBO;
import com.tydic.dyc.atom.zone.extension.bo.BkAgrMateriaPriceItemsBO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BkAgrQryMaterialInfoFunctionImpl
implements BkAgrQryMaterialInfoFunction {
    private static final Logger log = LoggerFactory.getLogger(BkAgrQryMaterialInfoFunctionImpl.class);
    @Autowired
    private BkUccMaterialInfoQryAbilityService bkUccMaterialInfoQryAbilityService;

    @Override
    public BkAgrIteminbulkAbilityRspBO qryMaterialInfoList(BkAgrIteminbulkAbilityReqBO reqBO) {
        BkUccMaterialInfoQryAbilityReqBO uccMaterialInfoQryAbilityReqBO = new BkUccMaterialInfoQryAbilityReqBO();
        uccMaterialInfoQryAbilityReqBO.setBatchMaterialCodeList(reqBO.getAgrCodes());
        log.info("\u5546\u57ce\u7269\u6599\u8865\u5168\u4fe1\u606f\u5165\u53c2{}", JSON.toJSON((Object)uccMaterialInfoQryAbilityReqBO));
        BkUccMaterialInfoQryAbilityRspBO abilityRspBO = this.bkUccMaterialInfoQryAbilityService.qryMaterialInfo(uccMaterialInfoQryAbilityReqBO);
        log.info("\u5546\u57ce\u7269\u6599\u8865\u5168\u4fe1\u606f\u51fa\u53c2{}", JSON.toJSON((Object)abilityRspBO));
        if (CollectionUtils.isEmpty((Collection)abilityRspBO.getMaterlaiList())) {
            throw new ZTBusinessException("\u67e5\u8be2\u5546\u54c1\u7269\u6599\u4fe1\u606f\u8fd4\u56de\u65e0\u6570\u636e");
        }
        if (reqBO.getAgrCodes().size() != abilityRspBO.getMaterlaiList().size()) {
            throw new ZTBusinessException("\u67e5\u8be2\u5546\u54c1\u7269\u6599\u4fe1\u606f\u8fd4\u56de\u8bb0\u5f55\u4e0e\u5165\u53c2\u6570\u91cf\u4e0d\u4e00\u81f4");
        }
        BkAgrIteminbulkAbilityRspBO rspBO = new BkAgrIteminbulkAbilityRspBO();
        if (!CollectionUtils.isEmpty((Collection)abilityRspBO.getMaterlaiList())) {
            Map map = abilityRspBO.getMaterlaiList().stream().collect(Collectors.toMap(UccMaterialBatchBO::getMaterialCode, Function.identity(), (key1, key2) -> key2));
            List<BkAgrMateriaPriceItemsBO> agrMateriaPriceItemBOs = reqBO.getAgrMateriaPriceItemBOs();
            agrMateriaPriceItemBOs.forEach(obj -> {
                UccMaterialBatchBO uccMaterialBatchBO = (UccMaterialBatchBO)map.get(obj.getMaterialCode());
                if (uccMaterialBatchBO != null) {
                    obj.setCatalogCode(uccMaterialBatchBO.getCatalog3Code());
                    obj.setCatalogName(uccMaterialBatchBO.getCatalog3Name());
                    obj.setMeasureName(uccMaterialBatchBO.getMeasureName());
                    if (StringUtils.isEmpty((Object)uccMaterialBatchBO.getMeasureCode())) {
                        throw new ZTBusinessException("\u5f53\u524d\u7269\u6599[" + obj.getMaterialCode() + "]\u5bf9\u5e94\u7684\u8ba1\u91cf\u5355\u4f4d\u7f16\u7801\u4e3a\u7a7a");
                    }
                    obj.setMeasureCode(uccMaterialBatchBO.getMeasureCode());
                    obj.setUnitDigit(uccMaterialBatchBO.getDecimalLimit() + "");
                    obj.setMaterialShortDesc(uccMaterialBatchBO.getShortDesc());
                }
            });
            rspBO.setAgrMateriaPriceItemBOs(agrMateriaPriceItemBOs);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

