/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.UccSkuBatchAddRecordBO;
import com.tydic.commodity.base.constant.CommodityStatusConstants;
import com.tydic.commodity.base.constant.SkuStatusConstants;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccSkuBatchAddRecordAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuBatchAddRecordAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccSkuBatchAddRecordAtomRspBO;
import com.tydic.commodity.dao.ComBatchDealOrderMapper;
import com.tydic.commodity.dao.ComBatchDealRrecordMapper;
import com.tydic.commodity.dao.ComBatchDealTaskMapper;
import com.tydic.commodity.po.ComBatchDealRecordPO;
import com.tydic.commodity.po.ComBatchDealTaskPO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class UccSkuBatchAddRecordAtomServiceImpl
implements UccSkuBatchAddRecordAtomService {
    @Autowired
    private ComBatchDealRrecordMapper comBatchDealRrecordMapper;
    @Autowired
    private ComBatchDealOrderMapper comBatchDealOrderMapper;
    @Autowired
    private ComBatchDealTaskMapper comBatchDealTaskMapper;
    @Value(value="${ucc.batch.record.submit.size:5000}")
    private int submitSize;

    @Override
    public UccSkuBatchAddRecordAtomRspBO addRecrod(UccSkuBatchAddRecordAtomReqBO reqBO) {
        this.validReqParam(reqBO);
        UccSkuBatchAddRecordAtomRspBO rspBO = new UccSkuBatchAddRecordAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        this.addRecord(reqBO, rspBO);
        return rspBO;
    }

    private void addRecord(UccSkuBatchAddRecordAtomReqBO reqBO, UccSkuBatchAddRecordAtomRspBO rspBO) {
        String batchNo = String.valueOf(Sequence.getInstance().nextId());
        Date now = new Date();
        List<Long> objIdList = reqBO.getBatchObjList().stream().map(UccSkuBatchAddRecordBO::getObjId).collect(Collectors.toList());
        ComBatchDealRecordPO insertBatchDealRecordPO = new ComBatchDealRecordPO();
        insertBatchDealRecordPO.setDealType(reqBO.getDealType());
        insertBatchDealRecordPO.setBatchNo(batchNo);
        insertBatchDealRecordPO.setCreateTime(now);
        insertBatchDealRecordPO.setCreateUserId(reqBO.getUserId());
        insertBatchDealRecordPO.setCreateUserName(reqBO.getName());
        insertBatchDealRecordPO.setStatus(UccConstants.SkuBatchDealStatus.TO_CHECK);
        insertBatchDealRecordPO.setObjType(reqBO.getObjType());
        ArrayList<Integer> objStatusList = new ArrayList<Integer>();
        this.statusConvert(reqBO, insertBatchDealRecordPO, objStatusList);
        if (CollectionUtils.isEmpty(objStatusList)) {
            throw new BaseBusinessException("8888", "\u72b6\u6001\u8f6c\u6362\u4e3a\u7a7a");
        }
        this.submitBatch(reqBO, objIdList, insertBatchDealRecordPO);
        int reqCount = reqBO.getBatchObjList().size();
        ComBatchDealRecordPO comBatchDealRecordPO = new ComBatchDealRecordPO();
        comBatchDealRecordPO.setBatchNo(batchNo);
        int batchCount = this.comBatchDealRrecordMapper.getCheckBy(comBatchDealRecordPO);
        Long batchTaskId = this.insertBatchDeal(reqBO, batchNo, now, reqCount, batchCount);
        rspBO.setBatchTaskId(batchTaskId);
        rspBO.setFailNum(reqCount - batchCount);
        rspBO.setSuccessNum(batchCount);
        rspBO.setTotalNum(reqCount);
        rspBO.setBatchNo(batchNo);
    }

    private void statusConvert(UccSkuBatchAddRecordAtomReqBO reqBO, ComBatchDealRecordPO insertBatchDealRecordPO, List<Integer> objStatusList) {
        if (UccConstants.BatchObjType.SKU.equals(reqBO.getObjType())) {
            if (UccConstants.BatchDealType.SKU_DELETE.equals(reqBO.getDealType())) {
                if (UccConstants.Source.ECOM.equals(reqBO.getSource())) {
                    objStatusList.add(SkuStatusConstants.SKU_STATUS_INVALID);
                } else {
                    objStatusList.add(SkuStatusConstants.SKU_STATUS_DRAFT);
                }
                insertBatchDealRecordPO.setObjStatusList(objStatusList);
            }
            if (UccConstants.BatchDealType.SKU_REJECT.equals(reqBO.getDealType())) {
                objStatusList.add(SkuStatusConstants.SKU_STATUS_WAIT_SHELF);
                insertBatchDealRecordPO.setObjStatusList(objStatusList);
            }
            if (UccConstants.BatchDealType.SKU_RE_TO_PUT_ON.equals(reqBO.getDealType())) {
                objStatusList.add(SkuStatusConstants.SKU_STATUS_REJECT);
                insertBatchDealRecordPO.setObjStatusList(objStatusList);
            }
            if (UccConstants.BatchDealType.SKU_EDIT_SUBMIT_DRAFT.equals(reqBO.getDealType())) {
                objStatusList.add(SkuStatusConstants.SKU_STATUS_DRAFT);
                insertBatchDealRecordPO.setObjStatusList(objStatusList);
            }
            if (UccConstants.BatchDealType.SKU_EDIT_SUBMIT_NOT_DRAFT.equals(reqBO.getDealType())) {
                objStatusList.add(SkuStatusConstants.SKU_STATUS_ON_SHELF);
                objStatusList.add(SkuStatusConstants.SKU_STATUS_DOWN_SHELF);
                objStatusList.add(SkuStatusConstants.SKU_STATUS_FORCE_DOWN_SHELF);
                objStatusList.add(SkuStatusConstants.SKU_STATUS_WARING_DOWN_SHELF);
                objStatusList.add(SkuStatusConstants.SKU_STATUS_WAIT_SHELF);
                insertBatchDealRecordPO.setObjStatusList(objStatusList);
            }
            this.sameLevelSkuStatusConvert(reqBO, insertBatchDealRecordPO, objStatusList);
            if (UccConstants.BatchDealType.BEFOR_TASK.equals(reqBO.getDealType()) || UccConstants.BatchDealType.TRANSFER_TASK.equals(reqBO.getDealType()) || UccConstants.BatchDealType.BATCH_AUDIT.equals(reqBO.getDealType())) {
                objStatusList.add(SkuStatusConstants.SKU_STATUS_PUT_ON_AUDITING);
                objStatusList.add(SkuStatusConstants.SKU_STATUS_EDIT_AUDITING);
                objStatusList.add(SkuStatusConstants.SKU_STATUS_RE_PUT_ON_AUDITING);
                objStatusList.add(SkuStatusConstants.SKU_STATUS_ON_SHELF_EDIT_AUDITING);
                objStatusList.add(SkuStatusConstants.SKU_STATUS_WAIT_SHELF_EDIT_AUDITING);
                objStatusList.add(SkuStatusConstants.SKU_STATUS_SHELF_EDIT_AUDITING);
                objStatusList.add(SkuStatusConstants.SKU_STATUS_DOWN_SHELF_EDIT_AUDITING);
                insertBatchDealRecordPO.setObjStatusList(objStatusList);
            }
        }
        if (UccConstants.BatchObjType.COMMODITY.equals(reqBO.getObjType())) {
            if (UccConstants.BatchDealType.COMM_EDIT_SUBMIT.equals(reqBO.getDealType())) {
                objStatusList.add(CommodityStatusConstants.COMMD_STATUS_CREATE_ING);
                objStatusList.add(CommodityStatusConstants.COMMD_STATUS_DRAFT);
                insertBatchDealRecordPO.setObjStatusList(objStatusList);
            }
            if (UccConstants.BatchDealType.COMM_EDIT_SUBMIT_NOT_DRAFT.equals(reqBO.getDealType())) {
                objStatusList.add(CommodityStatusConstants.COMMD_STATUS_ON_SHELF);
                objStatusList.add(CommodityStatusConstants.COMMD_STATUS_WAIT_SHELF);
                objStatusList.add(CommodityStatusConstants.COMMD_STATUS_DOWN_SHELF);
                insertBatchDealRecordPO.setObjStatusList(objStatusList);
            }
            if (UccConstants.BatchDealType.COMM_DELETE.equals(reqBO.getDealType())) {
                objStatusList.add(CommodityStatusConstants.COMMD_STATUS_DRAFT);
                insertBatchDealRecordPO.setObjStatusList(objStatusList);
            }
            if (UccConstants.IsSameLevelCommodity.YES.equals(reqBO.getSameLevel())) {
                this.sameLevelSkuStatusConvert(reqBO, insertBatchDealRecordPO, objStatusList);
            }
        }
    }

    private void sameLevelSkuStatusConvert(UccSkuBatchAddRecordAtomReqBO reqBO, ComBatchDealRecordPO insertBatchDealRecordPO, List<Integer> objStatusList) {
        if (UccConstants.BatchDealType.SKU_PUT_ON.equals(reqBO.getDealType())) {
            objStatusList.add(SkuStatusConstants.SKU_STATUS_WAIT_SHELF);
            insertBatchDealRecordPO.setObjStatusList(objStatusList);
        }
        if (UccConstants.BatchDealType.SKU_PUT_OFF.equals(reqBO.getDealType())) {
            objStatusList.add(SkuStatusConstants.SKU_STATUS_ON_SHELF);
            insertBatchDealRecordPO.setObjStatusList(objStatusList);
        }
        if (UccConstants.BatchDealType.SKU_RE_PUT_ON.equals(reqBO.getDealType())) {
            objStatusList.add(SkuStatusConstants.SKU_STATUS_DOWN_SHELF);
            objStatusList.add(SkuStatusConstants.SKU_STATUS_ECCOM_DOWN_SHELF);
            objStatusList.add(SkuStatusConstants.SKU_STATUS_FORCE_DOWN_SHELF);
            objStatusList.add(SkuStatusConstants.SKU_STATUS_WARING_DOWN_SHELF);
            insertBatchDealRecordPO.setObjStatusList(objStatusList);
        }
        if (UccConstants.BatchDealType.SKU_FROCE_PUT_OFF.equals(reqBO.getDealType())) {
            objStatusList.add(SkuStatusConstants.SKU_STATUS_ON_SHELF);
            insertBatchDealRecordPO.setObjStatusList(objStatusList);
        }
    }

    private Long insertBatchDeal(UccSkuBatchAddRecordAtomReqBO reqBO, String batchNo, Date now, int reqCount, int batchCount) {
        ComBatchDealTaskPO uccBatchDealTaskPO = new ComBatchDealTaskPO();
        uccBatchDealTaskPO.setBatchNo(batchNo);
        uccBatchDealTaskPO.setCreateTime(now);
        uccBatchDealTaskPO.setCreateUserId(reqBO.getUserId());
        uccBatchDealTaskPO.setCreateUserName(reqBO.getName());
        uccBatchDealTaskPO.setTotalNum(Long.valueOf(reqCount));
        uccBatchDealTaskPO.setBatchTaskId(Sequence.getInstance().nextId());
        JSONObject json = new JSONObject();
        json.put("sameLevel", (Object)reqBO.getSameLevel());
        json.put("userId", (Object)reqBO.getUserId());
        json.put("name", (Object)reqBO.getName());
        json.put("orgId", (Object)reqBO.getOrgId());
        json.put("orgName", (Object)reqBO.getOrgName());
        json.put("companyId", (Object)reqBO.getCompanyId());
        json.put("companyName", (Object)reqBO.getCompanyName());
        if (!StringUtils.isBlank((CharSequence)reqBO.getReqJson())) {
            JSONObject reqJsonObj = JSON.parseObject((String)reqBO.getReqJson());
            json.putAll((Map)reqJsonObj);
        }
        uccBatchDealTaskPO.setReqJson(json.toJSONString());
        uccBatchDealTaskPO.setTotalNum(Convert.toLong((Object)reqCount));
        uccBatchDealTaskPO.setFailNum(Convert.toLong((Object)(reqCount - batchCount)));
        uccBatchDealTaskPO.setSuccessNum(Convert.toLong((Object)batchCount));
        if (uccBatchDealTaskPO.getFailNum() > 0L) {
            uccBatchDealTaskPO.setFailReason("\u72b6\u6001\u4e0d\u5bf9");
        }
        uccBatchDealTaskPO.setDealType(reqBO.getDealType());
        uccBatchDealTaskPO.setSource(reqBO.getSource());
        this.comBatchDealTaskMapper.insert(uccBatchDealTaskPO);
        return uccBatchDealTaskPO.getBatchTaskId();
    }

    private void submitBatch(UccSkuBatchAddRecordAtomReqBO reqBO, List<Long> objIdList, ComBatchDealRecordPO insertBatchDealRecordPO) {
        int pageCount = objIdList.size() / this.submitSize;
        int modSzie = objIdList.size() % this.submitSize;
        if (objIdList.size() > this.submitSize) {
            for (int i = 0; i < pageCount; ++i) {
                insertBatchDealRecordPO.setObjIdList(objIdList.subList(i - 1, this.submitSize * (i + 1)));
                this.insertBatch(insertBatchDealRecordPO, reqBO);
            }
            if (modSzie > 0) {
                int ySize = this.submitSize * (pageCount - 1) - 1;
                insertBatchDealRecordPO.setObjIdList(objIdList.subList(ySize, ySize + modSzie));
                this.insertBatch(insertBatchDealRecordPO, reqBO);
            }
        } else {
            insertBatchDealRecordPO.setObjIdList(objIdList);
            this.insertBatch(insertBatchDealRecordPO, reqBO);
        }
    }

    private void insertBatch(ComBatchDealRecordPO insertBatchDealRecordPO, UccSkuBatchAddRecordAtomReqBO reqBO) {
        if (UccConstants.BatchObjType.SKU.equals(reqBO.getObjType())) {
            this.comBatchDealRrecordMapper.insertBatchSkuIgnore(insertBatchDealRecordPO);
        }
        if (UccConstants.BatchObjType.COMMODITY.equals(reqBO.getObjType())) {
            if (UccConstants.IsSameLevelCommodity.YES.equals(reqBO.getSameLevel())) {
                reqBO.setObjType(UccConstants.BatchObjType.SKU);
                insertBatchDealRecordPO.setObjType(UccConstants.BatchObjType.SKU);
                this.comBatchDealRrecordMapper.insertBatchSameCommodityIgnore(insertBatchDealRecordPO);
            } else {
                this.comBatchDealRrecordMapper.insertBatchCommodityIgnore(insertBatchDealRecordPO);
            }
            if (UccConstants.BatchDealType.COMM_EDIT_SUBMIT.equals(insertBatchDealRecordPO.getDealType())) {
                this.comBatchDealRrecordMapper.updateOnShelveWayBy(insertBatchDealRecordPO);
            }
        }
        if (UccConstants.BatchObjType.AUDIT_ORDER.equals(reqBO.getObjType())) {
            this.comBatchDealRrecordMapper.insertBatchAuditIgnore(insertBatchDealRecordPO);
            this.comBatchDealOrderMapper.updateOrderByRecord(insertBatchDealRecordPO.getBatchNo());
        }
        if (!StringUtils.isBlank((CharSequence)reqBO.getBatchObjList().get(0).getTaskId())) {
            insertBatchDealRecordPO.setBatchObjList(reqBO.getBatchObjList());
            this.comBatchDealRrecordMapper.updateRecordByBatch(insertBatchDealRecordPO);
        }
    }

    private void validReqParam(UccSkuBatchAddRecordAtomReqBO abilityReqBO) {
        if (CollectionUtils.isEmpty(abilityReqBO.getBatchObjList())) {
            throw new BusinessException("8888", "\u5165\u53c2batchSkuList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UccSkuBatchAddRecordBO uccSkuBatchAddRecordBO : abilityReqBO.getBatchObjList()) {
            if (null != uccSkuBatchAddRecordBO.getObjId()) continue;
            throw new BusinessException("8888", "\u5165\u53c2objId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)abilityReqBO.getDealType())) {
            throw new BusinessException("8888", "\u5165\u53c2dealType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == abilityReqBO.getObjType()) {
            throw new BusinessException("8888", "\u5165\u53c2objType\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

