/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.SkuPriceBo;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccSkuPriceChangeSyncOoocAtomService;
import com.tydic.commodity.busibase.atom.api.UccSkuPriceModifyAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSkuPriceChangeBo;
import com.tydic.commodity.busibase.atom.bo.UccSkuPriceChangeSyncOoocAtomServiceReqBo;
import com.tydic.commodity.busibase.atom.bo.UccSkuPriceModifyAtomServiceReqBo;
import com.tydic.commodity.busibase.atom.bo.UccSkuPriceModifyAtomServiceRspBo;
import com.tydic.commodity.dao.UccGoodsPriceChangeLogMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceLogMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.po.UccGoodsPriceChangeLogPO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPriceLogPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccSkuPriceModifyAtomServiceImpl
implements UccSkuPriceModifyAtomService {
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccGoodsPriceChangeLogMapper uccGoodsPriceChangeLogMapper;
    @Autowired
    private UccSkuPriceLogMapper uccSkuPriceLogMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPriceChangeSyncOoocAtomService uccSkuPriceChangeSyncOoocAtomService;
    @Value(value="${ucc.skuPrice.sync.oooc.type:1}")
    private Integer syncType;
    @Value(value="${ucc.skuPrice.sync.oooc.poolName:diyicai}")
    private String poolName;

    @Override
    public UccSkuPriceModifyAtomServiceRspBo skuPriceChange(UccSkuPriceModifyAtomServiceReqBo reqBo) {
        this.val(reqBo);
        if (UccConstants.SkuPriceChangeType.COEFFICIENT.equals(reqBo.getChangeType())) {
            this.changePriceByAddCoefficient(reqBo);
        } else {
            this.changePriceNormal(reqBo);
        }
        UccSkuPriceModifyAtomServiceRspBo rspBo = new UccSkuPriceModifyAtomServiceRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void changePriceNormal(UccSkuPriceModifyAtomServiceReqBo reqBo) {
        Map<Long, SkuPriceBo> skuPriceBoMap = reqBo.getSkuPriceBos().stream().collect(Collectors.toMap(SkuPriceBo::getSkuId, o -> o));
        List<UccSkuPricePo> uccSkuPricePos = this.uccSkuPriceMapper.batchQryPriBySkuIds(new ArrayList<Long>(skuPriceBoMap.keySet()), null);
        if (!CollectionUtils.isEmpty(uccSkuPricePos)) {
            Map<Long, UccSkuPricePo> uccSkuPricePoMap = uccSkuPricePos.stream().collect(Collectors.toMap(UccSkuPricePo::getSkuId, o -> o));
            List<UccSkuPo> uccSkuPos = this.uccSkuMapper.batchQrySku(new ArrayList<Long>(skuPriceBoMap.keySet()), null);
            Map<Long, UccSkuPo> uccSkuPoMap = uccSkuPos.stream().collect(Collectors.toMap(UccSkuPo::getSkuId, o -> o));
            ArrayList<Long> skuPriceIds = new ArrayList<Long>();
            for (SkuPriceBo skuPriceBo : reqBo.getSkuPriceBos()) {
                UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
                uccSkuPricePo.setSkuPriceId(uccSkuPricePoMap.get(skuPriceBo.getSkuId()).getSkuPriceId());
                uccSkuPricePo.setSalePrice(skuPriceBo.getSalePrice());
                uccSkuPricePo.setAgreementPrice(skuPriceBo.getAgreementPrice());
                uccSkuPricePo.setMarketPrice(skuPriceBo.getMarketPrice());
                uccSkuPricePo.setMemberPrice1(skuPriceBo.getMemberPrice1());
                uccSkuPricePo.setMemberPrice2(skuPriceBo.getMemberPrice2());
                uccSkuPricePo.setMemberPrice3(skuPriceBo.getMemberPrice3());
                uccSkuPricePo.setMemberPrice4(skuPriceBo.getMemberPrice4());
                uccSkuPricePo.setMemberPrice5(skuPriceBo.getMemberPrice5());
                uccSkuPricePo.setUpdateTime(new Date());
                this.uccSkuPriceMapper.updateSkuPriceById(uccSkuPricePo);
                skuPriceIds.add(uccSkuPricePoMap.get(skuPriceBo.getSkuId()).getSkuPriceId());
            }
            List<UccSkuPricePo> updatedUccSkuPricePoList = this.uccSkuPriceMapper.batchQryPriByIds(skuPriceIds);
            this.addChangeLog(uccSkuPricePos, uccSkuPoMap, new ArrayList<Long>(uccSkuPricePoMap.keySet()), updatedUccSkuPricePoList);
            this.syncOooc(updatedUccSkuPricePoList);
        }
    }

    private void syncOooc(List<UccSkuPricePo> updatedUccSkuPricePoList) {
        UccSkuPriceChangeSyncOoocAtomServiceReqBo uccSkuPriceChangeSyncOoocAtomServiceReqBo = new UccSkuPriceChangeSyncOoocAtomServiceReqBo();
        ArrayList<UccSkuPriceChangeBo> skuPriceList = new ArrayList<UccSkuPriceChangeBo>();
        for (UccSkuPricePo uccSkuPricePo : updatedUccSkuPricePoList) {
            UccSkuPriceChangeBo uccSkuPriceChangeBo = new UccSkuPriceChangeBo();
            uccSkuPriceChangeBo.setSkuId(uccSkuPricePo.getSkuId());
            uccSkuPriceChangeBo.setChangeTime(new Date());
            uccSkuPriceChangeBo.setPoolName(this.poolName);
            uccSkuPriceChangeBo.setPriceType("sales");
            uccSkuPriceChangeBo.setPriceValue(MoneyUtils.haoToYuan(uccSkuPricePo.getSalePrice()));
            skuPriceList.add(uccSkuPriceChangeBo);
        }
        uccSkuPriceChangeSyncOoocAtomServiceReqBo.setSkuPriceList(skuPriceList);
        uccSkuPriceChangeSyncOoocAtomServiceReqBo.setSyncType(this.syncType);
        this.uccSkuPriceChangeSyncOoocAtomService.priceSyncOooc(uccSkuPriceChangeSyncOoocAtomServiceReqBo);
    }

    private void changePriceByAddCoefficient(UccSkuPriceModifyAtomServiceReqBo reqBo) {
        List<UccSkuPricePo> uccSkuPricePos = this.uccSkuPriceMapper.batchQryPriBySkuIds(reqBo.getSkuIds(), null);
        if (!CollectionUtils.isEmpty(uccSkuPricePos)) {
            List<Long> skuPriceIds = uccSkuPricePos.stream().map(UccSkuPricePo::getSkuPriceId).collect(Collectors.toList());
            List<UccSkuPo> uccSkuPos = this.uccSkuMapper.batchQrySku(reqBo.getSkuIds(), null);
            Map<Long, UccSkuPo> uccSkuPoMap = uccSkuPos.stream().collect(Collectors.toMap(UccSkuPo::getSkuId, o -> o));
            this.changePrice(reqBo, skuPriceIds);
            List<UccSkuPricePo> updatedUccSkuPricePoList = this.uccSkuPriceMapper.batchQryPriByIds(skuPriceIds);
            this.addChangeLog(uccSkuPricePos, uccSkuPoMap, skuPriceIds, updatedUccSkuPricePoList);
            this.syncOooc(updatedUccSkuPricePoList);
        }
    }

    private void changePrice(UccSkuPriceModifyAtomServiceReqBo reqBo, List<Long> skuPriceIds) {
        BigDecimal addCoefficient = reqBo.getAddCoefficient().add(new BigDecimal(100)).divide(new BigDecimal(100), 2, 2);
        this.uccSkuPriceMapper.updateSalePrice(skuPriceIds, reqBo.getAllowMarketPrice(), addCoefficient);
    }

    private void addChangeLog(List<UccSkuPricePo> uccSkuPricePos, Map<Long, UccSkuPo> uccSkuPoMap, List<Long> skuPriceIds, List<UccSkuPricePo> updatedUccSkuPricePoList) {
        Map<Long, UccSkuPricePo> uccSkuPricePoMap = updatedUccSkuPricePoList.stream().collect(Collectors.toMap(UccSkuPricePo::getSkuPriceId, o -> o));
        ArrayList<UccGoodsPriceChangeLogPO> uccGoodsPriceChangeLogPOS = new ArrayList<UccGoodsPriceChangeLogPO>();
        ArrayList<UccSkuPriceLogPo> uccSkuPriceLogPos = new ArrayList<UccSkuPriceLogPo>();
        Long batchId = Sequence.getInstance().nextId();
        Date now = new Date();
        for (UccSkuPricePo uccSkuPricePo : uccSkuPricePos) {
            UccGoodsPriceChangeLogPO uccGoodsPriceChangeLogPO = new UccGoodsPriceChangeLogPO();
            uccGoodsPriceChangeLogPO.setPriceChangeLogId(Sequence.getInstance().nextId());
            uccGoodsPriceChangeLogPO.setSkuId(uccSkuPricePo.getSkuId());
            uccGoodsPriceChangeLogPO.setCommodityId(uccSkuPoMap.get(uccSkuPricePo.getSkuId()).getCommodityId());
            uccGoodsPriceChangeLogPO.setSupplierShopId(uccSkuPoMap.get(uccSkuPricePo.getSkuId()).getSupplierShopId());
            uccGoodsPriceChangeLogPO.setChangeTime(now);
            uccGoodsPriceChangeLogPO.setOldPrice(uccSkuPricePo.getSalePrice());
            uccGoodsPriceChangeLogPO.setCurrentPrice(uccSkuPricePoMap.get(uccSkuPricePo.getSkuPriceId()).getSalePrice());
            uccGoodsPriceChangeLogPO.setChangeRange(new BigDecimal(uccGoodsPriceChangeLogPO.getCurrentPrice()).subtract(new BigDecimal(uccGoodsPriceChangeLogPO.getOldPrice())).doubleValue());
            uccGoodsPriceChangeLogPO.setChangeSnNo(batchId.toString());
            uccGoodsPriceChangeLogPOS.add(uccGoodsPriceChangeLogPO);
            UccSkuPriceLogPo uccSkuPriceLogPo = (UccSkuPriceLogPo)JSON.parseObject((String)JSON.toJSONString((Object)uccSkuPricePoMap.get(uccSkuPricePo.getSkuPriceId())), UccSkuPriceLogPo.class);
            uccSkuPriceLogPo.setBatchId(batchId);
            uccSkuPriceLogPo.setUpdateTime(now);
            uccSkuPriceLogPos.add(uccSkuPriceLogPo);
        }
        if (!CollectionUtils.isEmpty(uccGoodsPriceChangeLogPOS)) {
            this.uccGoodsPriceChangeLogMapper.insertBatch(uccGoodsPriceChangeLogPOS);
        }
        if (!CollectionUtils.isEmpty(uccSkuPriceLogPos)) {
            this.uccSkuPriceLogMapper.insertBatch(uccSkuPriceLogPos);
        }
    }

    private void val(UccSkuPriceModifyAtomServiceReqBo reqBo) {
        if (UccConstants.SkuPriceChangeType.COEFFICIENT.equals(reqBo.getChangeType())) {
            if (CollectionUtils.isEmpty(reqBo.getSkuIds())) {
                throw new BusinessException("8888", "\u5165\u53c2skuId\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == reqBo.getAddCoefficient()) {
                throw new BusinessException("8888", "\u5165\u53c2addCoefficient\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == reqBo.getAllowMarketPrice()) {
                throw new BusinessException("8888", "\u5165\u53c2allowMarketPrice\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if (CollectionUtils.isEmpty(reqBo.getSkuPriceBos())) {
            throw new BusinessException("8888", "\u5165\u53c2skuPriceBos\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

