/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.busibase.busi.api.UccGeneralBusiRuleExecService;
import com.tydic.commodity.busibase.busi.bo.UccGeneralBusiRuleExecReqBO;
import com.tydic.commodity.busibase.busi.bo.UccGeneralBusiRuleExecRspBO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccGeneralBusiRuleExecServiceImpl
implements UccGeneralBusiRuleExecService {
    private static final Logger log = LoggerFactory.getLogger(UccGeneralBusiRuleExecServiceImpl.class);
    @Value(value="${qry.rule.url}")
    private String qryRuleUrl;
    @Value(value="${call.rule.url}")
    private String callRuleUrl;

    @Override
    public UccGeneralBusiRuleExecRspBO generalBusiRuleExec(UccGeneralBusiRuleExecReqBO reqBO) {
        UccGeneralBusiRuleExecRspBO rspBO = new UccGeneralBusiRuleExecRspBO();
        JSONObject qryRuleReqJsonObj = new JSONObject();
        qryRuleReqJsonObj.put("serviceCode", (Object)reqBO.getServiceCode());
        qryRuleReqJsonObj.put("dealType", (Object)"RULE_TYPE_BUSINESS");
        String qryRuleRspJsonObjStr = HttpUtil.post((String)this.qryRuleUrl, (String)qryRuleReqJsonObj.toJSONString(), (int)4000);
        JSONObject qryRuleRspJsonObj = JSON.parseObject((String)qryRuleRspJsonObjStr);
        JSONArray ruleInfos = qryRuleRspJsonObj.getJSONArray("ruleInfos");
        if (!ruleInfos.isEmpty()) {
            for (int i = 0; i < ruleInfos.size(); ++i) {
                JSONObject ruleInfo = JSON.parseObject((String)JSON.toJSONString((Object)ruleInfos.get(i)));
                List fields = ruleInfo.getJSONArray("fields").toJavaList(String.class);
                Long ruleId = ruleInfo.getLong("ruleId");
                JSONObject callRuleReqJsonObj = new JSONObject();
                callRuleReqJsonObj.put("ruleId", (Object)ruleId);
                if (!CollectionUtils.isEmpty((Collection)fields)) {
                    Map<String, Object> ruleParams = reqBO.getParamMap();
                    JSONObject callRuleReqParamsJsonObj = new JSONObject();
                    for (String field : fields) {
                        if (!ruleParams.containsKey(field)) continue;
                        callRuleReqParamsJsonObj.put(field, ruleParams.get(field));
                    }
                    callRuleReqJsonObj.put("params", (Object)callRuleReqParamsJsonObj.toJSONString());
                }
                log.info("\u8c03\u7528\u89c4\u5219\u5f15\u64ce\u5165\u53c2\u4e3a\uff1a" + callRuleReqJsonObj.toJSONString());
                String callRuleRspJsonObjStr = HttpUtil.post((String)this.callRuleUrl, (String)callRuleReqJsonObj.toJSONString(), (int)4000);
                log.info("\u8c03\u7528\u89c4\u5219\u5f15\u64ce\u51fa\u53c2\u4e3a\uff1a" + callRuleRspJsonObjStr);
                JSONObject callRuleRspJsonObj = JSON.parseObject((String)callRuleRspJsonObjStr);
                JSONObject resultJson = callRuleRspJsonObj.getJSONObject("result");
                if (resultJson == null) {
                    throw new ZTBusinessException("\u4e1a\u52a1\u89c4\u5219\u6267\u884c\u5931\u8d25\uff01");
                }
                rspBO.setBusiRuleExecResult(JSON.toJSONString((Object)resultJson));
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

