/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.enumType.ApprovalTypeEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccApproveCreationAtomService;
import com.tydic.commodity.busibase.atom.api.UccSkuPutCirAtomService;
import com.tydic.commodity.busibase.atom.api.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.busibase.atom.bo.UccApproveCreationAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccApproveCreationAtomRspBO;
import com.tydic.commodity.busibase.atom.bo.UccSkuPutCirReqBO;
import com.tydic.commodity.busibase.atom.bo.UccSkuUpdateStatusBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomRspBO;
import com.tydic.commodity.busibase.busi.api.UccGeneralBusiRuleExecService;
import com.tydic.commodity.busibase.busi.api.UccUpAndOffApplyBusiService;
import com.tydic.commodity.busibase.busi.bo.ExtReqBO;
import com.tydic.commodity.busibase.busi.bo.UccGeneralBusiRuleExecReqBO;
import com.tydic.commodity.busibase.busi.bo.UccGeneralBusiRuleExecRspBO;
import com.tydic.commodity.busibase.busi.bo.UccUpAndOffApplyAbilityReqBO;
import com.tydic.commodity.busibase.busi.bo.UccUpAndOffApplyAbilityRspBO;
import com.tydic.commodity.busibase.comb.api.DycUccSendHaveDoneCombService;
import com.tydic.commodity.busibase.comb.bo.DycUccSendHaveDoneCombReqBO;
import com.tydic.commodity.busibase.comb.bo.DycUccSendHaveDoneCombRspBO;
import com.tydic.commodity.consumer.bo.DycUccApproveTaskSyncBO;
import com.tydic.commodity.dao.EacRuTaskMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.EacRuTaskPO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.DateUtils;
import com.tydic.commodity.utils.ListUtils;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.dyc.umc.service.todo.UmcSendHaveDoneService;
import com.tydic.osworkflow.approve.ability.EacRuTaskAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacApproveAbilityRspInfoBO;
import com.tydic.osworkflow.approve.ability.bo.EacRuInstAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacRuInstAbilityRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccUpAndOffApplyBusiServiceImpl
implements UccUpAndOffApplyBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccUpAndOffApplyBusiServiceImpl.class);
    @Value(value="${SERVICE_CODE:UCC001}")
    private String SERVICE_CODE;
    @Value(value="${NULL_PROCESS:NULL_PROCESS}")
    private String NULL_PROCESS;
    @Resource(name="dycUccProcessTaskSyncBySelfProducer")
    private ProxyMessageProducer dycUccProcessTaskSyncBySelfProducer;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccApproveCreationAtomService uccApproveCreationAtomService;
    @Autowired
    private UccSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;
    @Autowired
    private UccSkuPutCirAtomService uccSkuPutCirAtomService;
    @Autowired
    private UccGeneralBusiRuleExecService uccGeneralBusiRuleExecService;
    @Autowired
    private EacRuTaskMapper eacRuTaskMapper;
    @Autowired
    private EacRuTaskAbilityService eacRuTaskAbilityService;
    @Autowired
    private UmcSendHaveDoneService umcSendHaveDoneService;
    @Autowired
    private DycUccSendHaveDoneCombService dycUccSendHaveDoneCombService;

    @Override
    public UccUpAndOffApplyAbilityRspBO dealUpAndOffApply(UccUpAndOffApplyAbilityReqBO reqBO, ExtReqBO extReqBO) {
        UccUpAndOffApplyAbilityRspBO rspBO = new UccUpAndOffApplyAbilityRspBO();
        if (CollectionUtils.isEmpty(reqBO.getBatchSkuList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u7533\u8bf7\u5355\u54c1\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isEmpty((Object)extReqBO.getProcess())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5ba1\u6279\u6d41\u83dc\u5355\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        Map<Long, List<UccBatchSkuBO>> mapSku = reqBO.getBatchSkuList().stream().collect(Collectors.groupingBy(UccBatchSkuBO::getSupplierShopId));
        ArrayList<Long> skus = new ArrayList();
        Iterator<Long> iteratorSku = mapSku.keySet().iterator();
        UccGeneralBusiRuleExecReqBO uccGeneralBusiRuleExecReqBO = new UccGeneralBusiRuleExecReqBO();
        uccGeneralBusiRuleExecReqBO.setServiceCode(this.SERVICE_CODE);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("orgId", reqBO.getOrgId().toString());
        paramMap.put("inProcessKey", extReqBO.getProcess());
        uccGeneralBusiRuleExecReqBO.setParamMap(paramMap);
        UccGeneralBusiRuleExecRspBO uccGeneralBusiRuleExecRspBO = this.uccGeneralBusiRuleExecService.generalBusiRuleExec(uccGeneralBusiRuleExecReqBO);
        if (!"0000".equals(uccGeneralBusiRuleExecRspBO.getRespCode())) {
            throw new BusinessException("8888", uccGeneralBusiRuleExecRspBO.getRespDesc());
        }
        if (StringUtils.isEmpty((Object)uccGeneralBusiRuleExecRspBO.getBusiRuleExecResult())) {
            throw new BusinessException("8888", "\u89c4\u5219\u5f15\u64ce\u51fa\u53c2\u8fd4\u56de\u4e3a\u7a7a");
        }
        Map resultMap = (Map)JSON.parseObject((String)uccGeneralBusiRuleExecRspBO.getBusiRuleExecResult(), Map.class);
        if (resultMap.containsKey("changedProcessKey") && !StringUtils.isEmpty(resultMap.get("changedProcessKey"))) {
            extReqBO.setProcess((String)resultMap.get("changedProcessKey"));
        } else {
            throw new BusinessException("8888", "\u89c4\u5219\u5f15\u64ce\u51fa\u53c2\u8fd4\u56dechangedProcessKey\u4e3a\u7a7a");
        }
        while (iteratorSku.hasNext()) {
            Long supplierShopId = iteratorSku.next();
            skus = mapSku.get(supplierShopId).stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
            List<UccSkuPo> uccSkuPos = null;
            uccSkuPos = this.uccSkuMapper.batchQrySku(skus, supplierShopId);
            List<Long> failIds = new ArrayList();
            List<Long> failIdAudit = new ArrayList();
            HashSet<Long> editSpu = new HashSet<Long>();
            if (uccSkuPos.size() < skus.size()) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5b58\u5728\u65e0\u6548\u5355\u54c1\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2");
                return rspBO;
            }
            try {
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(uccSkuPos)) {
                    for (UccSkuPo uccSkuPo : uccSkuPos) {
                        if (extReqBO.getStatusOld().contains(uccSkuPo.getSkuStatus())) continue;
                        failIds.add(uccSkuPo.getSkuId());
                    }
                    for (UccSkuPo uccSkuPo : uccSkuPos) {
                        if (StringUtils.isEmpty((Object)uccSkuPo.getApprovalStatus())) continue;
                        if (ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_PUSH_GO.equals(Integer.valueOf(uccSkuPo.getApprovalStatus())) || ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_RECOVER_GO.equals(Integer.valueOf(uccSkuPo.getApprovalStatus())) || ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_DOWN_GO.equals(Integer.valueOf(uccSkuPo.getApprovalStatus()))) {
                            failIdAudit.add(uccSkuPo.getSkuId());
                        }
                        if (ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_EDIT_GO.equals(Integer.valueOf(uccSkuPo.getApprovalStatus())) && !ModelRuleConstant.UAC_APPROVAL_TYPE_DOWN.equals(extReqBO.getAuditObjType())) {
                            failIdAudit.add(uccSkuPo.getSkuId());
                        }
                        if (!ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_EDIT_GO.equals(Integer.valueOf(uccSkuPo.getApprovalStatus())) || !ModelRuleConstant.UAC_APPROVAL_TYPE_DOWN.equals(extReqBO.getAuditObjType())) continue;
                        editSpu.add(uccSkuPo.getCommodityId());
                    }
                }
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(failIds = ListUtils.removeNull(failIds))) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u5355\u54c1" + failIds.toString() + "\u5f53\u524d\u72b6\u6001\u4e0d\u6b63\u786e");
                    return rspBO;
                }
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(failIdAudit = ListUtils.removeNull(failIdAudit))) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u5355\u54c1" + failIdAudit.toString() + "\u6b63\u5728\u5ba1\u6279\u4e2d");
                    return rspBO;
                }
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u5931\u8d25");
            }
            ArrayList<Long> editSpuAray = new ArrayList<Long>(editSpu);
            if (!CollectionUtils.isEmpty(editSpuAray)) {
                log.info("-----------------------\u64a4\u9500\u5ba1\u6279\u670d\u52a1\uff0c\u8c03\u6d41\u7a0b\u7ec8\u6b62\u670d\u52a1\uff0cspuId::{}", (Object)JSON.toJSONString(editSpuAray));
                this.dealApproveRollBack(editSpuAray, reqBO);
                try {
                    this.uccCommodityMapper.batchUpdateSpuApprovalStatus(editSpuAray, null, supplierShopId);
                    this.uccCommodityMapper.batchUpdateStep(editSpuAray, null, supplierShopId);
                }
                catch (Exception e) {
                    throw new BusinessException("8888", e.getMessage());
                }
            }
            UccApproveCreationAtomRspBO uccApproveCreationAtomRspBO = new UccApproveCreationAtomRspBO();
            if (!reqBO.getNeedProcess().booleanValue()) {
                uccApproveCreationAtomRspBO.setFinish(true);
            } else if (!extReqBO.getProcess().equals(this.NULL_PROCESS)) {
                UccApproveCreationAtomReqBO approveCreationAtomReqBO = new UccApproveCreationAtomReqBO();
                BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)approveCreationAtomReqBO));
                approveCreationAtomReqBO.setObjId(skus);
                approveCreationAtomReqBO.setMenuId(extReqBO.getProcess());
                approveCreationAtomReqBO.setObjType(extReqBO.getAuditObjType());
                approveCreationAtomReqBO.setOrderId(supplierShopId);
                approveCreationAtomReqBO.setUserId(reqBO.getUserId());
                try {
                    uccApproveCreationAtomRspBO = this.uccApproveCreationAtomService.createApprove(approveCreationAtomReqBO);
                }
                catch (Exception e) {
                    throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), e.getMessage());
                }
                if (!"0000".equals(uccApproveCreationAtomRspBO.getRespCode())) {
                    throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), uccApproveCreationAtomRspBO.getRespDesc());
                }
            } else {
                uccApproveCreationAtomRspBO.setFinish(true);
            }
            if (uccApproveCreationAtomRspBO.getFinish().booleanValue()) {
                UccSkuPutCirReqBO uccSkuPutCirReqBO;
                this.updateSkuStatus(extReqBO.getStatusApproval(), "", "", skus, supplierShopId, reqBO);
                if (ModelRuleConstant.UAC_APPROVAL_TYPE_DOWN.equals(extReqBO.getAuditObjType())) {
                    try {
                        for (Long skuId : skus) {
                            uccSkuPutCirReqBO = new UccSkuPutCirReqBO();
                            uccSkuPutCirReqBO.setSkuId(skuId);
                            uccSkuPutCirReqBO.setSupplierShopId(supplierShopId);
                            uccSkuPutCirReqBO.setDownType(extReqBO.getOperate());
                            uccSkuPutCirReqBO.setRealDownTime(DateUtils.dateToStr(new Date()));
                            uccSkuPutCirReqBO.setCreateOperId(reqBO.getUsername());
                            uccSkuPutCirReqBO.setRemark(extReqBO.getRemark());
                            this.uccSkuPutCirAtomService.dealSkuPutCir(uccSkuPutCirReqBO);
                        }
                    }
                    catch (Exception e) {
                        throw new BusinessException("8888", "\u63d2\u5165\u4e0a\u4e0b\u67b6\u5468\u671f\u8868\u5931\u8d25");
                    }
                }
                if (!ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF.equals(extReqBO.getAuditObjType())) continue;
                try {
                    for (Long skuId : skus) {
                        uccSkuPutCirReqBO = new UccSkuPutCirReqBO();
                        uccSkuPutCirReqBO.setSkuId(skuId);
                        uccSkuPutCirReqBO.setSupplierShopId(supplierShopId);
                        uccSkuPutCirReqBO.setUptype(extReqBO.getOperate());
                        uccSkuPutCirReqBO.setRealUpTime(DateUtils.dateToStr(new Date()));
                        uccSkuPutCirReqBO.setCreateOperId(reqBO.getUsername());
                        uccSkuPutCirReqBO.setRemark(extReqBO.getRemark());
                        this.uccSkuPutCirAtomService.dealSkuPutCir(uccSkuPutCirReqBO);
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new BusinessException("8888", "\u66f4\u65b0\u4e0a\u4e0b\u67b6\u5468\u671f\u8868\u5931\u8d25");
                }
            }
            try {
                this.updateSkuStatus(extReqBO.getStatusApply(), extReqBO.getAuditStatusApply(), uccApproveCreationAtomRspBO.getStepId(), skus, supplierShopId, reqBO);
            }
            catch (Exception e) {
                throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), e.getMessage());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updateSkuStatus(Integer newStatus, String newApprovalStatus, String newStepId, List<Long> skus, Long supplierShopId, UccUpAndOffApplyAbilityReqBO reqBO) {
        UccStatusChangeUpdateSpuAtomRspBO statusChangeUpdateSpuAtomRspBO = null;
        UccStatusChangeUpdateSpuAtomReqBO uccStatusChangeUpdateSpuAtomReqBO = new UccStatusChangeUpdateSpuAtomReqBO();
        ArrayList<UccSkuUpdateStatusBO> skuUpdateStatusBOS = new ArrayList<UccSkuUpdateStatusBO>();
        UccSkuUpdateStatusBO bo = null;
        for (Long each : skus) {
            bo = new UccSkuUpdateStatusBO();
            bo.setSkuId(each);
            bo.setSkuStatus(newStatus);
            if (ModelRuleConstant.SKU_STATUS_ON_SHELF.equals(newStatus)) {
                bo.setOnShelveTime(new Date());
            }
            skuUpdateStatusBOS.add(bo);
        }
        uccStatusChangeUpdateSpuAtomReqBO.setSkuStatusList(skuUpdateStatusBOS);
        uccStatusChangeUpdateSpuAtomReqBO.setSupplierShopId(supplierShopId);
        uccStatusChangeUpdateSpuAtomReqBO.setUserId(reqBO.getUserId());
        uccStatusChangeUpdateSpuAtomReqBO.setApprovalStatus(newApprovalStatus);
        uccStatusChangeUpdateSpuAtomReqBO.setStepId(newStepId);
        try {
            statusChangeUpdateSpuAtomRspBO = this.uccSkuStatusUpdatesAtomService.delaStatusChange(uccStatusChangeUpdateSpuAtomReqBO);
            if (!"0000".equals(statusChangeUpdateSpuAtomRspBO.getRespCode())) {
                throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), statusChangeUpdateSpuAtomRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), e.getMessage());
        }
    }

    private void dealApproveRollBack(List<Long> businessIdList, UccUpAndOffApplyAbilityReqBO reqBO) {
        log.info("\u64a4\u9500\u5ba1\u6279\u540e\u7eed\u64cd\u4f5c-----------businessIdList:{}", (Object)JSON.toJSONString(businessIdList));
        EacRuTaskPO eacRuTaskPO = new EacRuTaskPO();
        eacRuTaskPO.setBusinessIds(businessIdList.stream().map(Object::toString).collect(Collectors.toList()));
        eacRuTaskPO.setObjType(Integer.parseInt(ApprovalTypeEnum.uccEditProcessOrder.getStep()));
        eacRuTaskPO.setStatus("ACTIVE");
        List<EacRuTaskPO> taskList = this.eacRuTaskMapper.getList(eacRuTaskPO);
        Map<String, List<EacRuTaskPO>> collect = taskList.stream().collect(Collectors.groupingBy(EacRuTaskPO::getApproveInstId));
        ArrayList<EacApproveAbilityRspInfoBO> list = new ArrayList<EacApproveAbilityRspInfoBO>();
        for (String approveInstId : collect.keySet()) {
            EacRuInstAbilityReqBO eacRuInstAbilityReqBO = new EacRuInstAbilityReqBO();
            eacRuInstAbilityReqBO.setApproveInstId(approveInstId);
            try {
                log.info("\u5ba1\u6279\u5355\u5ba1\u6279\u6d41\u7a0b\u7ec8\u6b62\u5165\u53c2eacRuInstAbilityReqBO:" + JSON.toJSON((Object)eacRuInstAbilityReqBO));
                EacRuInstAbilityRspBO eacRuInstAbilityRspBO = this.eacRuTaskAbilityService.suspensionApprove(eacRuInstAbilityReqBO);
                log.info("\u5ba1\u6279\u5355\u5ba1\u6279\u6d41\u7a0b\u7ec8\u6b62\u51fa\u53c2eacRuInstAbilityRspBO:" + JSON.toJSON((Object)eacRuInstAbilityRspBO));
                if (!"0000".equals(eacRuInstAbilityRspBO.getRespCode())) {
                    throw new BusinessException(RspConstantEnums.COMMODITY_APPROVAL_PASS_FAIL.code(), eacRuInstAbilityRspBO.getRespDesc());
                }
            }
            catch (BusinessException e) {
                throw new BusinessException(RspConstantEnums.COMMODITY_APPROVAL_PASS_FAIL.code(), e.getMsgInfo());
            }
            EacApproveAbilityRspInfoBO eacApproveAbilityRspInfoBO = new EacApproveAbilityRspInfoBO();
            eacApproveAbilityRspInfoBO.setApproveInstId(approveInstId);
            eacApproveAbilityRspInfoBO.setIsFinish(Boolean.valueOf(true));
            eacApproveAbilityRspInfoBO.setTacheCode(collect.get(approveInstId).get(0).getTacheCode());
            eacApproveAbilityRspInfoBO.setTacheName(collect.get(approveInstId).get(0).getTacheName());
            list.add(eacApproveAbilityRspInfoBO);
        }
        log.info("----------------------list:{}", (Object)JSON.toJSONString(list));
        for (EacApproveAbilityRspInfoBO each : list) {
            try {
                DycUccApproveTaskSyncBO dycUccApproveTaskSyncBO = new DycUccApproveTaskSyncBO();
                dycUccApproveTaskSyncBO.setIsfinish(null);
                dycUccApproveTaskSyncBO.setIsfinish(each.getIsFinish());
                dycUccApproveTaskSyncBO.setProcInstId(each.getApproveInstId());
                log.info("------------------\u64a4\u9500\u5ba1\u6279\u540e\u7eed\u64cd\u4f5c\uff0c\u4eff\u7167\u5ba1\u6279\u4e2d\u5fc3\u53d1\u9001mq\uff1a{}" + JSON.toJSONString((Object)dycUccApproveTaskSyncBO));
                this.dycUccProcessTaskSyncBySelfProducer.send(new ProxyMessage(PropertiesUtil.getProperty("UCC_APPROVE_TASK_SYNC_BY_SELF_TOPIC"), PropertiesUtil.getProperty("APPROVE_TASK_SYNC_TAG"), JSON.toJSONString((Object)dycUccApproveTaskSyncBO)));
            }
            catch (Exception e) {
                log.error("\u64a4\u9500\u5ba1\u6279\u540e\u7eed\u64cd\u4f5c\uff0c\u4eff\u7167\u5ba1\u6279\u4e2d\u5fc3\u53d1\u9001mq\u5931\u8d25\uff1a" + e.getMessage());
            }
            try {
                DycUccSendHaveDoneCombReqBO dycUccSendHaveDoneCombReqBO = new DycUccSendHaveDoneCombReqBO();
                dycUccSendHaveDoneCombReqBO.setApproveInstId(each.getApproveInstId());
                dycUccSendHaveDoneCombReqBO.setTacheCode(each.getTacheCode());
                dycUccSendHaveDoneCombReqBO.setCreateUserId(reqBO.getUserId());
                dycUccSendHaveDoneCombReqBO.setCreateUserName(reqBO.getUsername());
                log.info("\u64a4\u9500\u5ba1\u6279\u540e\u7eed\u64cd\u4f5c\uff0c\u6d41\u7a0b\u7ed3\u675f\uff0c\u53d1\u9001\u5df2\u529e\u5165\u53c2dycUccSendHaveDoneCombReqBO:{}", (Object)JSON.toJSONString((Object)dycUccSendHaveDoneCombReqBO));
                DycUccSendHaveDoneCombRspBO dycUccSendHaveDoneCombRspBO = this.dycUccSendHaveDoneCombService.sendHaveDone(dycUccSendHaveDoneCombReqBO);
                log.info("\u64a4\u9500\u5ba1\u6279\u540e\u7eed\u64cd\u4f5c\uff0c\u6d41\u7a0b\u7ed3\u675f\uff0c\u53d1\u9001\u5df2\u529e\u51fa\u53c2dycUccSendHaveDoneCombRspBO:{}", (Object)JSON.toJSONString((Object)((Object)dycUccSendHaveDoneCombRspBO)));
            }
            catch (Exception e) {
                log.info("\u64a4\u9500\u5ba1\u6279\u540e\u7eed\u64cd\u4f5c\uff0c\u6d41\u7a0b\u7ed3\u675f\uff0c\u53d1\u9001\u5df2\u529e\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
    }
}

