/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.consumer;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.commodity.base.bo.SelfRunSyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.busibase.busi.api.UccApplyListFlowMsgBusiService;
import com.tydic.commodity.busibase.busi.api.UccApproveTaskSyncBusiService;
import com.tydic.commodity.busibase.busi.api.UccDealTaskBusiService;
import com.tydic.commodity.busibase.busi.bo.UccApplyListFlowMsgBusiReqBo;
import com.tydic.commodity.busibase.busi.bo.UccApplyListFlowMsgBusiRspBo;
import com.tydic.commodity.busibase.busi.bo.UccApproveTaskSyncBusiReqBO;
import com.tydic.commodity.busibase.busi.bo.UccApproveTaskSyncBusiRspBO;
import com.tydic.commodity.busibase.busi.bo.UccDealTaskBusiReqBO;
import com.tydic.commodity.busibase.busi.bo.UccProcessTaskBO;
import com.tydic.commodity.consumer.bo.DycUccApproveTaskSyncBO;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.utils.PropertiesUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class DycUccApproveTaskSyncConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(DycUccApproveTaskSyncConsumer.class);
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccApproveTaskSyncBusiService uccApproveTaskSyncBusiService;
    @Autowired
    private UccApplyListFlowMsgBusiService uccApplyListFlowMsgBusiService;
    @Autowired
    private UccDealTaskBusiService uccDealTaskBusiService;

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        log.info("\u6d41\u7a0b\u4efb\u52a1\u6d88\u8d39\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)proxyMessage));
        if ("UCC_NEW_TAG".equals(proxyMessage.getTag())) {
            String content = proxyMessage.getContent();
            log.info("\u6d41\u7a0b\u4efb\u52a1\u6d88\u8d39\u8005New\u6536\u5230\uff0c\u6570\u636e\u5185\u5bb9\u5982\u4e0b:{}" + content);
            try {
                DycUccApproveTaskSyncBO dycUccApproveTaskSyncBO = (DycUccApproveTaskSyncBO)JSON.parseObject((String)content, DycUccApproveTaskSyncBO.class);
                log.info("\u8f6c\u6362\u540e\u53c2\u6570\u5982\u4e0b:{}", (Object)JSON.toJSONString((Object)dycUccApproveTaskSyncBO));
                if (dycUccApproveTaskSyncBO != null) {
                    log.info("\u5ba1\u6279\u56de\u8c03\u6d88\u8d39\u8005mq\u6536\u5230\u7684\u6d41\u7a0b\u5b9e\u4f8bId:" + dycUccApproveTaskSyncBO.getProcInstId());
                    UccDealTaskBusiReqBO uccDealTaskBusiReqBO = new UccDealTaskBusiReqBO();
                    uccDealTaskBusiReqBO.setNextTaskInfos(dycUccApproveTaskSyncBO.getTaskList());
                    uccDealTaskBusiReqBO.getNextTaskInfos().forEach(approveTaskSyncBO -> approveTaskSyncBO.setApproveInstId(dycUccApproveTaskSyncBO.getProcInstId()));
                    this.uccDealTaskBusiService.dealTask(uccDealTaskBusiReqBO);
                    return ProxyConsumerStatus.CONSUME_SUCCESS;
                }
                log.error("\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a");
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            catch (Exception e) {
                log.error("\u6570\u636e\u540c\u6b65\u6d88\u8d39\u8005\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
        }
        if ("UCC_TAG".equals(proxyMessage.getTag())) {
            String content = proxyMessage.getContent();
            log.info("\u6d41\u7a0b\u4efb\u52a1\u6d88\u8d39\u8005\u6536\u5230\uff0c\u6570\u636e\u5185\u5bb9\u5982\u4e0b:{}" + content);
            try {
                DycUccApproveTaskSyncBO dycUccApproveTaskSyncBO = (DycUccApproveTaskSyncBO)JSON.parseObject((String)content, DycUccApproveTaskSyncBO.class);
                log.info("\u8f6c\u6362\u540e\u53c2\u6570\u5982\u4e0b:{}", (Object)JSON.toJSONString((Object)dycUccApproveTaskSyncBO));
                UccApplyListFlowMsgBusiReqBo uccApplyListFlowMsgBusiReqBo = (UccApplyListFlowMsgBusiReqBo)JSON.parseObject((String)content, UccApplyListFlowMsgBusiReqBo.class);
                log.info("\u8f6c\u6362\u540e\u53c2\u65702\u5982\u4e0b:{}", (Object)JSON.toJSONString((Object)uccApplyListFlowMsgBusiReqBo));
                if (uccApplyListFlowMsgBusiReqBo != null) {
                    UccApplyListFlowMsgBusiRspBo msgBusiRspBo;
                    List<UccProcessTaskBO> completeTaskList = uccApplyListFlowMsgBusiReqBo.getCompletedTaskList();
                    List<UccProcessTaskBO> taskList = uccApplyListFlowMsgBusiReqBo.getTaskList();
                    String businessType = null;
                    if (ObjectUtil.isNotEmpty(completeTaskList)) {
                        businessType = completeTaskList.get(0).getBusiness().getBusinessType();
                    } else if (ObjectUtil.isNotEmpty(taskList)) {
                        businessType = taskList.get(0).getBusiness().getBusinessType();
                    }
                    if ("UccApplyForList".equals(businessType) && "0000".equals((msgBusiRspBo = this.uccApplyListFlowMsgBusiService.dealFlowMsg(uccApplyListFlowMsgBusiReqBo)).getRespCode())) {
                        return ProxyConsumerStatus.CONSUME_SUCCESS;
                    }
                }
                if (dycUccApproveTaskSyncBO != null) {
                    List<UccCommodityPo> uccCommodityPos;
                    Map<Long, List<UccCommodityPo>> collect;
                    log.info("\u5ba1\u6279\u56de\u8c03\u6d88\u8d39\u8005mq\u6536\u5230\u7684\u6d41\u7a0b\u5b9e\u4f8bId:" + dycUccApproveTaskSyncBO.getProcInstId());
                    UccApproveTaskSyncBusiReqBO uccApproveTaskSyncBusiReqBO = new UccApproveTaskSyncBusiReqBO();
                    BeanUtils.copyProperties((Object)dycUccApproveTaskSyncBO, (Object)((Object)uccApproveTaskSyncBusiReqBO));
                    UccApproveTaskSyncBusiRspBO rspBO = this.uccApproveTaskSyncBusiService.ApproveTaskSync(uccApproveTaskSyncBusiReqBO);
                    if (!CollectionUtils.isEmpty(rspBO.getSpuIds()) && (collect = (uccCommodityPos = this.uccCommodityMapper.qeryBatchCommdity(rspBO.getSpuIds())).stream().collect(Collectors.groupingBy(UccCommodityPo::getSupplierShopId))) != null) {
                        for (Long supplierShopId : collect.keySet()) {
                            ArrayList spus = new ArrayList(collect.get(supplierShopId).stream().map(UccCommodityPo::getCommodityId).collect(Collectors.toSet()));
                            SelfRunSyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SelfRunSyncSceneCommodityToEsReqBO();
                            syncSceneCommodityToEsReqBO.setCommodityIds((List)Lists.newArrayList(spus));
                            syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
                            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
                            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                            try {
                                log.info("\u5ba1\u6279\u6d88\u8d39\u8005es\u540c\u6b65\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
                                this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty("LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty("LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                            }
                            catch (Exception e) {
                                log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
                            }
                        }
                    }
                    return ProxyConsumerStatus.CONSUME_SUCCESS;
                }
                log.error("\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a");
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            catch (Exception e) {
                log.error("\u6570\u636e\u540c\u6b65\u6d88\u8d39\u8005\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }
}

